/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class AddTaskCommentApiService
extends AbstractWorkflowApiService {
    public static final String USERNUMBER = "userNumber";
    public static final String AUDITMESSAGE = "auditMessage";

    public ApiResult doCustomService(Map<String, Object> map) {
        Object auditMessage;
        if (map.get("userId") == null && map.get(USERNUMBER) == null || map.get("taskId") == null || map.get("resultNumber") == null || map.get(AUDITMESSAGE) == null || map.get("subactivityName") == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddTaskCommentApiService_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.assertInServiceAndLog("addTaskComment", map);
        Long userId = null;
        if (map.get(USERNUMBER) != null) {
            String userNum = String.valueOf(map.get(USERNUMBER));
            userId = this.getUserIdByNumber(userNum);
        } else {
            userId = Long.valueOf(String.valueOf(map.get("userId")));
        }
        Map userInfo = UserServiceHelper.getUserInfoByID((long)userId);
        if (WfUtils.isEmptyForMap(userInfo)) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4eba\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AddTaskCommentApiService_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        Long taskId = Long.valueOf(String.valueOf(map.get("taskId")));
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        boolean existStatus = wfService.getTaskService().getTaskExistStatus(taskId);
        if (!existStatus) {
            String tips = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u201ctaskId\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"AddTaskCommentApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]);
            return ApiResult.fail((String)tips);
        }
        String resultNumber = (String)map.get("resultNumber");
        String subactivityName = (String)map.get("subactivityName");
        LocaleString auditMessageVal = null;
        if (map.get(AUDITMESSAGE) instanceof Map) {
            auditMessage = (LinkedHashMap)map.get(AUDITMESSAGE);
            auditMessageVal = LocaleString.fromMap((Map)auditMessage);
        } else if (map.get(AUDITMESSAGE) instanceof String) {
            auditMessage = (String)map.get(AUDITMESSAGE);
            auditMessageVal = WfUtils.getMultiLangValue((String)auditMessage);
        }
        try {
            Comment comment;
            if (WfPermUtils.isNeedCheckApiPer("api_v1")) {
                ArrayList<Long> taskIds = new ArrayList<Long>(1);
                taskIds.add(taskId);
                boolean isRelation = WfPermUtils.isTaskRelationship(taskIds, userId);
                if (!isRelation) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"userID\u4e0d\u662f\u4efb\u52a1\u5e72\u7cfb\u4eba\uff0c\u4e0d\u80fd\u65b0\u589e\u4efb\u52a1\u5ba1\u6279\u4fe1\u606f\u3002", (String)"AddTaskCommentApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                if (userId.longValue() != RequestContext.get().getCurrUserId() && !WfPermUtils.hasTaskHandlerPerm("api_v1")) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u4efb\u52a1\u5e72\u7cfb\u4eba\u6216\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u4e0d\u80fd\u65b0\u589e\u4efb\u52a1\u5ba1\u6279\u4fe1\u606f\u3002", (String)"AddTaskCommentApiService_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
            if ((comment = (Comment)AddTaskCommentApiService.invokeBOSService("IWorkflowService", "createNewComment", new Object[0])) != null) {
                if (userId != null) {
                    comment.setUserId(userId);
                }
                comment.setTaskId(taskId);
                comment.setResultNumber(resultNumber);
                Date dateTime = null;
                if (map.get("auditTime") != null) {
                    Long editDateTime = Long.valueOf(String.valueOf(map.get("auditTime")));
                    dateTime = new Date(editDateTime);
                } else {
                    dateTime = new Date();
                }
                comment.setTime(dateTime);
                if (auditMessageVal != null) {
                    comment.setMessage((ILocaleString)auditMessageVal);
                }
                comment.setTerminalWay("api");
                comment.setSubactivityname(subactivityName);
                AddTaskCommentApiService.invokeBOSService("IWorkflowService", "addComment", comment);
                return ApiResult.success((Object)"addTaskComment sucesss");
            }
            return ApiResult.fail((String)"addTaskComment comment is null");
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

