/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.engine.AddsignInfoForApi;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.exception.EngineAPIExceptionEnum;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

@ApiController(value="wf", desc="\u5f15\u64ceapi")
@ApiMapping(value="/")
public class ApiEngineController
implements Serializable {
    private static final long serialVersionUID = 1653376362626959895L;
    private Log logger = LogFactory.getLog(this.getClass());
    private WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");

    @ApiPostMapping(value="/revokeProcessInstancesByProcessInstanceId", desc="\u624b\u5de5\u89e3\u6302")
    public CustomApiResult<String> revokeProcessInstancesByProcessInstanceId(@ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) Long processInstanceId) {
        if (!WfPermUtils.hasProcessRevokeSuspendPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.revokeSuspendProcessInstancesByIds(processInstanceId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u624b\u5de5\u89e3\u6302\u6210\u529f\u3002", (String)"ApiEngineController_7", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.REVOKEERRORCODE.getCode(), (String)EngineAPIExceptionEnum.REVOKEERRORCODE.getDesc());
        }
    }

    @ApiPostMapping(value="/suspendProcessInstanceByProcessInstanceId", desc="\u624b\u5de5\u6302\u8d77")
    public CustomApiResult<String> suspendProcessInstanceByProcessInstanceId(@ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) Long processInstanceId) {
        if (!WfPermUtils.hasProcessSuspendPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.suspendProcessInstanceByProcessInstanceId(processInstanceId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u624b\u5de5\u6302\u8d77\u6210\u529f\u3002", (String)"ApiEngineController_9", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.SUSPENDERRORCODE.getCode(), (String)EngineAPIExceptionEnum.SUSPENDERRORCODE.getDesc());
        }
    }

    @ApiPostMapping(value="/jumpToNode", desc="\u6d41\u7a0b\u8df3\u8f6c")
    public CustomApiResult<String> jumpToNode(@ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) Long processInstanceId, @ApiParam(value="\u76ee\u6807\u8282\u70b9id", required=true) @ApiParam(value="\u76ee\u6807\u8282\u70b9id", required=true) String destId, @ApiParam(value="\u6e90\u8282\u70b9id", required=true) @ApiParam(value="\u6e90\u8282\u70b9id", required=true) String srcId) {
        if (!WfPermUtils.hasProcessJumpPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.jumpToNode(processInstanceId, destId, srcId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u8df3\u8f6c\u6210\u529f\u3002", (String)"ApiEngineController_13", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.SKIPERRORCODE.getCode(), (String)EngineAPIExceptionEnum.SKIPERRORCODE.getDesc());
        }
    }

    @ApiPostMapping(value="/jumpToNodeWithReason", desc="\u6d41\u7a0b\u8df3\u8f6c")
    public CustomApiResult<String> jumpToNodeWithReason(@ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) Long processInstanceId, @ApiParam(value="\u76ee\u6807\u8282\u70b9id", required=true) @ApiParam(value="\u76ee\u6807\u8282\u70b9id", required=true) String destId, @ApiParam(value="\u6e90\u8282\u70b9id", required=true) @ApiParam(value="\u6e90\u8282\u70b9id", required=true) String srcId, @ApiParam(value="\u8df3\u8f6c\u539f\u56e0") @ApiParam(value="\u8df3\u8f6c\u539f\u56e0") String reason) {
        if (!WfPermUtils.hasProcessJumpPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.jumpToNodeWithReason(processInstanceId, destId, srcId, (ILocaleString)new LocaleString(reason));
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u8df3\u8f6c\u6210\u529f\u3002", (String)"ApiEngineController_13", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.SKIPERRORCODE.getCode(), (String)EngineAPIExceptionEnum.SKIPERRORCODE.getDesc());
        }
    }

    @ApiPostMapping(value="/abortProcessInstance", desc="\u6d41\u7a0b\u5b9e\u4f8b\u5f3a\u5236\u7ec8\u6b62")
    public CustomApiResult<String> abortProcessInstance(@ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) Long processInstanceId) {
        if (!WfPermUtils.hasProcessAbandonPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.abortProcessInstance(processInstanceId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5f3a\u5236\u7ec8\u6b62\u6210\u529f\u3002", (String)"ApiEngineController_15", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.ABORTERRORCODE.getCode(), (String)EngineAPIExceptionEnum.ABORTERRORCODE.getDesc());
        }
    }

    private boolean checkParticipantPermission(Long taskId) {
        if (WfPermUtils.hasTaskHandlerPerm("api_v2")) {
            return true;
        }
        QFilter q1 = new QFilter("taskid", "=", (Object)taskId);
        QFilter q2 = new QFilter("userid", "=", (Object)RequestContext.get().getCurrUserId());
        boolean isExist = QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])new QFilter[]{q1, q2});
        return isExist;
    }

    @ApiPostMapping(value="/addSign", desc="\u52a0\u7b7e")
    public CustomApiResult<String> addSign(@ApiParam(value="\u4efb\u52a1id", required=true) @ApiParam(value="\u4efb\u52a1id", required=true) Long taskId, @ApiParam(value="\u52a0\u7b7e\u4fe1\u606f", required=true) @ApiParam(value="\u52a0\u7b7e\u4fe1\u606f", required=true) AddsignInfoForApi addSignInfo) {
        try {
            if (!this.checkParticipantPermission(taskId)) {
                return CustomApiResult.fail((String)EngineAPIExceptionEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)EngineAPIExceptionEnum.USER_DONT_HAVE_PERMISSION.getDesc());
            }
            String addSignType = addSignInfo.getAddSignType();
            if (!"addsignbefore".equals(addSignType) && !"addsignafter".equals(addSignType)) {
                return CustomApiResult.fail((String)EngineAPIExceptionEnum.CHECKERRORCODE.getCode(), (String)EngineAPIExceptionEnum.CHECKERRORCODE.getDesc());
            }
            AddSignInfo addSign = new AddSignInfo();
            addSign.setAddSignDealType(addSignInfo.getAddSignDealType());
            addSign.setAddSignType("http_api_" + addSignInfo.getAddSignType());
            addSign.setAddSingMsg(addSignInfo.getAddSingMsg());
            addSign.setAllowAddSign(addSignInfo.getAllowAddSign());
            addSign.setUserIds(addSignInfo.getUserIds());
            addSign.setYzjType(addSignInfo.getYzjType());
            addSign.setNodeNames(addSignInfo.getNodeNames());
            addSign.setOwnerId(addSignInfo.getOwnerId());
            String result = this.workflowService.addSign(taskId, addSign);
            if ("addsignsucces".equals(result)) {
                if ("addsignbefore".equals(addSignInfo.getAddSignType())) {
                    return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u524d\u52a0\u7b7e\u6210\u529f\u3002", (String)"ApiEngineController_17", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u540e\u52a0\u7b7e\u6210\u529f\u3002", (String)"ApiEngineController_19", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.SYSTEMERRORCODE.getCode(), (String)(result == null ? EngineAPIExceptionEnum.SYSTEMERRORCODE.getDesc() : result));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            if ("addsignbefore".equals(addSignInfo.getAddSignType())) {
                return CustomApiResult.fail((String)EngineAPIExceptionEnum.ADDBEFOREERRORCODE.getCode(), (String)EngineAPIExceptionEnum.ADDBEFOREERRORCODE.getDesc());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.ADDAFTERERRORCODE.getCode(), (String)EngineAPIExceptionEnum.ADDAFTERERRORCODE.getDesc());
        }
    }

    @ApiPostMapping(value="/getPreComputorRecord", desc="\u9884\u8ba1\u7b97")
    public CustomApiResult<IPreComputorRecord> getPreComputorRecord(@ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @ApiParam(value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) Long processInstanceId) {
        if (!WfPermUtils.hasExecutionQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            IPreComputorRecord data = this.workflowService.getPreComputorRecord(processInstanceId);
            return CustomApiResult.success((Object)data);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.NEXTERRORCODE.getCode(), (String)EngineAPIExceptionEnum.NEXTERRORCODE.getDesc());
        }
    }

    @ApiPostMapping(value="/getProInsIdByBusinessKeyAndEntityNumber", desc="\u6839\u636e\u5355\u636eid\u548c\u5b9e\u4f53\u7f16\u7801\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8bid")
    public CustomApiResult<Long> getProInsIdByBusinessKeyAndEntityNumber(@ApiParam(value="\u5355\u636eid", required=true) @ApiParam(value="\u5355\u636eid", required=true) String businessKey, @ApiParam(value="\u5b9e\u4f53\u7f16\u7801", required=true) @ApiParam(value="\u5b9e\u4f53\u7f16\u7801", required=true) String entityNumber) {
        if (!WfPermUtils.hasExecutionQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            Long processInstanceId = this.workflowService.getProcessInstanceIdByBusinessKeyAndEntityNumber(businessKey, entityNumber);
            return CustomApiResult.success((Object)processInstanceId);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (e.getErrorCode() != null && EngineAPIExceptionEnum.isExistCode(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)e.getErrorCode().getCode(), (String)e.getErrorCode().getMessage());
            }
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.GETIDRRORCODE.getCode(), (String)EngineAPIExceptionEnum.GETIDRRORCODE.getDesc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiPostMapping(value="/tryTriggerProcess", desc="\u542f\u52a8\u6d41\u7a0b")
    public CustomApiResult<String> tryTriggerProcess(@ApiParam(value="businesskey", required=true) @ApiParam(value="businesskey", required=true) String businesskey, @ApiParam(value="\u64cd\u4f5c", required=true) @ApiParam(value="\u64cd\u4f5c", required=true) String operation, @ApiParam(value="\u5b9e\u4f53\u7f16\u7801", required=true) @ApiParam(value="\u5b9e\u4f53\u7f16\u7801", required=true) String entityNumber, @ApiParam(value="\u53d8\u91cf", required=true) @ApiParam(value="\u53d8\u91cf", required=true) Map<String, Object> variables) {
        if (!WfPermUtils.hasProcessTryTriggerProcessPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try (TXHandle tx = TX.requiresNew();){
            this.workflowService.tryTriggerProcess(businesskey, operation, entityNumber, variables);
            CustomApiResult customApiResult = CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6d41\u7a0b\u542f\u52a8\u6210\u529f", (String)"ApiEngineController_64", (String)"bos-wf-engine", (Object[])new Object[0]));
            return customApiResult;
        }
    }

    @ApiPostMapping(value="/completeCallActivity", desc="\u5b8c\u6210\u5b50\u6d41\u7a0b\u8282\u70b9")
    public CustomApiResult<String> completeCallActivity(@ApiParam(value="executionId", required=true) @ApiParam(value="executionId", required=true) Long executionId, @ApiParam(value="\u5b50execution\u5411\u7236execution\u4f20\u7684\u53d8\u91cf", required=true) @ApiParam(value="\u5b50execution\u5411\u7236execution\u4f20\u7684\u53d8\u91cf", required=true) Map<String, Object> variablesForParent) {
        if (!WfPermUtils.hasCompleteCallActivityPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.completeCallActivity(executionId, variablesForParent);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u5b8c\u6210\u5b50\u6d41\u7a0b\u8282\u70b9\u6210\u529f", (String)"ApiEngineController_67", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.STRRTPROCESSERROR.getCode(), (String)EngineAPIExceptionEnum.STRRTPROCESSERROR.getDesc());
        }
    }

    @ApiPostMapping(value="/addProcessRelationPersonByProcInstId", desc="\u6dfb\u52a0\u4efb\u52a1\u5173\u8054\u4eba")
    public CustomApiResult<Boolean> addProcessRelationPersonByProcInstId(@ApiParam(value="processInstanceId", required=true) @ApiParam(value="processInstanceId", required=true) Long processInstanceId, @ApiParam(value="assigneeIds") @ApiParam(value="assigneeIds") List<Long> assigneeIds) {
        if (!WfPermUtils.hasProcessRelationPersonPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.addProcessRelationPerson(processInstanceId, assigneeIds);
            return CustomApiResult.success((Object)Boolean.TRUE);
        }
        catch (KDException e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)"bos.wf.AddProcessRelationCmd", (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/addProcessRelationPerson", desc="\u6dfb\u52a0\u4efb\u52a1\u5173\u8054\u4eba")
    public CustomApiResult<Boolean> addProcessRelationPerson(@ApiParam(value="entityNumber", required=true) @ApiParam(value="entityNumber", required=true) String entityNumber, @ApiParam(value="businessKey", required=true) @ApiParam(value="businessKey", required=true) String businessKey, @ApiParam(value="assigneeIds") @ApiParam(value="assigneeIds") List<Long> assigneeIds) {
        if (!WfPermUtils.hasProcessRelationPersonPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        try {
            this.workflowService.addProcessRelationPerson(entityNumber, businessKey, assigneeIds);
            return CustomApiResult.success((Object)Boolean.TRUE);
        }
        catch (KDException e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)"bos.wf.AddProcessRelationCmd", (String)e.getMessage());
        }
    }
}

