/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.exception.EngineAPIExceptionEnum;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

@ApiController(value="wf", desc="workflow archive api")
@ApiMapping(value="/")
public class ArchiveController
implements Serializable {
    private static Log logger = LogFactory.getLog(ArchiveController.class);

    @ApiPostMapping(value="/getArchiveRouteKeys", desc="\u83b7\u53d6\u5f52\u6863\u8def\u7531")
    public CustomApiResult<Object> getArchiveRouteKeys(@ApiParam(value="archiveEntity") @ApiParam(value="archiveEntity") String archiveEntity, @ApiParam(value="conditions") @ApiParam(value="conditions") Map<String, Object> conditions) {
        if (WfUtils.isEmpty(archiveEntity) || conditions == null) {
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.CHECKERRORCODE.getCode(), (String)EngineAPIExceptionEnum.CHECKERRORCODE.getDesc());
        }
        logger.debug(String.format("requestApi[%s] and param[%s]", "getArchiveRouteKeys", archiveEntity));
        ArrayList<ArchiveRouteIndexCondition> archiveRouteIndexConditions = new ArrayList<ArchiveRouteIndexCondition>();
        try {
            Set<Map.Entry<String, Object>> entrySet = conditions.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                archiveRouteIndexConditions.add(new ArchiveRouteIndexCondition(entry.getKey(), entry.getValue()));
            }
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.CHECKERRORCODE.getCode(), (String)EngineAPIExceptionEnum.CHECKERRORCODE.getDesc());
        }
        try {
            WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
            List result = workflowService.getArchiveRouteKeys(archiveEntity, archiveRouteIndexConditions);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            return CustomApiResult.fail((String)EngineAPIExceptionEnum.ARCHIVEQUERYERROR.getCode(), (String)EngineAPIExceptionEnum.ARCHIVEQUERYERROR.getDesc());
        }
    }
}

