/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.workflow.basedata.DelegateSettingInfo;
import kd.bos.workflow.basedata.role.WorkflowRole;
import kd.bos.workflow.basedata.role.WorkflowRoleEntry;
import kd.bos.workflow.basedata.role.WorkflowRoleResult;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

@ApiController(desc="api", value="wf")
@ApiMapping(value="/")
public class BasedataApiController
implements Serializable {
    private static final long serialVersionUID = -2186582529648298713L;
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String CHECKERRORCODE = "39001";
    private static final String SYSTEMERRORCODE = "39501";
    private static final String UPDATEWORKFLOWROLEERRORCODE = "39650";
    private static final String MULTIENTRYERRORCODE = "39651";
    private WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");

    @ApiPostMapping(value="updateWorkflowRole", desc="\u6279\u91cf\u66f4\u65b0\u5de5\u4f5c\u6d41\u89d2\u8272")
    public CustomApiResult<WorkflowRoleResult> updateWorkflowRole(@ApiParam(value="\u5de5\u4f5c\u6d41\u89d2\u8272\u5b9e\u4f53", required=true) @ApiParam(value="\u5de5\u4f5c\u6d41\u89d2\u8272\u5b9e\u4f53", required=true) List<WorkflowRole> roles) {
        if (!WfPermUtils.hasUpdateFlowRolesPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (roles == null || roles.isEmpty()) {
            return CustomApiResult.fail((String)CHECKERRORCODE, (String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BasedataApiController_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        for (WorkflowRole r : roles) {
            if (WfUtils.isEmpty(r.getNumber())) {
                return CustomApiResult.fail((String)CHECKERRORCODE, (String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BasedataApiController_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            if (WfUtils.isNotEmpty(r.getRoleType()) && !"user".equals(r.getRoleType()) && !"approvalposition".equals(r.getRoleType())) {
                return CustomApiResult.fail((String)CHECKERRORCODE, (String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BasedataApiController_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            List entry = r.getRoleEntry();
            if (entry == null || entry.isEmpty()) {
                return CustomApiResult.fail((String)MULTIENTRYERRORCODE, (String)ResManager.loadKDString((String)"roleEntry\u4e0d\u80fd\u4e3a\u7a7a", (String)"BasedataApiController_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            if (entry.size() > 5000) {
                return CustomApiResult.fail((String)MULTIENTRYERRORCODE, (String)ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u89d2\u8272\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5355\u4e2a\u5de5\u4f5c\u6d41\u89d2\u8272\u8d85\u8fc75000\u6761\u4eba\u5458\u5206\u5f55\u3002", (String)"BasedataApiController_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            for (WorkflowRoleEntry e : entry) {
                if (!WfUtils.isEmpty(e.getOrg()) && !WfUtils.isEmpty(e.getFunctiontype()) && (!WfUtils.isEmpty(e.getUser()) || !"user".equals(r.getRoleType()) && !WfUtils.isEmpty(r.getRoleType())) && (!WfUtils.isEmpty(e.getApprovalPosition()) || !"approvalposition".equals(r.getRoleType()))) continue;
                return CustomApiResult.fail((String)CHECKERRORCODE, (String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BasedataApiController_0", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        try {
            WorkflowRoleResult result = this.workflowService.updateWorkflowRole(roles);
            if (result.getResult()) {
                return CustomApiResult.success((Object)result);
            }
            return CustomApiResult.fail((String)UPDATEWORKFLOWROLEERRORCODE, (String)result.getDesc());
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)SYSTEMERRORCODE, (String)ResManager.loadKDString((String)"\u6d41\u7a0b\u5f15\u64ce\u5f02\u5e38\u3002", (String)"BasedataApiController_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="saveDelegateSettings", desc="\u6279\u91cf\u66f4\u65b0\u4fee\u6539\u59d4\u6258\u8bbe\u7f6e")
    public CustomApiResult<Map<String, Object>> saveDelegateSettings(@ApiParam(value="\u59d4\u6258\u8bbe\u7f6e\u5b9e\u4f53", required=true) @ApiParam(value="\u59d4\u6258\u8bbe\u7f6e\u5b9e\u4f53", required=true) List<DelegateSettingInfo> delegateSettings) {
        if (!WfPermUtils.canUpdateDelegateSetting("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmptyForCollection(delegateSettings)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
        Map<String, Object> saveResult = workflowService.getManagementService().saveAndEnableDelegateSettings(delegateSettings);
        int failCount = (Integer)saveResult.get("failedCount");
        if (failCount > 0) {
            return this.buildFailCustomApiResult(TaskErrorCodeEnum.DELEGATESETTING_SAVEERROR.getCode(), TaskErrorCodeEnum.DELEGATESETTING_SAVEERROR.getDesc(), saveResult);
        }
        return CustomApiResult.success(saveResult);
    }

    private CustomApiResult<Map<String, Object>> buildFailCustomApiResult(String errorCode, String ErroeMessage, Map<String, Object> data) {
        CustomApiResult result = new CustomApiResult();
        result.setStatus(false);
        result.setErrorCode(errorCode);
        result.setMessage(ErroeMessage);
        result.setData(data);
        return result;
    }

    @ApiPostMapping(value="deleteDelegateSettings", desc="\u6279\u91cf\u5220\u9664\u59d4\u6258\u8bbe\u7f6e")
    public CustomApiResult<Map> deleteDelegateSettings(@ApiParam(value="\u59d4\u6258ID") @ApiParam(value="\u59d4\u6258ID") List<Long> delegateSettingIds) {
        if (!WfPermUtils.canDeleteDelegateSetting("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmptyForCollection(delegateSettingIds)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
        try {
            workflowService.getManagementService().deleteDelegateSettings(delegateSettingIds);
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.DELEGATESETTING_DELETEERROR.getCode(), (String)TaskErrorCodeEnum.DELEGATESETTING_DELETEERROR.getDesc());
        }
        JSONObject result = new JSONObject();
        result.put("successCount", (Object)delegateSettingIds.size());
        result.put("successIds", delegateSettingIds);
        return CustomApiResult.success((Object)result);
    }
}

