/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;

public class BatchAgreeTaskApiService
extends AbstractWorkflowApiService {
    public static final String TASKIDS = "taskids";
    public static final String PARAM = "param";
    private static final String SUCCESSIDS = "successIds";
    private Log logger = LogFactory.getLog(this.getClass());

    public ApiResult doCustomService(Map<String, Object> map) {
        this.logger.debug("batchagree's params is :" + map.toString());
        List<String> sourceIds = new ArrayList();
        boolean isYzjUp = false;
        String openId = "";
        if (!map.containsKey(TASKIDS)) {
            if (map.get(PARAM) != null) {
                Map paramMap = (Map)map.get(PARAM);
                openId = String.valueOf(paramMap.get("openId"));
                if (StringUtils.isNotBlank(paramMap.get("bizIds"))) {
                    List bizIds = (List)paramMap.get("bizIds");
                    isYzjUp = true;
                    for (String bizId : bizIds) {
                        String string = bizId.replace(openId, "");
                        sourceIds.add(string);
                    }
                } else {
                    sourceIds = (List)paramMap.get("sourceIds");
                }
                if (sourceIds.isEmpty()) {
                    this.logger.debug("batchagree's sourceIds: params is error");
                    return ApiResult.fail((String)WFMultiLangConstants.getTaskTodoLang());
                }
            } else {
                this.logger.debug("batchagree's params:params is error");
                return ApiResult.fail((String)WFMultiLangConstants.getTaskTodoLang());
            }
        }
        try {
            String taskIds = (String)map.get(TASKIDS);
            if (WfUtils.isEmpty(taskIds)) {
                Map param = (Map)map.get(PARAM);
                if (param == null) {
                    return ApiResult.fail((String)WFMultiLangConstants.getTaskTodoLang());
                }
                StringBuilder tIds = new StringBuilder();
                for (int i = 0; i < sourceIds.size(); ++i) {
                    if (i == sourceIds.size() - 1) {
                        tIds.append((String)sourceIds.get(i));
                        continue;
                    }
                    tIds.append((String)sourceIds.get(i)).append(',');
                }
                taskIds = tIds.toString();
            }
            this.logger.debug("batchagree's taskIds :" + taskIds);
            Long userId = this.getQuickAgreeUserId(openId);
            if (WfUtils.isNotEmpty(taskIds)) {
                String[] arrs = taskIds.split(",");
                ArrayList<Long> taskIdList = new ArrayList<Long>(10);
                for (String val : arrs) {
                    taskIdList.add(Long.valueOf(val));
                }
                boolean bl = WfPermUtils.isTaskParticipantByType(taskIdList, userId, "participant");
                if (!bl) {
                    this.logger.debug(String.format("batchagree's reason :has task handler perm but operationer is not owner of all task, userId:%s", userId));
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u53ef\u80fd\u4e0d\u662f\u4efb\u52a1\u5904\u7406\u4eba\uff0c\u65e0\u6cd5\u6279\u91cf\u5904\u7406\u4efb\u52a1\u3002", (String)"BatchAgreeTaskApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0]));
                }
                if (WfPermUtils.isNeedCheckApiPer("api_v1") && userId.longValue() != RequestContext.get().getCurrUserId() && !WfPermUtils.hasTaskHandlerPerm("api_v1")) {
                    this.logger.debug(String.format("batchagree's reason :not has task handler perm,and operationer is not owner of all task or task not belong to me, userId:%s", RequestContext.get().getCurrUserId()));
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f85\u529e\u4efb\u52a1\u5904\u7406\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u6240\u6709\u4efb\u52a1\u53c2\u4e0e\u4eba\u6216\u975e\u5904\u7406\u672c\u4eba\u4efb\u52a1\u3002\u4e0d\u80fd\u6279\u91cf\u5904\u7406\u4efb\u52a1\u3002", (String)"BatchAgreeTaskApiService_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
            if (taskIds != null && StringUtils.isNotEmpty((CharSequence)taskIds)) {
                Object batchDealTodoResult = BatchAgreeTaskApiService.invokeBOSService("IWorkflowService", "batchAgreeTaskWithUserId", taskIds, new LocaleString(), userId);
                if (map.containsKey(TASKIDS)) {
                    return ApiResult.success((Object)batchDealTodoResult);
                }
                JSONArray successTodoIds = JSONObject.parseObject((String)((String)batchDealTodoResult)).getJSONArray(SUCCESSIDS);
                JSONObject jSONObject = new JSONObject();
                if (isYzjUp && successTodoIds != null) {
                    JSONArray successTodoIdsForYzjup = new JSONArray();
                    int len = successTodoIds.size();
                    for (int i = 0; i < len; ++i) {
                        successTodoIdsForYzjup.add((Object)(successTodoIds.get(i) + openId));
                    }
                    jSONObject.put(SUCCESSIDS, (Object)successTodoIdsForYzjup);
                } else {
                    jSONObject.put(SUCCESSIDS, (Object)successTodoIds);
                }
                return ApiResult.success((Object)jSONObject);
            }
            this.logger.debug("batchagree's taskId is zero");
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f85\u5904\u7406\u4efb\u52a1ID\u6570\u91cf\u4e3a0\u3002", (String)"BatchAgreeTaskApiService_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.logger.warn("batchagree's exception:" + e.getLocalizedMessage());
            return ApiResult.ex((Throwable)e.getCause());
        }
    }

    private Long getQuickAgreeUserId(String openId) {
        DynamicObject dyObj;
        if (StringUtils.isNotBlank((CharSequence)openId) && (dyObj = QueryServiceHelper.queryOne((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("useropenid", "=", (Object)openId)})) != null) {
            try {
                this.logger.debug("batchagree's userid is " + dyObj.getLong("id"));
                return dyObj.getLong("id");
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage());
            }
        }
        return RequestContext.get().getCurrUserId();
    }
}

