/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;

public class CompleteTaskApiService
extends AbstractWorkflowApiService {
    public static final String USERID = "userId";

    public ApiResult doCustomService(Map<String, Object> map) {
        Long taskId;
        String auditMessage;
        String decOptionNumber;
        if (WfUtils.isEmptyString(map.get("decOptionNumber")) || WfUtils.isEmptyString(map.get("auditMessage")) || map.get("taskId") == null) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CompleteTaskApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.assertInServiceAndLog("getTaskCountByType", map);
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        if (map.get("userNumber") != null) {
            String userNum = String.valueOf(map.get("userNumber"));
            Long returnUserId = this.getUserIdByNumber(userNum);
            if (returnUserId != null) {
                userId = returnUserId;
            } else if (WfUtils.isNotEmptyString(map.get(USERID))) {
                userId = this.getUserId(map);
            }
        } else if (WfUtils.isNotEmptyString(map.get(USERID))) {
            userId = this.getUserId(map);
        }
        try {
            decOptionNumber = map.get("decOptionNumber").toString();
            auditMessage = map.get("auditMessage").toString();
            taskId = Long.parseLong(map.get("taskId").toString());
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CompleteTaskApiService_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            if (WfPermUtils.isNeedCheckApiPer("api_v1")) {
                boolean isParticipant = WfPermUtils.isTaskParticipantByType(taskId, userId, "participant");
                if (!isParticipant) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"userId\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u65e0\u6743\u5ba1\u6279\u4efb\u52a1\u3002", (String)"CompleteTaskApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                if (userId.longValue() != RequestContext.get().getCurrUserId() && !WfPermUtils.hasTaskHandlerPerm("api_v1")) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\u6216\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u4e0d\u80fd\u5ba1\u6279\u4efb\u52a1\u3002", (String)"CompleteTaskApiService_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
            CompleteTaskApiService.invokeBOSService("IWorkflowService", "completeTask", taskId, userId, decOptionNumber, auditMessage);
            return ApiResult.success((Object)"completeTask sucesss");
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }

    public Long getUserId(Map<String, Object> map) {
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        Long parameterUserId = Long.valueOf(String.valueOf(map.get(USERID)));
        Boolean userExist = QueryServiceHelper.exists((String)"bos_user", (Object)parameterUserId);
        if (userExist.booleanValue()) {
            userId = parameterUserId;
        }
        return userId;
    }
}

