/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.Map;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.TaskErrorCodeEnum;

public class GetEnabledProcessesApiService
extends AbstractWorkflowApiService {
    public static final String PROCINSTID = "procInstId";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String OPERATION = "operation";
    private static final String BUSINESSKEY = "businessKey";

    public ApiResult doCustomService(Map<String, Object> map) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v1")) {
            return ApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode());
        }
        if (map == null || WfUtils.isEmpty((String)map.get(ENTITYNUMBER)) || WfUtils.isEmpty((String)map.get(OPERATION)) || WfUtils.isEmpty((String)map.get(BUSINESSKEY))) {
            return ApiResult.fail((String)WFMultiLangConstants.getParamsErrorName());
        }
        this.assertInServiceAndLog("GetEnabledProcesses", map);
        try {
            String entityNumber = (String)map.get(ENTITYNUMBER);
            String operation = (String)map.get(OPERATION);
            String businessKey = (String)map.get(BUSINESSKEY);
            Object result = GetEnabledProcessesApiService.invokeBOSService("IWorkflowService", "getEnabledProcesses", WfUtils.findBusinessObject(businessKey, entityNumber), operation);
            return ApiResult.success((Object)result);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

