/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;

public class GetNextUseableUserAndScopeApiService
extends AbstractWorkflowApiService {
    private static final String TASKID = "taskId";
    private static final String AUDIT_NUMBER = "auditNumber";

    public ApiResult doCustomService(Map<String, Object> params) {
        String auditNumber;
        long taskId;
        if (WfUtils.isEmptyString(params.get(TASKID)) || WfUtils.isEmptyString(params.get(AUDIT_NUMBER))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetNextUseableUserAndScopeApiService_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.assertInServiceAndLog("getNextUseableUserAndScope", params);
        try {
            taskId = Long.parseLong(params.get(TASKID).toString());
            auditNumber = params.get(AUDIT_NUMBER).toString();
            if (!this.isAuditNumberLegal(auditNumber)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetNextUseableUserAndScopeApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            if (!this.isTaskExist(taskId)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u201ctaskId\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"GetNextUseableUserAndScopeApiService_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetNextUseableUserAndScopeApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            if (WfPermUtils.isNeedCheckApiPer("api_v1") && !WfPermUtils.isTaskParticipantByType(taskId, (Long)RequestContext.get().getCurrUserId(), "participant") && !WfPermUtils.hasToHandlerTaskQueryPerm("api_v1")) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u83b7\u53d6\u6307\u5b9a\u4e0b\u4e00\u6b65\u53c2\u4e0e\u4eba\u8303\u56f4\u3002", (String)"GetNextUseableUserAndScopeApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            Object taskResult = GetNextUseableUserAndScopeApiService.invokeBOSService("IWorkflowService", "getNextUseableUserAndScope", taskId, auditNumber);
            return ApiResult.success((Object)taskResult);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }

    private boolean isAuditNumberLegal(String auditNumber) {
        Pattern pattern = Pattern.compile("^[A-Za-z0-9-]{0,20}$");
        Matcher m = pattern.matcher(auditNumber);
        return m.matches();
    }
}

