/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.exception.ModelErrorCodeEnum;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

@ApiController(value="wf", desc="\u6a21\u578b\u64cd\u4f5c")
@ApiMapping(value="/")
public class ModelController
implements Serializable {
    private static final long serialVersionUID = -4353762235592012879L;
    private transient Log logger = LogFactory.getLog(this.getClass());
    private transient WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");

    @ApiGetMapping(value="/getEnabledProcDefByEntityNumber", desc="\u6839\u636e\u5355\u636e\u5b9e\u4f53\u7f16\u7801\u83b7\u53d6\u542f\u7528\u7684\u6d41\u7a0b")
    public CustomApiResult<List<Map<String, Object>>> getEnabledProcDefByEntityNumber(@ApiParam(value="entityNumber", required=true) @ApiParam(value="entityNumber", required=true) String entityNumber) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(entityNumber)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            List result = this.workflowService.getEnabledProcDefByEntityNumber(entityNumber);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCESSINFOBYENTITYNUMBER_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCESSINFOBYENTITYNUMBER_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcDefById", desc="\u6839\u636e\u6d41\u7a0bid\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f")
    public CustomApiResult<Map<String, Object>> getProcDefById(@ApiParam(value="procDefId", required=true) @ApiParam(value="procDefId", required=true) Long procDefId) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(procDefId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            Map result = this.workflowService.getProcDefById(procDefId);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCDEFINFOBYID_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCDEFINFOBYID_FAIL.getDesc());
        }
    }

    @ApiPostMapping(value="/enableProcess", desc="\u542f\u7528\u6d41\u7a0b")
    public CustomApiResult<String> enableProcess(@ApiParam(value="procDefId", required=true) @ApiParam(value="procDefId", required=true) Long procDefId) {
        if (!WfPermUtils.hasProcessEnablePerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(procDefId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            this.workflowService.enableProcess(procDefId);
            return CustomApiResult.success((Object)String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u201c%s\u201d\u542f\u7528\u6210\u529f\u3002", (String)"ModelController_1", (String)"bos-wf-engine", (Object[])new Object[0]), procDefId));
        }
        catch (KDBizException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.ENABLEPROCESS_FAIL_WITHERROR.getCode(), (String)String.format(ModelErrorCodeEnum.ENABLEPROCESS_FAIL_WITHERROR.getDesc(), e.getMessage()));
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.ENABLEPROCESS_FAIL.getCode(), (String)ModelErrorCodeEnum.ENABLEPROCESS_FAIL.getDesc());
        }
    }

    @ApiPostMapping(value="/disableProcess", desc="\u7981\u7528\u6d41\u7a0b")
    public CustomApiResult<String> disableProcess(@ApiParam(value="procDefId", required=true) @ApiParam(value="procDefId", required=true) Long procDefId) {
        if (!WfPermUtils.hasProcessDisablePerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(procDefId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            this.workflowService.disableProcess(procDefId);
            return CustomApiResult.success((Object)String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u201c%s\u201d\u7981\u7528\u6210\u529f\u3002", (String)"ModelController_2", (String)"bos-wf-engine", (Object[])new Object[0]), procDefId));
        }
        catch (KDBizException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.DISABLEPROCESS_FAIL_WITHERROR.getCode(), (String)String.format(ModelErrorCodeEnum.DISABLEPROCESS_FAIL_WITHERROR.getDesc(), e.getMessage()));
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.DISABLEPROCESS_FAIL.getCode(), (String)ModelErrorCodeEnum.DISABLEPROCESS_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcSchemeBySchemeId", desc="\u6839\u636e\u65b9\u6848id\u83b7\u53d6\u6d41\u7a0b\u65b9\u6848")
    public CustomApiResult<Map<String, Object>> getProcSchemeBySchemeId(@ApiParam(value="schemeId", required=true) @ApiParam(value="schemeId", required=true) Long schemeId) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(schemeId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            Map result = this.workflowService.getProcSchemeBySchemeId(schemeId);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCDEFINFOBYSCHEMEID_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCDEFINFOBYSCHEMEID_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcSchemeBySchemeNumber", desc="\u6839\u636e\u65b9\u6848\u7f16\u7801\u83b7\u53d6\u6d41\u7a0b\u65b9\u6848")
    public CustomApiResult<Map<String, Object>> getProcSchemeBySchemeNumber(@ApiParam(value="schemeNumber", required=true) @ApiParam(value="schemeNumber", required=true) String schemeNumber) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(schemeNumber)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            Map result = this.workflowService.getProcSchemeBySchemeNumber(schemeNumber);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCDEFBYSCHEMENUMBER_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCDEFBYSCHEMENUMBER_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcElementsByProcDefId", desc="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u8282\u70b9\u4fe1\u606f")
    public CustomApiResult<List<WFFlowElement>> getProcElementsByProcDefId(@ApiParam(value="procDefId", required=true) @ApiParam(value="procDefId", required=true) Long procDefId) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(procDefId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            List result = this.workflowService.getProcElementsByProcDefId(procDefId);
            this.clearNextNodes(result);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCELEMENTSBYPROCDEFID_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCELEMENTSBYPROCDEFID_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcElementsBySchemeId", desc="\u6839\u636e\u65b9\u6848id\u83b7\u53d6\u8282\u70b9\u4fe1\u606f")
    public CustomApiResult<List<WFFlowElement>> getProcElementsBySchemeId(@ApiParam(value="schemeId", required=true) @ApiParam(value="schemeId", required=true) Long schemeId) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(schemeId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            List result = this.workflowService.getProcElementsBySchemeId(schemeId);
            this.clearNextNodes(result);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCELEMENTSBYSCHEMEID_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCELEMENTSBYSCHEMEID_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcElementsBySchemeNumber", desc="\u6839\u636e\u65b9\u6848\u7f16\u7801\u83b7\u53d6\u8282\u70b9\u4fe1\u606f")
    public CustomApiResult<List<WFFlowElement>> getProcElementsBySchemeNumber(@ApiParam(value="schemeNumber", required=true) @ApiParam(value="schemeNumber", required=true) String schemeNumber) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(schemeNumber)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            List result = this.workflowService.getProcElementsBySchemeNumber(schemeNumber);
            this.clearNextNodes(result);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCELEMENTSBYSCHEMENUMBER_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCELEMENTSBYSCHEMENUMBER_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcDefByNumberAndVerson", desc="\u6839\u636e\u7f16\u7801\u548c\u7248\u672c\u53f7\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49")
    public CustomApiResult<Map<String, Object>> getProcDefByNumberAndVerson(@ApiParam(value="processNumber", required=true) @ApiParam(value="processNumber", required=true) String processNumber, @ApiParam(value="version") @ApiParam(value="version") String version) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(processNumber)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            Map result = this.workflowService.getProcDefByNumberAndVerson(processNumber, version);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCDEFINFOBYNUMBERANDVERSON_FAIL.getCode(), (String)ModelErrorCodeEnum.GETPROCDEFINFOBYNUMBERANDVERSON_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcSchemesByProcDefId", desc="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id\u83b7\u53d6\u65b9\u6848\u5217\u8868")
    public CustomApiResult<List<Map<String, Object>>> getProcSchemesByProcDefId(@ApiParam(value="procDefId", required=true) @ApiParam(value="procDefId", required=true) Long procDefId) {
        if (!WfPermUtils.hasProcessQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(procDefId)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            List result = this.workflowService.getProcSchemesByProcDefId(procDefId);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETDYNCONFSCHEMESBYPROCDEFID_FAIL.getCode(), (String)ModelErrorCodeEnum.GETDYNCONFSCHEMESBYPROCDEFID_FAIL.getDesc());
        }
    }

    @ApiGetMapping(value="/getVariablesByProcInstId", desc="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u83b7\u53d6\u53d8\u91cf\u4fe1\u606f")
    public CustomApiResult<Map<String, Object>> getVariablesByProcInstId(@ApiParam(value="procInstId", required=true) @ApiParam(value="procInstId", required=true) Long procInstId, @ApiParam(value="variableKeys", required=true) @ApiParam(value="variableKeys", required=true) String variableKeys) {
        if (!WfPermUtils.hasExecutionQueryPerm("api_v2")) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc());
        }
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(variableKeys)) {
            return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            String[] tVariableKeys = variableKeys.split(",");
            Map result = this.workflowService.getVariablesByProcInstId(procInstId, tVariableKeys);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETVARIABLESBYPROCINSTID_FAIL.getCode(), (String)ModelErrorCodeEnum.GETVARIABLESBYPROCINSTID_FAIL.getDesc());
        }
    }

    private void clearNextNodes(List<WFFlowElement> result) {
        if (result != null) {
            for (WFFlowElement element : result) {
                element.getNextNodes().clear();
            }
        }
    }

    @ApiGetMapping(value="/getWorkflowModelMultiLanguageIdsByAppId", desc="\u83b7\u53d6\u6d41\u7a0b\u8bbe\u8ba1\u8d44\u6e90Id")
    public CustomApiResult<Object> getWorkflowModelMultiLanguageIdsByAppId(@ApiParam(value="\u5e94\u7528Id", required=true) @ApiParam(value="\u5e94\u7528Id", required=true) String applicationId) {
        try {
            List result = this.workflowService.getWorkflowModelMultiLanguageIdsByAppId(applicationId);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETWORKFLOWMODELMULTILANGUAGEIDSERROR.getCode(), (String)ModelErrorCodeEnum.GETWORKFLOWMODELMULTILANGUAGEIDSERROR.getDesc());
        }
    }

    @ApiGetMapping(value="/getWorkflowTemplateMultiLanguageIdsByCategoryId", desc="\u83b7\u53d6\u6d41\u7a0b\u6a21\u677f\u8d44\u6e90Id")
    public CustomApiResult<Object> getWorkflowTemplateMultiLanguageIdsByCategoryId(@ApiParam(value="\u5206\u7c7bId", required=true) @ApiParam(value="\u5206\u7c7bId", required=true) Long categoryId) {
        try {
            List result = this.workflowService.getWorkflowTemplateMultiLanguageIdsByCategoryId(categoryId);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETWORKFLOWTEMPLATEMULTILANGUAGEIDSERROR.getCode(), (String)ModelErrorCodeEnum.GETWORKFLOWTEMPLATEMULTILANGUAGEIDSERROR.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcessCategoryData", desc="\u83b7\u53d6\u6d41\u7a0b\u5206\u7c7b\u6811\u6570\u636e")
    public CustomApiResult<Object> getProcessCategoryData() {
        try {
            Object result = this.workflowService.getProcessCategoryData();
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCESSCATEGORYDATAERROR.getCode(), (String)ModelErrorCodeEnum.GETPROCESSCATEGORYDATAERROR.getDesc());
        }
    }

    @ApiGetMapping(value="/getProcessTemplateCategoryData", desc="\u83b7\u53d6\u6d41\u7a0b\u6a21\u677f\u5206\u7c7b\u6811\u6570\u636e")
    public CustomApiResult<Object> getProcessTemplateCategoryData() {
        try {
            Object result = this.workflowService.getProcessTemplateCategoryData();
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETPROCESSTEMPLATECATEGORYDATAERROR.getCode(), (String)ModelErrorCodeEnum.GETPROCESSTEMPLATECATEGORYDATAERROR.getDesc());
        }
    }

    @ApiPostMapping(value="/getWorkflowResourceIdsByCategoryId", desc="\u6839\u636e\u6d41\u7a0b\u7c7b\u522bID\u83b7\u53d6\u5168\u90e8\u7684\u5de5\u4f5c\u6d41\u591a\u8bed\u8a00\u8bcd\u6761ID")
    public CustomApiResult<List<Map<String, Object>>> getWorkflowResourceIdsByCategoryId(@ApiParam(value="\u6d41\u7a0b\u7c7b\u522bId", required=true) @ApiParam(value="\u6d41\u7a0b\u7c7b\u522bId", required=true) Long categoryId) {
        this.logger.debug(String.format("[request param] categoryId: %s", categoryId));
        try {
            if (WfUtils.isEmpty(categoryId)) {
                return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
            }
            List result = this.workflowService.getWorkflowResourceIdsByCategoryId(categoryId);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETWORKFLOWRESOURCEIDSBYCATEGORYIDERROR.getCode(), (String)ModelErrorCodeEnum.GETWORKFLOWRESOURCEIDSBYCATEGORYIDERROR.getDesc());
        }
    }

    @ApiPostMapping(value="/getWorkflowModelResourceIdsByCategoryId", desc="\u6839\u636e\u6d41\u7a0b\u7c7b\u522bID\u83b7\u53d6\u5168\u90e8\u7684\u5de5\u4f5c\u6d41\u591a\u8bed\u8a00\u8bcd\u6761ID")
    public CustomApiResult<List<Map<String, Object>>> getWorkflowModelResourceIdsByCategoryId(@ApiParam(value="\u6d41\u7a0b\u7c7b\u522bId", required=true) @ApiParam(value="\u6d41\u7a0b\u7c7b\u522bId", required=true) Long categoryId) {
        this.logger.debug(String.format("[request param] categoryId: %s", categoryId));
        try {
            if (WfUtils.isEmpty(categoryId)) {
                return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
            }
            List result = this.workflowService.getWorkflowModelResourceIdsByCategoryId(categoryId);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.GETWORKFLOWMODELRESOURCEIDSBYCATEGORYIDERROR.getCode(), (String)ModelErrorCodeEnum.GETWORKFLOWMODELRESOURCEIDSBYCATEGORYIDERROR.getDesc());
        }
    }

    @ApiPostMapping(value="/applyWorkflowMultiLanguageWords4ModelAndTpl", desc="\u56de\u5199\u591a\u8bed\u8a00\u6d41\u7a0b\u8bbe\u8ba1\u548c\u6d41\u7a0b\u6a21\u677f")
    public CustomApiResult<String> applyWorkflowMultiLanguageWords4ModelAndTpl(@ApiParam(value="\u591a\u8bed\u8a00\u6570\u636e", required=true) @ApiParam(value="\u591a\u8bed\u8a00\u6570\u636e", required=true) Map<String, Object> mutiLangDatas) {
        this.logger.debug(String.format("[request param] mutiLangDatas: %s", WfUtils.mapToString(mutiLangDatas)));
        try {
            if (WfUtils.isEmptyForMap(mutiLangDatas)) {
                return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
            }
            this.workflowService.applyWorkflowMultiLanguageWords4ModelAndTpl(mutiLangDatas);
            return CustomApiResult.success((Object)"success");
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.APPLYWORKFLOWMULTILANGUAGEWORDS4MODELANDTPLERROR.getCode(), (String)ModelErrorCodeEnum.APPLYWORKFLOWMULTILANGUAGEWORDS4MODELANDTPLERROR.getDesc());
        }
    }

    @ApiPostMapping(value="/makeWorkflowMultiLanguagePackage4ModelAndTpl", desc="\u5de5\u4f5c\u6d41\u670d\u52a1\u5236\u4f5c\u6d41\u7a0b\u8bbe\u8ba1\u548c\u6d41\u7a0b\u6a21\u677f\u591a\u8bed\u8a00\u5b89\u88c5")
    public CustomApiResult<Map<String, Object>> makeWorkflowMultiLanguagePackage4ModelAndTpl(@ApiParam(value="\u8d44\u6e90\u53c2\u6570", required=true) @ApiParam(value="\u8d44\u6e90\u53c2\u6570", required=true) Map<String, Object> mutiLangDatas) {
        this.logger.debug(String.format("[request param] mutiLangDatas: %s", WfUtils.mapToString(mutiLangDatas)));
        try {
            if (WfUtils.isEmptyForMap(mutiLangDatas)) {
                return CustomApiResult.fail((String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)ModelErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
            }
            Map result = this.workflowService.makeWorkflowMultiLanguagePackage4ModelAndTpl(mutiLangDatas);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)ModelErrorCodeEnum.MAKEWORKFLOWMULTILANGUAGEPACKAGE4MODELANDTPLERROR.getCode(), (String)ModelErrorCodeEnum.MAKEWORKFLOWMULTILANGUAGEPACKAGE4MODELANDTPLERROR.getDesc());
        }
    }
}

