/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class TaskCirculateApiService
extends AbstractWorkflowApiService {
    public ApiResult doCustomService(Map<String, Object> map) {
        if (WfUtils.isEmptyString(map.get("taskId"))) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%s\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCirculateForBatchApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]), "taskId"));
        }
        if (WfUtils.isEmptyString(map.get("userId"))) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%s\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCirculateForBatchApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]), "userId"));
        }
        if (WfUtils.isEmptyString(map.get("circulationMsg"))) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%s\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCirculateForBatchApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]), "circulationMsg"));
        }
        this.assertInServiceAndLog("taskCirculate", map);
        Long taskId = 0L;
        ArrayList<Long> userIds = new ArrayList<Long>();
        ILocaleString circulationMsg = null;
        try {
            taskId = Long.parseLong(map.get("taskId").toString());
            try {
                DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"wf_hitaskinst");
                if (taskInfo == null) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u4efb\u52a1\uff0c\u6570\u636e\u5df2\u5220\u9664\uff0c\u4e0d\u80fd%s\u3002", (String)"TaskCirculationCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
                }
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                String[] bpmnModel = wfService.getRepositoryService().getBpmnModel(taskInfo.getLong("processdefinitionid"), taskInfo.getLong("processinstanceid"));
                FlowElement flowElement = bpmnModel.getFlowElement(taskInfo.getString("taskdefinitionkey"));
                if (!(flowElement instanceof UserTask) || ((UserTask)flowElement).getCirculateModel() == null || !((UserTask)flowElement).getCirculateModel().isCirculateWhenMatch()) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u8282\u70b9\u4e0d\u652f\u6301\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u914d\u7f6e\u3002", (String)"TaskCirculateApiService_2", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
                }
            }
            catch (Exception e) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8282\u70b9\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5taskID\u662f\u5426\u6b63\u786e\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"TaskCirculateApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.getExceptionStacktrace(e)));
            }
            String userStr = map.get("userId").toString();
            if (WfUtils.isNotEmpty(userStr)) {
                String[] arrs = userStr.split(",");
                for (String val : arrs) {
                    userIds.add(Long.valueOf(val));
                }
            }
            if (userIds.isEmpty()) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4eba\u7684\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5userID\u662f\u5426\u6b63\u786e\u3002", (String)"TaskCirculateApiService_4", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName()));
            }
            if (userIds.size() == 1 && userIds.contains(Long.valueOf(RequestContext.get().getUserId()))) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u201c%2$s\u201d\u7ed9\u81ea\u5df1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCirculateApiService_5", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName(), WfConfigurationUtil.getCirculationName()));
            }
            for (Long userId : userIds) {
                boolean userEnable = UserServiceHelper.isUserEnable((long)userId);
                if (userEnable) continue;
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u53ef\u7528\uff08\u4eba\u5458\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaskCirculationForBatchCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getCirculationName(), WfConfigurationUtil.getCirculationName()));
            }
            String circulationMsgStr = map.get("circulationMsg").toString();
            if (circulationMsgStr != null && circulationMsgStr.startsWith("{") && circulationMsgStr.endsWith("}")) {
                JSONObject circulatMsg = (JSONObject)JSONObject.parse((String)circulationMsgStr);
                circulationMsg = WfMultiLangUtils.getMultiLangValue((Map<String, Object>)circulatMsg);
            } else {
                circulationMsg = WfUtils.getMultiLangValue(circulationMsgStr);
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"TaskCirculateApiService_7", (String)"bos-wf-engine", (Object[])new Object[0]), WfUtils.getExceptionStacktrace(e)));
        }
        try {
            if (WfPermUtils.isNeedCheckApiPer("api_v1")) {
                ArrayList<Long> taskIds = new ArrayList<Long>(1);
                taskIds.add(taskId);
                if (!WfPermUtils.isTaskRelationship(taskIds, RequestContext.get().getCurrUserId()) && !WfPermUtils.hasTaskHandlerPerm("api_v1")) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u4efb\u52a1\u5e72\u7cfb\u4eba\uff0c\u4e0d\u80fd\u8fdb\u884c\u4efb\u52a1\u4f20\u9605\u3002", (String)"TaskCirculateApiService_8", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
            }
            TaskCirculateApiService.invokeBOSService("IWorkflowService", "taskCirculate", taskId, userIds, circulationMsg);
            return ApiResult.success((Object)"taskCirculate sucesss");
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

