/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.modle.TaskCirculateRequestParams;
import kd.bos.workflow.api.modle.TaskCoordinateRequestParams;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.OperateResult;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;
import kd.bos.workflow.exception.TaskErrorCodeEnum;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.collections.CollectionUtils;

@ApiController(value="wf", desc="\u4efb\u52a1\u64cd\u4f5c")
@ApiMapping(value="/")
public class TaskController
implements Serializable {
    private Log logger = LogFactory.getLog(this.getClass());
    private static WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");

    @ApiPostMapping(value="/withdrawTransferTask", desc="\u4efb\u52a1\u64a4\u56de\u8f6c\u4ea4")
    public CustomApiResult<String> withdrawTransferTask(@ApiParam(value="taskId", required=true) @ApiParam(value="taskId", required=true) Long taskId, @ApiParam(value="ownerId", required=true) @ApiParam(value="ownerId", required=true) Long ownerId) {
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(ownerId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            TaskEntity taskEntity;
            TaskService taskService = workflowService.getTaskService();
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean isExist = WfPermUtils.isTaskTransfer(taskId, RequestContext.get().getCurrUserId());
                if (isExist) {
                    if (RequestContext.get().getCurrUserId() != ownerId.longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TRANSFER_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_TRANSFER_IS_NOT_ME.getDesc());
                    }
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            if ((taskEntity = taskService.createTaskQuery().addFilter("id", taskId).singleResult()) == null) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), (String)TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
            }
            Map result = workflowService.withdrawTransferTask(taskId, ownerId);
            for (Map.Entry map : result.entrySet()) {
                if ("success".equals(map.getKey())) continue;
                return CustomApiResult.fail((String)((String)map.getKey()), (String)map.getValue().toString());
            }
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u8f6c\u4ea4\u4efb\u52a1\u5df2\u64a4\u56de\u3002", (String)"TaskController_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TRANSFER_TASK_FAILE.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_TRANSFER_TASK_FAILE.getDesc());
        }
    }

    @ApiPostMapping(value="/withdrawTaskByTaskId")
    public CustomApiResult<String> withdrawTaskByTaskId(@ApiParam(value="historicTaskId", required=true) @ApiParam(value="historicTaskId", required=true) Long historicTaskId, @ApiParam(value="userId", required=true) @ApiParam(value="userId", required=true) Long userId) {
        if (WfUtils.isEmpty(historicTaskId) || WfUtils.isEmpty(userId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            HistoryService taskService;
            HistoricTaskInstanceEntity taskEntity;
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean isExist = WfPermUtils.isTaskAssignee(historicTaskId, RequestContext.get().getCurrUserId());
                if (isExist) {
                    if (RequestContext.get().getCurrUserId() != userId.longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TASK_BY_TASKID_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_TASK_BY_TASKID_IS_NOT_ME.getDesc());
                    }
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            if ((taskEntity = (taskService = workflowService.getHistoryService()).createHistoricTaskInstanceQuery().addFilter("id", historicTaskId).singleResult()) == null) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), (String)TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
            }
            if (!userId.equals(taskEntity.getAssigneeId())) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_NOT_ASSIGNEE.getCode(), (String)TaskErrorCodeEnum.USER_NOT_ASSIGNEE.getDesc());
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)historicTaskId, (String)"wf_hitaskinst");
            if (dynamicObject != null && "BillTask".equals(dynamicObject.get("category"))) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.BILL_TASK_NOT_WITHDRAW.getCode(), (String)TaskErrorCodeEnum.BILL_TASK_NOT_WITHDRAW.getDesc());
            }
            workflowService.withdrawTask(historicTaskId, userId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u64a4\u56de\u4efb\u52a1\u6210\u529f\u3002", (String)"TaskController_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if ("bos.wf.canNotWithdraw".equals(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TASK_RULE_VAILD_FAILE.getCode(), (String)e.getMessage());
            }
            return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TASK_FAILE.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_TASK_FAILE.getDesc());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ApiPostMapping(value="/withdrawTaskByBusinessKey")
    public CustomApiResult<String> withdrawTaskByBusinessKey(@ApiParam(value="businessKey", required=true) @ApiParam(value="businessKey", required=true) String businessKey, @ApiParam(value="userId", required=true) @ApiParam(value="userId", required=true) Long userId) {
        if (WfUtils.isEmptyString(businessKey) || WfUtils.isEmpty(userId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            Long historicTaskId = workflowService.getTaskService().getLatestHiTaskIdByBusinessKeyAndUserId(businessKey, userId);
            if (!WfUtils.isNotEmpty(historicTaskId)) return CustomApiResult.fail((String)TaskErrorCodeEnum.HISTASK_NOT_EXITS_BY_BUSINESS.getCode(), (String)TaskErrorCodeEnum.HISTASK_NOT_EXITS_BY_BUSINESS.getDesc());
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean isExist = WfPermUtils.isTaskAssignee(historicTaskId, RequestContext.get().getCurrUserId());
                if (!isExist) return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                if (RequestContext.get().getCurrUserId() != userId.longValue()) {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TASK_BY_TASKID_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_TASK_BY_TASKID_IS_NOT_ME.getDesc());
                }
            }
            workflowService.withdrawTaskByBusinessKeyAndUserId(businessKey, userId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u64a4\u56de\u4efb\u52a1\u6210\u529f\u3002", (String)"TaskController_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if (!"bos.wf.canNotWithdraw".equals(e.getErrorCode().getCode())) return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TASK_FAILE.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_TASK_FAILE.getDesc());
            return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_TASK_RULE_VAILD_FAILE.getCode(), (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/requestTaskCoordinate")
    public CustomApiResult<String> requestTaskCoordinate(@ApiParam(value="taskCoordinateRequestParams", required=true) @ApiParam(value="taskCoordinateRequestParams", required=true) TaskCoordinateRequestParams taskCoordinateRequestParams) {
        if (ObjectUtils.isEmpty((Object)taskCoordinateRequestParams) || WfUtils.isEmpty(taskCoordinateRequestParams.getTaskId()) || CollectionUtils.isEmpty(taskCoordinateRequestParams.getUserIds()) || WfUtils.isEmptyString(taskCoordinateRequestParams.getCoordinateMsg()) || WfUtils.isEmpty(taskCoordinateRequestParams.getOwnerId())) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        long taskId = taskCoordinateRequestParams.getTaskId();
        List<Long> userIds = taskCoordinateRequestParams.getUserIds();
        LocaleString coordinateMsg = new LocaleString(taskCoordinateRequestParams.getCoordinateMsg());
        boolean isPublic = taskCoordinateRequestParams.isPublic();
        try {
            WorkflowService workflowService;
            TaskService taskService;
            TaskEntity taskEntity;
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean isExist = WfPermUtils.isTaskParticipant(taskId, (Long)RequestContext.get().getCurrUserId());
                if (isExist) {
                    if (RequestContext.get().getCurrUserId() != taskCoordinateRequestParams.getOwnerId().longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.COORDINATE_TASK_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.COORDINATE_TASK_IS_NOT_ME.getDesc());
                    }
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            if ((taskEntity = (taskService = (workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService")).getTaskService()).createTaskQuery().addFilter("id", taskId).singleResult()) == null) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), (String)TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
            }
            if (!QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)})) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.USERID_NOT_EXTIS.getCode(), (String)TaskErrorCodeEnum.USERID_NOT_EXTIS.getDesc());
            }
            Long ownerId = taskCoordinateRequestParams.getOwnerId();
            String result = taskService.taskCoordinateRequest(taskId, false, userIds, (ILocaleString)coordinateMsg, ownerId, isPublic);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if ("bos.wf.task.participantExistForWorksTransferError".equals(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.PARTICIPANT_EXIST_FOR_WORK_STRANSFER_ERROR.getCode(), (String)TaskErrorCodeEnum.PARTICIPANT_EXIST_FOR_WORK_STRANSFER_ERROR.getDesc());
            }
            if ("bos.wf.task.participantExistForCoordinateError".equals(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.PARTICIPANT_EXIST_FOR_COORDINATE_ERROR.getCode(), (String)TaskErrorCodeEnum.PARTICIPANT_EXIST_FOR_COORDINATE_ERROR.getDesc());
            }
            if ("bos.wf.task.participantIsNullForCoordinateError".equals(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.PARTICIPANT_IS_NULL_FOR_COORDINAT_EERROR.getCode(), (String)TaskErrorCodeEnum.PARTICIPANT_IS_NULL_FOR_COORDINAT_EERROR.getDesc());
            }
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_COORDINATE_REQUEST_FAILE.getCode(), (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/withdrawCoordinateTaskReply")
    public CustomApiResult<String> withdrawCoordinateTaskReply(@ApiParam(value="historicTaskId", required=true) @ApiParam(value="historicTaskId", required=true) Long historicTaskId, @ApiParam(value="userId", required=true) @ApiParam(value="userId", required=true) Long userId) {
        if (WfUtils.isEmpty(historicTaskId) || WfUtils.isEmpty(userId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            WorkflowService workflowService;
            HistoryService taskService;
            HistoricTaskInstanceEntity taskEntity;
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean extis = WfPermUtils.isTaskCoordinate(historicTaskId, RequestContext.get().getCurrUserId());
                if (extis) {
                    if (RequestContext.get().getCurrUserId() != userId.longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_COORDINATE_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_COORDINATE_IS_NOT_ME.getDesc());
                    }
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            if ((taskEntity = (taskService = (workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService")).getHistoryService()).createHistoricTaskInstanceQuery().addFilter("id", historicTaskId).singleResult()) == null) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), (String)TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
            }
            workflowService.withdrawCoordinateTaskReply(historicTaskId, userId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u534f\u529e\u4efb\u52a1\u56de\u590d\u64a4\u56de\u6210\u529f\u3002", (String)"TaskController_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            if ("bos.wf.canNotWithdraw".equals(e.getErrorCode().getCode())) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_COORDINATE_TASK_RULE_VAILD_FAILE.getCode(), (String)e.getMessage());
            }
            return CustomApiResult.fail((String)TaskErrorCodeEnum.WITHDRAW_COORDINATE_TASK_REPLY_FAILE.getCode(), (String)TaskErrorCodeEnum.WITHDRAW_COORDINATE_TASK_REPLY_FAILE.getDesc());
        }
    }

    @ApiPostMapping(value="/replyCoordinateTask")
    public CustomApiResult<String> replyCoordinateTask(@ApiParam(value="taskId", required=true) @ApiParam(value="taskId", required=true) Long taskId, @ApiParam(value="taskCoordinateOpinion", required=true) @ApiParam(value="taskCoordinateOpinion", required=true) String taskCoordinateOpinion, @ApiParam(value="userId", required=true) @ApiParam(value="userId", required=true) Long userId) {
        if (WfUtils.isEmptyString(taskId) || WfUtils.isEmptyString(taskCoordinateOpinion) || WfUtils.isEmpty(userId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            boolean isSameUser = false;
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean extis = WfPermUtils.isTaskCoordinate(taskId, RequestContext.get().getCurrUserId());
                if (extis) {
                    if (RequestContext.get().getCurrUserId() != userId.longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.COORDINATE_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.COORDINATE_IS_NOT_ME.getDesc());
                    }
                    isSameUser = true;
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            LocaleString coordinateOpinion = new LocaleString(taskCoordinateOpinion);
            TaskService taskService = workflowService.getTaskService();
            TaskEntity taskEntity = taskService.createTaskQuery().addFilter("id", taskId).singleResult();
            if (taskEntity == null) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), (String)TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
            }
            if (!isSameUser && !WfPermUtils.isTaskCoordinate(taskId, userId)) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_NOT_COORDINATE_REPLY.getCode(), (String)TaskErrorCodeEnum.USER_NOT_COORDINATE_REPLY.getDesc());
            }
            workflowService.taskCoordinateReply(taskId, (ILocaleString)coordinateOpinion, null, userId);
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u534f\u529e\u4efb\u52a1\u56de\u590d\u6210\u529f\u3002", (String)"TaskController_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        catch (KDException e) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.COORDINATE_TASK_REPLY_FAILE.getCode(), (String)e.getMessage());
        }
    }

    @ApiPostMapping(value="/circulateTask")
    public CustomApiResult<Map<String, Object>> circulateTask(@ApiParam(value="taskId", required=true) @ApiParam(value="taskId", required=true) Long taskId, @ApiParam(value="userIds", required=true) @ApiParam(value="userIds", required=true) List<Long> userIds, @ApiParam(value="circulationMsg", required=true) @ApiParam(value="circulationMsg", required=true) String circulationMsg, @ApiParam(value="ownerId", required=true) @ApiParam(value="ownerId", required=true) Long ownerId) {
        if (WfUtils.isEmpty(taskId) || CollectionUtils.isEmpty(userIds) || WfUtils.isEmptyString(circulationMsg) || WfUtils.isEmpty(ownerId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        HistoryService historyService = workflowService.getHistoryService();
        HistoricTaskInstanceEntity historicTaskInstanceEntity = historyService.createHistoricTaskInstanceQuery().addFilter("id", taskId).singleResult();
        if (historicTaskInstanceEntity == null) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_NOT_EXITS.getCode(), (String)TaskErrorCodeEnum.TASK_NOT_EXITS.getDesc());
        }
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        boolean isSameUser = false;
        if (!historicTaskInstanceEntity.isBizTask()) {
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean extis = WfPermUtils.isTaskRelationship(taskIds, RequestContext.get().getCurrUserId());
                if (extis) {
                    if (RequestContext.get().getCurrUserId() != ownerId.longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.CIRCULATE_TASK_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.CIRCULATE_TASK_IS_NOT_ME.getDesc());
                    }
                    isSameUser = true;
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            try {
                BpmnModel bpmnModel = workflowService.getRepositoryService().getBpmnModel(historicTaskInstanceEntity.getProcessDefinitionId(), historicTaskInstanceEntity.getProcessInstanceId());
                FlowElement flowElement = bpmnModel.getFlowElement(historicTaskInstanceEntity.getTaskDefinitionKey());
                if (!(flowElement instanceof UserTask) || ((UserTask)flowElement).getCirculateModel() == null || !((UserTask)flowElement).getCirculateModel().isCirculateWhenMatch()) {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_ACTIVITY_NOT_COORDINATE.getCode(), (String)TaskErrorCodeEnum.TASK_ACTIVITY_NOT_COORDINATE.getDesc());
                }
            }
            catch (Exception e) {
                this.logger.warn(WfUtils.getExceptionStacktrace(e));
                return CustomApiResult.fail((String)TaskErrorCodeEnum.PARSE_ACTIVITY_FAILE.getCode(), (String)TaskErrorCodeEnum.PARSE_ACTIVITY_FAILE.getDesc());
            }
        }
        for (Long userId : userIds) {
            if (userId != null) continue;
            return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_IS_NULL.getCode(), (String)TaskErrorCodeEnum.USER_IS_NULL.getDesc());
        }
        if (!isSameUser && !WfPermUtils.isTaskHiparticipant(taskId, ownerId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARTICIPANT_IS_NOT_EXIST.getCode(), (String)TaskErrorCodeEnum.PARTICIPANT_IS_NOT_EXIST.getDesc());
        }
        ILocaleString circulationMsgI = null;
        try {
            if (WfUtils.isJSONFormat(circulationMsg)) {
                JSONObject circulatMsg = (JSONObject)JSONObject.parse((String)circulationMsg);
                circulationMsgI = WfMultiLangUtils.getMultiLangValue((Map<String, Object>)circulatMsg);
            } else {
                circulationMsgI = WfUtils.getMultiLangValue(circulationMsg);
            }
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_CIRCULATE_MSG_ERROR.getCode(), (String)TaskErrorCodeEnum.TASK_CIRCULATE_MSG_ERROR.getDesc());
        }
        Map<Object, Object> result = new HashMap<String, Object>();
        try {
            if (historicTaskInstanceEntity.isBizTask()) {
                try {
                    OperateResult operateResult;
                    IMessageCenterService messageCenterService = (IMessageCenterService)ServiceFactory.getService((String)"MessageCenterService");
                    CirculateOperationParam circulateOperationParam = new CirculateOperationParam();
                    circulateOperationParam.setTaskIds(taskIds);
                    circulateOperationParam.setOperaterId(ownerId);
                    circulateOperationParam.setCirculateMsg(circulationMsgI);
                    circulateOperationParam.setCirculateUserIds(userIds);
                    BatchOperateResult batchOperateResult = messageCenterService.circulateBizTask(circulateOperationParam);
                    result.put("issuccess", batchOperateResult.isSuccess());
                    if (!batchOperateResult.isSuccess()) {
                        result.put("message", batchOperateResult.getValidateMsg());
                    }
                    Long circulateMsgId = 0L;
                    List operateResults = batchOperateResult.getOperateResults();
                    if (operateResults != null && !operateResults.isEmpty() && "success".equals((operateResult = (OperateResult)operateResults.get(0)).getOperateStatus())) {
                        circulateMsgId = Long.valueOf(operateResult.getOperateMsg());
                    }
                    result.put("circulateMsgId", circulateMsgId);
                }
                catch (Exception e) {
                    result.put("issuccess", false);
                    result.put("message", e.getMessage());
                }
            } else {
                TaskService taskService = workflowService.getTaskService();
                result = taskService.taskCirculation(taskId, userIds, circulationMsgI, ownerId);
            }
            return CustomApiResult.success(result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_CIRCULATION_FAILE.getCode(), (String)TaskErrorCodeEnum.TASK_CIRCULATION_FAILE.getDesc());
        }
    }

    @ApiPostMapping(value="/circulateTaskForBatch")
    public CustomApiResult<BatchOperateResult> circulateTaskForBatch(@ApiParam(value="taskCirculateRequestParams", required=true) @ApiParam(value="taskCirculateRequestParams", required=true) TaskCirculateRequestParams taskCirculateRequestParams) {
        List<Long> taskIds = taskCirculateRequestParams.getTaskIds();
        if (CollectionUtils.isEmpty(taskIds) || CollectionUtils.isEmpty(taskCirculateRequestParams.getCirculationUserIds()) || WfUtils.isEmptyString(taskCirculateRequestParams.getCirculationMsg()) || WfUtils.isEmpty(taskCirculateRequestParams.getSenderUserId())) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        Iterator<Long> ite = taskIds.iterator();
        while (ite.hasNext()) {
            if (!WfUtils.isEmpty(ite.next())) continue;
            ite.remove();
        }
        if (CollectionUtils.isEmpty(taskIds)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        boolean isSameUser = false;
        if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
            boolean extis = WfPermUtils.isTaskRelationship(taskCirculateRequestParams.getTaskIds(), RequestContext.get().getCurrUserId());
            if (extis) {
                if (RequestContext.get().getCurrUserId() != taskCirculateRequestParams.getSenderUserId().longValue()) {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.CIRCULATE_TASK_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.CIRCULATE_TASK_IS_NOT_ME.getDesc());
                }
                isSameUser = true;
            } else {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
            }
        }
        for (Long userId : taskCirculateRequestParams.getCirculationUserIds()) {
            if (userId != null) continue;
            return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_IS_NULL.getCode(), (String)TaskErrorCodeEnum.USER_IS_NULL.getDesc());
        }
        if (!isSameUser && !WfPermUtils.isTaskHiparticipant(taskCirculateRequestParams.getTaskIds(), taskCirculateRequestParams.getSenderUserId())) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARTICIPANT_IS_NOT_EXIST.getCode(), (String)TaskErrorCodeEnum.PARTICIPANT_IS_NOT_EXIST.getDesc());
        }
        ILocaleString circulationMsgI = null;
        try {
            if (WfUtils.isJSONFormat(taskCirculateRequestParams.getCirculationMsg())) {
                JSONObject circulatMsg = (JSONObject)JSONObject.parse((String)taskCirculateRequestParams.getCirculationMsg());
                circulationMsgI = WfMultiLangUtils.getMultiLangValue((Map<String, Object>)circulatMsg);
            } else {
                circulationMsgI = WfUtils.getMultiLangValue(taskCirculateRequestParams.getCirculationMsg());
            }
        }
        catch (Exception e) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_CIRCULATE_MSG_ERROR.getCode(), (String)TaskErrorCodeEnum.TASK_CIRCULATE_MSG_ERROR.getDesc());
        }
        try {
            WorkflowService workflowService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
            BatchOperateResult result = workflowService.taskCirculateForBatch(taskCirculateRequestParams.getTaskIds(), taskCirculateRequestParams.getCirculationUserIds(), taskCirculateRequestParams.getSenderUserId(), circulationMsgI);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_CIRCULATION_FORBATCH_FAILE.getCode(), (String)TaskErrorCodeEnum.TASK_CIRCULATION_FORBATCH_FAILE.getDesc());
        }
    }

    @ApiPostMapping(value="/remindersTask")
    public CustomApiResult<Map<String, Object>> remindersTask(@ApiParam(value="processInsId", required=true) @ApiParam(value="processInsId", required=true) Long processInsId, @ApiParam(value="reminderMsg", required=true) @ApiParam(value="reminderMsg", required=true) String reminderMsg, @ApiParam(value="userId", required=true) @ApiParam(value="userId", required=true) Long userId) {
        if (WfUtils.isEmpty(processInsId) || WfUtils.isEmptyString(reminderMsg) || WfUtils.isEmpty(userId)) {
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getCode(), (String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR.getDesc());
        }
        try {
            HistoricProcessInstanceEntity entity = workflowService.getHistoryService().getHistoricProcessInstance(processInsId);
            if (ObjectUtils.isEmpty((Object)entity) || entity.getEndTime() != null) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.PROCESS_NOT_EXTIS.getCode(), (String)TaskErrorCodeEnum.PROCESS_NOT_EXTIS.getDesc());
            }
            boolean isSameUser = false;
            if (!WfPermUtils.hasTaskHandlerPerm("api_v2")) {
                boolean extis = WfPermUtils.isTaskStarter(processInsId, RequestContext.get().getCurrUserId());
                if (extis) {
                    if (RequestContext.get().getCurrUserId() != userId.longValue()) {
                        return CustomApiResult.fail((String)TaskErrorCodeEnum.REDMINES_TASK_IS_NOT_ME.getCode(), (String)TaskErrorCodeEnum.REDMINES_TASK_IS_NOT_ME.getDesc());
                    }
                    isSameUser = true;
                } else {
                    return CustomApiResult.fail((String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getCode(), (String)TaskErrorCodeEnum.USER_DONT_HAVE_PERMISSION.getDesc());
                }
            }
            LocaleString reminderMsgI = new LocaleString(reminderMsg);
            if (!isSameUser && !WfPermUtils.isTaskStarter(processInsId, userId)) {
                return CustomApiResult.fail((String)TaskErrorCodeEnum.PARTICIPANT_IS_NOT_EXIST_AND_NOT_REDMINDERS.getCode(), (String)TaskErrorCodeEnum.PARTICIPANT_IS_NOT_EXIST_AND_NOT_REDMINDERS.getDesc());
            }
            Map<String, Object> result = workflowService.getTaskService().taskAssigneeReminders(processInsId, (ILocaleString)reminderMsgI, "submit", userId);
            return CustomApiResult.success(result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)TaskErrorCodeEnum.TASK_REMINDERS_FAILE.getCode(), (String)TaskErrorCodeEnum.TASK_REMINDERS_FAILE.getDesc());
        }
    }

    @ApiGetMapping(value="/getApprovalRecords")
    public CustomApiResult<List<IApprovalRecordGroup>> getApprovalRecords(@ApiParam(value="entityNumber", required=true) @ApiParam(value="entityNumber", required=true) String entityNumber, @ApiParam(value="businessKey", required=true) @ApiParam(value="businessKey", required=true) String businessKey, @ApiParam(value="allRecord", required=true) @ApiParam(value="allRecord", required=true) boolean allRecord) {
        try {
            List result = workflowService.getApprovalRecords(entityNumber, businessKey, allRecord);
            return CustomApiResult.success((Object)result);
        }
        catch (KDException e) {
            this.logger.warn(WfUtils.getExceptionStacktrace(e));
            return CustomApiResult.fail((String)TaskErrorCodeEnum.PARAMS_CHECK_ERROR_WITHPARAM.getCode(), (String)e.getMessage());
        }
    }
}

