/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;

public class TaskCoordinateReplyApiService
extends AbstractWorkflowApiService {
    private static final String TASKID = "taskId";
    private static final String USERID = "userId";
    private static final String TASK_COORDINATE_OPINION = "taskCoordinateOpinion";

    public ApiResult doCustomService(Map<String, Object> params) {
        LocaleString taskCoordinateOpinion;
        long taskId;
        if (WfUtils.isEmptyString(params.get(TASKID)) || WfUtils.isEmptyString(params.get(TASK_COORDINATE_OPINION))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCoordinateReplyApiService_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.assertInServiceAndLog("taskCoordinateReply", params);
        long userId = 0L;
        try {
            taskId = Long.parseLong(params.get(TASKID).toString());
            if (params.get(USERID) != null) {
                userId = Long.parseLong(params.get(USERID).toString());
            }
            if (WfUtils.isEmpty(userId)) {
                userId = RequestContext.get().getCurrUserId();
            }
            taskCoordinateOpinion = new LocaleString(params.get(TASK_COORDINATE_OPINION).toString());
            if (!this.isTaskExist(taskId)) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u201ctaskId\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"TaskCoordinateReplyApiService_2", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCoordinateReplyApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            boolean isRelation = WfPermUtils.isTaskCoordinate(taskId, userId);
            if (!isRelation) {
                return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"userId\u4e0d\u662f\u4efb\u52a1\u7684\u534f\u529e\u4eba\uff0c\u4e0d\u80fd\u5904\u7406\u534f\u529e\u4efb\u52a1\u3002", (String)"TaskCoordinateReplyApiService_4", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0]));
            }
            if (WfPermUtils.isNeedCheckApiPer("api_v1") && userId != RequestContext.get().getCurrUserId() && !WfPermUtils.hasTaskHandlerPerm("api_v1")) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u4efb\u52a1\u534f\u529e\u4eba\uff0c\u4e0d\u80fd\u5904\u7406\u534f\u529e\u4efb\u52a1\u3002", (String)"TaskCoordinateReplyApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
            Object taskResult = TaskCoordinateReplyApiService.invokeBOSService("IWorkflowService", "taskCoordinateReply", taskId, taskCoordinateOpinion, null, userId);
            return ApiResult.success((Object)taskResult);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

