/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class TaskCoordinateRequestWithdrawApiService
extends AbstractWorkflowApiService {
    public ApiResult doCustomService(Map<String, Object> map) {
        if (WfUtils.isEmptyString(map.get("taskId"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCoordinateRequestWithdrawAPIService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.assertInServiceAndLog("taskCoordinateRequestWithdraw", map);
        Long taskId = 0L;
        List<Object> coordinaterIds = new ArrayList();
        Long userid = 0L;
        try {
            if (!WfUtils.isEmptyString(map.get("coordinaterId"))) {
                String[] arrs = map.get("coordinaterId").toString().replace(" ", "").split(",");
                coordinaterIds = Stream.of(arrs).map(userId -> Long.parseLong(userId)).collect(Collectors.toList());
            }
            taskId = Long.parseLong(map.get("taskId").toString());
            if (map.get("userId") != null) {
                userid = Long.parseLong(map.get("userId").toString());
            }
            if (WfUtils.isEmpty(userid)) {
                userid = RequestContext.get().getCurrUserId();
            }
            try {
                DynamicObject taskInfo = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"wf_hitaskinst");
                if (taskInfo == null) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u201ctaskId\u201d\u662f\u5426\u6b63\u786e\u3002", (String)"TaskCoordinateRequestWithdrawApiService_3", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                boolean isRelation = WfPermUtils.isTaskParticipant(taskId, userid);
                if (!isRelation) {
                    return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"userId\u4e0d\u662f\u4efb\u52a1\u7684\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u64a4\u9500\u534f\u529e\u4efb\u52a1\u3002", (String)"TaskCoordinateRequestWithdrawApiService_8", (String)"bos-wf-engine", (Object[])new Object[0]), new Object[0]));
                }
                if (WfPermUtils.isNeedCheckApiPer("api_v1") && userid.longValue() != RequestContext.get().getCurrUserId() && !WfPermUtils.hasTaskHandlerPerm("api_v1")) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f85\u529e\u4efb\u52a1\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u4e14\u4e0d\u662f\u4efb\u52a1\u53c2\u4e0e\u4eba\uff0c\u4e0d\u80fd\u64a4\u9500\u534f\u529e\u4efb\u52a1\u3002", (String)"TaskCoordinateRequestWithdrawApiService_7", (String)"bos-wf-engine", (Object[])new Object[0]));
                }
                TaskService taskService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService();
                if (CollectionUtils.isNotEmpty(coordinaterIds)) {
                    for (Long l : coordinaterIds) {
                        Map<String, Object> participantInfo = taskService.getParticipantInfoByTaskIdAndUserId(taskId, l);
                        if (!MapUtils.isEmpty(participantInfo) && "coordinate".equals(participantInfo.get("mapKeyForIdentityLinkType")) && taskInfo.get("endtime") == null) continue;
                        return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u53c2\u6570coordinaterId\u662f\u5426\u6b63\u786e\uff0c\u4f20\u5165\u7684coordinaterId\u4e2d\u53ef\u80fd\u5305\u542b\u975e\u534f\u529e\u4eba\u5458\u6216\u5df2\u5904\u7406\u7684\u534f\u529e\u4efb\u52a1\u3002", (String)"TaskCoordinateRequestWithdrawApiService_4", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"taskId\u89e3\u6790\u8282\u70b9\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5taskId\u662f\u5426\u6b63\u786e\u3002", (String)"TaskCoordinateRequestWithdrawApiService_5", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskCoordinateRequestWithdrawApiService_6", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            Object ret = TaskCoordinateRequestWithdrawApiService.invokeBOSService("IWorkflowService", "taskCoordinateRequestWithdraw", taskId, coordinaterIds, userid);
            return ApiResult.success((Object)ret);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

