/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.api;

import java.util.Map;
import kd.bos.bec.engine.pojo.TriggerEventResult;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.workflow.api.AbstractWorkflowApiService;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.exception.TaskErrorCodeEnum;

public class TriggerEventApiService
extends AbstractWorkflowApiService {
    public ApiResult doCustomService(Map<String, Object> map) {
        String data;
        String eventNumber;
        if (!WfPermUtils.hasTrigEventPerm("api_v1")) {
            return ApiResult.fail((String)TaskErrorCodeEnum.PERMISSION_DENIED.getDesc(), (String)TaskErrorCodeEnum.PERMISSION_DENIED.getCode());
        }
        if (WfUtils.isEmptyString(map.get("eventNumber")) || WfUtils.isEmptyString(map.get("data"))) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TriggerEventApiService_0", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.assertInServiceAndLog("TriggerEventApiService", map);
        try {
            eventNumber = map.get("eventNumber").toString();
            data = SerializationUtils.toJsonString((Object)map.get("data"));
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TriggerEventApiService_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        try {
            TriggerEventResult eret;
            Object result = TriggerEventApiService.invokeBOSService("IEventService", "triggerEventSubscribe", eventNumber, data);
            if (result instanceof TriggerEventResult && "fail".equals((eret = (TriggerEventResult)result).getType())) {
                this.logger.debug(String.format("trigger evt[%s] error! %s", eventNumber, eret.getDesc()));
                if (eret.getThrowable() != null) {
                    throw new KDException(eret.getThrowable(), new ErrorCode("triggerEventSubscribeError", eret.getDesc()), new Object[]{eventNumber});
                }
                throw new KDException(new ErrorCode("triggerEventSubscribeError", eret.getDesc()), new Object[]{eventNumber});
            }
            return ApiResult.success((Object)"triggerEventSubscribe sucesss");
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

