/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.handler;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.graph.handler.CardLinkManager;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationGraphPluginHandler;
import kd.bos.workflow.bizflow.graph.model.BillCardData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;

public abstract class AbstractBillRelationCardHandler<T extends BillRelation>
implements IBillRelationCardHandler {
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void setCardContent(BillRelation billRelation, Map<String, BillRelation> relMap, Map<String, CardBillInfo> billMap, BillRelationGraphData graphData) {
        BillRelation relation = billRelation;
        boolean hasPermission = this.isHasPermission(relation, billMap);
        if (hasPermission) {
            this.setBillRelationCardContent(relation, relMap, billMap, graphData);
        } else {
            Map<String, Object> datas = relation.getDatas();
            datas.put("lock", true);
            datas.put("title", relation.getEntityName());
            datas.put("lockTip", ResManager.loadKDString((String)"\u65e0\u67e5\u770b\u6743\u9650", (String)"AbstractBillRelationCardHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
    }

    protected abstract boolean isHasPermission(T var1, Map<String, CardBillInfo> var2);

    protected abstract void setBillRelationCardContent(T var1, Map<String, BillRelation> var2, Map<String, CardBillInfo> var3, BillRelationGraphData var4);

    protected void setBillCardFieldValue(Map<String, Object> datas, BillCardData cardData) {
        datas.put("name", cardData.getName());
        datas.put("department", cardData.getDepartment());
        datas.put("status", cardData.getStatus());
    }

    protected CardLinkManager getCardLinkManager(IFormView view) {
        String permStrategy = (String)view.getFormShowParameter().getCustomParam("permStrategy");
        return new CardLinkManager(permStrategy);
    }

    protected IBillRelationGraphPluginHandler getBillRelationGraphHandlerPlugin(IFormView view) {
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)view.getService(FormViewPluginProxy.class);
        List plugins = pluginProxy.getPlugIns();
        for (IFormPlugin plugin : plugins) {
            if (!(plugin instanceof IBillRelationGraphPluginHandler)) continue;
            return (IBillRelationGraphPluginHandler)plugin;
        }
        return new IBillRelationGraphPluginHandler(){};
    }
}

