/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.handler;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.workflow.bizflow.graph.handler.AbstractBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationGraphPluginHandler;
import kd.bos.workflow.bizflow.graph.model.BillCardData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;

public class BillRelationCardHandler
extends AbstractBillRelationCardHandler<BillRelation> {
    @Override
    protected boolean isHasPermission(BillRelation relation, Map<String, CardBillInfo> billMap) {
        String uniqueKey = BizFlowGraphUtil.getUniqueKey(relation.getEntityNumber(), relation.getBusinessKey());
        CardBillInfo billInfo = billMap.get(uniqueKey);
        return billInfo.isHasPermission();
    }

    @Override
    protected void setBillRelationCardContent(BillRelation relation, Map<String, BillRelation> relMap, Map<String, CardBillInfo> billMap, BillRelationGraphData graphData) {
        String uniqueKey = BizFlowGraphUtil.getUniqueKey(relation.getEntityNumber(), relation.getBusinessKey());
        CardBillInfo billInfo = billMap.get(uniqueKey);
        DynamicObject dynamicObject = billInfo.getBill();
        Map<String, Object> datas = relation.getDatas();
        this.setCommonDatas(relation, datas);
        BillCardData cardData = relation.getCardData();
        if (dynamicObject != null) {
            cardData.setBill(dynamicObject);
            cardData.addCanNotReadFields(billInfo.getCanNotReadFields());
            this.setBillCardFieldValue(datas, cardData);
        }
    }

    protected void setCommonDatas(BillRelation relation, Map<String, Object> datas) {
        datas.put("title", relation.getEntityName());
        datas.put("subtitle", relation.getBillNo());
        datas.put("businessKey", relation.getBusinessKey());
        datas.put("entityName", relation.getEntityName());
        datas.put("entityNumber", relation.getEntityNumber());
        datas.put("activityInstId", relation.getActivityInstId());
        datas.put("hasCustomRelation", relation.isHasCustomRelation());
        datas.put("accountId", relation.getAccountId());
        datas.put("tenantId", relation.getTenantId());
    }

    @Override
    public void clickHyperLink(IFormView view, Map<String, Object> param) {
        String entityNumber = (String)param.get("entityNumber");
        String businessKey = (String)param.get("businessKey");
        this.getCardLinkManager(view).clickShowSingleBillLink(view, entityNumber, businessKey);
    }

    @Override
    public void selectCard(IFormView view, Map<String, Object> param) {
        IBillRelationGraphPluginHandler plugin = this.getBillRelationGraphHandlerPlugin(view);
        plugin.selectCard(param);
    }

    @Override
    public void deselectCard(IFormView view, Map<String, Object> param) {
        IBillRelationGraphPluginHandler plugin = this.getBillRelationGraphHandlerPlugin(view);
        plugin.deselectCard(param);
    }
}

