/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.handler;

import java.util.HashMap;
import java.util.Map;
import kd.bos.workflow.bizflow.graph.handler.BillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.CrossTenantBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.CrossTenantStackedBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.CrossTenantVoucherCardHandler;
import kd.bos.workflow.bizflow.graph.handler.CrossTenantVoucherStackedCardHandler;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.StackedBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;

public class BillRelationCardHandlerFactory {
    private static final String TYPE_COMMON = "common";
    private static final String TYPE_STACKED = "stacked";
    private static final String TYPE_CROSSTENANT_COMMON = "crossTenantCommon";
    private static final String TYPE_CROSSTENANT_STACKED = "crossTenantStacked";
    private static Map<String, IBillRelationCardHandler> handlerMap = new HashMap<String, IBillRelationCardHandler>();

    private BillRelationCardHandlerFactory() {
    }

    public static IBillRelationCardHandler getBillRelationCardHandler(BillRelation relation) {
        boolean stacked = relation instanceof StackedBillRelation;
        String tenantId = relation.getTenantId();
        String accountId = relation.getAccountId();
        String entityNumber = relation.getEntityNumber();
        return BillRelationCardHandlerFactory.getBillRelationCardHandler(stacked, tenantId, accountId, entityNumber);
    }

    public static IBillRelationCardHandler getBillRelationCardHandler(boolean stacked, String tenantId, String accountId, String entityNumber) {
        boolean isCrossTenant = BizFlowGraphUtil.isCrossTenant(tenantId, accountId);
        if (isCrossTenant) {
            return BillRelationCardHandlerFactory.getCrossTenantBillRelationCardHandler(stacked, entityNumber);
        }
        return BillRelationCardHandlerFactory.getBillRelationCardHandler(stacked);
    }

    private static IBillRelationCardHandler getBillRelationCardHandler(boolean stacked) {
        if (stacked) {
            return BillRelationCardHandlerFactory.getBillRelationCardHandler(TYPE_STACKED);
        }
        return BillRelationCardHandlerFactory.getBillRelationCardHandler(TYPE_COMMON);
    }

    private static IBillRelationCardHandler getCrossTenantBillRelationCardHandler(boolean stacked, String entityNumber) {
        if ("gl_voucher".equals(entityNumber)) {
            return BillRelationCardHandlerFactory.getCrossTenantVoucherBillRelationCardHandler(stacked);
        }
        if (stacked) {
            return BillRelationCardHandlerFactory.getBillRelationCardHandler(TYPE_CROSSTENANT_STACKED);
        }
        return BillRelationCardHandlerFactory.getBillRelationCardHandler(TYPE_CROSSTENANT_COMMON);
    }

    private static IBillRelationCardHandler getCrossTenantVoucherBillRelationCardHandler(boolean stacked) {
        if (stacked) {
            return new CrossTenantVoucherStackedCardHandler();
        }
        return new CrossTenantVoucherCardHandler();
    }

    private static IBillRelationCardHandler getBillRelationCardHandler(String type) {
        IBillRelationCardHandler handler = handlerMap.get(type);
        if (handler == null) {
            switch (type) {
                case "stacked": {
                    handler = new StackedBillRelationCardHandler();
                    break;
                }
                case "common": {
                    handler = new BillRelationCardHandler();
                    break;
                }
                case "crossTenantStacked": {
                    handler = new CrossTenantStackedBillRelationCardHandler();
                    break;
                }
                case "crossTenantCommon": {
                    handler = new CrossTenantBillRelationCardHandler();
                    break;
                }
            }
            handlerMap.put(type, handler);
        }
        return handler;
    }
}

