/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.handler;

import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.WfUtils;

public class CardLinkManager {
    private Log logger = LogFactory.getLog(this.getClass());
    private String permStrategy;

    public CardLinkManager() {
        this("all");
    }

    public CardLinkManager(String permStrategy) {
        this.permStrategy = permStrategy;
    }

    public void clickShowSingleBillLink(IFormView view, String entityNumber, String businessKey) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setBillStatus(BillOperationStatus.VIEW);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(entityNumber);
        showParameter.setPkId((Object)businessKey);
        this.setCommonParameter(view, (FormShowParameter)showParameter, entityNumber);
        view.showForm((FormShowParameter)showParameter);
    }

    public void clickShowBillListLink(IFormView view, String title, String entityNumber, List<String> ids) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(entityNumber);
        ListFilterParameter filterParameter = new ListFilterParameter();
        Class pkType = null;
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            pkType = entityType.getPrimaryKey().getPropertyType();
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        if (ids != null && !ids.isEmpty()) {
            if (pkType != null && (Long.TYPE.isAssignableFrom(pkType) || Long.class.isAssignableFrom(pkType))) {
                List<Long> longIds = BizFlowUtil.getLongBusinessKeys(ids);
                for (Long id : longIds) {
                    showParameter.addLinkQueryPkId((Object)id);
                }
            } else {
                for (String id : ids) {
                    showParameter.addLinkQueryPkId((Object)id);
                }
            }
        } else {
            filterParameter.setFilter(new QFilter("1", "!=", (Object)1));
            showParameter.setListFilterParameter(filterParameter);
        }
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u5217\u8868", (String)"CardLinkManager_1", (String)"bos-wf-engine", (Object[])new Object[0]), title));
        this.setCommonParameter(view, (FormShowParameter)showParameter, entityNumber);
        view.showForm((FormShowParameter)showParameter);
    }

    private void setCommonParameter(IFormView view, FormShowParameter showParameter, String entityNumber) {
        showParameter.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("none".equals(this.permStrategy)) {
            showParameter.setHasRight(true);
        } else {
            String appId = BizFlowGraphUtil.getAppId(entityNumber, view.getFormShowParameter().getAppId());
            PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            boolean notNeedCheckPerm = permissionService.notNeedCheckPermForEntityInApp(appId, entityNumber);
            if (notNeedCheckPerm) {
                showParameter.setHasRight(true);
            } else {
                showParameter.setCustomParam("PERM_IGNORE_CHECKAPP", (Object)true);
                String originalAppId = BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
                showParameter.setCustomParam("checkRightAppId", (Object)originalAppId);
            }
        }
    }
}

