/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.workflow.bizflow.graph.handler.AbstractBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationGraphPluginHandler;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;

public class StackedBillRelationCardHandler
extends AbstractBillRelationCardHandler<StackedBillRelation> {
    @Override
    protected boolean isHasPermission(StackedBillRelation relation, Map<String, CardBillInfo> billMap) {
        return true;
    }

    @Override
    protected void setBillRelationCardContent(StackedBillRelation relation, Map<String, BillRelation> relMap, Map<String, CardBillInfo> billMap, BillRelationGraphData graphData) {
        Map<String, Object> datas = relation.getDatas();
        List<String> businessKeys = relation.getStackedBusKeys();
        int size = relation.getStackedSize();
        this.setCommonData(relation, relMap, datas);
        if (size > 0) {
            datas.put("subtitle", ResManager.loadKDString((String)"\u67e5\u770b\u6709\u6743\u9650\u7684\u5355\u636e", (String)"StackedBillRelationCardHandler_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            datas.put("name", String.format(ResManager.loadKDString((String)"\u5355\u636e\u603b\u6570\uff1a%s", (String)"StackedBillRelationCardHandler_2", (String)"bos-wf-engine", (Object[])new Object[0]), size));
            graphData.getBusinessKeysMap().put(relation.getResourceId(relMap), businessKeys);
        } else {
            this.logger.debug(String.format("The card %s (%s) has no data and may have been deleted.", relation.getResourceId(relMap), relation.getBusinessKey()));
        }
    }

    protected void setCommonData(StackedBillRelation relation, Map<String, BillRelation> relMap, Map<String, Object> datas) {
        datas.put("title", relation.getEntityName());
        datas.put("entityNumber", relation.getEntityNumber());
        datas.put("itemId", relation.getResourceId(relMap));
        datas.put("isStacked", true);
        datas.put("accountId", relation.getAccountId());
        datas.put("tenantId", relation.getTenantId());
    }

    @Override
    public void clickHyperLink(IFormView view, Map<String, Object> param) {
        String entityNumber = (String)param.get("entityNumber");
        String title = (String)param.get("title");
        List<String> ids = this.getStackedBillIds(view, param);
        this.getCardLinkManager(view).clickShowBillListLink(view, title, entityNumber, ids);
    }

    protected List<String> getStackedBillIds(IFormView view, Map<String, Object> param) {
        String itemId = (String)param.get("itemId");
        String billIdStr = view.getPageCache().get(String.format("%s.%s", "stackedBillIds", itemId));
        if (billIdStr != null) {
            return (List)SerializationUtils.fromJsonString((String)billIdStr, List.class);
        }
        return new ArrayList<String>();
    }

    @Override
    public void selectCard(IFormView view, Map<String, Object> params) {
        IBillRelationGraphPluginHandler plugin = this.getBillRelationGraphHandlerPlugin(view);
        List<String> ids = this.getStackedBillIds(view, params);
        params.put("billIds", ids);
        plugin.selectStackedCard(params);
    }

    @Override
    public void deselectCard(IFormView view, Map<String, Object> param) {
        IBillRelationGraphPluginHandler plugin = this.getBillRelationGraphHandlerPlugin(view);
        plugin.deselectStackedCard(param);
    }
}

