/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.model;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BillCardData {
    private DynamicObject bill;
    private BusinessModelVariableScope variableScope;
    private WorkflowService service;
    protected Set<String> canNotReadFields = new HashSet<String>(16);
    protected String nameField;
    protected String departmentField;
    protected String statusField;

    public void setBill(DynamicObject bill) {
        this.bill = bill;
        this.variableScope = new BusinessModelVariableScope(bill);
        this.service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public void setDepartmentField(String departmentField) {
        this.departmentField = departmentField;
    }

    public void setStatusField(String statusField) {
        this.statusField = statusField;
    }

    public void addCanNotReadFields(Set<String> canNotReadFields) {
        if (WfUtils.isNotEmptyForCollection(canNotReadFields)) {
            this.canNotReadFields.addAll(canNotReadFields);
        }
    }

    public String getName() {
        return this.getParsedValue(this.nameField);
    }

    public String getDepartment() {
        return this.getParsedValue(this.departmentField);
    }

    public String getStatus() {
        return this.getParsedValue(this.statusField);
    }

    private String getParsedValue(String expression) {
        if (expression == null) {
            return "";
        }
        if (this.bill == null) {
            return expression;
        }
        expression = BizFlowGraphUtil.getExpressionWithCanNotReadFields(expression, this.canNotReadFields);
        String value = this.service.getRepositoryService().getBillExpressionParsedValue(this.bill, expression, this.variableScope);
        return value == null ? "" : value;
    }
}

