/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.model;

import java.util.ArrayList;
import java.util.List;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.StackedBillCardData;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;

public class StackedBillRelation
extends BillRelation {
    private String layoutFormId;
    private int stackedSize = 0;
    private List<String> stackedBusKeys = new ArrayList<String>();
    private int stackIdsLimit;

    public StackedBillRelation() {
        this.cardData = new StackedBillCardData();
        this.stackIdsLimit = BizFlowGraphUtil.getBillRelationGraphStackIdsLimit();
    }

    public int getStackedSize() {
        return this.stackedSize;
    }

    @Override
    public StackedBillCardData getCardData() {
        return (StackedBillCardData)super.getCardData();
    }

    public String getLayoutFormId() {
        return this.layoutFormId;
    }

    public void setLayoutFormId(String layoutFormId) {
        this.layoutFormId = layoutFormId;
    }

    public List<String> getStackedBusKeys() {
        return new ArrayList<String>(this.stackedBusKeys);
    }

    public void addStackedBusKey(String businessKey) {
        ++this.stackedSize;
        int size = this.stackedBusKeys.size();
        if (size == this.stackIdsLimit) {
            return;
        }
        this.stackedBusKeys.add(businessKey);
    }

    public void addStackedBusKeys(List<String> businessKeys) {
        this.stackedSize += businessKeys.size();
        int size = this.stackedBusKeys.size();
        if (size == this.stackIdsLimit) {
            return;
        }
        if (size + businessKeys.size() > this.stackIdsLimit) {
            int num = this.stackIdsLimit - this.stackedBusKeys.size();
            for (int i = 0; i < num; ++i) {
                this.stackedBusKeys.add(businessKeys.get(i));
            }
        } else {
            this.stackedBusKeys.addAll(businessKeys);
        }
    }

    public void setStackedBusKeys(List<String> stackedBusKeys) {
        if (stackedBusKeys != null) {
            this.addStackedBusKeys(stackedBusKeys);
        }
    }
}

