/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.workflow.bizflow.graph.model.BOTPRelationParamData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.provider.BusinessKeyBillRelationBuilder;
import kd.bos.workflow.bizflow.graph.provider.IRelationGraphProvider;
import kd.bos.workflow.bizflow.graph.provider.IntegratedBillRelationBuilder;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public abstract class AbstractBusinessKeyRelationGraphProvider<R, U, D>
implements IRelationGraphProvider {
    protected String billEntityNumber;
    protected String billPrimaryKey;
    protected Long billId;
    private Map<Long, TableDefine> tableDefineMap = new HashMap<Long, TableDefine>(16);
    protected Log log = LogFactory.getLog(this.getClass());

    public AbstractBusinessKeyRelationGraphProvider(String billEntityNumber, String billPrimaryKey) {
        this.billEntityNumber = billEntityNumber;
        this.billPrimaryKey = billPrimaryKey;
        this.billId = Long.valueOf(billPrimaryKey);
    }

    @Override
    public List<BillRelation> getBillRelations(boolean loadOtherRelations) {
        String entityNumber = this.billEntityNumber;
        String businessKey = this.billPrimaryKey;
        BOTPRelationParamData paramData = new BOTPRelationParamData();
        BillRelation current = this.createBillRelation(entityNumber, businessKey, paramData.getEntityMap());
        paramData.getRelationMap().put(current.getUniqueKey(), current);
        List<BillRelation> roots = this.buildBillRelation(paramData, current, loadOtherRelations);
        Map<String, BillRelation> relationMap = paramData.getRelationMap();
        Map<String, Set<String>> entityBillMap = paramData.getEntityBillMap();
        try {
            this.setBillRelationBillNo(relationMap, entityBillMap);
            this.setBillRelationActInstId(relationMap, entityBillMap);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        if (roots.size() > 1) {
            return this.checkAndReplenishVirtualNode(this.getMergedRoots(roots));
        }
        return roots;
    }

    private List<BillRelation> buildBillRelation(BOTPRelationParamData paramData, BillRelation current, boolean loadOtherRelations) {
        BusinessKeyBillRelationBuilder<?, R, U, D> builder = this.createRelationBuilder();
        if (loadOtherRelations) {
            IntegratedBillRelationBuilder<R, U, D> relationBuilder = this.createIntegratedRelationBuilder(builder);
            return relationBuilder.buildBillRelation(paramData, current);
        }
        return builder.buildBillRelation(paramData, current);
    }

    protected BusinessKeyBillRelationBuilder<?, R, U, D> createRelationBuilder() {
        return new BusinessKeyBillRelationBuilder(this);
    }

    protected IntegratedBillRelationBuilder<R, U, D> createIntegratedRelationBuilder(BusinessKeyBillRelationBuilder<?, R, U, D> builder) {
        return new IntegratedBillRelationBuilder<R, U, D>(builder);
    }

    protected String getBusinessKey(R row) {
        return String.valueOf(this.getBillIdFromRow(row));
    }

    protected BillRelation createBillRelation() {
        BillRelation data = new BillRelation();
        data.setStatus("complete");
        return data;
    }

    protected BillRelation createBillRelation(String entityNumber, String businessKey, Map<String, String> entityMap) {
        BillRelation relation = this.createBillRelation();
        relation.setEntityNumber(entityNumber);
        relation.setEntityName(BizFlowUtil.getEntityName(entityMap, entityNumber));
        relation.setBusinessKey(businessKey);
        relation.setUniqueKey(entityNumber, businessKey);
        return relation;
    }

    protected StackedBillRelation createStackedBillRelation(String entityNumber, List<String> stackedBillIds, Map<String, String> entityMap) {
        StackedBillRelation stackedRelation = new StackedBillRelation();
        String businessKey = stackedBillIds.get(0);
        stackedRelation.setEntityNumber(entityNumber);
        stackedRelation.setBusinessKey(businessKey);
        stackedRelation.setUniqueKey(entityNumber, businessKey);
        stackedRelation.setStatus("complete");
        stackedRelation.setStackedBusKeys(stackedBillIds);
        return stackedRelation;
    }

    private void setBillRelationBillNo(Map<String, BillRelation> relationMap, Map<String, Set<String>> entityBillMap) {
        Set<String> entityNumbers = entityBillMap.keySet();
        HashMap<String, String> fieldMap = new HashMap<String, String>(entityNumbers.size());
        BizFlowGraphUtil.initEntityBillNoField(fieldMap, entityNumbers);
        for (Map.Entry<String, Set<String>> entry : entityBillMap.entrySet()) {
            String entityNumber = entry.getKey();
            if (WfUtils.isEmpty(entityNumber)) continue;
            Set<String> billIds = entry.getValue();
            String billNoField = (String)fieldMap.get(entityNumber);
            HashMap<String, String> billNoMap = new HashMap<String, String>(billIds.size());
            BizFlowGraphUtil.initEntityBillNoMap(entityNumber, billIds, billNoField, billNoMap);
            for (Map.Entry billEntry : billNoMap.entrySet()) {
                String uniqueKey = (String)billEntry.getKey();
                BillRelation relation = relationMap.get(uniqueKey);
                if (relation == null) continue;
                relation.setBillNo((String)billEntry.getValue());
            }
        }
    }

    private void setBillRelationActInstId(Map<String, BillRelation> relationMap, Map<String, Set<String>> entityBillMap) {
        HashSet<String> businessKeys = new HashSet<String>(16);
        for (Set<String> ids : entityBillMap.values()) {
            businessKeys.addAll(ids);
        }
        Map<String, Long> actInstMap = this.getActInstMap(businessKeys);
        if (actInstMap == null || actInstMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : actInstMap.entrySet()) {
            String uniqueKey = entry.getKey();
            Long actInstId = entry.getValue();
            BillRelation relation = relationMap.get(uniqueKey);
            if (relation == null) continue;
            relation.setActivityInstId(actInstId);
        }
    }

    private Map<String, Long> getActInstMap(Set<String> businessKeys) {
        HashMap<String, Long> actInstMap;
        block8: {
            String orderBy;
            String fields;
            QFilter[] filters;
            HistoryService hiService;
            RepositoryService service;
            block7: {
                List<HistoricActivityInstanceEntity> entities;
                actInstMap = null;
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                service = wfService.getRepositoryService();
                hiService = wfService.getHistoryService();
                filters = new QFilter[]{new QFilter("businessKey", "in", businessKeys)};
                fields = String.format("%s,%s,%s", "businesskey", "actinstid", "entitynumber");
                List relations = service.findEntitiesByFilters("wf_circulaterelation", filters, fields, orderBy = String.format("%s ASC", "businesskey"));
                if (!relations.isEmpty()) {
                    actInstMap = new HashMap<String, Long>(relations.size());
                    for (Object relation : relations) {
                        if (WfUtils.isEmpty(relation.getActInstId())) continue;
                        actInstMap.put(BizFlowGraphUtil.getUniqueKey(relation.getEntityNumber(), relation.getBusinessKey()), relation.getActInstId());
                    }
                    if (!actInstMap.isEmpty()) {
                        return actInstMap;
                    }
                }
                if ((entities = hiService.getHistoricActivityByBusinessKeysAndActType(businessKeys, "StartSignalEvent", fields = String.format("%s,%s,%s,%s", "id", "businessKey", "createDate", "entitynumber"), orderBy = String.format("%s ASC", "createDate"))) == null || entities.isEmpty()) break block7;
                actInstMap = new HashMap(entities.size());
                for (HistoricActivityInstanceEntity entity : entities) {
                    actInstMap.put(BizFlowGraphUtil.getUniqueKey(entity.getEntityNumber(), entity.getBusinessKey()), entity.getId());
                }
                break block8;
            }
            filters = new QFilter[]{new QFilter("businessKey", "in", businessKeys)};
            List processes = service.findEntitiesByFilters("wf_hiprocinst", filters, fields, null);
            if (processes.isEmpty()) break block8;
            HashMap<Long, String> procBillMap = new HashMap<Long, String>(processes.size());
            for (HistoricProcessInstanceEntity process : processes) {
                procBillMap.put(process.getId(), process.getBusinessKey());
            }
            fields = String.format("%s,%s,%s,%s", "id", "processInstanceId", "createDate", "entitynumber");
            List<HistoricActivityInstanceEntity> actInsts = hiService.getHistoricActivityByActivityType(procBillMap.keySet(), "StartSignalEvent", fields, orderBy);
            if (actInsts != null && !actInsts.isEmpty()) {
                actInstMap = new HashMap(actInsts.size());
                for (HistoricActivityInstanceEntity actInst : actInsts) {
                    String businessKey = (String)procBillMap.get(actInst.getProcessInstanceId());
                    actInstMap.put(BizFlowGraphUtil.getUniqueKey(actInst.getEntityNumber(), businessKey), actInst.getId());
                }
            }
        }
        return actInstMap;
    }

    private List<BillRelation> getMergedRoots(List<BillRelation> roots) {
        LinkedHashMap<String, BillRelation> map = new LinkedHashMap<String, BillRelation>(roots.size());
        for (BillRelation root : roots) {
            String id = root.getUniqueKey();
            BillRelation relation = (BillRelation)map.get(id);
            if (relation == null) {
                relation = root;
                map.put(id, relation);
                continue;
            }
            this.mergeBillRelation(relation, root);
        }
        return new ArrayList<BillRelation>(map.values());
    }

    private void mergeBillRelation(BillRelation relation, BillRelation another) {
        Sets.SetView difference;
        List<BillRelation> targets = relation.getTargets();
        List<BillRelation> anotherTargets = another.getTargets();
        if (targets.isEmpty() || anotherTargets.isEmpty()) {
            return;
        }
        HashMap<String, BillRelation> relationTgtsMap = new HashMap<String, BillRelation>(targets.size());
        for (BillRelation billRelation : targets) {
            relationTgtsMap.put(billRelation.getUniqueKey(), billRelation);
        }
        HashMap<String, BillRelation> anotherTgtsMap = new HashMap<String, BillRelation>(anotherTargets.size());
        for (BillRelation target : anotherTargets) {
            anotherTgtsMap.put(target.getUniqueKey(), target);
        }
        Sets.SetView setView = Sets.intersection(relationTgtsMap.keySet(), anotherTgtsMap.keySet());
        if (!setView.isEmpty()) {
            for (String key : setView) {
                this.mergeBillRelation((BillRelation)relationTgtsMap.get(key), (BillRelation)anotherTgtsMap.get(key));
            }
        }
        if (!(difference = Sets.difference(anotherTgtsMap.keySet(), relationTgtsMap.keySet())).isEmpty()) {
            for (String key : difference) {
                targets.add((BillRelation)anotherTgtsMap.get(key));
            }
        }
    }

    private List<BillRelation> checkAndReplenishVirtualNode(List<BillRelation> roots) {
        int size = roots.size();
        ArrayList<Integer> levels = new ArrayList<Integer>(size);
        for (BillRelation root : roots) {
            levels.add(this.getLevel(root));
        }
        ArrayList<Integer> oriLevels = new ArrayList<Integer>(size);
        oriLevels.addAll(levels);
        Collections.sort(levels);
        int maxLevel = (Integer)levels.get(size - 1);
        if ((Integer)levels.get(0) == maxLevel) {
            return roots;
        }
        ArrayList<BillRelation> datas = new ArrayList<BillRelation>(size);
        long base = System.currentTimeMillis();
        int index = oriLevels.indexOf(maxLevel);
        for (int i = 0; i < size; ++i) {
            BillRelation root = roots.get(i);
            if (i == index) {
                datas.add(root);
                continue;
            }
            int len = maxLevel - (Integer)oriLevels.get(i);
            if (len > 0) {
                BillRelation prev = null;
                BillRelation temp = null;
                BillRelation newRoot = new BillRelation();
                newRoot.setVirtual(true);
                newRoot.setUniqueKey(String.valueOf(base++));
                datas.add(newRoot);
                prev = newRoot;
                for (int j = 1; j < len; ++j) {
                    temp = new BillRelation();
                    temp.setVirtual(true);
                    temp.setUniqueKey(String.valueOf(base++));
                    prev.getTargets().add(temp);
                    prev = temp;
                }
                prev.getTargets().add(root);
                continue;
            }
            datas.add(root);
        }
        return datas;
    }

    private int getLevel(BillRelation relation) {
        List<BillRelation> targets = relation.getTargets();
        if (targets.isEmpty()) {
            return 1;
        }
        ArrayList<Integer> levels = new ArrayList<Integer>(targets.size());
        for (BillRelation target : targets) {
            levels.add(this.getLevel(target));
        }
        if (levels.size() > 1) {
            Collections.sort(levels);
        }
        return (Integer)levels.get(levels.size() - 1) + 1;
    }

    protected TableDefine getTableDefine(Long mainTableId) {
        TableDefine tableDefine = this.tableDefineMap.get(mainTableId);
        if (tableDefine == null) {
            try {
                tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)mainTableId);
            }
            catch (Exception e) {
                tableDefine = new TableDefine();
                tableDefine.setEntityNumber(String.valueOf(mainTableId));
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
            this.tableDefineMap.put(mainTableId, tableDefine);
        }
        return tableDefine;
    }

    protected abstract Map<Long, D> getBillLinkDownNodes(String var1, String var2);

    protected abstract Map<Long, U> getBillLinkUpNodes(String var1, String var2);

    protected abstract Map<R, D> getTargetNodes(D var1);

    protected abstract Map<R, U> getSourceNodes(U var1);

    protected abstract BillRelation createBillRelation(R var1, Map<String, String> var2);

    protected abstract StackedBillRelation createStackedBillRelation(R var1, List<String> var2, Map<String, String> var3);

    protected abstract Long getBillIdFromRow(R var1);

    protected abstract String getEntityNumberFromRow(R var1);
}

