/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.graph.model.BOTPRelationParamData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillTypeInfo;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.provider.AbstractBusinessKeyRelationGraphProvider;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;

public class BusinessKeyBillRelationBuilder<P extends AbstractBusinessKeyRelationGraphProvider<R, U, D>, R, U, D> {
    private int stackSize;
    private boolean enableBillType;
    private Map<String, String> stackedUniqueKeyMap = new HashMap<String, String>(32);
    protected String billEntityNumber;
    protected String billPrimaryKey;
    protected P provider;
    protected Log log = LogFactory.getLog(this.getClass());

    public BusinessKeyBillRelationBuilder(P provider) {
        this.stackSize = BizFlowGraphUtil.getBillRelationGraphStackSize();
        this.provider = provider;
        this.enableBillType = "billtype".equals(WfConfigurationUtil.getBillRelationGraphStackType());
    }

    protected List<BillRelation> buildBillRelation(BOTPRelationParamData paramData, BillRelation current) {
        this.billEntityNumber = current.getEntityNumber();
        this.billPrimaryKey = current.getBusinessKey();
        ArrayList<BillRelation> roots = new ArrayList<BillRelation>();
        this.initBillLinkDownRelation(paramData, current);
        this.initBillLinkUpRelation(roots, paramData, current);
        this.stackedUniqueKeyMap.clear();
        HashSet<String> handled = new HashSet<String>();
        this.initAssistMapDatas(paramData, roots, handled);
        return roots;
    }

    protected void initBillLinkDownRelation(BOTPRelationParamData paramData, BillRelation current) {
        this.log.info(String.format("%s getBillLinkDownNodes(%s,%s)", this.getClass().getName(), this.billEntityNumber, this.billPrimaryKey));
        Map downNodes = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBillLinkDownNodes(this.billEntityNumber, this.billPrimaryKey);
        if (downNodes != null && !downNodes.isEmpty()) {
            Long billId = Long.valueOf(this.billPrimaryKey);
            Object linkDownNode = downNodes.get(billId);
            this.initBillRelation(linkDownNode, current, paramData);
        }
    }

    private void initBillRelation(D linkDownNode, BillRelation current, BOTPRelationParamData paramData) {
        Map tNodes = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getTargetNodes(linkDownNode);
        this.initBillRelation(tNodes, current, paramData);
    }

    private void initBillRelation(Map<R, D> tNodes, BillRelation current, BOTPRelationParamData paramData) {
        if (tNodes.isEmpty()) {
            return;
        }
        int size = tNodes.size();
        if (size >= this.stackSize) {
            this.initStackedBillRelation(tNodes, current, paramData);
        } else {
            this.initSingleBillRelation(tNodes, current, paramData);
        }
    }

    private void initStackedBillRelation(Map<R, D> tNodes, BillRelation current, BOTPRelationParamData paramData) {
        HashMap<String, GroupedRelationInfo<R, D>> groupedInfoMap = new HashMap<String, GroupedRelationInfo<R, D>>(16);
        int estimatedSize = this.getEstimatedSize(tNodes.size());
        for (Map.Entry<R, D> entry : tNodes.entrySet()) {
            R row = entry.getKey();
            String entityNumber = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getEntityNumberFromRow(row);
            String businessKey = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBusinessKey(row);
            GroupedRelationInfo<R, D> info = (GroupedRelationInfo<R, D>)groupedInfoMap.get(entityNumber);
            if (info == null) {
                info = new GroupedRelationInfo<R, D>(estimatedSize);
                info.setEntityNumber(entityNumber);
                groupedInfoMap.put(entityNumber, info);
            }
            info.addRelationInfo(row, entry.getValue(), businessKey);
        }
        if (this.enableBillType) {
            for (GroupedRelationInfo info : groupedInfoMap.values()) {
                Map<Long, List<String>> groupedBills = BizFlowGraphUtil.groupBillsByBillType(info.getEntityNumber(), info.getBillIds());
                if (groupedBills == null || groupedBills.isEmpty()) {
                    this.initBillRelationByGroupedInfo(current, paramData, info);
                    continue;
                }
                BillTypeInfo billType = null;
                Map<Long, BillTypeInfo> billTypeMap = BizFlowGraphUtil.getBillTypeInfos(groupedBills.keySet());
                for (Map.Entry<Long, List<String>> entry : groupedBills.entrySet()) {
                    Long billTypeId = entry.getKey();
                    List<String> billIds = entry.getValue();
                    billType = billTypeMap.get(billTypeId);
                    GroupedRelationInfo relationInfo = info.getPart(billIds);
                    relationInfo.setBillType(billType);
                    this.initBillRelationByGroupedInfo(current, paramData, relationInfo);
                }
            }
        } else {
            for (GroupedRelationInfo info : groupedInfoMap.values()) {
                this.initBillRelationByGroupedInfo(current, paramData, info);
            }
        }
    }

    private void initBillRelationByGroupedInfo(BillRelation current, BOTPRelationParamData paramData, GroupedRelationInfo<R, D> info) {
        List<String> ids = info.getBillIds();
        if (ids.size() >= this.stackSize) {
            String entityNumber = info.getEntityNumber();
            String uniqueKey = BizFlowGraphUtil.getUniqueKey(entityNumber, info.getOneBusinessKey());
            Map<String, BillRelation> relationMap = paramData.getRelationMap();
            BillRelation child = this.getExistingBillRelation(relationMap, uniqueKey);
            if (child != null) {
                current.getTargets().add(child);
                return;
            }
            child = this.createStackedBillRelation(info.getOneRow(), info.getBillType(), ids, paramData.getEntityMap());
            current.getTargets().add(child);
            relationMap.put(uniqueKey, child);
            HashMap tgtRowNodeMap = new HashMap();
            for (D node : info.getNodes()) {
                Map nodes = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getTargetNodes(node);
                if (nodes == null || nodes.isEmpty()) continue;
                for (Map.Entry entry : nodes.entrySet()) {
                    Object row = entry.getKey();
                    String id = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBusinessKey(row);
                    String entity = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getEntityNumberFromRow(row);
                    if (entityNumber.equals(entity) && ids.contains(id)) continue;
                    tgtRowNodeMap.put(row, entry.getValue());
                }
            }
            this.initBillRelation(tgtRowNodeMap, child, paramData);
        } else {
            this.initSingleBillRelation(info.getRowNodeMap(), current, paramData);
        }
    }

    private void initSingleBillRelation(Map<R, D> tNodes, BillRelation current, BOTPRelationParamData paramData) {
        BillRelation child = null;
        HashSet<String> billIds = new HashSet<String>(tNodes.size());
        Map<String, BillRelation> relationMap = paramData.getRelationMap();
        for (Map.Entry<R, D> entry : tNodes.entrySet()) {
            R row = entry.getKey();
            String businessKey = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBusinessKey(row);
            if (!billIds.add(businessKey)) continue;
            String entityNumber = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getEntityNumberFromRow(row);
            String uniqueKey = BizFlowGraphUtil.getUniqueKey(entityNumber, businessKey);
            BillRelation relation = this.getExistingBillRelation(relationMap, uniqueKey);
            if (relation != null) {
                child = relation;
                current.getTargets().add(child);
                continue;
            }
            child = ((AbstractBusinessKeyRelationGraphProvider)this.provider).createBillRelation(row, paramData.getEntityMap());
            current.getTargets().add(child);
            relationMap.put(uniqueKey, child);
            this.initBillRelation(entry.getValue(), child, paramData);
        }
    }

    protected void initBillLinkUpRelation(List<BillRelation> roots, BOTPRelationParamData paramData, BillRelation current) {
        this.log.info(String.format("%s getBillLinkUpNodes(%s,%s)", this.getClass().getName(), this.billEntityNumber, this.billPrimaryKey));
        Map upNodes = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBillLinkUpNodes(this.billEntityNumber, this.billPrimaryKey);
        if (upNodes != null && !upNodes.isEmpty()) {
            Long billId = Long.valueOf(this.billPrimaryKey);
            Object linkUpNode = upNodes.get(billId);
            this.initBillRelation(linkUpNode, current, roots, paramData);
            if (roots.isEmpty()) {
                roots.add(current);
            }
        } else {
            roots.add(current);
        }
    }

    private BillRelation initBillRelation(U linkUpNode, BillRelation current, List<BillRelation> roots, BOTPRelationParamData paramData) {
        Map sNodes = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getSourceNodes(linkUpNode);
        return this.initBillRelation(sNodes, current, roots, paramData);
    }

    private BillRelation initBillRelation(Map<R, U> sNodes, BillRelation current, List<BillRelation> roots, BOTPRelationParamData paramData) {
        if (sNodes.isEmpty()) {
            return null;
        }
        BillRelation root = null;
        int size = sNodes.size();
        root = size >= this.stackSize ? this.initStackedBillRelation(sNodes, current, roots, paramData) : this.initSingleBillRelation(sNodes, current, roots, paramData);
        return root;
    }

    private BillRelation initStackedBillRelation(Map<R, U> sNodes, BillRelation current, List<BillRelation> roots, BOTPRelationParamData paramData) {
        HashMap<String, GroupedRelationInfo<R, U>> groupedInfoMap = new HashMap<String, GroupedRelationInfo<R, U>>(16);
        int estimatedSize = this.getEstimatedSize(sNodes.size());
        for (Map.Entry<R, U> entry : sNodes.entrySet()) {
            R row = entry.getKey();
            String entityNumber = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getEntityNumberFromRow(row);
            String businessKey = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBusinessKey(row);
            GroupedRelationInfo<R, U> info = (GroupedRelationInfo<R, U>)groupedInfoMap.get(entityNumber);
            if (info == null) {
                info = new GroupedRelationInfo<R, U>(estimatedSize);
                info.setEntityNumber(entityNumber);
                groupedInfoMap.put(entityNumber, info);
            }
            info.addRelationInfo(row, entry.getValue(), businessKey);
        }
        BillRelation root = null;
        if (this.enableBillType) {
            for (GroupedRelationInfo info : groupedInfoMap.values()) {
                Map<Long, List<String>> groupedBills = BizFlowGraphUtil.groupBillsByBillType(info.getEntityNumber(), info.getBillIds());
                if (groupedBills == null || groupedBills.isEmpty()) {
                    root = this.initBillRelationByGroupedInfo(current, roots, paramData, info);
                    continue;
                }
                BillTypeInfo billType = null;
                Map<Long, BillTypeInfo> billTypeMap = BizFlowGraphUtil.getBillTypeInfos(groupedBills.keySet());
                for (Map.Entry<Long, List<String>> entry : groupedBills.entrySet()) {
                    Long billTypeId = entry.getKey();
                    List<String> billIds = entry.getValue();
                    billType = billTypeMap.get(billTypeId);
                    GroupedRelationInfo relationInfo = info.getPart(billIds);
                    relationInfo.setBillType(billType);
                    root = this.initBillRelationByGroupedInfo(current, roots, paramData, relationInfo);
                }
            }
        } else {
            for (GroupedRelationInfo info : groupedInfoMap.values()) {
                root = this.initBillRelationByGroupedInfo(current, roots, paramData, info);
            }
        }
        return root;
    }

    private BillRelation initBillRelationByGroupedInfo(BillRelation current, List<BillRelation> roots, BOTPRelationParamData paramData, GroupedRelationInfo<R, U> info) {
        BillRelation root = null;
        List<String> ids = info.getBillIds();
        if (ids.size() >= this.stackSize) {
            String entityNumber = info.getEntityNumber();
            String uniqueKey = BizFlowGraphUtil.getUniqueKey(entityNumber, info.getOneBusinessKey());
            Map<String, BillRelation> relationMap = paramData.getRelationMap();
            BillRelation stacked = this.getExistingBillRelation(relationMap, uniqueKey);
            if (stacked != null) {
                stacked.getTargets().add(current);
                return stacked;
            }
            stacked = this.createStackedBillRelation(info.getOneRow(), info.getBillType(), ids, paramData.getEntityMap());
            relationMap.put(uniqueKey, stacked);
            stacked.getTargets().add(current);
            root = stacked;
            HashMap srcRowNodeMap = new HashMap();
            for (U node : info.getNodes()) {
                Map nodes = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getSourceNodes(node);
                if (nodes == null || nodes.isEmpty()) continue;
                for (Map.Entry entry : nodes.entrySet()) {
                    Object row = entry.getKey();
                    String id = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getBusinessKey(row);
                    String entity = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getEntityNumberFromRow(row);
                    if (entityNumber.equals(entity) && ids.contains(id)) continue;
                    srcRowNodeMap.put(row, entry.getValue());
                }
            }
            BillRelation parent = this.initBillRelation(srcRowNodeMap, stacked, roots, paramData);
            if (parent != null) {
                root = parent;
            } else {
                roots.add(root);
            }
        } else {
            root = this.initSingleBillRelation(info.getRowNodeMap(), current, roots, paramData);
        }
        return root;
    }

    private BillRelation initSingleBillRelation(Map<R, U> sNodes, BillRelation current, List<BillRelation> roots, BOTPRelationParamData paramData) {
        BillRelation root = null;
        BillRelation parent = null;
        HashSet<String> billIds = new HashSet<String>(sNodes.size());
        Map<String, BillRelation> relationMap = paramData.getRelationMap();
        for (Map.Entry<R, U> entry : sNodes.entrySet()) {
            R row = entry.getKey();
            String businessKey = String.valueOf(((AbstractBusinessKeyRelationGraphProvider)this.provider).getBillIdFromRow(row));
            if (!billIds.add(businessKey)) continue;
            String entityNumber = ((AbstractBusinessKeyRelationGraphProvider)this.provider).getEntityNumberFromRow(row);
            String uniqueKey = BizFlowGraphUtil.getUniqueKey(entityNumber, businessKey);
            BillRelation relation = this.getExistingBillRelation(relationMap, uniqueKey);
            if (relation != null) {
                relation.getTargets().add(current);
                root = relation;
                continue;
            }
            root = parent = ((AbstractBusinessKeyRelationGraphProvider)this.provider).createBillRelation(row, paramData.getEntityMap());
            parent.getTargets().add(current);
            relationMap.put(uniqueKey, parent);
            parent = this.initBillRelation(entry.getValue(), parent, roots, paramData);
            if (parent != null) {
                root = parent;
                continue;
            }
            roots.add(root);
        }
        return root;
    }

    private BillRelation getExistingBillRelation(Map<String, BillRelation> relationMap, String uniqueKey) {
        BillRelation relation = relationMap.get(uniqueKey);
        if (relation != null) {
            return relation;
        }
        String stackedUniqueKey = this.stackedUniqueKeyMap.get(uniqueKey);
        if (stackedUniqueKey != null) {
            relation = relationMap.get(stackedUniqueKey);
        }
        return relation;
    }

    private void initAssistMapDatas(BOTPRelationParamData paramData, List<BillRelation> relations, Set<String> handled) {
        for (BillRelation relation : relations) {
            if (!handled.add(relation.getUniqueKey())) continue;
            this.initAssistMapData(paramData, relation);
            this.initAssistMapDatas(paramData, relation.getTargets(), handled);
        }
    }

    private void initAssistMapData(BOTPRelationParamData paramData, BillRelation relation) {
        String entityNumber;
        if (relation.isCrossTenant()) {
            return;
        }
        Map<String, Set<String>> entityBillMap = paramData.getEntityBillMap();
        Set<String> billIds = entityBillMap.get(entityNumber = relation.getEntityNumber());
        if (billIds == null) {
            billIds = new HashSet<String>();
            entityBillMap.put(entityNumber, billIds);
        }
        billIds.add(relation.getBusinessKey());
    }

    private StackedBillRelation createStackedBillRelation(R row, BillTypeInfo billType, List<String> stackedBillIds, Map<String, String> entityMap) {
        StackedBillRelation stacked = ((AbstractBusinessKeyRelationGraphProvider)this.provider).createStackedBillRelation(row, stackedBillIds, entityMap);
        String entityNumber = stacked.getEntityNumber();
        if (billType != null) {
            stacked.setLayoutFormId(billType.getLayout());
            stacked.setEntityName(billType.getName());
        }
        int size = stackedBillIds.size();
        for (int i = 1; i < size; ++i) {
            String billId = stackedBillIds.get(i);
            this.stackedUniqueKeyMap.put(BizFlowGraphUtil.getUniqueKey(entityNumber, billId), stacked.getUniqueKey());
        }
        return stacked;
    }

    protected BillRelation createBillRelation(String entityNumber, String businessKey, Map<String, String> entityMap) {
        return ((AbstractBusinessKeyRelationGraphProvider)this.provider).createBillRelation(entityNumber, businessKey, entityMap);
    }

    private int getEstimatedSize(int relSize) {
        int estimatedSize = 0;
        if (relSize >= 10000) {
            estimatedSize = relSize / 5;
        }
        return estimatedSize;
    }

    private static class InfoPair<R, N> {
        private R row;
        private N node;

        public InfoPair(R row, N node) {
            this.row = row;
            this.node = node;
        }

        public R getRow() {
            return this.row;
        }

        public N getNode() {
            return this.node;
        }
    }

    private static class GroupedRelationInfo<R, N> {
        private String entityNumber;
        private BillTypeInfo billType;
        private R oneRow;
        private String oneBillId;
        private Map<String, InfoPair<R, N>> infoMap = new LinkedHashMap<String, InfoPair<R, N>>();

        public GroupedRelationInfo(int estimatedSize) {
            if (estimatedSize > 0) {
                this.infoMap = new LinkedHashMap<String, InfoPair<R, N>>(estimatedSize);
            }
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public BillTypeInfo getBillType() {
            return this.billType;
        }

        public void setBillType(BillTypeInfo billType) {
            this.billType = billType;
        }

        public void addRelationInfo(R row, N node, String businessKey) {
            if (this.infoMap.containsKey(businessKey)) {
                return;
            }
            if (this.oneRow == null) {
                this.oneRow = row;
            }
            if (this.oneBillId == null) {
                this.oneBillId = businessKey;
            }
            this.infoMap.put(businessKey, new InfoPair<R, N>(row, node));
        }

        public List<String> getBillIds() {
            return new ArrayList<String>(this.infoMap.keySet());
        }

        public String getOneBusinessKey() {
            return this.oneBillId != null ? this.oneBillId : "";
        }

        public R getOneRow() {
            return this.oneRow;
        }

        public Collection<N> getNodes() {
            ArrayList<N> nodes = new ArrayList<N>(this.infoMap.size());
            for (InfoPair<R, N> pair : this.infoMap.values()) {
                nodes.add(pair.getNode());
            }
            return nodes;
        }

        public Map<R, N> getRowNodeMap() {
            HashMap<R, N> map = new HashMap<R, N>(this.infoMap.size());
            for (InfoPair<R, N> pair : this.infoMap.values()) {
                map.put(pair.getRow(), pair.getNode());
            }
            return map;
        }

        public GroupedRelationInfo<R, N> getPart(List<String> ids) {
            GroupedRelationInfo<R, N> part = new GroupedRelationInfo<R, N>(ids.size());
            part.setEntityNumber(this.entityNumber);
            for (String id : ids) {
                InfoPair<R, N> pair = this.infoMap.get(id);
                part.addRelationInfo(pair.getRow(), pair.getNode(), id);
            }
            return part;
        }
    }
}

