/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.botp.BusinessFlowDataService;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.workflow.bizflow.graph.model.BOTPRelationParamData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.SelectedRowData;
import kd.bos.workflow.bizflow.graph.provider.BusinessKeyBillRelationBuilder;
import kd.bos.workflow.bizflow.graph.provider.BusinessKeyEntryRelationGraphProvider;

public class BusinessKeyEntryBillRelationBuilder
extends BusinessKeyBillRelationBuilder<BusinessKeyEntryRelationGraphProvider, BFRowId, BFRowLinkUpNode, BFRowLinkDownNode> {
    public BusinessKeyEntryBillRelationBuilder(BusinessKeyEntryRelationGraphProvider provider) {
        super(provider);
    }

    @Override
    protected void initBillLinkDownRelation(BOTPRelationParamData paramData, BillRelation current) {
        SelectedRowData rowData = ((BusinessKeyEntryRelationGraphProvider)this.provider).getRowData();
        BusinessFlowDataService service = new BusinessFlowDataService();
        Long[] srcBillIds = new Long[]{rowData.getPrimaryKeyValue()};
        Long[] srcEntryIds = rowData.getEntryPrimaryKeyValues().toArray(new Long[0]);
        List downNodes = service.loadLinkDownNodes(this.billEntityNumber, rowData.getEntryEntityKey(), srcBillIds, srcEntryIds, null);
        if (downNodes != null && !downNodes.isEmpty()) {
            HashMap<String, BillRelation> map = new HashMap<String, BillRelation>(downNodes.size());
            for (BFRowLinkDownNode linkDownNode : downNodes) {
                BFRowId row = linkDownNode.getRowId();
                String key = this.getUniqueKey(row.getMainTableId(), row.getBillId());
                BillRelation value = (BillRelation)map.get(key);
                if (value == null) {
                    map.put(key, current);
                }
                Map tnodes = linkDownNode.getTNodes();
                this.initLinkDownRelation(current, tnodes, map, paramData);
            }
        }
    }

    private void initLinkDownRelation(BillRelation parent, Map<BFRowId, BFRowLinkDownNode> tnodes, Map<String, BillRelation> cache, BOTPRelationParamData paramData) {
        if (tnodes == null || tnodes.isEmpty()) {
            return;
        }
        Map<String, BillRelation> relationMap = paramData.getRelationMap();
        for (Map.Entry<BFRowId, BFRowLinkDownNode> entry : tnodes.entrySet()) {
            BFRowId row = entry.getKey();
            BFRowLinkDownNode downNode = entry.getValue();
            String key = this.getUniqueKey(row.getMainTableId(), row.getBillId());
            BillRelation child = cache.get(key);
            if (child == null) {
                child = ((BusinessKeyEntryRelationGraphProvider)this.provider).createBillRelation(row, paramData.getEntityMap());
                parent.getTargets().add(child);
                cache.put(key, child);
                relationMap.put(child.getUniqueKey(), child);
            }
            this.initLinkDownRelation(child, downNode.getTNodes(), cache, paramData);
        }
    }

    private String getUniqueKey(Long mainTableId, Long billId) {
        return String.format("%s_%s", mainTableId, billId);
    }
}

