/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider;

import java.util.List;
import java.util.Map;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.provider.AbstractBusinessKeyRelationGraphProvider;
import kd.bos.workflow.bizflow.util.BizFlowUtil;

public class BusinessKeyRelationGraphProvider
extends AbstractBusinessKeyRelationGraphProvider<BFRowId, BFRowLinkUpNode, BFRowLinkDownNode> {
    public BusinessKeyRelationGraphProvider(String billEntityNumber, String billPrimaryKey) {
        super(billEntityNumber, billPrimaryKey);
    }

    @Override
    protected Map<Long, BFRowLinkDownNode> getBillLinkDownNodes(String entityNumber, String businessKey) {
        return BFTrackerServiceHelper.loadBillLinkDownNodes((String)this.billEntityNumber, (Long[])new Long[]{Long.valueOf(this.billPrimaryKey)}, (boolean)false);
    }

    @Override
    protected Map<Long, BFRowLinkUpNode> getBillLinkUpNodes(String entityNumber, String businessKey) {
        return BFTrackerServiceHelper.loadBillLinkUpNodes((String)this.billEntityNumber, (Long[])new Long[]{Long.valueOf(this.billPrimaryKey)}, (boolean)false);
    }

    @Override
    protected Map<BFRowId, BFRowLinkDownNode> getTargetNodes(BFRowLinkDownNode linkDownNode) {
        return linkDownNode.getTNodes();
    }

    @Override
    protected Map<BFRowId, BFRowLinkUpNode> getSourceNodes(BFRowLinkUpNode linkUpNode) {
        return linkUpNode.getSNodes();
    }

    @Override
    protected BillRelation createBillRelation(BFRowId row, Map<String, String> entityMap) {
        BillRelation relation = super.createBillRelation();
        String businessKey = this.getBusinessKey(row);
        String entityNumber = this.getEntityNumberFromRow(row);
        relation.setBusinessKey(businessKey);
        relation.setEntityNumber(entityNumber);
        relation.setUniqueKey(entityNumber, businessKey);
        relation.setEntityName(BizFlowUtil.getEntityName(entityMap, entityNumber));
        return relation;
    }

    @Override
    protected StackedBillRelation createStackedBillRelation(BFRowId row, List<String> stackedBillIds, Map<String, String> entityMap) {
        String entityNumber = this.getEntityNumberFromRow(row);
        StackedBillRelation stacked = super.createStackedBillRelation(entityNumber, stackedBillIds, entityMap);
        stacked.setEntityName(BizFlowUtil.getEntityName(entityMap, entityNumber));
        return stacked;
    }

    @Override
    protected Long getBillIdFromRow(BFRowId row) {
        return row.getBillId();
    }

    @Override
    protected String getEntityNumberFromRow(BFRowId row) {
        TableDefine tableDefine = this.getTableDefine(row.getMainTableId());
        return tableDefine.getEntityNumber();
    }
}

