/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ctbotp.constants.SyncModelEnum;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.provider.AbstractBusinessKeyRelationGraphProvider;
import kd.bos.workflow.bizflow.graph.provider.BusinessKeyBillRelationBuilder;
import kd.bos.workflow.bizflow.graph.provider.CrossTenantIntegratedBillRelationBuilder;
import kd.bos.workflow.bizflow.graph.provider.IntegratedBillRelationBuilder;

public class CrossTenantBusinessKeyRelationGraphProvider
extends AbstractBusinessKeyRelationGraphProvider<CtBFRowId, CtBFRowLinkUpNode, CtBFRowLinkDownNode> {
    private String tenantId;
    private String accountId;

    public CrossTenantBusinessKeyRelationGraphProvider(String billEntityNumber, String billPrimaryKey) {
        super(billEntityNumber, billPrimaryKey);
        this.initTenantInfo();
    }

    private void initTenantInfo() {
        RequestContext context = RequestContext.get();
        if (context == null) {
            return;
        }
        this.tenantId = context.getTenantId();
        this.accountId = context.getAccountId();
    }

    @Override
    protected BillRelation createBillRelation(CtBFRowId row, Map<String, String> entityMap) {
        BillRelation relation = super.createBillRelation();
        String entityNumber = this.getEntityNumberFromRow(row);
        String businessKey = this.getBusinessKey(row);
        relation.setEntityNumber(entityNumber);
        relation.setBusinessKey(businessKey);
        relation.setUniqueKey(entityNumber, businessKey);
        relation.setEntityName(row.getMainEntityName());
        relation.setTenantId(row.getTenantId());
        relation.setAccountId(row.getAccountId());
        return relation;
    }

    @Override
    protected StackedBillRelation createStackedBillRelation(CtBFRowId row, List<String> stackedBillIds, Map<String, String> entityMap) {
        String entityNumber = this.getEntityNumberFromRow(row);
        StackedBillRelation stacked = super.createStackedBillRelation(entityNumber, stackedBillIds, entityMap);
        stacked.setAccountId(row.getAccountId());
        stacked.setTenantId(row.getTenantId());
        stacked.setEntityName(row.getMainEntityName());
        return stacked;
    }

    @Override
    protected Map<Long, CtBFRowLinkDownNode> getBillLinkDownNodes(String entityNumber, String businessKey) {
        Long billId = Long.valueOf(businessKey);
        Map ret = CtBillLkServiceHelper.loadBillLinkDownNodes((String)this.tenantId, (String)this.accountId, (String)entityNumber, (Long[])new Long[]{billId}, (boolean)false);
        if (ret != null) {
            this.log.info(SerializationUtils.serializeToBase64((Object)ret));
        } else {
            this.log.debug(String.format("loadBillLinkDownNodes null. %s %s", entityNumber, businessKey));
        }
        return ret;
    }

    @Override
    protected Map<Long, CtBFRowLinkUpNode> getBillLinkUpNodes(String entityNumber, String businessKey) {
        Long billId = Long.valueOf(businessKey);
        Map ret = CtBillLkServiceHelper.loadBillLinkUpNodes((String)this.tenantId, (String)this.accountId, (String)entityNumber, (Long[])new Long[]{billId}, (boolean)false);
        if (ret != null) {
            this.log.info(SerializationUtils.serializeToBase64((Object)ret));
        } else {
            this.log.debug(String.format("loadBillLinkUpNodes null. %s %s", entityNumber, businessKey));
        }
        return ret;
    }

    @Override
    protected IntegratedBillRelationBuilder<CtBFRowId, CtBFRowLinkUpNode, CtBFRowLinkDownNode> createIntegratedRelationBuilder(BusinessKeyBillRelationBuilder<?, CtBFRowId, CtBFRowLinkUpNode, CtBFRowLinkDownNode> builder) {
        return new CrossTenantIntegratedBillRelationBuilder(builder);
    }

    @Override
    protected Map<CtBFRowId, CtBFRowLinkDownNode> getTargetNodes(CtBFRowLinkDownNode linkDownNode) {
        Map tnodes = linkDownNode.getTNodes();
        HashMap<CtBFRowId, CtBFRowLinkDownNode> targetNodes = new HashMap<CtBFRowId, CtBFRowLinkDownNode>(tnodes.size());
        for (Map.Entry entry : tnodes.entrySet()) {
            CtBFRowId key = (CtBFRowId)entry.getKey();
            CtBFRowLinkDownNode value = (CtBFRowLinkDownNode)entry.getValue();
            if (SyncModelEnum.MIRROR.getValue().equals(key.getSyncModel())) {
                Map<CtBFRowId, CtBFRowLinkDownNode> targets = this.getTargetNodes(value);
                if (targets == null) continue;
                targetNodes.putAll(targets);
                continue;
            }
            targetNodes.put(key, value);
        }
        return targetNodes;
    }

    @Override
    protected Map<CtBFRowId, CtBFRowLinkUpNode> getSourceNodes(CtBFRowLinkUpNode linkUpNode) {
        Map snodes = linkUpNode.getSNodes();
        HashMap<CtBFRowId, CtBFRowLinkUpNode> sourceNodes = new HashMap<CtBFRowId, CtBFRowLinkUpNode>(snodes.size());
        for (Map.Entry entry : snodes.entrySet()) {
            CtBFRowId key = (CtBFRowId)entry.getKey();
            CtBFRowLinkUpNode value = (CtBFRowLinkUpNode)entry.getValue();
            if (SyncModelEnum.MIRROR.getValue().equals(key.getSyncModel())) {
                Map<CtBFRowId, CtBFRowLinkUpNode> sources = this.getSourceNodes(value);
                if (sources == null) continue;
                sourceNodes.putAll(sources);
                continue;
            }
            sourceNodes.put(key, value);
        }
        return sourceNodes;
    }

    @Override
    protected Long getBillIdFromRow(CtBFRowId row) {
        return row.getBillId();
    }

    @Override
    protected String getEntityNumberFromRow(CtBFRowId row) {
        return row.getMainEntityKey();
    }
}

