/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.graph.model.BOTPRelationParamData;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.provider.BusinessKeyBillRelationBuilder;
import kd.bos.workflow.bizflow.graph.provider.voucher.VoucherDataProvider;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillRelationModelEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class IntegratedBillRelationBuilder<R, U, D> {
    private VoucherDataProvider voucherDataProvider;
    private BusinessKeyBillRelationBuilder<?, R, U, D> innerBuilder;
    private Log log = LogFactory.getLog(this.getClass());

    public IntegratedBillRelationBuilder(BusinessKeyBillRelationBuilder<?, R, U, D> innerBuilder) {
        this.innerBuilder = innerBuilder;
        this.voucherDataProvider = new VoucherDataProvider();
    }

    protected List<BillRelation> buildBillRelation(BOTPRelationParamData paramData, BillRelation current) {
        List<BillRelation> roots = this.innerBuilder.buildBillRelation(paramData, current);
        this.loadOtherBillRelations(paramData, current);
        return roots;
    }

    private void loadOtherBillRelations(BOTPRelationParamData paramData, BillRelation current) {
        try {
            this.initDAPRelations(paramData);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        try {
            this.initCardCustomRelation(paramData);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    private void initDAPRelations(BOTPRelationParamData paramData) {
        Map<String, BillRelation> relationMap = paramData.getRelationMap();
        Map<String, Set<String>> entityBillMap = paramData.getEntityBillMap();
        Set<String> vouchers = entityBillMap.get("gl_voucher");
        if (vouchers == null) {
            vouchers = new HashSet<String>(16);
        }
        Set<String> entityNumbers = this.getDAPSupportedEntityNumbers();
        for (Map.Entry<String, Set<String>> entityEntry : entityBillMap.entrySet()) {
            Set<String> billIds;
            String entityNumber = entityEntry.getKey();
            if (!entityNumbers.contains(entityNumber) || (billIds = entityEntry.getValue()).isEmpty()) continue;
            HashMap<String, StackedBillRelation> idRelationMap = new HashMap<String, StackedBillRelation>(16);
            HashSet<Long> ids = new HashSet<Long>(billIds.size());
            for (String billId : billIds) {
                String uniqueKey = BizFlowGraphUtil.getUniqueKey(entityNumber, billId);
                BillRelation relation = relationMap.get(uniqueKey);
                if (relation instanceof StackedBillRelation) {
                    StackedBillRelation stackedRelation = (StackedBillRelation)relation;
                    List<String> stackedBillIds = stackedRelation.getStackedBusKeys();
                    for (String id : stackedBillIds) {
                        ids.add(Long.valueOf(id));
                        idRelationMap.put(id, stackedRelation);
                    }
                    continue;
                }
                ids.add(Long.valueOf(billId));
            }
            Map<Long, Set<Long>> ret = null;
            try {
                ret = this.getBillVouchers(entityNumber, ids);
            }
            catch (Exception e) {
                this.log.error(WfUtils.getExceptionStacktrace(e));
            }
            if (ret == null || ret.isEmpty()) continue;
            this.log.info(String.format("invoke fi-ai-DapQueryDataService-getVoucherInfo: %s, entityNumber: %s", ret.size(), entityNumber));
            for (Map.Entry<Long, Set<Long>> entry : ret.entrySet()) {
                String businessKey = String.valueOf(entry.getKey());
                BillRelation relation = relationMap.get(BizFlowGraphUtil.getUniqueKey(entityNumber, businessKey));
                if (relation == null) {
                    relation = (BillRelation)idRelationMap.get(businessKey);
                }
                Set<Long> voucherIds = entry.getValue();
                ArrayList<BillRelation> voucherRels = new ArrayList<BillRelation>(voucherIds.size());
                for (Long id : voucherIds) {
                    String voucherId = String.valueOf(id);
                    String uniqueKey = BizFlowGraphUtil.getUniqueKey("gl_voucher", voucherId);
                    BillRelation voucher = relationMap.get(uniqueKey);
                    if (voucher != null) continue;
                    voucher = this.createVoucherBillRelation(voucherId, paramData.getEntityMap());
                    relationMap.put(uniqueKey, voucher);
                    voucherRels.add(voucher);
                    vouchers.add(voucherId);
                }
                if (relation == null || voucherRels.isEmpty()) continue;
                relation.getTargets().addAll(voucherRels);
            }
        }
        entityBillMap.put("gl_voucher", vouchers);
    }

    protected Set<String> getDAPSupportedEntityNumbers() {
        return this.voucherDataProvider.getDAPSupportedEntityNumbers();
    }

    protected Map<Long, Set<Long>> getBillVouchers(String entityNumber, Set<Long> ids) {
        return this.voucherDataProvider.getBillVouchers(entityNumber, ids);
    }

    protected BillRelation createVoucherBillRelation(String voucherId, Map<String, String> entityMap) {
        return this.innerBuilder.createBillRelation("gl_voucher", voucherId, entityMap);
    }

    private void initCardCustomRelation(BOTPRelationParamData paramData) {
        Map<String, BillRelation> relationMap = paramData.getRelationMap();
        Map<String, Set<String>> entityBillMap = paramData.getEntityBillMap();
        Set<String> entityNumbers = entityBillMap.keySet();
        WorkflowService workflowService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService service = workflowService.getRepositoryService();
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("relationtype", "not in", (Object)new String[]{"botp", "dap"}), new QFilter("srcbill", "in", entityNumbers).or(new QFilter("targetbill", "in", entityNumbers))};
        String fields = String.format("%s,%s", "srcbill", "targetbill");
        List relationModels = service.findEntitiesByFilters("bpm_billrelationmodel", filters, fields, null);
        if (relationModels.isEmpty()) {
            return;
        }
        HashSet<String> hasCustomRelationEntities = new HashSet<String>(relationModels.size());
        for (BillRelationModelEntity billRelationModelEntity : relationModels) {
            hasCustomRelationEntities.add(billRelationModelEntity.getSrcbill());
            hasCustomRelationEntities.add(billRelationModelEntity.getTargetbill());
        }
        for (Map.Entry entry : entityBillMap.entrySet()) {
            String entity = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            if (!hasCustomRelationEntities.contains(entity)) continue;
            for (String id : ids) {
                BillRelation rel = relationMap.get(BizFlowGraphUtil.getUniqueKey(entity, id));
                rel.setHasCustomRelation(true);
            }
        }
    }
}

