/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.provider.voucher;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.BillCirculateRelationConstants;

public abstract class AbstractVoucherDataProvider<R, N> {
    protected static final String KEY_IDS = "ids";
    protected static final String KEY_DATA = "data";
    protected static final String KEY_ENTITYNAME = "entityName";
    protected Log log = LogFactory.getLog(this.getClass());

    public Set<String> getDAPSupportedEntityNumbers() {
        Set entityNumbers = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getCanBuildVoucherBillNames", (Object[])new Object[0]);
        this.log.info(String.format("invoke fi-ai-DapQueryDataService-getCanBuildVoucherBillNames: %s", entityNumbers));
        return entityNumbers;
    }

    public N getVoucherUpNodes(Long voucherId) {
        Map<String, Map<String, Object>> entityBillIdMap = null;
        try {
            entityBillIdMap = this.getDirectSourceBills(voucherId);
        }
        catch (Exception e) {
            this.log.error(WfUtils.getExceptionStacktrace(e));
        }
        if (entityBillIdMap == null || entityBillIdMap.isEmpty()) {
            return null;
        }
        this.log.info(String.format("invoke DapService getVoucherSourceBillInfo, entityNumbers: %s", entityBillIdMap.keySet()));
        HashMap<Long, N> relMap = new HashMap<Long, N>();
        for (Map.Entry<String, Map<String, Object>> entry : entityBillIdMap.entrySet()) {
            Map<Long, N> val;
            String entityNumber = entry.getKey();
            Map<String, Object> map = entry.getValue();
            Set billIds = (Set)map.get(KEY_IDS);
            if (billIds == null || billIds.isEmpty() || (val = this.getBillLinkUpNodes(entityNumber, billIds.toArray(new Long[0]))) == null) continue;
            relMap.putAll(val);
        }
        Map<String, Long> entityTableIdMap = this.getEntityNumberTableIdMap(entityBillIdMap.keySet());
        HashMap sNodes = new HashMap(entityBillIdMap.size() * 10);
        for (Map.Entry entry : entityBillIdMap.entrySet()) {
            String entityNumber = (String)entry.getKey();
            Map info = (Map)entry.getValue();
            Set ids = (Set)info.get(KEY_IDS);
            String entityName = (String)info.get(KEY_ENTITYNAME);
            for (Long id : ids) {
                Long mainTableId = entityTableIdMap.get(entityNumber);
                R rowId = this.createRowId(entityNumber, entityName, mainTableId != null ? mainTableId : 0L, id);
                Object node = relMap.get(id);
                if (node == null) {
                    node = this.createUpNode(rowId, new HashMap());
                }
                sNodes.put(rowId, node);
            }
        }
        R rowId = this.createRowId("gl_voucher", "", BillCirculateRelationConstants.TABLEID_VOUCHER, voucherId);
        return (N)this.createUpNode(rowId, sNodes);
    }

    private Map<String, Long> getEntityNumberTableIdMap(Set<String> entityNumbers) {
        StringBuilder numbers = new StringBuilder();
        int i = 0;
        int size = entityNumbers.size();
        Iterator<String> iterator = entityNumbers.iterator();
        while (iterator.hasNext()) {
            numbers.append("'").append(iterator.next()).append("'");
            if (i++ >= size - 1) continue;
            numbers.append(",");
        }
        String sql = String.format("SELECT FID, FTABLEID FROM T_META_ENTITYINFO WHERE FID IN (%s) AND FENTITYKEY IN (%s);", numbers, numbers);
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> map = new HashMap<String, Long>(16);
                while (rs.next()) {
                    map.put(rs.getString("FID"), rs.getLong("FTABLEID"));
                }
                return map;
            }
        });
    }

    public abstract Map<Long, Set<Long>> getBillVouchers(String var1, Set<Long> var2);

    protected abstract N createUpNode(R var1, Map<R, N> var2);

    protected abstract R createRowId(String var1, String var2, Long var3, Long var4);

    protected abstract Map<String, Map<String, Object>> getDirectSourceBills(Long var1);

    protected abstract Map<Long, N> getBillLinkUpNodes(String var1, Long[] var2);
}

