/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bizflow.graph.handler.BillRelationCardHandlerFactory;
import kd.bos.workflow.bizflow.graph.handler.IBillRelationCardHandler;
import kd.bos.workflow.bizflow.graph.model.BillCardPlugin;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.BillTypeInfo;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.render.IBillRelationGraphRender;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;

public abstract class AbstractBillRelationGraphRender
implements IBillRelationGraphRender {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected int stackLimit;
    protected boolean enableBillType;
    protected String permstrategy;
    protected String currentEntityNumber;
    protected String currentBusinessKey;
    private int maxLevel = 30;
    private int levelMaxCount = 100;
    private boolean overload;
    private long idIndex = 0L;

    public AbstractBillRelationGraphRender(int stackLimit) {
        this.stackLimit = stackLimit;
        this.enableBillType = "billtype".equals(WfConfigurationUtil.getBillRelationGraphStackType());
        this.permstrategy = "all";
        Map<String, Integer> config = this.getConfigurationCount("workflow.relationGraph.maxLevel", "workflow.relationGraph.levelMaxCount");
        Integer count = config.get("workflow.relationGraph.maxLevel");
        if (count != null && count > 0) {
            this.maxLevel = count;
        }
        if ((count = config.get("workflow.relationGraph.levelMaxCount")) != null && count > 0) {
            this.levelMaxCount = count;
        }
    }

    public AbstractBillRelationGraphRender(int stackLimit, String permstrategy) {
        this(stackLimit);
        if (permstrategy != null) {
            this.permstrategy = permstrategy;
        }
    }

    private Map<String, Integer> getConfigurationCount(String ... keys) {
        HashMap<String, Integer> countConfig = new HashMap<String, Integer>(keys.length);
        Map<String, Object> config = WfConfigurationUtil.getConfigCenterVals(keys);
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String count;
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String) || !(count = value.toString()).matches("^\\d{1,8}$")) continue;
            countConfig.put(key, Integer.parseInt(count));
        }
        return countConfig;
    }

    @Override
    @Deprecated
    public BillRelationGraphData getBillRelationModel(List<BillRelation> relations, String businessKey, String appId) {
        return this.getBillRelationModel(relations, null, businessKey, appId);
    }

    @Override
    public BillRelationGraphData getBillRelationModel(List<BillRelation> relations, String entityNumber, String businessKey, String appId) {
        if (relations == null || relations.isEmpty()) {
            return null;
        }
        this.currentEntityNumber = entityNumber;
        this.currentBusinessKey = businessKey;
        BillRelationGraphData graphData = this.createBillRelationGraphData();
        BillRelation root = this.createRoot(relations);
        HashMap<String, BillRelation> relMap = new HashMap<String, BillRelation>();
        LinkedHashSet<String> recalculates = new LinkedHashSet<String>();
        this.initBillRelations(root, relMap, recalculates);
        if (this.overload) {
            graphData.setTip(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\uff0c\u4ec5\u5c55\u793a\u90e8\u5206\u6570\u636e\u3002", (String)"AbstractBillRelationGraphRender_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        this.removeVirtualBillRelation(relMap);
        Map<String, BillCardPlugin> pluginMap = this.getBillCardPlugin(relMap);
        this.setCardCustomData(graphData, relMap, pluginMap, appId);
        this.afterInitBillRelations(root, graphData, relMap, pluginMap);
        return graphData;
    }

    protected BillRelationGraphData createBillRelationGraphData() {
        return new BillRelationGraphData();
    }

    protected void afterInitBillRelations(BillRelation root, BillRelationGraphData graphData, Map<String, BillRelation> relMap, Map<String, BillCardPlugin> pluginMap) {
    }

    protected void initBillRelations(BillRelation root, Map<String, BillRelation> relMap, Set<String> recalculates) {
        this.initRelationAndModel(root, relMap, recalculates);
        this.mergeRelationForStacking(root, relMap, recalculates);
        this.checkAndBreakCycle(root, relMap, new HashMap<String, Boolean>(relMap.size()));
    }

    protected void initRelationAndModel(BillRelation root, Map<String, BillRelation> relMap, Set<String> recalculates) {
        LinkedList<BillRelation> queue = new LinkedList<BillRelation>();
        queue.offer(root);
        HashSet<String> handled = new HashSet<String>(16);
        while (!queue.isEmpty()) {
            BillRelation current = (BillRelation)queue.poll();
            handled.add(current.getUniqueKey());
            this.initRelation(relMap, current);
            List<BillRelation> targets = current.getTargets();
            int size = targets.size();
            for (int i = 0; i < size; ++i) {
                BillRelation target = targets.get(i);
                target.getSources().add(current);
                if (queue.contains(target) || handled.contains(target.getUniqueKey())) continue;
                queue.add(target);
            }
        }
    }

    private void removeVirtualBillRelation(Map<String, BillRelation> relMap) {
        Iterator<Map.Entry<String, BillRelation>> iterator = relMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BillRelation> entry = iterator.next();
            if (!entry.getValue().isVirtual()) continue;
            iterator.remove();
        }
    }

    protected BillRelation createRoot(List<BillRelation> relations) {
        BillRelation root = null;
        if (relations.size() == 1) {
            root = relations.get(0);
            root.setRoot(true);
        } else {
            root = this.createVirtualRoot(relations);
            for (BillRelation relation : relations) {
                relation.setRoot(true);
            }
        }
        return root;
    }

    protected BillRelation createVirtualRoot(List<BillRelation> relations) {
        BillRelation root = new BillRelation();
        root.setVirtual(true);
        root.setUniqueKey("000");
        root.setTargets(relations);
        return root;
    }

    protected void initRelation(Map<String, BillRelation> relMap, BillRelation current) {
        BillRelation relation = relMap.get(current.getUniqueKey());
        if (relation == null) {
            String resourceId = this.createElementId("billCard");
            current.setResourceId(resourceId);
            relMap.put(current.getUniqueKey(), current);
        } else {
            current.setResourceId(relation.getResourceId());
        }
    }

    protected void mergeRelationForStacking(BillRelation root, Map<String, BillRelation> relMap, Set<String> recalculates) {
        int maxLayer;
        HashSet<BillRelation> relationsInLayer = new HashSet<BillRelation>(32);
        HashMap<String, Integer> relationLayerMap = new HashMap<String, Integer>(relMap.size());
        relationsInLayer.add(root);
        ArrayList<Set<BillRelation>> layeredRelations = new ArrayList<Set<BillRelation>>(32);
        LinkedHashSet<BillRelation> firstLayer = new LinkedHashSet<BillRelation>();
        firstLayer.add(root);
        layeredRelations.add(firstLayer);
        Set<BillRelation> lastLayer = firstLayer;
        Set<BillRelation> nextLayer = null;
        boolean layerOverload = false;
        int n = maxLayer = root.isVirtual() ? this.maxLevel + 1 : this.maxLevel;
        while (!(nextLayer = this.getNextLayerRelations(lastLayer, relationsInLayer)).isEmpty()) {
            if (layeredRelations.size() + 1 > maxLayer) {
                layerOverload = true;
                break;
            }
            layeredRelations.add(nextLayer);
            lastLayer = nextLayer;
        }
        relationsInLayer.clear();
        if (layerOverload) {
            this.overload = true;
            this.handleLayerOverload(lastLayer);
        }
        int size = layeredRelations.size();
        HashSet<String> removeIds = new HashSet<String>(16);
        ArrayList<StackedBillRelation> stackedRelations = new ArrayList<StackedBillRelation>(16);
        for (int i = 0; i < size; ++i) {
            Set set = (Set)layeredRelations.get(i);
            if (set.size() < this.stackLimit) continue;
            LinkedHashMap<String, ArrayList<BillRelation>> classified = new LinkedHashMap<String, ArrayList<BillRelation>>();
            for (BillRelation billRelation : set) {
                relationLayerMap.put(billRelation.getUniqueKey(), i);
                String entityNumber = billRelation.getEntityNumber();
                if (entityNumber == null) continue;
                ArrayList<BillRelation> rels = (ArrayList<BillRelation>)classified.get(entityNumber);
                if (rels == null) {
                    rels = new ArrayList<BillRelation>();
                    classified.put(entityNumber, rels);
                }
                rels.add(billRelation);
            }
            for (Map.Entry entry : classified.entrySet()) {
                List rels = (List)entry.getValue();
                if (rels.isEmpty() || rels.size() < this.stackLimit && !this.hasStackedRelation(rels)) continue;
                String entityNumber = (String)entry.getKey();
                if (this.enableBillType) {
                    stackedRelations.addAll(this.createStackedElementByBillType(entityNumber, relMap, removeIds, rels));
                    continue;
                }
                StackedBillRelation stacked = this.createStackedElement(relMap, removeIds, rels);
                stackedRelations.add(stacked);
            }
        }
        for (String string : removeIds) {
            relMap.remove(string);
            recalculates.remove(string);
            Integer idx = (Integer)relationLayerMap.get(string);
            if (idx == null) continue;
            Set rels = (Set)layeredRelations.get(idx);
            Iterator iterator = rels.iterator();
            while (iterator.hasNext()) {
                BillRelation next = (BillRelation)iterator.next();
                if (!string.equals(next.getUniqueKey())) continue;
                iterator.remove();
            }
        }
        relationLayerMap.clear();
        boolean countOverload = this.handleCardCountOverload(relMap, layeredRelations);
        if (countOverload) {
            this.overload = true;
        }
        for (StackedBillRelation rel : stackedRelations) {
            relMap.put(rel.getUniqueKey(), rel);
            if (rel.getSources().size() <= 1) continue;
            recalculates.add(rel.getUniqueKey());
        }
        Iterator<String> iterator = recalculates.iterator();
        while (iterator.hasNext()) {
            String recalculate = iterator.next();
            if (!this.isRecalculatedNodeInTheMultiNodeLayer(recalculate, layeredRelations)) continue;
            iterator.remove();
        }
    }

    protected boolean handleCardCountOverload(Map<String, BillRelation> relMap, List<Set<BillRelation>> layeredRelations) {
        boolean countOverload = false;
        for (Set<BillRelation> relations : layeredRelations) {
            int count = 1;
            boolean remove = false;
            for (BillRelation relation : relations) {
                if (relation.isVirtual()) continue;
                if (remove) {
                    BillRelation rel = relMap.get(relation.getUniqueKey());
                    List<BillRelation> sources = rel.getSources();
                    for (BillRelation source : sources) {
                        List<BillRelation> targets = source.getTargets();
                        targets.remove(relation);
                    }
                }
                if (++count <= this.levelMaxCount) continue;
                countOverload = true;
                remove = true;
            }
        }
        return countOverload;
    }

    protected void handleLayerOverload(Set<BillRelation> lastLayer) {
        for (BillRelation relation : lastLayer) {
            relation.getTargets().clear();
        }
    }

    private boolean hasStackedRelation(List<BillRelation> relations) {
        if (relations.size() <= 1) {
            return false;
        }
        for (BillRelation relation : relations) {
            if (!(relation instanceof StackedBillRelation)) continue;
            return true;
        }
        return false;
    }

    private boolean hasBillTypeStackedRelation(String entityNumber, List<String> busKeys, Map<String, BillRelation> relationMap) {
        if (busKeys.isEmpty()) {
            return false;
        }
        for (String busKey : busKeys) {
            BillRelation relation = relationMap.get(BizFlowGraphUtil.getUniqueKey(entityNumber, busKey));
            if (!(relation instanceof StackedBillRelation)) continue;
            return true;
        }
        return false;
    }

    private boolean isRecalculatedNodeInTheMultiNodeLayer(String uniqueKey, List<Set<BillRelation>> layeredRelations) {
        for (Set<BillRelation> relations : layeredRelations) {
            if (relations.size() < 2) continue;
            for (BillRelation relation : relations) {
                if (relation.isVirtual() || uniqueKey == null || !uniqueKey.equals(relation.getUniqueKey())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<BillRelation> getNextLayerRelations(Set<BillRelation> lastLayerRelations, Set<BillRelation> relationsInLayer) {
        LinkedHashSet<BillRelation> relations = new LinkedHashSet<BillRelation>(16);
        for (BillRelation relation : lastLayerRelations) {
            List<BillRelation> targets = relation.getTargets();
            for (BillRelation target : targets) {
                if (!relationsInLayer.add(target)) continue;
                relations.add(target);
            }
        }
        return relations;
    }

    private List<StackedBillRelation> createStackedElementByBillType(String entityNumber, Map<String, BillRelation> relMap, Set<String> removeIds, List<BillRelation> relations) {
        ArrayList<StackedBillRelation> result = new ArrayList<StackedBillRelation>(16);
        HashMap<String, BillRelation> relationMap = new HashMap<String, BillRelation>(relations.size());
        ArrayList<String> businessKeys = new ArrayList<String>(relations.size());
        for (BillRelation rel : relations) {
            businessKeys.add(rel.getBusinessKey());
            relationMap.put(rel.getUniqueKey(), rel);
        }
        Map<Long, List<String>> groupedBills = BizFlowGraphUtil.groupBillsByBillType(entityNumber, businessKeys);
        if (groupedBills == null || groupedBills.isEmpty()) {
            result.add(this.createStackedElement(relMap, removeIds, relations));
        } else {
            Map<Long, BillTypeInfo> billTypeMap = BizFlowGraphUtil.getBillTypeInfos(groupedBills.keySet());
            BillTypeInfo billType = null;
            StackedBillRelation stacked = null;
            for (Map.Entry<Long, List<String>> entry : groupedBills.entrySet()) {
                Long billTypeId = entry.getKey();
                billType = billTypeMap.get(billTypeId);
                List<String> busKeys = entry.getValue();
                if (busKeys.size() < this.stackLimit && !this.hasBillTypeStackedRelation(entityNumber, busKeys, relationMap)) continue;
                ArrayList<BillRelation> rels = new ArrayList<BillRelation>(busKeys.size());
                for (String busKey : busKeys) {
                    String uniqueKey = BizFlowGraphUtil.getUniqueKey(entityNumber, busKey);
                    rels.add((BillRelation)relationMap.get(uniqueKey));
                }
                stacked = this.createStackedElement(relMap, removeIds, rels);
                stacked.setLayoutFormId(billType.getLayout());
                stacked.setEntityName(billType.getName());
                result.add(stacked);
            }
        }
        return result;
    }

    private StackedBillRelation createStackedElement(Map<String, BillRelation> relMap, Set<String> removeIds, List<BillRelation> relations) {
        boolean isVirtual = relations.get(0).isVirtual();
        int index = -1;
        HashSet<BillRelation> sources = new HashSet<BillRelation>();
        HashSet<BillRelation> targets = new HashSet<BillRelation>();
        ArrayList<BillRelation> virtualSrcs = new ArrayList<BillRelation>(relations.size());
        int size = relations.size();
        for (int i = 0; i < size; ++i) {
            BillRelation relation = relations.get(i);
            ArrayList<BillRelation> rels = new ArrayList<BillRelation>(relation.getSources().size());
            rels.addAll(relation.getSources());
            for (BillRelation source : rels) {
                if (index == -1) {
                    index = this.disconnectSourceRelation(relMap, relation, source);
                } else {
                    this.disconnectSourceRelation(relMap, relation, source);
                }
                if (!"000".equals(source.getUniqueKey()) && source.isVirtual()) {
                    virtualSrcs.add(source);
                    continue;
                }
                sources.add(source);
            }
            rels = new ArrayList(relation.getTargets().size());
            rels.addAll(relation.getTargets());
            for (BillRelation target : rels) {
                targets.add(target);
                this.disconnectTargetRelation(relMap, relation, target);
            }
            if (i != 0 || isVirtual) {
                removeIds.add(relation.getUniqueKey());
            }
            this.afterHandleToBeStackedRelation(relMap, relation);
        }
        StackedBillRelation stacked = this.createStackedBillRelation(relMap, relations);
        if (!virtualSrcs.isEmpty()) {
            StackedBillRelation virtualStacked = this.createStackedElement(relMap, removeIds, virtualSrcs);
            virtualStacked.setVirtual(true);
            virtualStacked.getTargets().add(stacked);
        }
        for (BillRelation source : sources) {
            this.handleStackBillRelationSource(relMap, index, stacked, source);
            ++index;
        }
        for (BillRelation target : targets) {
            this.handleStackBillRelationTarget(relMap, stacked, target);
        }
        return stacked;
    }

    protected StackedBillRelation createStackedBillRelation(Map<String, BillRelation> relMap, List<BillRelation> relations) {
        StackedBillRelation stackedRelation = BizFlowGraphUtil.createStackedBillRelation(relations);
        String uniqueKey = stackedRelation.getUniqueKey();
        BillRelation relation = relMap.get(uniqueKey);
        if (relation == null) {
            String stackedNodeId = this.createElementId("stackedCard");
            stackedRelation.setResourceId(stackedNodeId);
            relMap.put(uniqueKey, stackedRelation);
        } else {
            stackedRelation.setResourceId(relation.getResourceId());
        }
        return stackedRelation;
    }

    protected void afterHandleToBeStackedRelation(Map<String, BillRelation> relMap, BillRelation relation) {
    }

    protected int disconnectSourceRelation(Map<String, BillRelation> relMap, BillRelation relation, BillRelation source) {
        return BizFlowGraphUtil.disconnectRelation(relMap, null, relation, source, true);
    }

    protected void disconnectTargetRelation(Map<String, BillRelation> relMap, BillRelation relation, BillRelation target) {
        BizFlowGraphUtil.disconnectRelation(relMap, null, relation, target, false);
    }

    protected void handleStackBillRelationSource(Map<String, BillRelation> relMap, int index, StackedBillRelation stacked, BillRelation source) {
        BizFlowGraphUtil.connectRelation(relMap, null, null, stacked, source, index, true);
    }

    protected void handleStackBillRelationTarget(Map<String, BillRelation> relMap, StackedBillRelation stacked, BillRelation target) {
        BizFlowGraphUtil.connectRelation(relMap, null, null, (BillRelation)stacked, target, false);
    }

    protected Map<String, BillCardPlugin> getBillCardPlugin(Map<String, BillRelation> relMap) {
        HashSet<String> entityNumbers = new HashSet<String>(16);
        for (Map.Entry<String, BillRelation> entry : relMap.entrySet()) {
            entityNumbers.add(entry.getValue().getEntityNumber());
        }
        return BizFlowGraphUtil.getBillRelationCardPlugin(entityNumbers);
    }

    private void setCardCustomData(BillRelationGraphData graphData, Map<String, BillRelation> relMap, Map<String, BillCardPlugin> pluginMap, String appId) {
        ArrayList<BillRelation> cards = null;
        Collection<BillRelation> relations = relMap.values();
        HashMap<String, List<BillRelation>> billCardMap = new HashMap<String, List<BillRelation>>(16);
        for (BillRelation relation : relations) {
            if (relation instanceof StackedBillRelation || relation.isCrossTenant()) continue;
            String entityNumber = relation.getEntityNumber();
            cards = (ArrayList<BillRelation>)billCardMap.get(entityNumber);
            if (cards == null) {
                cards = new ArrayList<BillRelation>();
                billCardMap.put(entityNumber, cards);
            }
            cards.add(relation);
        }
        HashMap<String, CardBillInfo> billMap = new HashMap();
        if (!billCardMap.isEmpty()) {
            billMap = BizFlowGraphUtil.getBillCardData(billCardMap, pluginMap, appId, this.permstrategy);
        }
        for (BillRelation relation : relMap.values()) {
            IBillRelationCardHandler handler = BillRelationCardHandlerFactory.getBillRelationCardHandler(relation);
            handler.setCardContent(relation, relMap, billMap, graphData);
        }
    }

    private void checkAndBreakCycle(BillRelation relation, Map<String, BillRelation> relMap, Map<String, Boolean> visitStatus) {
        String uniqueKey = relation.getUniqueKey();
        visitStatus.put(uniqueKey, Boolean.TRUE);
        List<BillRelation> targets = relation.getTargets();
        if (targets != null && !targets.isEmpty()) {
            HashSet<BillRelation> toBeRemoved = new HashSet<BillRelation>(16);
            for (BillRelation target : targets) {
                Boolean status = visitStatus.get(target.getUniqueKey());
                if (status == null) {
                    this.checkAndBreakCycle(target, relMap, visitStatus);
                    continue;
                }
                if (!Boolean.TRUE.equals(status)) continue;
                toBeRemoved.add(target);
            }
            for (BillRelation element : toBeRemoved) {
                this.breakCycleElement(relation, relMap, targets, element);
            }
        }
        visitStatus.put(uniqueKey, Boolean.FALSE);
    }

    protected void breakCycleElement(BillRelation relation, Map<String, BillRelation> relMap, List<BillRelation> targets, BillRelation element) {
        targets.remove(element);
    }

    protected Map<String, BillRelation> getNodeRelationMap(Map<String, BillRelation> relMap) {
        HashMap<String, BillRelation> nodeRelationMap = new HashMap<String, BillRelation>(relMap.size());
        for (Map.Entry<String, BillRelation> entry : relMap.entrySet()) {
            BillRelation relation = entry.getValue();
            nodeRelationMap.put(relation.getResourceId(relMap), relation);
        }
        return nodeRelationMap;
    }

    private String createElementId(String stencilType) {
        return BizFlowGraphUtil.createElementId("bill_circulaterelation", stencilType, this.idIndex++);
    }
}

