/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bizflow.graph.model.BillCardPlugin;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.render.AbstractBillRelationGraphRender;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpmn.graph.model.GraphIcon;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.GraphicOffset;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public abstract class AbstractBillRelationGraphServerRender
extends AbstractBillRelationGraphRender {
    private static final String FLOW_TIPS_COMPLETEICON = "ierp.billrelation.IconComplete";
    private static final String FLOW_TIPS_UNDERWAYICON = "ierp.billrelation.IconUnderway";
    private static final String CURRENTNODE_SIGN_ICON = "ierp.billrelation.Location";
    protected static final int DEFAULT_SPACE = 20;
    protected int locX;
    protected int locY;
    private BpmnModel bpmnModel = new BpmnModel();

    public AbstractBillRelationGraphServerRender(int stackLimit, String permstrategy) {
        super(stackLimit, permstrategy);
    }

    @Override
    protected BillRelationGraphData createBillRelationGraphData() {
        BillRelationGraphData graphData = super.createBillRelationGraphData();
        this.bpmnModel = BizFlowGraphUtil.createBpmnModel(ModelType.BizFlow.name(), "bill_circulaterelation");
        graphData.setBpmnModel(this.bpmnModel);
        return graphData;
    }

    @Override
    protected void initBillRelations(BillRelation root, Map<String, BillRelation> relMap, Set<String> recalculates) {
        super.initBillRelations(root, relMap, recalculates);
        this.setRootLocation(root);
        HashSet<String> calculated = new HashSet<String>();
        this.calculateLocation(this.bpmnModel, root, relMap, calculated);
        try {
            this.recalculateLocations(this.bpmnModel, relMap, recalculates);
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    @Override
    protected void initRelationAndModel(BillRelation root, Map<String, BillRelation> relMap, Set<String> recalculates) {
        LinkedList<BillRelation> queue = new LinkedList<BillRelation>();
        queue.offer(root);
        this.initRelationAndModel(queue, relMap);
    }

    private void initRelationAndModel(Queue<BillRelation> queue, Map<String, BillRelation> relMap) {
        HashSet<String> handled = new HashSet<String>(16);
        LinkedHashSet<String> recalculates = new LinkedHashSet<String>();
        HashMap<String, ArrayList<String>> joinRelation = new HashMap<String, ArrayList<String>>(16);
        while (!queue.isEmpty()) {
            BillRelation current = queue.poll();
            handled.add(current.getUniqueKey());
            this.initRelation(relMap, current);
            List sourceBusKeys = (List)joinRelation.get(current.getUniqueKey());
            if (sourceBusKeys != null) {
                this.replenishRelationsInfo(relMap, current, current.getSources(), sourceBusKeys);
                sourceBusKeys.clear();
                try {
                    this.reorderBeJoinedElements(current);
                }
                catch (Exception e) {
                    this.logger.error(WfUtils.getExceptionStacktrace(e));
                }
            }
            List<BillRelation> targets = current.getTargets();
            int size = targets.size();
            for (int i = 0; i < size; ++i) {
                BillRelation target = targets.get(i);
                target.getSources().add(current);
                if (!queue.contains(target) && !handled.contains(target.getUniqueKey())) {
                    queue.add(target);
                    continue;
                }
                ArrayList<String> srcBusKeys = (ArrayList<String>)joinRelation.get(target.getUniqueKey());
                if (srcBusKeys == null) {
                    recalculates.add(target.getUniqueKey());
                    srcBusKeys = new ArrayList<String>();
                    joinRelation.put(target.getUniqueKey(), srcBusKeys);
                }
                if (srcBusKeys.contains(current.getUniqueKey())) continue;
                srcBusKeys.add(current.getUniqueKey());
            }
        }
        if (!joinRelation.isEmpty()) {
            for (Map.Entry entry : joinRelation.entrySet()) {
                BillRelation relation = relMap.get(entry.getKey());
                List<BillRelation> sources = relation.getSources();
                List sourceBusKeys = (List)entry.getValue();
                if (sourceBusKeys == null || sourceBusKeys.isEmpty()) continue;
                this.replenishRelationsInfo(relMap, relation, sources, sourceBusKeys);
            }
        }
    }

    private void replenishRelationsInfo(Map<String, BillRelation> relMap, BillRelation relation, List<BillRelation> sources, List<String> sourceBusKeys) {
        BillRelation source;
        for (String busKey : sourceBusKeys) {
            source = relMap.get(busKey);
            if (sources.contains(source)) continue;
            sources.add(source);
        }
        for (String busKey : sourceBusKeys) {
            source = relMap.get(busKey);
            List<BillRelation> tgts = source.getTargets();
            int idx = tgts.indexOf(relation);
            if (idx > -1) {
                BillRelation tgt = tgts.get(idx);
                tgt.setShadow(true);
                tgt.setSelf(relation.getSelf(relMap));
                tgt.setResourceId(relation.getResourceId(relMap));
                tgt.setSources(sources);
                tgt.setTargets(relation.getTargets());
            }
            if (source.isVirtual() || relation.isVirtual()) continue;
            SequenceFlow flow = this.createSequenceFlow(this.bpmnModel, source.getSelf(relMap), relation.getSelf(relMap));
            BizFlowGraphUtil.addFlowInProcessAndConnect(relMap, this.bpmnModel.getMainProcess(), source, flow, relation);
        }
    }

    private void reorderBeJoinedElements(BillRelation joinRelation) {
        List<BillRelation> sources = joinRelation.getSources();
        int size = sources.size();
        if (size < 2) {
            return;
        }
        for (BillRelation source : sources) {
            if (source.getTargets().size() == 1) continue;
            return;
        }
        BillRelation first = sources.get(0);
        List<BillRelation> srcs = first.getSources();
        if (srcs.isEmpty()) {
            return;
        }
        BillRelation next = null;
        BillRelation src = srcs.get(0);
        List<BillRelation> nextSrcs = null;
        for (int i = 1; i < size; ++i) {
            next = sources.get(i);
            nextSrcs = next.getSources();
            if (nextSrcs != null && nextSrcs.size() == 1 && nextSrcs.get(0).equals(src)) continue;
            return;
        }
        List<BillRelation> targets = src.getTargets();
        int index = targets.indexOf(first);
        for (int i = 1; i < size; ++i) {
            BillRelation relation = sources.get(i);
            targets.remove(relation);
            targets.add(++index, relation);
        }
    }

    @Override
    protected void handleLayerOverload(Set<BillRelation> lastLayer) {
    }

    @Override
    protected boolean handleCardCountOverload(Map<String, BillRelation> relMap, List<Set<BillRelation>> layeredRelations) {
        return false;
    }

    @Override
    protected void afterInitBillRelations(BillRelation root, BillRelationGraphData graphData, Map<String, BillRelation> relMap, Map<String, BillCardPlugin> pluginMap) {
        super.afterInitBillRelations(root, graphData, relMap, pluginMap);
        String uniqueKey = BizFlowGraphUtil.getUniqueKey(this.currentEntityNumber, this.currentBusinessKey);
        this.addIconToElement(graphData.getBpmnModel(), relMap, pluginMap, uniqueKey);
    }

    protected void setRootLocation(BillRelation root) {
        int width = this.getGraphWidth(root);
        int height = this.getGraphHeight(root);
        root.setX(this.getRootLocationX(root, width, 826));
        root.setY(this.getRootLocationY(root, height, 1169));
    }

    protected int getRootLocationX(BillRelation root, int width, int pageWidth) {
        int location = (pageWidth - width) / 2;
        if (root.isVirtual()) {
            location -= 216 + this.getNodeSpacing();
        }
        return location;
    }

    protected int getRootLocationY(BillRelation root, int height, int pageHeight) {
        int location = (pageHeight - height) / 2;
        if (root.isVirtual()) {
            location -= 132 + this.getNodeSpacing();
        }
        return location;
    }

    protected void recalculateLocations(BpmnModel bpmnModel, Map<String, BillRelation> relMap, Set<String> recalculates) {
        HashSet<String> sameSrcKeys = new HashSet<String>(recalculates.size());
        for (String businessKey : recalculates) {
            if (sameSrcKeys.contains(businessKey)) continue;
            BillRelation relation = relMap.get(businessKey);
            for (String key : recalculates) {
                BillRelation another;
                if (businessKey.equals(key) || sameSrcKeys.contains(key) || !this.hasSameSources(relation, another = relMap.get(key))) continue;
                sameSrcKeys.add(key);
                sameSrcKeys.add(businessKey);
            }
        }
        recalculates.removeAll(sameSrcKeys);
        HashMap<String, Integer> distanceMap = new HashMap<String, Integer>(recalculates.size());
        HashMap<Integer, BillRelation> newLocMap = new HashMap<Integer, BillRelation>(recalculates.size());
        Map<String, GraphicInfo> locationMap = bpmnModel.getLocationMap();
        for (String businessKey : recalculates) {
            BillRelation relation = relMap.get(businessKey);
            this.recalculateLocation(locationMap, relMap, relation, distanceMap, newLocMap);
        }
    }

    private boolean hasSameSources(BillRelation relation, BillRelation another) {
        List<BillRelation> srcs = relation.getSources();
        List<BillRelation> anosrcs = another.getSources();
        if (srcs.size() != anosrcs.size()) {
            return false;
        }
        HashSet<String> ids = new HashSet<String>(srcs.size());
        for (BillRelation src : srcs) {
            ids.add(src.getUniqueKey());
        }
        for (BillRelation rel : anosrcs) {
            ids.remove(rel.getUniqueKey());
        }
        return ids.isEmpty();
    }

    protected void calculateLocation(BpmnModel bpmnModel, BillRelation parent, Map<String, BillRelation> relMap, Set<String> calculated) {
        calculated.add(parent.getUniqueKey());
        this.addGraphicInfo(bpmnModel, parent, relMap);
        List<BillRelation> targets = parent.getTargets();
        if (!targets.isEmpty()) {
            this.calculateChildrenLocation(bpmnModel, parent, relMap, calculated);
            for (BillRelation target : targets) {
                if (calculated.contains(target.getUniqueKey())) continue;
                this.calculateLocation(bpmnModel, target, relMap, calculated);
            }
        }
    }

    protected void addGraphicInfo(BpmnModel bpmnModel, BillRelation relation, Map<String, BillRelation> relMap) {
        String resourceId = relation.getResourceId(relMap);
        GraphicInfo oriInfo = bpmnModel.getGraphicInfo(resourceId);
        bpmnModel.addGraphicInfo(resourceId, this.createGraphicInfo(relation.getX(), relation.getY()));
        if (oriInfo != null && (oriInfo.getX() != (double)relation.getX() || oriInfo.getY() != (double)relation.getY())) {
            try {
                Map<String, GraphicInfo> locationMap = bpmnModel.getLocationMap();
                List<SequenceFlow> srcFlows = relation.getSrcFlows();
                if (srcFlows.isEmpty()) {
                    srcFlows = relMap.get(relation.getUniqueKey()).getSrcFlows();
                }
                for (SequenceFlow flow : srcFlows) {
                    GraphicInfo target;
                    GraphicInfo source = locationMap.get(flow.getSourceRef());
                    String style = this.locationChanged(source, target = locationMap.get(flow.getTargetRef()), flow.getStyle());
                    if (style == null) continue;
                    flow.setStyle(style);
                }
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace(e));
            }
        }
    }

    protected GraphicInfo createGraphicInfo(int x, int y) {
        GraphicInfo graphic = new GraphicInfo();
        graphic.setWidth(216.0);
        graphic.setHeight(132.0);
        graphic.setX(x);
        graphic.setY(y);
        return graphic;
    }

    protected void calculateChildrenLocation(BpmnModel bpmnModel, BillRelation parent, Map<String, BillRelation> relMap, Set<String> calculated) {
        int location;
        int wholeWidth;
        int location2;
        int wholeWidth2;
        int lastNodeWholeWidth;
        BillRelation target;
        int i;
        List<BillRelation> tgts = parent.getTargets();
        ArrayList<BillRelation> targets = new ArrayList<BillRelation>(tgts.size());
        for (BillRelation relation : tgts) {
            if (calculated.contains(relation.getUniqueKey())) continue;
            targets.add(relation);
        }
        if (targets.isEmpty()) {
            return;
        }
        int size = targets.size();
        boolean odd = size % 2 != 0;
        int middle = odd ? (size - 1) / 2 : size / 2;
        int x = parent.getX();
        int y = parent.getY();
        this.locX = this.getLocationX(x);
        this.locY = this.getLocationY(y);
        int rightIndex = middle;
        BillRelation last = null;
        BillRelation middleElement = null;
        if (odd) {
            middleElement = (BillRelation)targets.get(middle);
            middleElement.setX(this.locX);
            middleElement.setY(this.locY);
            last = middleElement;
            rightIndex = middle + 1;
            this.addGraphicInfo(bpmnModel, middleElement, relMap);
            this.updateRelMapElementLocation(relMap, middleElement);
        }
        if (size == 1) {
            return;
        }
        for (i = middle - 1; i >= 0; --i) {
            target = (BillRelation)targets.get(i);
            if (last != null) {
                lastNodeWholeWidth = Math.abs(this.getNodeCrossAxisWholeWidth(last));
                wholeWidth2 = Math.abs(this.getNodeCrossAxisWholeWidth(target));
                location2 = this.getCrossAxisLocation() - (lastNodeWholeWidth - this.getNodeCrossAxisWidth(last)) / 2 - this.getSpace() - (wholeWidth2 + this.getNodeCrossAxisWidth(target)) / 2;
                this.setNodeCrossAxisLocation(target, location2);
            } else {
                wholeWidth = Math.abs(this.getNodeCrossAxisWholeWidth(target));
                location = this.getCrossAxisLocation() + this.getNodeCrossAxisWidth(parent) / 2 - this.getSpace() / 2 - (wholeWidth + this.getNodeCrossAxisWidth(target)) / 2;
                this.setNodeCrossAxisLocation(target, location);
            }
            this.setNodeMainAxisLocation(target, this.getMainAxisLocation());
            last = target;
            this.setCrossAxisLocation(this.getNodeCrossAxisLocation(target));
            this.addGraphicInfo(bpmnModel, target, relMap);
            this.updateRelMapElementLocation(relMap, target);
        }
        last = middleElement;
        this.resetCrossAxisLocation(x, y);
        for (i = rightIndex; i < size; ++i) {
            target = (BillRelation)targets.get(i);
            if (last != null) {
                lastNodeWholeWidth = Math.abs(this.getNodeCrossAxisWholeWidth(last));
                wholeWidth2 = Math.abs(this.getNodeCrossAxisWholeWidth(target));
                location2 = this.getCrossAxisLocation() + (lastNodeWholeWidth + this.getNodeCrossAxisWidth(last)) / 2 + this.getSpace() + (wholeWidth2 - this.getNodeCrossAxisWidth(target)) / 2;
                this.setNodeCrossAxisLocation(target, location2);
            } else {
                wholeWidth = Math.abs(this.getNodeCrossAxisWholeWidth(target));
                location = this.getCrossAxisLocation() + this.getNodeCrossAxisWidth(parent) / 2 + this.getSpace() / 2 + (wholeWidth - this.getNodeCrossAxisWidth(target)) / 2;
                this.setNodeCrossAxisLocation(target, location);
            }
            this.setNodeMainAxisLocation(target, this.getMainAxisLocation());
            last = target;
            this.setCrossAxisLocation(this.getNodeCrossAxisLocation(target));
            this.addGraphicInfo(bpmnModel, target, relMap);
            this.updateRelMapElementLocation(relMap, target);
        }
        if (size < 2) {
            return;
        }
        BillRelation leftmost = (BillRelation)targets.get(0);
        BillRelation rightmost = (BillRelation)targets.get(size - 1);
        if (leftmost instanceof StackedBillRelation || rightmost instanceof StackedBillRelation) {
            return;
        }
        int min = this.getNodeCrossAxisLocation(leftmost);
        int max = this.getNodeCrossAxisLocation(rightmost);
        int middleLocation = min + (max - min) / 2;
        int location3 = this.getNodeCrossAxisLocation(parent);
        int distance = location3 - middleLocation;
        if (distance != 0) {
            HashSet<String> movedBills = new HashSet<String>(16);
            Map<String, GraphicInfo> locationMap = bpmnModel.getLocationMap();
            for (BillRelation target2 : targets) {
                this.translationLocation(target2, distance, locationMap, relMap, movedBills, false);
            }
        }
    }

    private void updateRelMapElementLocation(Map<String, BillRelation> relMap, BillRelation relation) {
        BillRelation billRelation = relMap.get(relation.getUniqueKey());
        if (billRelation != null) {
            billRelation.setX(relation.getX());
            billRelation.setY(relation.getY());
        }
    }

    protected void recalculateLocation(Map<String, GraphicInfo> locationMap, Map<String, BillRelation> relMap, BillRelation relation, Map<String, Integer> distanceMap, Map<Integer, BillRelation> newLocMap) {
        int location;
        List<BillRelation> sources = relation.getSources();
        int size = sources.size();
        if (size < 2) {
            return;
        }
        for (BillRelation billRelation : sources) {
            if (billRelation.getTargets().size() <= 1) continue;
            return;
        }
        ArrayList<Integer> locations = new ArrayList<Integer>(sources.size());
        for (BillRelation source : sources) {
            if (source.isVirtual()) continue;
            location = this.getNodeCrossAxisLocation(source);
            locations.add(location);
        }
        Collections.sort(locations);
        int n = (Integer)locations.get(0);
        int max = (Integer)locations.get(locations.size() - 1);
        location = n + Math.abs(max - n) / 2;
        int distance = location - this.getNodeCrossAxisLocation(relation);
        int newLocation = this.getAfterMovementLocation(relation, distance);
        HashSet<String> movedBills = new HashSet<String>(32);
        BillRelation node = newLocMap.get(newLocation);
        if (node != null) {
            if (WfUtils.isEmpty(node.getUniqueKey())) {
                return;
            }
            Integer movedDistance = distanceMap.get(node.getUniqueKey());
            this.translationLocation(node, 0 - movedDistance, locationMap, relMap, movedBills);
            newLocMap.put(newLocation, new BillRelation());
            return;
        }
        newLocMap.put(newLocation, relation);
        distanceMap.put(relation.getUniqueKey(), distance);
        this.translationLocation(relation, distance, locationMap, relMap, movedBills);
    }

    protected void translationLocation(BillRelation node, int distance, Map<String, GraphicInfo> locationMap, Map<String, BillRelation> relMap, Set<String> movedBills) {
        this.translationLocation(node, distance, locationMap, relMap, movedBills, true);
    }

    private void translationLocation(BillRelation node, int distance, Map<String, GraphicInfo> locationMap, Map<String, BillRelation> relMap, Set<String> movedBills, boolean translateChildren) {
        String resourceId = node.getResourceId(relMap);
        GraphicInfo graphicInfo = locationMap.get(resourceId);
        int newLocation = this.getAfterMovementLocation(node, distance);
        this.setNodeCrossAxisLocation(node, newLocation);
        this.setNodeCrossAxisGraphicInfo(graphicInfo, newLocation);
        if (translateChildren) {
            List<BillRelation> targets = node.getTargets();
            for (BillRelation target : targets) {
                if (!movedBills.add(target.getUniqueKey())) continue;
                this.translationLocation(target, distance, locationMap, relMap, movedBills);
                this.translationSiblingLocation(target.getSources(), node, distance, locationMap, relMap, movedBills);
            }
        }
    }

    private void translationSiblingLocation(List<BillRelation> sources, BillRelation node, int distance, Map<String, GraphicInfo> locationMap, Map<String, BillRelation> relMap, Set<String> movedBills) {
        if (sources.size() < 2) {
            return;
        }
        int index = sources.indexOf(node);
        if (index < 0) {
            return;
        }
        for (int i = index + 1; i < sources.size(); ++i) {
            BillRelation source = sources.get(i);
            if (!movedBills.add(source.getUniqueKey())) continue;
            this.translationLocation(source, distance, locationMap, relMap, movedBills);
        }
    }

    @Override
    protected void initRelation(Map<String, BillRelation> relMap, BillRelation current) {
        List<BillRelation> sources;
        super.initRelation(relMap, current);
        Process process = this.bpmnModel.getMainProcess();
        String stencilType = "billCard";
        if (current instanceof StackedBillRelation) {
            stencilType = "stackedCard";
        }
        FlowElement element = BizFlowGraphUtil.createFlowElement(this.bpmnModel, stencilType, current.getResourceId());
        current.setSelf(element);
        if (!current.isVirtual()) {
            process.addFlowElement(element);
        }
        if (!(sources = current.getSources()).isEmpty() && !sources.get(0).isVirtual()) {
            for (BillRelation source : sources) {
                FlowElement parent = source.getSelf();
                SequenceFlow flow = this.createSequenceFlow(this.bpmnModel, parent, element);
                BizFlowGraphUtil.addFlowInProcessAndConnect(relMap, process, source, flow, current);
            }
        }
    }

    @Override
    protected StackedBillRelation createStackedBillRelation(Map<String, BillRelation> relMap, List<BillRelation> relations) {
        StackedBillRelation stackedRelation = super.createStackedBillRelation(relMap, relations);
        boolean isVirtual = relations.get(0).isVirtual();
        this.setStackedRelationElement(stackedRelation, isVirtual);
        return stackedRelation;
    }

    private void setStackedRelationElement(StackedBillRelation stackedRelation, boolean isVirtual) {
        Process process = this.bpmnModel.getMainProcess();
        FlowNode stackedTask = BizFlowGraphUtil.createStackedTask(this.bpmnModel, stackedRelation.getResourceId());
        stackedRelation.setSelf(stackedTask);
        if (!isVirtual) {
            process.addFlowElement(stackedTask);
        }
    }

    @Override
    protected void afterHandleToBeStackedRelation(Map<String, BillRelation> relMap, BillRelation relation) {
        super.afterHandleToBeStackedRelation(relMap, relation);
        Process process = this.bpmnModel.getMainProcess();
        for (SequenceFlow flow : relation.getSrcFlows()) {
            process.removeFlowElement(flow.getId());
        }
        for (SequenceFlow flow : relation.getTgtFlows()) {
            process.removeFlowElement(flow.getId());
        }
        process.removeFlowElement(relation.getResourceId(relMap));
    }

    @Override
    protected int disconnectSourceRelation(Map<String, BillRelation> relMap, BillRelation relation, BillRelation source) {
        return BizFlowGraphUtil.disconnectRelation(relMap, this.bpmnModel.getMainProcess(), relation, source, true);
    }

    @Override
    protected void disconnectTargetRelation(Map<String, BillRelation> relMap, BillRelation relation, BillRelation target) {
        BizFlowGraphUtil.disconnectRelation(relMap, this.bpmnModel.getMainProcess(), relation, target, false);
    }

    @Override
    protected void handleStackBillRelationSource(Map<String, BillRelation> relMap, int index, StackedBillRelation stacked, BillRelation source) {
        SequenceFlow flow = this.createSequenceFlow(this.bpmnModel, source.getSelf(relMap), stacked.getSelf(relMap));
        BizFlowGraphUtil.connectRelation(relMap, this.bpmnModel.getMainProcess(), flow, stacked, source, index, true);
    }

    @Override
    protected void handleStackBillRelationTarget(Map<String, BillRelation> relMap, StackedBillRelation stacked, BillRelation target) {
        SequenceFlow flow = this.createSequenceFlow(this.bpmnModel, stacked.getSelf(relMap), target.getSelf(relMap));
        BizFlowGraphUtil.connectRelation(relMap, this.bpmnModel.getMainProcess(), flow, (BillRelation)stacked, target, false);
    }

    @Override
    protected void breakCycleElement(BillRelation relation, Map<String, BillRelation> relMap, List<BillRelation> targets, BillRelation element) {
        super.breakCycleElement(relation, relMap, targets, element);
        BizFlowGraphUtil.disconnectRelation(relMap, this.bpmnModel.getMainProcess(), relation, element, false);
    }

    protected int getAfterMovementLocation(BillRelation node, int distance) {
        return this.getNodeCrossAxisLocation(node) + distance;
    }

    protected int getNodeCrossAxisWholeWidth(BillRelation node) {
        List<BillRelation> targets = BizFlowGraphUtil.getNodeTargetsWithoutShadow(node);
        int size = targets.size();
        if (size < 1) {
            return this.getNodeCrossAxisWidth(node);
        }
        int sum = 0;
        for (BillRelation target : targets) {
            sum += this.getNodeCrossAxisWholeWidth(target);
        }
        return sum += (size - 1) * this.getSpace();
    }

    protected void addIconToElement(BpmnModel bpmnModel, Map<String, BillRelation> relMap, Map<String, BillCardPlugin> pluginMap, String uniqueKey) {
        Map<String, BillRelation> nodeRelationMap = this.getNodeRelationMap(relMap);
        Map<String, GraphicInfo> locationMap = bpmnModel.getLocationMap();
        List<FlowNode> flowNodes = bpmnModel.getMainProcess().findFlowElementsOfType(FlowNode.class);
        for (FlowNode flowNode : flowNodes) {
            List<SequenceFlow> flows = flowNode.getOutgoingFlows();
            if (flows == null || flows.isEmpty()) continue;
            this.createSequenceFlowIcon(flows.get(flows.size() - 1), nodeRelationMap, locationMap, pluginMap);
        }
        List<BillRelation> currentRelations = this.getCurrentBillRelation(relMap, uniqueKey);
        for (BillRelation relation : currentRelations) {
            if (relation instanceof StackedBillRelation) continue;
            this.createCurrentNodeIcon(relation.getSelf(relMap));
        }
    }

    protected List<BillRelation> getCurrentBillRelation(Map<String, BillRelation> relMap, String uniqueKey) {
        if (WfUtils.isEmpty(uniqueKey)) {
            return new ArrayList<BillRelation>();
        }
        ArrayList<BillRelation> relations = new ArrayList<BillRelation>(16);
        for (Map.Entry<String, BillRelation> entry : relMap.entrySet()) {
            BillRelation relation = entry.getValue();
            if (!uniqueKey.equals(relation.getUniqueKey())) continue;
            relations.add(relation);
        }
        return relations;
    }

    protected void createSequenceFlowIcon(SequenceFlow flow, Map<String, BillRelation> nodeRelationMap, Map<String, GraphicInfo> locationMap, Map<String, BillCardPlugin> pluginMap) {
        GraphIcon icon = new GraphIcon();
        icon.setHeight(24.0);
        icon.setWidth(24.0);
        BillRelation relation = nodeRelationMap.get(flow.getSourceRef());
        icon.addIconData("type", relation.getStatus());
        icon.addIconData("entityNumber", relation.getEntityNumber());
        icon.addIconData("businessKey", relation.getBusinessKey());
        BillCardPlugin cardPlugin = pluginMap.get(relation.getEntityNumber());
        if (cardPlugin != null && ExternalInterfaceUtil.isValidValue(cardPlugin.getPushStatusPlugin())) {
            icon.addIconData("plugin", cardPlugin.getPushStatusPlugin());
        }
        if ("complete".equals(relation.getStatus())) {
            icon.setShape(FLOW_TIPS_COMPLETEICON);
            icon.addIconData("title", ResManager.loadKDString((String)"\u4e0b\u63a8\u5df2\u5b8c\u6210", (String)"AbstractBillRelationGraphRender_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else {
            icon.setShape(FLOW_TIPS_UNDERWAYICON);
            icon.addIconData("title", ResManager.loadKDString((String)"\u4e0b\u63a8\u8fdb\u884c\u4e2d", (String)"AbstractBillRelationGraphRender_4", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        GraphicInfo source = locationMap.get(flow.getSourceRef());
        GraphicInfo target = locationMap.get(flow.getTargetRef());
        String flowStyle = flow.getStyle();
        this.createIconGraphicOffset(icon, source, target, flowStyle);
        if (icon.getOffset() != null) {
            flow.setIcon(icon);
        }
    }

    private void createCurrentNodeIcon(FlowElement element) {
        GraphIcon icon = new GraphIcon();
        icon.setShape(CURRENTNODE_SIGN_ICON);
        icon.setHeight(32.0);
        icon.setWidth(32.0);
        icon.setOffset(new GraphicOffset(-16.0, -16.0));
        element.setIcon(icon);
    }

    protected int getNodeMainAxisWholeWidth(BillRelation node) {
        int level = this.getNodeLevel(node, 1);
        return this.getNodeMainAxisWidth(node) * level + (level - 1) * this.getNodeSpacing();
    }

    protected int getNodeLevel(BillRelation node, int baseLevel) {
        List<BillRelation> targets = node.getTargets();
        if (targets.isEmpty()) {
            return 1;
        }
        if (node.isVirtual()) {
            baseLevel = 0;
        }
        int level = 1;
        for (BillRelation target : targets) {
            int childLevel = this.getNodeLevel(target, baseLevel);
            if (childLevel <= level) continue;
            level = childLevel;
        }
        return baseLevel + level;
    }

    protected SequenceFlow createSequenceFlow(BpmnModel bpmnModel, FlowElement source, FlowElement target) {
        return BizFlowGraphUtil.createSequenceFlow(bpmnModel, source, target);
    }

    protected abstract int getGraphWidth(BillRelation var1);

    protected abstract int getGraphHeight(BillRelation var1);

    protected abstract int getNodeSpacing();

    protected abstract void createIconGraphicOffset(GraphIcon var1, GraphicInfo var2, GraphicInfo var3, String var4);

    protected int getLocationX(int x) {
        return x;
    }

    protected int getLocationY(int y) {
        return y;
    }

    protected abstract void resetCrossAxisLocation(int var1, int var2);

    protected abstract int getNodeCrossAxisWidth(BillRelation var1);

    protected abstract int getNodeMainAxisWidth(BillRelation var1);

    protected abstract int getNodeMainAxisWidth();

    protected abstract int getNodeCrossAxisWidth();

    protected abstract int getCrossAxisLocation();

    protected abstract int getMainAxisLocation();

    protected abstract void setCrossAxisLocation(int var1);

    protected abstract void setNodeMainAxisLocation(BillRelation var1, int var2);

    protected abstract void setNodeCrossAxisLocation(BillRelation var1, int var2);

    protected abstract void setNodeCrossAxisGraphicInfo(GraphicInfo var1, int var2);

    protected abstract int getNodeCrossAxisLocation(BillRelation var1);

    protected abstract String locationChanged(GraphicInfo var1, GraphicInfo var2, String var3);

    protected int getSpace() {
        return 20;
    }
}

