/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.workflow.bizflow.graph.model.BillCardPlugin;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphCell;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.render.AbstractBillRelationGraphRender;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class BillRelationGraphClientRender
extends AbstractBillRelationGraphRender {
    private Map<String, BillRelation> relationMap;

    public BillRelationGraphClientRender(int stackLimit, String permstrategy) {
        super(stackLimit, permstrategy);
    }

    @Override
    protected void initBillRelations(BillRelation root, Map<String, BillRelation> relMap, Set<String> recalculates) {
        super.initBillRelations(root, relMap, recalculates);
        this.relationMap = new HashMap<String, BillRelation>(relMap);
    }

    @Override
    protected void afterInitBillRelations(BillRelation root, BillRelationGraphData graphData, Map<String, BillRelation> relMap, Map<String, BillCardPlugin> pluginMap) {
        super.afterInitBillRelations(root, graphData, relMap, pluginMap);
        Map<String, BillRelation> nodeRelationMap = this.getNodeRelationMap(this.relationMap);
        BillRelationGraphCell rootCell = this.createGraphCell(root, nodeRelationMap, pluginMap);
        graphData.setGraphRoot(rootCell);
    }

    private BillRelationGraphCell createGraphCell(BillRelation relation, Map<String, BillRelation> nodeRelationMap, Map<String, BillCardPlugin> pluginMap) {
        List<BillRelation> targets;
        if (relation == null) {
            return null;
        }
        String nodeId = relation.getResourceId();
        BillRelationGraphCell graphCell = new BillRelationGraphCell(nodeId);
        if (relation instanceof StackedBillRelation) {
            graphCell.setType("stackedCard");
        } else {
            graphCell.setType("billCard");
        }
        graphCell.setDatas(relation.getDatas());
        if (BizFlowGraphUtil.getUniqueKey(this.currentEntityNumber, this.currentBusinessKey).equals(relation.getUniqueKey())) {
            graphCell.setCurrent(true);
        }
        graphCell.setStatus(relation.getStatus());
        graphCell.setVirtual(relation.isVirtual());
        BillCardPlugin cardPlugin = pluginMap.get(relation.getEntityNumber());
        if (cardPlugin != null && ExternalInterfaceUtil.isValidValue(cardPlugin.getPushStatusPlugin())) {
            graphCell.setStausPlugin(cardPlugin.getPushStatusPlugin());
        }
        if ((targets = relation.getTargets()).isEmpty()) {
            return graphCell;
        }
        ArrayList<BillRelationGraphCell> targetCells = new ArrayList<BillRelationGraphCell>(targets.size());
        for (BillRelation target : targets) {
            BillRelationGraphCell targetCell = this.createGraphCell(target, nodeRelationMap, pluginMap);
            if (targetCell == null) continue;
            targetCells.add(targetCell);
        }
        graphCell.setTargets(targetCells);
        return graphCell;
    }
}

