/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.render;

import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.render.AbstractBillRelationGraphServerRender;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.model.GraphIcon;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.GraphicOffset;
import kd.bos.workflow.bpmn.model.SequenceFlow;

public class HorizontalBillRelationGraphRender
extends AbstractBillRelationGraphServerRender {
    public HorizontalBillRelationGraphRender(int stackLimit, String permstrategy) {
        super(stackLimit, permstrategy);
    }

    @Override
    protected int getGraphWidth(BillRelation root) {
        return this.getNodeMainAxisWholeWidth(root);
    }

    @Override
    protected int getGraphHeight(BillRelation root) {
        return this.getNodeCrossAxisWholeWidth(root);
    }

    @Override
    protected int getNodeSpacing() {
        return 80;
    }

    @Override
    protected int getRootLocationY(BillRelation root, int height, int pageHeight) {
        return (pageHeight - this.getNodeCrossAxisWidth()) / 2;
    }

    @Override
    protected int getLocationX(int x) {
        return x + this.getNodeMainAxisWidth() + this.getNodeSpacing();
    }

    @Override
    protected void resetCrossAxisLocation(int x, int y) {
        this.locY = y;
    }

    @Override
    protected int getNodeCrossAxisWidth(BillRelation node) {
        return node.getHeight();
    }

    @Override
    protected int getNodeMainAxisWidth(BillRelation node) {
        return node.getWidth();
    }

    @Override
    protected int getNodeMainAxisWidth() {
        return 216;
    }

    @Override
    protected int getNodeCrossAxisWidth() {
        return 132;
    }

    @Override
    protected int getCrossAxisLocation() {
        return this.locY;
    }

    @Override
    protected int getMainAxisLocation() {
        return this.locX;
    }

    @Override
    protected void setCrossAxisLocation(int location) {
        this.locY = location;
    }

    @Override
    protected void setNodeMainAxisLocation(BillRelation node, int location) {
        node.setX(location);
    }

    @Override
    protected void setNodeCrossAxisLocation(BillRelation node, int location) {
        node.setY(location);
    }

    @Override
    protected void setNodeCrossAxisGraphicInfo(GraphicInfo info, int location) {
        info.setY(location);
    }

    @Override
    protected int getNodeCrossAxisLocation(BillRelation node) {
        return node.getY();
    }

    @Override
    protected SequenceFlow createSequenceFlow(BpmnModel bpmnModel, FlowElement source, FlowElement target) {
        SequenceFlow sequenceFlow = super.createSequenceFlow(bpmnModel, source, target);
        sequenceFlow.setStyle(String.format("%sentryX=0;entryY=0.5;", sequenceFlow.getStyle()));
        return sequenceFlow;
    }

    @Override
    protected String locationChanged(GraphicInfo source, GraphicInfo target, String flowStyle) {
        if (target.getX() - source.getX() <= (double)(this.getNodeMainAxisWidth() + this.getNodeSpacing())) {
            return null;
        }
        String flowDefaultEntry = "entryX=0;entryY=0.5;";
        if (target.getY() >= source.getY() + (double)this.getNodeCrossAxisWidth()) {
            return flowStyle.replace(flowDefaultEntry, "entryX=0.5;entryY=0;");
        }
        return flowStyle.replace(flowDefaultEntry, "entryX=0.5;entryY=1;");
    }

    @Override
    protected void createIconGraphicOffset(GraphIcon icon, GraphicInfo source, GraphicInfo target, String flowStyle) {
        String entryX = GraphCodecUtils.getStyleValue(flowStyle, "entryX", "0");
        String entryY = GraphCodecUtils.getStyleValue(flowStyle, "entryY", "0.5");
        if (!"0".equals(entryX) || !"0.5".equals(entryY) || target.getX() <= source.getX() + source.getWidth()) {
            return;
        }
        double x1 = source.getX() + source.getWidth();
        double y1 = source.getY() + source.getHeight() / 2.0;
        double x2 = target.getX();
        double y2 = target.getY() + target.getHeight() / 2.0;
        double x = (x2 - x1) / 4.0 + icon.getWidth() / 2.0;
        if (y2 >= y1) {
            double y = (y2 - y1) / 2.0 + icon.getHeight() / 2.0;
            icon.setOffset(new GraphicOffset(0.0 - x, 0.0 - y));
        } else {
            double y = (y1 - y2) / 2.0 - icon.getHeight() / 2.0;
            icon.setOffset(new GraphicOffset(0.0 - x, y));
        }
    }
}

