/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.render;

import java.util.Map;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.render.AbstractBillRelationGraphServerRender;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.graph.model.GraphIcon;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.GraphicOffset;
import kd.bos.workflow.bpmn.model.SequenceFlow;

public class VerticalBillRelationGraphRender
extends AbstractBillRelationGraphServerRender {
    public VerticalBillRelationGraphRender(int stackLimit, String permstrategy) {
        super(stackLimit, permstrategy);
    }

    @Override
    protected int getGraphWidth(BillRelation root) {
        return this.getNodeCrossAxisWholeWidth(root);
    }

    @Override
    protected int getGraphHeight(BillRelation root) {
        return this.getNodeMainAxisWholeWidth(root);
    }

    @Override
    protected int getNodeSpacing() {
        return 100;
    }

    @Override
    protected int getRootLocationX(BillRelation root, int width, int pageWidth) {
        return (pageWidth - this.getNodeCrossAxisWidth()) / 2;
    }

    @Override
    protected int getLocationY(int y) {
        return y + this.getNodeMainAxisWidth() + this.getNodeSpacing();
    }

    @Override
    protected void resetCrossAxisLocation(int x, int y) {
        this.locX = x;
    }

    @Override
    protected int getNodeCrossAxisWidth(BillRelation node) {
        return node.getWidth();
    }

    @Override
    protected int getNodeMainAxisWidth(BillRelation node) {
        return node.getHeight();
    }

    @Override
    protected int getNodeMainAxisWidth() {
        return 132;
    }

    @Override
    protected int getNodeCrossAxisWidth() {
        return 216;
    }

    @Override
    protected int getCrossAxisLocation() {
        return this.locX;
    }

    @Override
    protected int getMainAxisLocation() {
        return this.locY;
    }

    @Override
    protected void setCrossAxisLocation(int location) {
        this.locX = location;
    }

    @Override
    protected void setNodeMainAxisLocation(BillRelation node, int location) {
        node.setY(location);
    }

    @Override
    protected void setNodeCrossAxisLocation(BillRelation node, int location) {
        node.setX(location);
    }

    @Override
    protected void setNodeCrossAxisGraphicInfo(GraphicInfo info, int location) {
        info.setX(location);
    }

    @Override
    protected int getNodeCrossAxisLocation(BillRelation node) {
        return node.getX();
    }

    @Override
    protected SequenceFlow createSequenceFlow(BpmnModel bpmnModel, FlowElement source, FlowElement target) {
        SequenceFlow sequenceFlow = super.createSequenceFlow(bpmnModel, source, target);
        sequenceFlow.setStyle(String.format("%sexitX=0.5;exitY=1;", sequenceFlow.getStyle()));
        return sequenceFlow;
    }

    @Override
    protected void recalculateLocation(Map<String, GraphicInfo> locationMap, Map<String, BillRelation> relMap, BillRelation relation, Map<String, Integer> distanceMap, Map<Integer, BillRelation> newLocMap) {
        super.recalculateLocation(locationMap, relMap, relation, distanceMap, newLocMap);
        for (SequenceFlow flow : relation.getSrcFlows()) {
            flow.setStyle(String.format("%s%s", flow.getStyle(), "exitX=0.5;exitY=1;"));
        }
    }

    @Override
    protected String locationChanged(GraphicInfo source, GraphicInfo target, String flowStyle) {
        if (target.getY() - source.getY() <= (double)(this.getNodeMainAxisWidth() + this.getNodeSpacing())) {
            return null;
        }
        if (target.getX() >= source.getX() + (double)this.getNodeCrossAxisWidth()) {
            return String.format("%sentryX=0;entryY=0.5;", flowStyle);
        }
        return String.format("%sentryX=1;entryY=0.5;", flowStyle);
    }

    @Override
    protected void createIconGraphicOffset(GraphIcon icon, GraphicInfo source, GraphicInfo target, String flowStyle) {
        String entryX = GraphCodecUtils.getStyleValue(flowStyle, "entryX", "0.5");
        String entryY = GraphCodecUtils.getStyleValue(flowStyle, "entryY", "0");
        if (!"0.5".equals(entryX) || !"0".equals(entryY) || target.getY() <= source.getY() + source.getHeight()) {
            return;
        }
        double x1 = source.getX() + source.getWidth() / 2.0;
        double y1 = source.getY() + source.getHeight();
        double x2 = target.getX() + source.getWidth() / 2.0;
        double y2 = target.getY();
        double y = (y2 - y1) / 4.0 + icon.getHeight() / 2.0;
        if (x2 >= x1) {
            double x = (x2 - x1) / 2.0 + icon.getWidth() / 2.0;
            icon.setOffset(new GraphicOffset(0.0 - x, 0.0 - y));
        } else {
            double x = (x1 - x2) / 2.0 - icon.getWidth() / 2.0;
            icon.setOffset(new GraphicOffset(x, 0.0 - y));
        }
    }
}

