/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.graph.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.property.AmountProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.model.CheckDimObjParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bizflow.graph.model.BillCardData;
import kd.bos.workflow.bizflow.graph.model.BillCardPlugin;
import kd.bos.workflow.bizflow.graph.model.BillCardTpl;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.BillRelationParameter;
import kd.bos.workflow.bizflow.graph.model.BillTypeInfo;
import kd.bos.workflow.bizflow.graph.model.CardBillInfo;
import kd.bos.workflow.bizflow.graph.model.SelectedRowData;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.render.AbstractBillRelationGraphRender;
import kd.bos.workflow.bizflow.graph.render.BillRelationGraphClientRender;
import kd.bos.workflow.bizflow.graph.render.HorizontalBillRelationGraphRender;
import kd.bos.workflow.bizflow.graph.render.VerticalBillRelationGraphRender;
import kd.bos.workflow.bizflow.graph.util.BOTPRelationGraphUtil;
import kd.bos.workflow.bizflow.graph.util.CheckPermissionParam;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;
import kd.bos.workflow.service.WorkflowService;

public class BizFlowGraphUtil {
    private static Log log = LogFactory.getLog(BizFlowGraphUtil.class);
    private static Map<String, Class> pkTypeMap = new HashMap<String, Class>();
    public static final String CANNOTREAD_VALUE = "******";

    private BizFlowGraphUtil() {
    }

    @Deprecated
    public static BillRelationGraphData createBillRelationModel(Long procInstId, String businessKey, String appId) {
        return BizFlowGraphUtil.createBillRelationModel(procInstId, businessKey, appId, true);
    }

    @Deprecated
    public static BillRelationGraphData createBillRelationModel(Long procInstId, String businessKey, String appId, boolean horizontal) {
        return BizFlowGraphUtil.createBillRelationModel(procInstId, null, businessKey, appId);
    }

    @Deprecated
    public static BillRelationGraphData createBillRelationModel(Long procInstId, String entityNumber, String businessKey, String appId) {
        return BizFlowGraphUtil.createBillRelationModel(procInstId, entityNumber, businessKey, appId, true);
    }

    @Deprecated
    public static BillRelationGraphData createBillRelationModel(Long procInstId, String entityNumber, String businessKey, String appId, boolean horizontal) {
        return BizFlowGraphUtil.createBillRelationModel(procInstId, entityNumber, businessKey, appId, horizontal, "all");
    }

    public static BillRelationGraphData createBillRelationModel(Long procInstId, String entityNumber, String businessKey, String appId, boolean horizontal, String permStrategy) {
        WorkflowService service = (WorkflowService)kd.bos.workflow.service.impl.ServiceFactory.getService(WorkflowService.class);
        List<BillRelation> relations = service.getRuntimeService().getBillCirculateRelations(procInstId, businessKey);
        BillRelationParameter parameter = new BillRelationParameter(entityNumber, appId, horizontal, false, permStrategy);
        parameter.setBusinessKey(businessKey);
        return BizFlowGraphUtil.createBillRelationModel(relations, parameter);
    }

    public static BillRelationGraphData createCustomBillRelationModel(List<BillRelation> relations, String currentEntity, String currentBusinessKey, String appId) {
        BillRelationParameter parameter = new BillRelationParameter(currentEntity, appId, true);
        parameter.setBusinessKey(currentBusinessKey);
        return BizFlowGraphUtil.createBillRelationModel(relations, parameter);
    }

    public static int getBillRelationGraphStackSize() {
        int configuredSize = 0;
        String stackSize = (String)WfConfigurationUtil.getConfigCenterVal("workflow.relationGraph.stackSize");
        if (stackSize != null && stackSize.matches("^\\d{1,8}$")) {
            configuredSize = Integer.parseInt(stackSize);
        }
        return configuredSize > 1 ? configuredSize : 3;
    }

    public static int getBillRelationGraphStackIdsLimit() {
        String idsLimit = (String)WfConfigurationUtil.getConfigCenterVal("workflow.relationGraph.stackIdsLimit");
        if (idsLimit != null && idsLimit.matches("^\\d{1,6}$")) {
            int limit = Integer.parseInt(idsLimit);
            if (limit > 100000) {
                limit = 100000;
            }
            return limit;
        }
        return 30000;
    }

    private static BillRelationGraphData createBillRelationModel(List<BillRelation> relations, BillRelationParameter parameter) {
        AbstractBillRelationGraphRender render = null;
        int stackLimit = BizFlowGraphUtil.getBillRelationGraphStackSize();
        String permStrategy = parameter.getPermStrategy();
        render = BizFlowGraphUtil.isServerRender() ? (parameter.isHorizontal() ? new HorizontalBillRelationGraphRender(stackLimit, permStrategy) : new VerticalBillRelationGraphRender(stackLimit, permStrategy)) : new BillRelationGraphClientRender(stackLimit, permStrategy);
        String entityNumber = parameter.getEntityNumber();
        String businessKey = parameter.getBusinessKey();
        return render.getBillRelationModel(relations, entityNumber, businessKey, parameter.getAppId());
    }

    @Deprecated
    public static BillRelationGraphData createBillBOTPRelationModel(String entityNumber, String businessKey, String appId, boolean horizontal) {
        return BizFlowGraphUtil.createBillBOTPRelationModel(entityNumber, businessKey, appId, horizontal, false);
    }

    @Deprecated
    public static BillRelationGraphData createBillBOTPRelationModel(String entityNumber, String businessKey, String appId, boolean horizontal, boolean loadOtherRelations) {
        BillRelationParameter parameter = new BillRelationParameter(entityNumber, appId, horizontal, loadOtherRelations, null);
        parameter.setBusinessKey(businessKey);
        return BizFlowGraphUtil.createBillBOTPRelationModel(parameter);
    }

    public static BillRelationGraphData createBillBOTPRelationModel(BillRelationParameter parameter) {
        SelectedRowData rowData = parameter.getRowData();
        String entityNumber = parameter.getEntityNumber();
        List<BillRelation> relations = null;
        if (rowData != null) {
            parameter.setBusinessKey(String.valueOf(rowData.getPrimaryKeyValue()));
            relations = BOTPRelationGraphUtil.getBillRelations(entityNumber, rowData, parameter.isLoadOtherRelations());
        } else {
            String businessKey = parameter.getBusinessKey();
            if (!businessKey.matches("^\\d+$")) {
                log.info(String.format("%s is not a number.", businessKey));
                return null;
            }
            relations = BOTPRelationGraphUtil.getBillRelations(parameter);
        }
        return BizFlowGraphUtil.createBillRelationModel(relations, parameter);
    }

    @Deprecated
    public static BillRelationGraphData createBillBOTPRelationModel(String entityNumber, SelectedRowData rowData, String appId, boolean horizontal, boolean loadOtherRelations) {
        BillRelationParameter parameter = new BillRelationParameter(entityNumber, appId, horizontal, loadOtherRelations);
        parameter.setRowData(rowData);
        return BizFlowGraphUtil.createBillBOTPRelationModel(parameter);
    }

    public static boolean isServerRender() {
        Object value = WfConfigurationUtil.getConfigCenterVal("workflow.relationGraph.serverRender");
        return "true".equals(value);
    }

    public static String getUniqueKey(String entityNumber, String businessKey) {
        if (WfUtils.isEmpty(entityNumber)) {
            return businessKey != null ? businessKey : "";
        }
        return String.format("%s_%s", entityNumber, businessKey);
    }

    public static BpmnModel createBpmnModel(String procType, String procNumber) {
        BpmnModel bpmnModel = new BpmnModel();
        Process process = new Process();
        process.setProcessType(procType);
        process.setId(procNumber);
        process.setNumber(procNumber);
        process.setResourceId("node_1");
        bpmnModel.addProcess(process);
        return bpmnModel;
    }

    public static String createElementId(String procNumber, String activityType, long index) {
        return String.format("%s_%s_%s", procNumber, activityType, index);
    }

    public static FlowElement createFlowElement(BpmnModel bpmnModel, String stencilType, String nodeId) {
        String modelType = GraphCodecUtils.getModelTypeByProcessType(bpmnModel.getMainProcess().getProcessType());
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        FlowElement element = (FlowElement)GraphCodecUtils.getDefaultElement(modelType, "BillTask", bpmnModel, config);
        element.setId(nodeId);
        element.setName("");
        String style = element.getStyle().replaceFirst("shape=.+?;", String.format("shape=%s;", stencilType));
        element.setStyle(style);
        element.setType(stencilType);
        return element;
    }

    public static SequenceFlow createSequenceFlow(BpmnModel bpmnModel, FlowElement source, FlowElement target) {
        String prefix = "bill_circulaterelation_";
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("is_dynamic_node", Boolean.TRUE);
        config.put("itemId", String.format("%s_%s", source.getId().replace(prefix, ""), target.getId().replace(prefix, "")));
        SequenceFlow sequenceFlow = (SequenceFlow)GraphCodecUtils.getDefaultElement(SequenceFlow.class, bpmnModel, config);
        sequenceFlow.setSourceRef(source.getId());
        sequenceFlow.setTargetRef(target.getId());
        return sequenceFlow;
    }

    public static List<BillRelation> getNodeTargetsWithoutShadow(BillRelation node) {
        List<BillRelation> targets = node.getTargets();
        if (targets.isEmpty()) {
            return targets;
        }
        ArrayList<BillRelation> ret = new ArrayList<BillRelation>(targets.size());
        for (BillRelation target : targets) {
            if (target.isShadow()) continue;
            ret.add(target);
        }
        return ret;
    }

    @Deprecated
    public static Map<String, CardBillInfo> getBillCardData(Map<String, List<BillRelation>> billCardMap, Map<String, List<BillRelation>> stackedCardMap, Map<String, BillCardPlugin> pluginMap, String appId) {
        return BizFlowGraphUtil.getBillCardData(billCardMap, pluginMap, appId, "all");
    }

    public static Map<String, CardBillInfo> getBillCardData(Map<String, List<BillRelation>> billCardMap, Map<String, BillCardPlugin> pluginMap, String appId, String permStrategy) {
        boolean verifyPerm = !"none".equals(permStrategy);
        String idField = "id";
        int size = billCardMap.size();
        HashSet<String> entityNumbers = new HashSet<String>(size);
        entityNumbers.addAll(billCardMap.keySet());
        Map<String, BillCardTpl> billCardTplMap = BizFlowGraphUtil.getBillCardDataFields(entityNumbers);
        BillCardTpl billCardTpl = billCardTplMap.get("bpm_billrelation_cardtpl");
        HashMap<String, Set<String>> queryFieldsMap = new HashMap<String, Set<String>>(billCardMap.size());
        HashMap<String, List<Object>> billIdMap = new HashMap<String, List<Object>>(billCardMap.size());
        BizFlowGraphUtil.initBillRelationCardData(billCardMap, billCardTpl, queryFieldsMap, billIdMap);
        BizFlowGraphUtil.addRelatedQueryField(queryFieldsMap);
        long userId = RequestContext.get().getCurrUserId();
        HashMap<String, CardBillInfo> billMap = new HashMap<String, CardBillInfo>(16);
        boolean isFromMsgCenter = "wftask".equals(appId);
        Map<String, String> entityAppIdMap = BizFlowGraphUtil.getSpecEntityAppIdMapping();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        for (Map.Entry entry : billIdMap.entrySet()) {
            String entityNumber = (String)entry.getKey();
            List ids = (List)entry.getValue();
            Map permMap = null;
            if (isFromMsgCenter) {
                appId = entityAppIdMap.get(entityNumber);
            }
            boolean hasPermPlugin = false;
            CheckPermissionParam permissionParam = new CheckPermissionParam(userId, appId, entityNumber, ids);
            BillCardPlugin cardPlugin = pluginMap.get(entityNumber);
            if (cardPlugin != null && ExternalInterfaceUtil.isValidValue(cardPlugin.getPermissionsPlugin())) {
                try {
                    permMap = (Map)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.GETPERMISSIONS, cardPlugin.getPermissionsPlugin(), userId, entityNumber, ids);
                    hasPermPlugin = true;
                }
                catch (Exception e) {
                    permMap = new HashMap<Object, Boolean>(ids.size());
                    for (Object id : ids) {
                        permMap.put(id, true);
                    }
                    log.error(String.format("invoke permission plugin error: %s", WfUtils.getExceptionStacktrace(e)));
                }
            } else if (verifyPerm) {
                try {
                    permMap = BizFlowGraphUtil.checkPermission(permissionService, permissionParam);
                }
                catch (Exception e) {
                    log.error(String.format("relationGraph checkPermission error! %s", WfUtils.getExceptionStacktrace(e)));
                }
            }
            if (permMap == null) {
                permMap = new HashMap<Object, Boolean>();
            }
            log.info(String.format("user: %s, appId: %s, entityNumber: %s, permStrategy: %s, permissionMap: %s", userId, appId, entityNumber, permStrategy, permMap));
            ArrayList billIds = new ArrayList(ids.size());
            for (Object id : ids) {
                boolean hasPermission = Boolean.TRUE.equals(permMap.get(id));
                if (!hasPermPlugin && !verifyPerm) {
                    hasPermission = true;
                }
                billMap.put(BizFlowGraphUtil.getUniqueKey(entityNumber, String.valueOf(id)), new CardBillInfo(hasPermission));
                if (!hasPermission) continue;
                billIds.add(id);
            }
            if (billIds.isEmpty()) {
                log.debug(String.format("billIds is empty. %s has no permission. %s", userId, ids));
                continue;
            }
            permissionParam.setUseFullName(true);
            Map<Object, Set<String>> canNotReadFields = BizFlowGraphUtil.getCanNotReadFields(permissionService, permissionParam);
            String selectFields = BizFlowGraphUtil.getQueryFields((Set)queryFieldsMap.get(entityNumber));
            if (selectFields == null) {
                selectFields = idField;
                log.debug(String.format("Could not get the field of %s", entityNumber));
            }
            try {
                DynamicObject[] bills;
                CardBillInfo info = null;
                for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(idField, "in", billIds)})) {
                    info = (CardBillInfo)billMap.get(BizFlowGraphUtil.getUniqueKey(entityNumber, String.valueOf(bill.getPkValue())));
                    info.setBill(bill);
                    info.setCanNotReadFields(canNotReadFields.get(bill.getPkValue()));
                }
            }
            catch (Exception e) {
                log.error(String.format("load %s %s fields failed: %s", entityNumber, selectFields, WfUtils.getExceptionStacktrace(e)));
            }
        }
        return billMap;
    }

    public static Map<Object, Set<String>> getCanNotReadFields(PermissionService permissionService, long userId, String appId, String entityNumber, List<Object> ids, boolean isGetFullName) {
        CheckPermissionParam permissionParam = new CheckPermissionParam(userId, appId, entityNumber, ids);
        permissionParam.setUseFullName(isGetFullName);
        return BizFlowGraphUtil.getCanNotReadFields(permissionService, permissionParam);
    }

    private static Map<Object, Set<String>> getCanNotReadFields(PermissionService permissionService, CheckPermissionParam permissionParam) {
        List<Object> ids = permissionParam.getIds();
        Long userId = permissionParam.getUserId();
        String appId = permissionParam.getAppId();
        String entityNumber = permissionParam.getEntityNumber();
        boolean isGetFullName = permissionParam.isUseFullName();
        HashMap<Object, Set<String>> result = new HashMap<Object, Set<String>>(ids.size());
        String originalAppId = BizAppServiceHelp.getAppIdByFormNum((String)entityNumber);
        if (originalAppId != null) {
            appId = originalAppId;
        }
        List<String> canNotReadPropertys = BizFlowGraphUtil.getCompletedPropertyNamesByEntityNumber(entityNumber);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (BizFlowGraphUtil.needDimControl(entityType)) {
            List<CheckDimObjParam> dimParams = permissionParam.getDimParams();
            if (dimParams == null) {
                dimParams = BizFlowGraphUtil.getCheckDimObjParams(entityNumber, ids, entityType);
                permissionParam.setDimParams(dimParams);
            }
            HashMap<Object, Long> billDimensionOrgMap = new HashMap<Object, Long>(dimParams.size());
            HashMap orgFiledMap = new HashMap(dimParams.size());
            for (CheckDimObjParam checkDimObjParam : dimParams) {
                billDimensionOrgMap.put(checkDimObjParam.getId(), checkDimObjParam.getDimensionOrg());
                orgFiledMap.put(checkDimObjParam.getDimensionOrg(), null);
            }
            for (Map.Entry entry : orgFiledMap.entrySet()) {
                log.debug(String.format("\u8c03\u7528\u5916\u90e8\u63a5\u53e3permissionService.getFieldControlRule()\uff0c\u53c2\u6570\uff1a[userId:%s-entry.getKey():%s-appId:%s-entityNumber:%s]", userId, entry.getKey(), appId, entityNumber));
                FieldControlRule fieldRule = permissionService.getFieldControlRule(userId.longValue(), ((Long)entry.getKey()).longValue(), appId, entityNumber);
                if (fieldRule == null) continue;
                Set fieldSet = fieldRule.getCanNotReadFields();
                if (isGetFullName) {
                    entry.setValue(BizFlowGraphUtil.checkAndGetCanNotReadProperty(canNotReadPropertys, fieldSet));
                    continue;
                }
                entry.setValue(fieldSet);
            }
            for (CheckDimObjParam checkDimObjParam : dimParams) {
                result.put(checkDimObjParam.getId(), (Set<String>)orgFiledMap.get(checkDimObjParam.getDimensionOrg()));
            }
        } else {
            log.debug(String.format("\u8c03\u7528\u5916\u90e8\u63a5\u53e3permissionService.getFieldRulesSum()\uff0c\u53c2\u6570\uff1a[userId:%s-appId:%s-entityNumber:%s]", userId, appId, entityNumber));
            FieldControlRule fieldRule = permissionService.getFieldRulesSum(userId.longValue(), appId, entityNumber);
            if (fieldRule == null) {
                return result;
            }
            Set<String> fieldSet = fieldRule.getCanNotReadFields();
            if (isGetFullName) {
                fieldSet = BizFlowGraphUtil.checkAndGetCanNotReadProperty(canNotReadPropertys, fieldRule.getCanNotReadFields());
            }
            for (Object id : ids) {
                result.put(id, fieldSet);
            }
        }
        return result;
    }

    private static void addRelatedQueryField(Map<String, Set<String>> queryFieldsMap) {
        String entityNumber = null;
        Set<String> fields = null;
        MainEntityType entityType = null;
        for (Map.Entry<String, Set<String>> entry : queryFieldsMap.entrySet()) {
            entityNumber = entry.getKey();
            fields = entry.getValue();
            if (fields == null || fields.isEmpty()) continue;
            entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            HashSet<String> relatedProps = new HashSet<String>(16);
            for (String field : fields) {
                AmountProp amountProp;
                String propName;
                DynamicProperty property = entityType.getProperty(field);
                if (!(property instanceof AmountProp) || !WfUtils.isNotEmpty(propName = (amountProp = (AmountProp)property).getControlPropName())) continue;
                relatedProps.add(propName);
            }
            fields.addAll(relatedProps);
        }
    }

    private static void initBillRelationCardData(Map<String, List<BillRelation>> billCardMap, BillCardTpl billCardTpl, Map<String, Set<String>> queryFieldsMap, Map<String, List<Object>> billIdMap) {
        Class<?> pkType = null;
        for (Map.Entry<String, List<BillRelation>> entry : billCardMap.entrySet()) {
            String entityNumber = entry.getKey();
            List<Object> ids = billIdMap.get(entityNumber);
            List<BillRelation> relations = entry.getValue();
            if (ids == null) {
                ids = new ArrayList<Object>(relations.size());
                billIdMap.put(entityNumber, ids);
            }
            String nameField = null;
            String departmentField = null;
            String statusField = null;
            List<String> fields = null;
            if (billCardTpl != null && (fields = billCardTpl.getShowContents(entityNumber)) != null && !fields.isEmpty()) {
                nameField = fields.get(0);
                int size = fields.size();
                if (size > 1) {
                    departmentField = fields.get(1);
                }
                if (size > 2) {
                    statusField = fields.get(2);
                }
                queryFieldsMap.put(entityNumber, BizFlowGraphUtil.getCardDataFields(fields));
            }
            pkType = BizFlowGraphUtil.getEntityPKType(entityNumber);
            for (BillRelation relation : relations) {
                if (WfUtils.isEmpty(relation.getBusinessKey())) continue;
                BillCardData cardData = relation.getCardData();
                cardData.setNameField(nameField);
                cardData.setDepartmentField(departmentField);
                cardData.setStatusField(statusField);
                if (BizFlowGraphUtil.isLongType(pkType)) {
                    ids.add(Long.valueOf(relation.getBusinessKey()));
                    continue;
                }
                ids.add(relation.getBusinessKey());
            }
        }
    }

    public static boolean isLongType(Class<?> pkType) {
        return pkType != null && (Long.TYPE.isAssignableFrom(pkType) || Long.class.isAssignableFrom(pkType));
    }

    public static Class<?> getEntityPKType(String entityNumber) {
        Class pkType = pkTypeMap.get(entityNumber);
        if (pkType != null) {
            return pkType;
        }
        MainEntityType entityType = null;
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            pkType = entityType.getPrimaryKey().getPropertyType();
            pkTypeMap.put(entityNumber, pkType);
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
        return pkType;
    }

    private static String getQueryFields(Set<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int size = fields.size();
        for (String field : fields) {
            sb.append(field);
            if (index < size - 1) {
                sb.append(',');
            }
            ++index;
        }
        return sb.toString();
    }

    private static Set<String> getCardDataFields(List<String> contents) {
        int size = Math.min(contents.size(), 3);
        HashSet<String> fields = new HashSet<String>(16);
        Pattern normalPattern = Pattern.compile("\\{\\s*(model\\.)?([\\w\\.]+?)\\s*\\}");
        Pattern functionPattern = Pattern.compile("\\{\\s*\\w+\\((model\\.)?([\\w\\.]+?)\\)\\s*\\}");
        for (int i = 0; i < size; ++i) {
            fields.addAll(BizFlowGraphUtil.getEntityField(contents.get(i), normalPattern, functionPattern));
        }
        return fields;
    }

    private static List<String> getEntityField(String expression, Pattern normalPattern, Pattern functionPattern) {
        ArrayList<String> fields = new ArrayList<String>();
        Matcher matcher = normalPattern.matcher(expression);
        while (matcher.find()) {
            fields.add(matcher.group(2));
        }
        matcher = functionPattern.matcher(expression);
        while (matcher.find()) {
            fields.add(matcher.group(2));
        }
        return fields;
    }

    public static Map<String, BillCardTpl> getBillCardDataFields(Set<String> entityNumbers) {
        HashMap<String, BillCardTpl> billCardTplMap = new HashMap<String, BillCardTpl>();
        HashSet<String> distinctSet = new HashSet<String>(16);
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        HashMap<Long, String> typeMap = new HashMap<Long, String>(16);
        String inCondition = BizFlowGraphUtil.getInCondition(entityNumbers);
        String algoKey = "wf.engine.findBillRelationCardConfig";
        String sql = "SELECT FID, FBILLTYPE, FSUMMARYTPL FROM T_WF_MBILLSUMMARYCFG WHERE FSUMMARYTPL in ('bpm_billrelation_cardtpl', 'bpm_billrelation_stkcard') AND FENABLE = ? AND FBILLTYPE IN %s ORDER BY FMODIFYTIME DESC";
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)String.format(sql, inCondition), (Object[])new Object[]{true});){
            for (Row row : ds) {
                String billType = row.getString("FBILLTYPE");
                String summaryTpl = row.getString("FSUMMARYTPL");
                String key = String.format("%s-%s", billType, summaryTpl);
                if (!distinctSet.add(key)) continue;
                Long id = row.getLong("FID");
                map.put(id, billType);
                typeMap.put(id, summaryTpl);
            }
        }
        if (map.isEmpty()) {
            return billCardTplMap;
        }
        algoKey = "wf.engine.findBillRelationCardConfigFields";
        int size = map.size();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add("?");
        }
        String join = Joiner.on((String)",").join(list);
        sql = "select  cfg.fid,  cfg.fentryid,  cfg.fseq,  case   when lang.fshowcontentmul is null then cfg.fshowcontentmul   when lang.fshowcontentmul = ' ' then cfg.fshowcontentmul   else lang .fshowcontentmul  end fshowcontentmul,  cfg.fshowcontent , lang.flocaleid,  cfg.ffieldkey ,  cfg.faggregatefunction from  t_wf_mbillsumarycfgentry as cfg left join t_wf_mbillsumarycfgentry_l as lang on  cfg.fentryid = lang.fentryid  and (lang.flocaleid = ?  or lang.flocaleid is null) where   fid in (" + join + ") order by  fid,  fseq";
        ArrayList params = new ArrayList(map.keySet());
        params.add(0, RequestContext.get().getLang().name());
        Object[] objects = params.toArray(new Object[0]);
        String format = String.format(sql, BizFlowGraphUtil.getInCondition(map.keySet()));
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)format, (Object[])objects);){
            for (Row row : ds) {
                Long id = row.getLong("FID");
                String entityNumber = (String)map.get(id);
                String type = (String)typeMap.get(id);
                BillCardTpl billCardTpl = (BillCardTpl)billCardTplMap.get(type);
                if (billCardTpl == null) {
                    billCardTpl = new BillCardTpl(type);
                    billCardTplMap.put(type, billCardTpl);
                }
                String field = row.getString("FFIELDKEY");
                String showContent = row.getString("fshowcontentmul");
                if (StringUtils.isEmpty((String)showContent)) {
                    showContent = row.getString("fshowcontent");
                }
                String aggregateFunction = row.getString("FAGGREGATEFUNCTION");
                billCardTpl.addBillCardTplConfig(entityNumber, field, aggregateFunction, showContent);
            }
        }
        return billCardTplMap;
    }

    public static Map<Long, List<String>> groupBillsByBillType(String entityNumber, List<String> businessKeys) {
        String billTypeField = null;
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (entityType instanceof BillEntityType) {
                billTypeField = ((BillEntityType)entityType).getBillType();
            }
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
        if (WfUtils.isEmpty(billTypeField)) {
            log.debug(String.format("%s no billtype.", entityNumber));
            return null;
        }
        ArrayList<String> ids = null;
        String fields = String.format("id,%s", billTypeField);
        LinkedHashMap<Long, List<String>> ret = new LinkedHashMap<Long, List<String>>(16);
        QFilter[] filters = null;
        filters = BizFlowGraphUtil.isLongType(BizFlowGraphUtil.getEntityPKType(entityNumber)) ? new QFilter[]{new QFilter("id", "in", BizFlowUtil.getLongBusinessKeys(businessKeys))} : new QFilter[]{new QFilter("id", "in", businessKeys)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityNumber, (String)fields, (QFilter[])filters);
        if (bills == null || bills.isEmpty()) {
            log.debug("bill not exists.");
            return null;
        }
        HashMap<String, DynamicObject> billMap = new HashMap<String, DynamicObject>(bills.size());
        for (DynamicObject bill : bills) {
            billMap.put(bill.getString("id"), bill);
        }
        DynamicObject bill = null;
        for (String businessKey : businessKeys) {
            bill = (DynamicObject)billMap.get(businessKey);
            Long billType = bill.getLong(billTypeField);
            if (WfUtils.isEmpty(billType)) continue;
            ids = (ArrayList<String>)ret.get(billType);
            if (ids == null) {
                ids = new ArrayList<String>();
                ret.put(billType, ids);
            }
            ids.add(String.valueOf(bill.get("id")));
        }
        return ret;
    }

    public static Map<Long, BillTypeInfo> getBillTypeInfos(Set<Long> billTypeIds) {
        int size = billTypeIds.size();
        HashMap<Long, BillTypeInfo> billTypeMap = new HashMap<Long, BillTypeInfo>(size);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", billTypeIds)};
        DynamicObjectCollection billTypes = QueryServiceHelper.query((String)"bos_billtype", (String)"id,name,layoutsolution", (QFilter[])filters);
        BillTypeInfo billTypeInfo = null;
        HashMap<String, BillTypeInfo> formBillTypeMap = new HashMap<String, BillTypeInfo>(size);
        for (DynamicObject billType : billTypes) {
            long id = billType.getLong("id");
            String formMetaId = billType.getString("layoutsolution");
            billTypeInfo = new BillTypeInfo(id, billType.getString("name"), formMetaId);
            formBillTypeMap.put(formMetaId, billTypeInfo);
            billTypeMap.put(id, billTypeInfo);
        }
        filters = new QFilter[]{new QFilter("id", "in", formBillTypeMap.keySet())};
        DynamicObjectCollection formMetas = QueryServiceHelper.query((String)"bos_formmeta", (String)"id,number", (QFilter[])filters);
        for (DynamicObject formMeta : formMetas) {
            billTypeInfo = (BillTypeInfo)formBillTypeMap.get(formMeta.getString("id"));
            billTypeInfo.setLayout(formMeta.getString("number"));
        }
        return billTypeMap;
    }

    @Deprecated
    public static void addFlowInProcessAndConnect(Process process, BillRelation source, SequenceFlow flow, BillRelation target) {
        BizFlowGraphUtil.addFlowInProcessAndConnect(new HashMap<String, BillRelation>(), process, source, flow, target);
    }

    public static void addFlowInProcessAndConnect(Map<String, BillRelation> relMap, Process process, BillRelation source, SequenceFlow flow, BillRelation target) {
        process.addFlowElement(flow);
        target.getSrcFlows().add(flow);
        source.getTgtFlows().add(flow);
        flow.setTargetRef(target.getResourceId(relMap));
        flow.setSourceRef(source.getResourceId(relMap));
        BizFlowGraphUtil.addOutgoingFlows(source.getSelf(relMap), flow);
    }

    private static void addOutgoingFlows(FlowElement parent, SequenceFlow flow) {
        if (parent instanceof FlowNode) {
            ((FlowNode)parent).getOutgoingFlows().add(flow);
        }
    }

    public static void removeElementFromProcss(Process process, FlowElement element) {
        process.removeFlowElement(element.getId());
        if (element instanceof FlowNode) {
            FlowNode node = (FlowNode)element;
            List<SequenceFlow> flows = node.getIncomingFlows();
            for (SequenceFlow flow : flows) {
                process.removeFlowElement(flow.getId());
            }
            flows = node.getOutgoingFlows();
            for (SequenceFlow flow : flows) {
                process.removeFlowElement(flow.getId());
            }
        }
    }

    @Deprecated
    public static void connectRelation(Process process, SequenceFlow flow, BillRelation relation, BillRelation terminal, boolean source) {
        BizFlowGraphUtil.connectRelation(new HashMap<String, BillRelation>(), process, flow, relation, terminal, source);
    }

    public static void connectRelation(Map<String, BillRelation> relMap, Process process, SequenceFlow flow, BillRelation relation, BillRelation terminal, boolean source) {
        BizFlowGraphUtil.connectRelation(relMap, process, flow, relation, terminal, -1, source);
    }

    @Deprecated
    public static void connectRelation(Process process, SequenceFlow flow, BillRelation relation, BillRelation terminal, int index, boolean source) {
        BizFlowGraphUtil.connectRelation(new HashMap<String, BillRelation>(), process, flow, relation, terminal, index, source);
    }

    public static void connectRelation(Map<String, BillRelation> relMap, Process process, SequenceFlow flow, BillRelation relation, BillRelation terminal, int index, boolean source) {
        if (source) {
            List<BillRelation> targets = terminal.getTargets();
            if (index > -1 && index <= targets.size()) {
                targets.add(index, relation);
            } else {
                targets.add(relation);
            }
            relation.getSources().add(terminal);
            if (process != null && flow != null) {
                BizFlowGraphUtil.addFlowInProcessAndConnect(relMap, process, terminal, flow, relation);
            }
        } else {
            List<BillRelation> sources = terminal.getSources();
            if (index > -1 && index <= sources.size()) {
                sources.add(index, relation);
            } else {
                sources.add(relation);
            }
            relation.getTargets().add(terminal);
            if (process != null && flow != null) {
                BizFlowGraphUtil.addFlowInProcessAndConnect(relMap, process, relation, flow, terminal);
            }
        }
    }

    @Deprecated
    public static int disconnectRelation(BillRelation relation, BillRelation terminal, boolean source) {
        return BizFlowGraphUtil.disconnectRelation(new Process(), relation, terminal, source);
    }

    @Deprecated
    public static int disconnectRelation(Process process, BillRelation relation, BillRelation terminal, boolean source) {
        return BizFlowGraphUtil.disconnectRelation(new HashMap<String, BillRelation>(), process, relation, terminal, source);
    }

    public static int disconnectRelation(Map<String, BillRelation> relMap, Process process, BillRelation relation, BillRelation terminal, boolean source) {
        int index = -1;
        if (source) {
            index = terminal.getTargets().indexOf(relation);
            if (index > -1) {
                terminal.getTargets().remove(index);
                relation.getSources().remove(terminal);
                if (process != null) {
                    BizFlowGraphUtil.disconnectSequenceFlow(relMap, process, terminal, relation);
                }
            } else {
                log.debug(String.format("No relation in targets, disconnect failed. relation: %s, terminal: %s, source: %s", relation, terminal, source));
            }
        } else {
            index = terminal.getSources().indexOf(relation);
            if (index > -1) {
                terminal.getSources().remove(index);
                relation.getTargets().remove(terminal);
                if (process != null) {
                    BizFlowGraphUtil.disconnectSequenceFlow(relMap, process, relation, terminal);
                }
            } else {
                log.debug(String.format("No relation in sources, disconnect failed. relation: %s, terminal: %s, source: %s", relation, terminal, source));
            }
        }
        return index;
    }

    private static void disconnectSequenceFlow(Map<String, BillRelation> relMap, Process process, BillRelation source, BillRelation target) {
        SequenceFlow flow;
        String src = source.getResourceId(relMap);
        String tgt = target.getResourceId(relMap);
        Iterator<SequenceFlow> iterator = source.getTgtFlows().iterator();
        while (iterator.hasNext()) {
            flow = iterator.next();
            if (!flow.getSourceRef().equals(src) || !flow.getTargetRef().equals(tgt)) continue;
            iterator.remove();
            process.removeFlowElement(flow.getId());
            break;
        }
        iterator = target.getSrcFlows().iterator();
        while (iterator.hasNext()) {
            flow = iterator.next();
            if (!flow.getSourceRef().equals(src) || !flow.getTargetRef().equals(tgt)) continue;
            iterator.remove();
            process.removeFlowElement(flow.getId());
            break;
        }
    }

    public static FlowNode createStackedTask(BpmnModel bpmnModel, String stackedNodeId) {
        String stencilType = "stackedCard";
        return (FlowNode)BizFlowGraphUtil.createFlowElement(bpmnModel, stencilType, stackedNodeId);
    }

    public static StackedBillRelation createStackedBillRelation(List<BillRelation> relations) {
        return BizFlowGraphUtil.createStackedBillRelation(null, relations);
    }

    public static StackedBillRelation createStackedBillRelation(FlowNode stackedTask, List<BillRelation> relations) {
        BillRelation template = relations.get(0);
        StackedBillRelation stacked = new StackedBillRelation();
        stacked.setEntityName(template.getEntityName());
        stacked.setEntityNumber(template.getEntityNumber());
        stacked.setBusinessKey(template.getBusinessKey());
        stacked.setUniqueKey(template.getUniqueKey());
        stacked.setSelf(stackedTask);
        stacked.setStatus(template.getStatus());
        stacked.setAccountId(template.getAccountId());
        stacked.setTenantId(template.getTenantId());
        for (BillRelation relation : relations) {
            if (relation instanceof StackedBillRelation) {
                stacked.addStackedBusKeys(((StackedBillRelation)relation).getStackedBusKeys());
                continue;
            }
            stacked.addStackedBusKey(relation.getBusinessKey());
        }
        return stacked;
    }

    public static Map<String, BillCardPlugin> getBillRelationCardPlugin(Set<String> entityNumbers) {
        HashMap<String, BillCardPlugin> pluginMap = new HashMap<String, BillCardPlugin>(entityNumbers.size());
        WorkflowService service = (WorkflowService)kd.bos.workflow.service.impl.ServiceFactory.getService(WorkflowService.class);
        QFilter[] filters = new QFilter[]{new QFilter("entitynumber", "in", entityNumbers)};
        String fields = String.format("%s,%s,%s", "entitynumber", "pushstatusplugin", "permissionsplugin");
        List entities = service.getRepositoryService().findEntitiesByFilters("wf_billsubjectmodel", filters, fields, null);
        if (entities.isEmpty()) {
            return pluginMap;
        }
        BillCardPlugin plugin = null;
        for (BillSubjectModelEntity entity : entities) {
            plugin = new BillCardPlugin();
            plugin.setPushStatusPlugin(entity.getPushStatusPlugin());
            plugin.setPermissionsPlugin(entity.getPermissionsPlugin());
            pluginMap.put(entity.getEntityNumber(), plugin);
        }
        return pluginMap;
    }

    public static void initEntityBillNoField(Map<String, String> fieldMap, Set<String> entityNumbers) {
        for (String entityNumber : entityNumbers) {
            if (WfUtils.isEmpty(entityNumber)) continue;
            try {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (!(entityType instanceof BillEntityType)) continue;
                fieldMap.put(entityNumber, ((BillEntityType)entityType).getBillNo());
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
    }

    public static void initEntityBillNoMap(String entityNumber, Set<String> billIds, String billNoField, Map<String, String> billNoMap) {
        if (WfUtils.isEmpty(billNoField)) {
            log.debug(String.format("%s has no billNo field.", entityNumber));
            return;
        }
        Class<?> pkType = BizFlowGraphUtil.getEntityPKType(entityNumber);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", BizFlowGraphUtil.isLongType(pkType) ? BizFlowUtil.getLongBusinessKeys(billIds) : billIds)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityNumber, (String)String.format("id,%s", billNoField), (QFilter[])filters);
        for (DynamicObject bill : bills) {
            String businessKey = bill.getString("id");
            billNoMap.put(BizFlowGraphUtil.getUniqueKey(entityNumber, businessKey), bill.getString(billNoField));
        }
    }

    private static String getInCondition(Collection values) {
        int index = 0;
        int size = values.size();
        StringBuilder sb = new StringBuilder("(");
        for (Object value : values) {
            if (value instanceof Number) {
                sb.append(value);
            } else {
                sb.append('\'').append(value).append('\'');
            }
            if (index < size - 1) {
                sb.append(',');
            }
            ++index;
        }
        sb.append(')');
        return sb.toString();
    }

    public static Map<Object, Boolean> checkPermission(PermissionService permissionService, Long userId, String appId, String entityNumber, List<Object> ids) {
        CheckPermissionParam permissionParam = new CheckPermissionParam(userId, appId, entityNumber, ids);
        return BizFlowGraphUtil.checkPermission(permissionService, permissionParam);
    }

    private static Map<Object, Boolean> checkPermission(PermissionService permissionService, CheckPermissionParam permissionParam) {
        List<Object> ids = permissionParam.getIds();
        Long userId = permissionParam.getUserId();
        String appId = permissionParam.getAppId();
        String entityNumber = permissionParam.getEntityNumber();
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>(ids.size());
        ArrayList<Object> billIds = new ArrayList<Object>(ids);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        boolean hasPermission = false;
        if (BizFlowGraphUtil.needDimControl(entityType)) {
            List list;
            List<CheckDimObjParam> dimParams = permissionParam.getDimParams();
            if (dimParams == null) {
                dimParams = BizFlowGraphUtil.getCheckDimObjParams(entityNumber, ids, entityType);
                permissionParam.setDimParams(dimParams);
            }
            if ((list = permissionService.checkPermissionBatch(userId, "", entityNumber, "47150e89000000ac", dimParams, true)) == null) {
                for (Object object : ids) {
                    result.put(object, false);
                }
                log.info(String.format("user: %s, appId: %s, entityNumber: %s, checkResult: null", userId, appId, entityNumber));
                return result;
            }
            for (Object object : ids) {
                result.put(object, true);
            }
            if (!list.isEmpty()) {
                ArrayList<Object> pks = new ArrayList<Object>(list.size());
                for (CheckDimObjParam param : list) {
                    pks.add(param.getId());
                    billIds.remove(param.getId());
                    result.put(param.getId(), false);
                }
                log.info(String.format("user: %s, appId: %s, entityNumber: %s, checkResult: true, no permission bills: %s", userId, appId, entityNumber, pks));
            }
        } else {
            hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)"", (String)entityNumber, (String)"47150e89000000ac");
            log.info(String.format("user: %s, appId: %s, entityNumber: %s, has view permission: %s", userId, appId, entityNumber, result));
            for (Object e : ids) {
                result.put(e, hasPermission);
            }
            if (!hasPermission) {
                return result;
            }
        }
        QFilter idFilter = new QFilter("id", "in", billIds);
        Map map = permissionService.matchDataRule(userId.longValue(), appId, entityNumber, "47150e89000000ac", new QFilter[]{idFilter}, null);
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey(), (Boolean)entry.getValue());
        }
        return result;
    }

    private static List<CheckDimObjParam> getCheckDimObjParams(String entityNumber, List<Object> ids, MainEntityType entityType) {
        String[] fields = BizFlowGraphUtil.getPermOrgField(entityType);
        String orgFieldKey = fields[0];
        String assistOrgFieldKey = fields[1];
        boolean hasOrgFieldKey = orgFieldKey != null;
        boolean hasAssistOrgFieldKey = assistOrgFieldKey != null;
        StringBuilder queryFields = new StringBuilder();
        if (hasOrgFieldKey) {
            queryFields.append(orgFieldKey);
        }
        if (hasAssistOrgFieldKey && !assistOrgFieldKey.equals(orgFieldKey)) {
            if (queryFields.length() > 0) {
                queryFields.append(",").append(assistOrgFieldKey);
            } else {
                queryFields.append(assistOrgFieldKey);
            }
        }
        if (queryFields.length() > 0) {
            queryFields.append(",");
        }
        queryFields.append("id");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityNumber, (String)queryFields.toString(), (QFilter[])filters);
        HashMap<Object, DynamicObject> billMap = new HashMap<Object, DynamicObject>(bills.size());
        for (DynamicObject bill : bills) {
            billMap.put(bill.get("id"), bill);
        }
        ArrayList<CheckDimObjParam> dimParams = new ArrayList<CheckDimObjParam>(ids.size());
        for (Object id : ids) {
            CheckDimObjParam dimParam = new CheckDimObjParam();
            dimParam.setId(id);
            dimParam.setNumber(entityNumber);
            DynamicObject bill = (DynamicObject)billMap.get(id);
            if (bill == null) {
                log.debug(String.format("entityNumber: %s, businessKey: %s not found.", entityNumber, id));
                continue;
            }
            if (hasOrgFieldKey) {
                dimParam.setDimensionOrg(bill.getLong(orgFieldKey));
            }
            if (hasAssistOrgFieldKey) {
                dimParam.setAssistDimensionOrg(bill.getLong(assistOrgFieldKey));
            }
            dimParams.add(dimParam);
        }
        return dimParams;
    }

    private static boolean needDimControl(MainEntityType entityType) {
        PermissionControlType permissionControlType = entityType.getPermissionControlType();
        boolean controlFunction = permissionControlType.isControlFunction();
        if (!controlFunction) {
            return false;
        }
        String dimension = permissionControlType.getDimension();
        if ("DIM_NULL".equals(dimension)) {
            return false;
        }
        if ("DIM_ORG".equals(dimension)) {
            String dataDimensionField = permissionControlType.getDataDimensionField();
            String mainOrg = entityType.getMainOrg();
            if (WfUtils.isEmpty(dataDimensionField) && WfUtils.isEmpty(mainOrg)) {
                return false;
            }
        } else {
            String dataDimensionField = permissionControlType.getDataDimensionField();
            if (WfUtils.isEmpty(dataDimensionField)) {
                return false;
            }
        }
        return true;
    }

    private static String[] getPermOrgField(MainEntityType entityType) {
        String mainDimField;
        String orgFieldKey = null;
        String assistOrgFieldKey = null;
        PermissionControlType permCtrlType = entityType.getPermissionControlType();
        if (!"DIM_ORG".equals(permCtrlType.getDimension())) {
            return new String[]{orgFieldKey, assistOrgFieldKey};
        }
        String assistDimField = permCtrlType.getDataAssistDimensionField();
        if (WfUtils.isNotEmpty(assistDimField)) {
            assistOrgFieldKey = assistDimField;
        }
        if (WfUtils.isEmpty(mainDimField = permCtrlType.getDataDimensionField())) {
            String mainOrg = entityType.getMainOrg();
            if (WfUtils.isNotEmpty(mainOrg)) {
                orgFieldKey = mainOrg;
            }
        } else {
            orgFieldKey = mainDimField;
        }
        return new String[]{orgFieldKey, assistOrgFieldKey};
    }

    public static Map<String, String> getSpecEntityAppIdMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>(16);
        String config = (String)WfConfigurationUtil.getConfigCenterVal("workflow.config.entityApplicationMapping");
        if (WfUtils.isNotEmpty(config)) {
            try {
                JSONObject ret = JSON.parseObject((String)config);
                for (Map.Entry entry : ret.entrySet()) {
                    mapping.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            catch (Exception e) {
                log.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return mapping;
    }

    public static boolean isCrossTenant(String tenantId, String accountId) {
        if (tenantId == null && accountId == null) {
            return false;
        }
        RequestContext requestContext = RequestContext.get();
        if (requestContext == null) {
            return false;
        }
        String tpl = "%s.%s";
        String contextTenant = requestContext.getTenantId();
        String contextAccount = requestContext.getAccountId();
        return !String.format(tpl, tenantId, accountId).equals(String.format(tpl, contextTenant, contextAccount));
    }

    public static String getAppId(String entityNumber, String appId) {
        boolean isFromMsgCenter = "wftask".equals(appId);
        if (isFromMsgCenter) {
            Map<String, String> entityAppIdMap = BizFlowGraphUtil.getSpecEntityAppIdMapping();
            appId = entityAppIdMap.get(entityNumber);
        }
        return appId;
    }

    public static String getExpressionWithCanNotReadFields(String expression, Set<String> canNotReadFields) {
        if (WfUtils.isEmpty(expression) || WfUtils.isEmptyForCollection(canNotReadFields)) {
            return expression;
        }
        Map<String, Set<String>> expFiledMap = BizFlowGraphUtil.getAllExpressionField(expression);
        if (expFiledMap != null) {
            Set<String> filedSet = expFiledMap.get("filedSet");
            Set<String> expContextSet = expFiledMap.get("expContextSet");
            HashSet<String> canNotReadContexts = new HashSet<String>(16);
            for (String expFiled : filedSet) {
                if (BizFlowGraphUtil.isExpFiledCanRead(expFiled, canNotReadFields)) continue;
                for (String expContext : expContextSet) {
                    if (!expContext.contains(expFiled)) continue;
                    canNotReadContexts.add(expContext);
                }
            }
            for (String canNotReadContext : canNotReadContexts) {
                expression = expression.replaceAll(canNotReadContext, CANNOTREAD_VALUE);
            }
        }
        return expression;
    }

    private static boolean isExpFiledCanRead(String expFiled, Set<String> canNotReadFields) {
        for (String canNotReadField : canNotReadFields) {
            if (!expFiled.equals(canNotReadField) && !expFiled.equals(String.format("model.%s", canNotReadField)) && !expFiled.startsWith(String.format("%s.", canNotReadField)) && !expFiled.startsWith(String.format("model.%s.", canNotReadField))) continue;
            return false;
        }
        return true;
    }

    private static Set<String> checkAndGetCanNotReadProperty(List<String> canNotReadPropertys, Set<String> canNotReadFields) {
        HashSet<String> result = new HashSet<String>(16);
        if (WfUtils.isEmptyForCollection(canNotReadPropertys) || WfUtils.isEmptyForCollection(canNotReadFields)) {
            return result;
        }
        for (String field : canNotReadFields) {
            for (String completedPropertyName : canNotReadPropertys) {
                List<String> propertyNameList = Arrays.asList(completedPropertyName.split("\\."));
                if (!propertyNameList.contains(field)) continue;
                result.add(completedPropertyName);
            }
        }
        return result;
    }

    private static List<String> getCompletedPropertyNamesByEntityNumber(String entityNumber) {
        ArrayList<String> propertyNames = new ArrayList<String>(10);
        if (WfUtils.isEmpty(entityNumber)) {
            return propertyNames;
        }
        Map entityPropertys = EntityMetadataCache.getDataEntityType((String)entityNumber).getAllFields();
        if (WfUtils.isEmptyForMap(entityPropertys)) {
            return propertyNames;
        }
        for (IDataEntityProperty entityProperty : entityPropertys.values()) {
            if (entityProperty.getParent().getName().equals(entityNumber)) {
                propertyNames.add(entityProperty.getName());
                continue;
            }
            StringBuilder completedPropertyName = new StringBuilder(entityProperty.getName());
            IDataEntityType parentEntityType = entityProperty.getParent();
            while (!parentEntityType.getName().equals(entityNumber)) {
                completedPropertyName = completedPropertyName.insert(0, parentEntityType.getName() + ".");
                parentEntityType = parentEntityType.getParent();
            }
            propertyNames.add(completedPropertyName.toString());
        }
        return propertyNames;
    }

    private static Map<String, Set<String>> getAllExpressionField(String expression) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (WfUtils.isEmpty(expression)) {
            return result;
        }
        HashSet<String> filedSet = new HashSet<String>(16);
        HashSet<String> expContextSet = new HashSet<String>(16);
        int endIndex = expression.lastIndexOf(125);
        int startIndex = expression.indexOf(123);
        ArrayList<Integer> headIndexs = new ArrayList<Integer>(10);
        ArrayList<Integer> endIndexs = new ArrayList<Integer>(10);
        ArrayList<Integer> headContextIndexs = new ArrayList<Integer>(10);
        ArrayList<Integer> endContextIndexs = new ArrayList<Integer>(10);
        if (endIndex > 0 && startIndex >= 0 && startIndex < endIndex) {
            int i;
            char[] erpArr = expression.toCharArray();
            int beginFeildIndex = -1;
            int endFeildIndex = -1;
            int beginContextIndex = -1;
            int endContextIndex = -1;
            int countContextLeft = 0;
            int countContextRight = 0;
            for (i = 0; i < erpArr.length; ++i) {
                if (erpArr[i] == '{' || erpArr[i] == '(') {
                    beginFeildIndex = i;
                    if (erpArr[i] != '{') continue;
                    ++countContextLeft;
                    if (beginContextIndex != -1) continue;
                    beginContextIndex = i;
                    continue;
                }
                if (erpArr[i] != '}' && erpArr[i] != ')') continue;
                endFeildIndex = i;
                if (beginFeildIndex != -1) {
                    headIndexs.add(beginFeildIndex);
                    endIndexs.add(endFeildIndex);
                    beginFeildIndex = -1;
                }
                if (erpArr[i] != '}') continue;
                endContextIndex = i;
                if (countContextLeft != ++countContextRight || countContextLeft <= 0) continue;
                headContextIndexs.add(beginContextIndex);
                endContextIndexs.add(endContextIndex);
                beginContextIndex = -1;
            }
            if (!headIndexs.isEmpty()) {
                for (i = 0; i < headIndexs.size(); ++i) {
                    String fieldScope = expression.substring((Integer)headIndexs.get(i) + 1, (Integer)endIndexs.get(i));
                    filedSet.add(fieldScope);
                }
            }
            if (!headContextIndexs.isEmpty()) {
                for (i = 0; i < headContextIndexs.size(); ++i) {
                    String expContext = expression.substring((Integer)headContextIndexs.get(i), (Integer)endContextIndexs.get(i) + 1);
                    expContext = expContext.replaceAll("\\{", "\\\\{");
                    expContext = expContext.replaceAll("\\}", "\\\\}");
                    expContext = expContext.replaceAll("\\(", "\\\\(");
                    expContext = expContext.replaceAll("\\)", "\\\\)");
                    expContextSet.add(expContext);
                }
            }
        }
        result.put("filedSet", filedSet);
        result.put("expContextSet", expContextSet);
        return result;
    }
}

