/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bizflow.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.api.model.BillCard;
import kd.bos.workflow.bizflow.graph.model.SelectedRowData;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.BillCloseConfig;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BillTask;
import kd.bos.workflow.bpmn.model.BillTaskCallActivity;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EventStartItem;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.IEntitySupport;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.StartItem;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpm.calculator.billrelation.BillRelationHelper;
import kd.bos.workflow.engine.impl.bpmn.behavior.SkipInfo;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessConfigEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SignalEventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class BizFlowUtil {
    private static Log log = LogFactory.getLog(BizFlowUtil.class);

    private BizFlowUtil() {
    }

    public static Map<String, Set<String>> getDirectSourceBills(String entityNumber, String billId) {
        HashMap<String, Set<String>> billsMap = new HashMap<String, Set<String>>();
        ArrayList<String> targetPks = new ArrayList<String>();
        targetPks.add(billId);
        Map<String, Set<String>> ret = BillRelationHelper.get().getDirectSourceBill(entityNumber, targetPks);
        if (ret != null && !ret.isEmpty()) {
            billsMap.putAll(ret);
        }
        return billsMap;
    }

    @Deprecated
    public static Set<String> getDirectSourceBillIds(String entityNumber, String billId, String bizTraceNo) {
        HashSet<String> ret = new HashSet<String>(8);
        ArrayList<String> targetPks = new ArrayList<String>(1);
        targetPks.add(billId);
        Map<String, Set<String>> tmp = BillRelationHelper.get().getDirectSourceBill(entityNumber, targetPks);
        if (tmp != null && !tmp.isEmpty()) {
            for (Map.Entry<String, Set<String>> t : tmp.entrySet()) {
                if (t.getValue() == null) continue;
                ret.addAll((Collection<String>)t.getValue());
            }
        }
        return ret;
    }

    public static Set<String> getDirectSourceBillIds(String entityNumber, String billId) {
        HashSet<String> srcIds = new HashSet<String>(1);
        DynamicObject entity = WfUtils.findBusinessObject(billId, entityNumber);
        if (entity == null) {
            return srcIds;
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
        MainEntityType entityType = null;
        IDataEntityType dataEntityType = entity.getDataEntityType();
        entityType = dataEntityType instanceof MainEntityType ? (MainEntityType)dataEntityType : EntityMetadataCache.getDataEntityType((String)entityNumber);
        dataEntitySet.Parse(new DynamicObject[]{entity}, entityType);
        for (LinkSetItemElement itemElement : linkSet.getItems()) {
            ExtendedDataEntity[] linkRows = dataEntitySet.FindByEntityKey(itemElement.getLinkEntityKey());
            if (linkRows == null) continue;
            for (ExtendedDataEntity linkRow : linkRows) {
                Object srcId = linkRow.getValue(itemElement.getLinkEntityKey() + "_sbillid");
                srcIds.add(String.valueOf(srcId));
            }
        }
        return srcIds;
    }

    public static String getEntityName(Map<String, String> entityMap, String entityNumber) {
        String entityName = entityMap.get(entityNumber);
        if (entityName == null) {
            try {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                entityName = (String)entityType.getDisplayName().get((Object)RequestContext.get().getLang().toString());
                entityMap.put(entityNumber, entityName);
            }
            catch (Exception e) {
                entityName = entityNumber;
                log.warn(String.format("get %s entityName failed, %s", entityNumber, WfUtils.getExceptionStacktrace(e)));
            }
        }
        return entityName;
    }

    public static void addBizFlowProcessConfigs(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process) {
        boolean allowNextPersonWhenMatch = false;
        AllowNextPersonSettingModel allowNextPersonSettingModel = process.getAllowNextPersonSettingModel();
        if (null != allowNextPersonSettingModel) {
            allowNextPersonWhenMatch = allowNextPersonSettingModel.isAllowNextPersonWhenMatch();
        }
        List<StartItem> startItems = process.getStartItems();
        boolean enable = "enable".equalsIgnoreCase(processDefinition.getEnable());
        ProcessConfigEntityManager configManager = commandContext.getProcessConfigEntityManager();
        for (StartItem item : startItems) {
            ProcessConfigEntity processConfig = (ProcessConfigEntity)configManager.create();
            BizFlowUtil.insertProcessConfigCondition(commandContext, processDefinition, item.getCondition(), processConfig);
            processConfig.setProcDefId(processDefinition.getId());
            processConfig.setEnable(enable);
            processConfig.setAllowStart(item.isAllowstart());
            processConfig.setBatchNumber(item.getBatchnumber());
            processConfig.setBatchNumName(item.getBatchnumname());
            processConfig.setEntityNumber(item.getEntitynumber());
            processConfig.setOperation(item.getOperationNumbers());
            processConfig.setAllowNextPerson(allowNextPersonWhenMatch);
            processConfig.setProcessType(process.getProcessType());
            configManager.insert(processConfig);
        }
        List<EventStartItem> evtStartItems = process.getEvtStartItems();
        for (EventStartItem item : evtStartItems) {
            ProcessConfigEntity processConfig = (ProcessConfigEntity)configManager.create();
            BizFlowUtil.insertProcessConfigCondition(commandContext, processDefinition, item.getCondition(), processConfig);
            processConfig.setProcDefId(processDefinition.getId());
            processConfig.setEnable(enable);
            processConfig.setStartType("event");
            processConfig.setEventNumber(item.getEventNumber());
            processConfig.setAllowNextPerson(allowNextPersonWhenMatch);
            processConfig.setProcessType(process.getProcessType());
            configManager.insert(processConfig);
        }
    }

    private static void insertProcessConfigCondition(CommandContext commandContext, ProcessDefinitionEntity processDefinition, ConditionalRuleEntity condRule, ProcessConfigEntity processConfig) {
        if (condRule != null) {
            condRule.setProcdefid(processDefinition.getId());
            commandContext.getConditionRuleEntityManager().saveOrUpdateConditionRule(condRule);
            processConfig.setStartCondition(condRule.getConditionRule());
            processConfig.setCondRuleId(condRule.getId());
        }
    }

    public static List<SignalEventSubscriptionEntity> addBizFlowSignalEventSubscriptions(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        return BizFlowUtil.addBizFlowSignalEventSubscriptions(commandContext, processDefinition, process, bpmnModel, true);
    }

    public static List<SignalEventSubscriptionEntity> addBizFlowSignalEventSubscriptions(CommandContext commandContext, ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel, boolean immediately) {
        ArrayList<SignalEventSubscriptionEntity> entities = new ArrayList<SignalEventSubscriptionEntity>(16);
        List<StartItem> startItems = process.getStartItems();
        List<EventStartItem> eventStartItems = process.getEvtStartItems();
        List<StartEvent> events = process.findFlowElementsOfType(StartEvent.class);
        if (events.isEmpty()) {
            log.debug("no startEvents!");
            return entities;
        }
        StartEvent startEvent = events.get(0);
        EventSubscriptionEntityManager subscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        if (!eventStartItems.isEmpty()) {
            SignalEventSubscriptionEntity subscriptionEntity = subscriptionEntityManager.createSignalEventSubscription();
            subscriptionEntity.setEventName(process.getNumber());
            subscriptionEntity.setActivityId(startEvent.getId());
            subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
            subscriptionEntity.setVersion(processDefinition.getVersion());
            if (immediately) {
                subscriptionEntityManager.insert(subscriptionEntity);
            }
            entities.add(subscriptionEntity);
        }
        if (!startItems.isEmpty()) {
            List<String> nodeIds = bpmnModel.getFollowNodeIds(startEvent.getId());
            for (StartItem item : startItems) {
                SignalEventSubscriptionEntity subscriptionEntity = subscriptionEntityManager.createSignalEventSubscription();
                subscriptionEntity.setEventName(String.format("%s.%s", process.getNumber(), item.getEntitynumber()));
                subscriptionEntity.setActivityId(BizFlowUtil.getTheHeadmostNodeId(nodeIds, item));
                subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
                subscriptionEntity.setVersion(processDefinition.getVersion());
                if (immediately) {
                    subscriptionEntityManager.insert(subscriptionEntity);
                }
                entities.add(subscriptionEntity);
            }
        }
        return entities;
    }

    public static List<String> getStartItemNodeIds(StartItem item) {
        ArrayList<String> nodeIds = null;
        String itemNodeIds = item.getNodeid();
        if (itemNodeIds == null || "".equals(itemNodeIds.trim())) {
            log.debug("ids is null! " + item.getEntitynumber());
            return new ArrayList<String>();
        }
        String[] ids = itemNodeIds.split(" ");
        if (ids == null || ids.length == 0) {
            return new ArrayList<String>();
        }
        nodeIds = new ArrayList<String>(ids.length);
        for (String id : ids) {
            if ("".equals(id.trim())) continue;
            nodeIds.add(id);
        }
        return nodeIds;
    }

    private static String getTheHeadmostNodeId(List<String> nodeIds, StartItem item) {
        String nodeId = null;
        List<String> ids = BizFlowUtil.getStartItemNodeIds(item);
        int index = nodeIds.size();
        for (String id : ids) {
            int temp = nodeIds.indexOf(id);
            if (temp <= -1 || temp >= index) continue;
            index = temp;
            nodeId = id;
        }
        return nodeId;
    }

    public static List<Long> getLongBusinessKeys(Collection<String> businessKeys) {
        ArrayList<Long> ids = new ArrayList<Long>(businessKeys.size());
        for (String businessKey : businessKeys) {
            try {
                ids.add(Long.valueOf(businessKey));
            }
            catch (NumberFormatException e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
        }
        return ids;
    }

    public static String showBillRelation(Long procInstId, IFormView view, String businessKey) {
        return BizFlowUtil.showBillRelation(procInstId, view, businessKey, "all");
    }

    public static String showBillRelation(Long procInstId, IFormView view, String businessKey, String permStrategy) {
        String tip = BizFlowUtil.validateBillRelationData(procInstId);
        if (tip != null) {
            view.showTipNotification(tip);
            return null;
        }
        String id = String.valueOf(procInstId);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bpm_billrelation_graph");
        parameter.setCustomParam("billId", (Object)businessKey);
        parameter.setCustomParam("procInstId", (Object)id);
        parameter.setCustomParam("permStrategy", (Object)permStrategy);
        parameter.setClientParam("billId", (Object)businessKey);
        parameter.setClientParam("procInstId", (Object)id);
        parameter.setClientParam("permStrategy", (Object)permStrategy);
        return BizFlowUtil.showBillRelationGraph(view, parameter);
    }

    private static String showBillRelationGraph(IFormView view, FormShowParameter parameter) {
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setClientParam("isBillRelationGraph", (Object)true);
        parameter.setClientParam("serverRender", (Object)BizFlowGraphUtil.isServerRender());
        view.showForm(parameter);
        return parameter.getPageId();
    }

    public static String showBillRelation(IFormView view, String entityNumber, String businessKey) {
        return BizFlowUtil.showBillRelation(view, entityNumber, businessKey, "all");
    }

    public static String showBillRelation(IFormView view, String entityNumber, String businessKey, String permStrategy) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bpm_billrelation_graph");
        parameter.setCustomParam("billId", (Object)businessKey);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("permStrategy", (Object)permStrategy);
        parameter.setClientParam("billId", (Object)businessKey);
        parameter.setClientParam("entityNumber", (Object)entityNumber);
        parameter.setClientParam("permStrategy", (Object)permStrategy);
        return BizFlowUtil.showBillRelationGraph(view, parameter);
    }

    public static String showBillRelation(IFormView view, String entityNumber, SelectedRowData rowData) {
        FormShowParameter parameter = new FormShowParameter();
        String businessKey = String.valueOf(rowData.getPrimaryKeyValue());
        parameter.setFormId("bpm_billrelation_graph");
        parameter.setClientParam("billId", (Object)businessKey);
        parameter.setClientParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("billId", (Object)businessKey);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        parameter.setCustomParam("selectedRowData", (Object)JSON.toJSONString((Object)rowData));
        return BizFlowUtil.showBillRelationGraph(view, parameter);
    }

    public static String showBillRelation(IFormView view, List<BillCard> billCards, String currentEntityNumber, String currentBusinessKey) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bpm_billrelation_graph");
        parameter.setClientParam("billId", (Object)currentBusinessKey);
        parameter.setClientParam("entityNumber", (Object)currentEntityNumber);
        parameter.setCustomParam("billId", (Object)currentBusinessKey);
        parameter.setCustomParam("entityNumber", (Object)currentEntityNumber);
        parameter.setCustomParam("billCards", (Object)JSON.toJSONString(billCards));
        if (billCards != null && !billCards.isEmpty()) {
            try {
                log.info("CustomBillRelationDatas: " + SerializationUtils.serializeToBase64(billCards));
            }
            catch (Exception e) {
                log.warn(WfUtils.getExceptionStacktrace(e));
            }
        }
        return BizFlowUtil.showBillRelationGraph(view, parameter);
    }

    private static String validateBillRelationData(Long procInstId) {
        RepositoryService service = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
        HistoricProcessInstanceEntity processInstance = (HistoricProcessInstanceEntity)service.findEntityById(procInstId, "wf_hiprocinst", "biztraceno");
        QFilter[] filters = null;
        filters = processInstance != null && WfUtils.isNotEmpty(processInstance.getBizTraceNo()) ? new QFilter[]{new QFilter("biztraceno", "=", (Object)processInstance.getBizTraceNo())} : new QFilter[]{new QFilter("procinstid", "=", (Object)procInstId)};
        Long count = service.getEntityCountByFilter("wf_circulaterelation", filters);
        if (count < 1L) {
            return WFMultiLangConstants.getBillRelationNoDatasTip();
        }
        return null;
    }

    public static String showBillRelation(Long procInstId, IFormView view) {
        return BizFlowUtil.showBillRelation(procInstId, view, null);
    }

    public static ExecutionEntity createBillExecutionAndContinue(CommandContext commandContext, ExecutionEntity processInstance, FlowElement flowElement, String entityNumber, String businessKey) {
        return BizFlowUtil.createBillExecutionAndContinue(commandContext, processInstance, flowElement, 0L, entityNumber, businessKey);
    }

    public static ExecutionEntity createBillExecutionAndContinue(CommandContext commandContext, ExecutionEntity processInstance, FlowElement flowElement, Long currentActInstId, String entityNumber, String businessKey) {
        log.debug(String.format("crateBillExecutionAndContinue: procInstId:_%s_ nodeId:_%s_ actInstId:_%s_ entityNumber:_%s_ businessKey:_%s_", processInstance.getId(), flowElement.getId(), currentActInstId, entityNumber, businessKey));
        ExecutionEntity executionEntity = BizFlowUtil.createBillExecutionAndRecordRelation(commandContext, processInstance, flowElement, currentActInstId, entityNumber, businessKey);
        Context.getAgenda().planContinueProcessOperation(executionEntity);
        return executionEntity;
    }

    public static ExecutionEntity createBillExecutionAndRecordRelation(CommandContext commandContext, ExecutionEntity processInstance, FlowElement flowElement, Long currentActInstId, String entityNumber, String businessKey) {
        ExecutionEntityManager executionManager = commandContext.getExecutionEntityManager();
        ExecutionEntity billExecution = executionManager.createChildExecution(processInstance);
        String billNo = TaskBehaviorUtil.getTaskBillNo(entityNumber, businessKey);
        billExecution.setBillNo(billNo);
        billExecution.setEntityNumber(entityNumber);
        billExecution.setBusinessKey(businessKey);
        billExecution.setBillExecution(Boolean.TRUE);
        billExecution.setActive(Boolean.FALSE);
        billExecution.setCurrentFlowElement(flowElement);
        billExecution.setActivityId(flowElement.getId());
        ExecutionEntity executionEntity = executionManager.createChildExecution(billExecution);
        executionEntity.setActivityId(flowElement.getId());
        executionEntity.setCurrentFlowElement(flowElement);
        executionEntity.setCurrentActInstId(currentActInstId);
        commandContext.getCirculateRelationEntityManager().recordCirculateRelationShip(executionEntity, flowElement);
        return executionEntity;
    }

    public static String parseBatchNumberValue(BusinessModelVariableScope bizScope, String batchNumber) {
        if (WfUtils.isEmpty(batchNumber)) {
            return batchNumber;
        }
        String batchNumberExpression = String.format("${%s}", batchNumber);
        Object value = ExpressionCalculatorUtil.parseValue(bizScope.getDynamicObject(), bizScope, batchNumberExpression, null);
        return value == null ? "" : String.valueOf(value);
    }

    public static SkipInfo getSkipInfoWhenBoot(ExecutionEntity execution, FlowNode flowNode) {
        SkipInfo skipInfo = new SkipInfo(false);
        String bootNodeId = (String)execution.getVariable("bootNodeId");
        String prevNodeIds = (String)execution.getVariable("bootNodePrevNodeIds");
        String skipReason = BizFlowUtil.getSkipReasonWhenBoot(flowNode, bootNodeId, prevNodeIds);
        log.debug(String.format("prcInstanceId[%s],skipReason[%s]", execution.getProcessInstanceId(), skipReason));
        if (skipReason != null) {
            skipInfo.setSkip(true);
            skipInfo.setSkipReason(skipReason);
        } else if (BizFlowUtil.isTargetEntity(execution, flowNode)) {
            skipInfo.setSkip(true);
            skipInfo.setSkipReason("NonSameBill");
        }
        skipInfo.setFirstNode(BpmnModelUtil.isFirstNodeByModel(flowNode));
        return skipInfo;
    }

    public static boolean isSequenceFlowInStartPath(ExecutionEntity execution, FlowNode currentNode, SequenceFlow flow) {
        if (!BizFlowUtil.isBizFlowExecution(execution)) {
            return true;
        }
        String bootNodeId = (String)execution.getVariable("bootNodeId");
        String prevNodeIds = (String)execution.getVariable("bootNodePrevNodeIds");
        if (prevNodeIds == null || !prevNodeIds.contains(currentNode.getId())) {
            return true;
        }
        String target = flow.getTargetRef();
        return prevNodeIds.contains(target) || bootNodeId != null && bootNodeId.equals(target);
    }

    public static boolean isTargetEntity(ExecutionEntity execution, FlowElement target) {
        String tagEntityNumber = (String)execution.getVariableLocal("bizTargetEntity");
        log.debug(String.format("prcInstanceId[%s],targetNumber[%s]", execution.getProcessInstanceId(), tagEntityNumber));
        return tagEntityNumber != null && target instanceof IEntitySupport && ((IEntitySupport)((Object)target)).getEntityNumber() != null && tagEntityNumber.equalsIgnoreCase(((IEntitySupport)((Object)target)).getEntityNumber());
    }

    public static boolean ifSkipWhenBootThenRecordExecutionType(DelegateExecution executionEntity, FlowNode flowNode) {
        return BizFlowUtil.ifSkipWhenBootThenRecordExecutionType(executionEntity, flowNode, true);
    }

    public static boolean ifSkipWhenBootThenRecordExecutionType(DelegateExecution executionEntity, FlowNode flowNode, boolean record) {
        if (!(executionEntity instanceof ExecutionEntity)) {
            return false;
        }
        ExecutionEntity execution = (ExecutionEntity)executionEntity;
        SkipInfo skipInfo = BizFlowUtil.getSkipInfoWhenBoot(execution, flowNode);
        if ("bootNode".equals(skipInfo.getSkipReason())) {
            BillTaskCallActivity callActivity;
            if (flowNode instanceof CallActivity) {
                return false;
            }
            if (flowNode instanceof BillTask && (callActivity = ((BillTask)flowNode).getBillTaskCallActivity()) != null && callActivity.isEnableCallActivity()) {
                return false;
            }
        }
        if (skipInfo.isSkip()) {
            if (record) {
                Context.getCommandContext().getHistoryManager().recordActivityExecutionType(execution, "skip", skipInfo.getSkipReason());
            }
            return true;
        }
        return false;
    }

    private static String getSkipReasonWhenBoot(FlowNode flowNode, String bootNodeId, String prevNodeIds) {
        if (flowNode.getId() == null) {
            return null;
        }
        if (prevNodeIds != null && prevNodeIds.contains(flowNode.getId())) {
            log.debug(String.format("curNode:[%s],prevNodeIds:[%s]", flowNode.getId(), prevNodeIds));
            return "nonBootNode";
        }
        return null;
    }

    public static boolean isNonBootNode(DelegateExecution execution, FlowNode flowNode) {
        String bootNodeId = (String)execution.getVariable("bootNodeId");
        return bootNodeId == null || !bootNodeId.equals(flowNode.getId());
    }

    public static boolean isBizFlow(BpmnModel bpmnModel) {
        return bpmnModel != null && ModelType.BizFlow.name().equals(bpmnModel.getMainProcess().getProcessType());
    }

    public static boolean isBizFlowExecution(ExecutionEntity executionEntity) {
        return ModelType.BizFlow.name().equals(executionEntity.getVariable("processType"));
    }

    public static boolean isAuditFlowExecution(ExecutionEntity executionEntity) {
        return null == executionEntity ? false : ModelType.AuditFlow.name().equals(executionEntity.getVariable("processType"));
    }

    public static void setBizTraceNo(CommandContext commandContext, String entityNumber, String businessKey, Map<String, Object> variables, JobEntity jobEntity, boolean bizFlow) {
        String bizTraceNo = null;
        boolean newable = true;
        if (variables != null) {
            bizTraceNo = (String)variables.get("biztraceno");
        }
        if (bizFlow && WfUtils.isEmpty(bizTraceNo)) {
            newable = true;
            bizTraceNo = WfUtils.getBizTraceNo(entityNumber, businessKey);
            if (variables != null) {
                variables.put("biztraceno", bizTraceNo);
            }
        } else {
            newable = false;
        }
        if (newable && WfUtils.isNotEmpty(bizTraceNo)) {
            QFilter[] filters = new QFilter[]{new QFilter("endTime", "is null", null), new QFilter("biztraceno", "=", (Object)bizTraceNo), new QFilter("processtype", "=", (Object)ModelType.BizFlow.name())};
            long count = commandContext.getHistoricProcessInstanceEntityManager().countByFilter("id", filters, false);
            if (count > 0L) {
                throw new WFException(WFErrorCode.bizTraceNoDuplicated(), entityNumber, businessKey, bizTraceNo);
            }
        }
        JobEntityManager jobMgr = commandContext.getJobEntityManager();
        jobEntity.setBizTraceNo(bizTraceNo);
        try {
            Long srJobId = jobEntity.getSrcJobId();
            JobEntity srcJob = null;
            if (WfUtils.isNotEmpty(srJobId) && (srcJob = (JobEntity)jobMgr.findById(srJobId)) != null) {
                srcJob.setBizTraceNo(bizTraceNo);
                jobMgr.update(srcJob);
            }
        }
        catch (Exception e) {
            log.warn(String.format("\u7ed9\u5bfb\u5740job\u5199bizTraceNo\u5931\u8d25%s", WfUtils.getExceptionStacktrace(e)));
        }
        jobMgr.update(jobEntity);
    }

    public static void setExecutionBatchNumber(ExecutionEntity execution) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcDefId(execution.getProcessDefinitionId());
        List<StartItem> startItems = bpmnModel.getMainProcess().getStartItems();
        String entityNumber = execution.getEntityNumber();
        String businessKey = execution.getBusinessKey();
        for (StartItem startItem : startItems) {
            if (entityNumber == null || !entityNumber.equals(startItem.getEntitynumber())) continue;
            DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, entityNumber);
            BusinessModelVariableScope bizScope = new BusinessModelVariableScope(dynamicObject);
            String batchNumber = BizFlowUtil.parseBatchNumberValue(bizScope, startItem.getBatchnumber());
            execution.setBatchNumber(batchNumber);
            log.debug(String.format("set %s batchNumber %s", execution.getId(), batchNumber));
            break;
        }
    }

    public static boolean canCloseTask(VariableScope scope, SequenceFlow flow) {
        if (flow == null) {
            return true;
        }
        BillTask billTask = null;
        BillRelationshipModel conversionInfo = flow.getBillRelationshipModel();
        if ("botpTargetBills".equalsIgnoreCase(conversionInfo.getRelationType())) {
            BillCloseConfig billCloseConfig;
            if (flow.getSourceFlowElement() instanceof BillTask) {
                billTask = (BillTask)flow.getSourceFlowElement();
            }
            ExecutionEntity execution = null;
            execution = scope instanceof TaskEntity ? ((TaskEntity)scope).getExecution() : (ExecutionEntity)scope;
            if (billTask == null && execution != null && execution.getParent() != null) {
                ExecutionEntity billExecution = execution.getParent();
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(billExecution.getProcessDefinitionId(), billExecution.getSchemeId(), billExecution.getProcessInstanceId());
                FlowElement element = bpmnModel.getFlowElement(billExecution.getActivityId());
                if (element instanceof BillTask) {
                    billTask = (BillTask)element;
                } else {
                    String billTaskId = BizFlowUtil.findClosestBillTaskId(execution.getId(), flow);
                    FlowElement flowElement = element = billTaskId != null ? bpmnModel.getFlowElement(billTaskId) : null;
                    if (element instanceof BillTask) {
                        billTask = (BillTask)element;
                    }
                }
            }
            if (billTask != null && (billCloseConfig = billTask.getBillCloseConfig()) != null && billCloseConfig.getBillCloseCondition() != null) {
                ConditionType.logItemName(billTask);
                return BizFlowUtil.isMeetBillCloseCondition(billTask, execution);
            }
        }
        return BizFlowUtil.canCloseTask(scope, conversionInfo);
    }

    public static boolean canCloseTask(VariableScope scope, BillRelationshipModel conversionInfo) {
        if (conversionInfo == null || !"botpTargetBills".equals(conversionInfo.getRelationType())) {
            return true;
        }
        ConditionalRuleEntity taskCloseRule = conversionInfo.getTaskCloseRule();
        if (taskCloseRule == null) {
            return true;
        }
        return ConditionUtil.hasTrueCondition(taskCloseRule, scope, "bizFlow-close-rule");
    }

    public static boolean isMeetBillCloseCondition(BillTask billTask, ExecutionEntity executionEntity) {
        boolean isMeetCloseCondition = true;
        BillCloseConfig billCloseConfig = billTask.getBillCloseConfig();
        if (billCloseConfig != null && billCloseConfig.getBillCloseCondition() != null) {
            String key = String.format("bizFlow-billCloseCondition-%s", billTask.getId());
            isMeetCloseCondition = ConditionUtil.hasTrueCondition(billCloseConfig.getBillCloseCondition(), (VariableScope)executionEntity, key);
        }
        return isMeetCloseCondition;
    }

    public static String findClosestBillTaskId(Long executionId, SequenceFlow flow) {
        QFilter[] filters = new QFilter[]{new QFilter("executionId", "=", (Object)executionId)};
        String fields = String.format("%s, %s", "activityId", "activityType");
        List actInsts = Context.getCommandContext().getHistoricActivityInstanceEntityManager().findByQueryFilters(filters, fields, String.format("%s DESC", "step"));
        if (actInsts.isEmpty()) {
            return null;
        }
        boolean find = false;
        for (HistoricActivityInstanceEntity actInst : actInsts) {
            String actId = actInst.getActivityId();
            String actType = actInst.getActivityType();
            if (find && "BillTask".equals(actType)) {
                return actId;
            }
            if (!actId.equals(flow.getId())) continue;
            find = true;
        }
        return null;
    }

    public static void deleteToDoMsg(CommandContext commandContext, Long taskId) {
        if (WfUtils.isEmpty(taskId)) {
            return;
        }
        List<IdentityLinkEntity> identityLinks = commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskId(taskId);
        ArrayList<Long> userIds = new ArrayList<Long>(identityLinks.size());
        for (IdentityLinkEntity iden : identityLinks) {
            userIds.add(iden.getUserId());
        }
        if (!userIds.isEmpty()) {
            commandContext.getMessageService().deleteToDo(taskId, userIds);
        }
    }

    public static HistoricActivityInstanceEntity makeEndActInst(CommandContext commandContext, ExecutionEntity executeExecution) {
        return BizFlowUtil.makeEndActInst(commandContext, executeExecution, "cancel");
    }

    public static HistoricActivityInstanceEntity makeEndActInst(CommandContext commandContext, ExecutionEntity executeExecution, String executionType) {
        HistoricActivityInstanceEntityManager actinstMgr = commandContext.getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity currentActInst = (HistoricActivityInstanceEntity)actinstMgr.findById(executeExecution.getCurrentActInstId());
        if (currentActInst != null) {
            Date endTime = WfUtils.now();
            log.debug(String.format("\u7ed3\u675f\u6d3b\u52a8\u5b9e\u4f8b%s", currentActInst.getId()));
            currentActInst.setEndTime(endTime);
            currentActInst.setDurationInMillis(endTime.getTime() - currentActInst.getCreateDate().getTime());
            ((HistoricActivityInstanceEntityImpl)currentActInst).calRealDuration();
            currentActInst.setExecutionType(executionType);
            actinstMgr.update(currentActInst);
        }
        return currentActInst;
    }

    public static void closeUserTask(CommandContext commandContext, ExecutionEntity execution, TaskEntity task) {
        if (execution == null || !ModelType.BizFlow.name().equalsIgnoreCase(execution.getProcessType())) {
            throw new WFBizException(null, WFErrorCode.cannotCloseAuditFlowTask(), new Object[]{task.getBillNo()});
        }
        Long taskId = task.getId();
        log.debug(String.format("\u5220\u9664\u4efb\u52a1%s\u548c\u4ee3\u529e", taskId));
        commandContext.getTaskHelper().deleteTask(taskId, "billExcepAbort", false);
        BizFlowUtil.deleteToDoMsg(commandContext, taskId);
        BizFlowUtil.makeEndActInst(commandContext, execution);
        execution.setActive(false);
    }

    public static void completeBillTaskNotContinue(CommandContext commandContext, ExecutionEntity execution, TaskEntity task) {
        if (task != null) {
            task.setDisplay(false);
            JobEntity job = commandContext.getJobManager().createCompensationConvertTaskJob(task, null);
            commandContext.getJobEntityManager().insert(job);
            commandContext.getJobManager().scheduleAsyncJob(job);
            commandContext.getHistoryManager().recordActivityEnd(task.getExecution(), null);
        }
        commandContext.getExecutionEntityManager().deleteChildrenExecutions(execution.getId());
        execution.setActive(false);
    }

    public static String getSignalEvent(String processType, String processNumber, String entityNumber) {
        if (ModelType.BizFlow.name().equals(processType)) {
            return String.format("%s.%s", processNumber, entityNumber);
        }
        return processNumber;
    }

    public static void deleteBizRelationData(CommandContext commandContext, String businessKey) {
        commandContext.getCirculateRelationEntityManager().deleteByFilters(new QFilter[]{new QFilter("businesskey", "=", (Object)businessKey)});
        commandContext.getExeConversionEntityManager().deleteByFilters(new QFilter[]{new QFilter("tagbusinesskey", "=", (Object)businessKey)});
    }

    public static ExecutionEntity findBillExecution(ExecutionEntity exec) {
        while (exec != null) {
            if (exec.isBillExecution()) {
                return exec;
            }
            exec = exec.getParent();
        }
        return null;
    }
}

