/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.converter.UserTaskJsonConverter;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.CustomParam;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.ExtendAttributeGroup;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateExtAttrEntity;
import kd.bos.workflow.engine.impl.bpmn.helper.nodetemplate.NodeTemplateUtil;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import org.apache.commons.lang.BooleanUtils;

public class AuditTaskJsonConverter
extends UserTaskJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        AuditTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        AuditTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("AuditTask", AuditTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(AuditTask.class, AuditTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "AuditTask";
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        BaseElement elem = super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        AuditTask auditTask = (AuditTask)elem;
        JsonNode repeaterbtn = elementNode.get("properties").get("repeaterbtn");
        JsonNode repeaterModel = elementNode.get("properties").get("repeaterModel");
        if (repeaterModel != null && repeaterbtn == null && !"manual".equals(repeaterModel.asText())) {
            auditTask.setRepeaterbtn(true);
        }
        List<DecisionOption> decisions = auditTask.getDecisionOptions();
        this.decisonSceneCompatible(decisions, auditTask);
        if (decisions != null && !decisions.isEmpty()) {
            for (DecisionOption decision : decisions) {
                String recallOperation = decision.getAttributeValue("recallOperation");
                String operation = decision.getAttributeValue("operation");
                if (!WfUtils.isNotEmpty(operation) && !WfUtils.isNotEmpty(recallOperation)) continue;
                ActivitiListener listener = new ActivitiListener();
                listener.setEvent("complete");
                listener.setNumber(decision.getNumber());
                listener.setOperation(decision.getNumber());
                listener.setImplementationType("operation");
                String operationName = WfUtils.getOperationName(auditTask.getEntityNumber(), operation);
                String recallOperationName = WfUtils.getOperationName(auditTask.getEntityNumber(), recallOperation);
                listener.setImplementation(ExternalInterfaceUtil.buildExtItfOperationValue(operation, operationName, recallOperation, recallOperationName));
                auditTask.getTaskListeners().add(listener);
                decision.removeAttribute("operation", "recallOperation");
            }
        }
        if (BpmnModelUtil.instanceofAuditTask(BpmnJsonConverterUtil.getStencilId(elementNode))) {
            this.convertSSCCreditCustomParam2ExtAttrGroup(auditTask);
            if (!BpmnModelUtil.instanceofYunzhijiaTask(BpmnJsonConverterUtil.getStencilId(elementNode))) {
                this.setAllowNextPersonSettingModel(auditTask, elementNode);
            }
        }
        return elem;
    }

    private void decisonSceneCompatible(List<DecisionOption> decisions, AuditTask auditTask) {
        ArrayList<DecisionOption> decisionOptions = new ArrayList<DecisionOption>();
        if (decisions != null && decisions.size() > 0) {
            for (DecisionOption decisionOption : decisions) {
                if (WfUtils.isEmpty(decisionOption.getDecisionScene())) {
                    switch (decisionOption.getAuditType()) {
                        case "approve": {
                            decisionOption.setDecisionScene("approve");
                            break;
                        }
                        case "reject": {
                            decisionOption.setDecisionScene("rejectToAllAuditNode");
                            break;
                        }
                        case "forceReject": {
                            decisionOption.setDecisionScene("forceReject");
                            break;
                        }
                        case "terminate": {
                            decisionOption.setDecisionScene("terminate");
                        }
                    }
                }
                decisionOptions.add(decisionOption);
            }
            auditTask.setDecisionOptions(decisionOptions);
        }
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new AuditTask();
    }

    private void setAllowNextPersonSettingModel(AuditTask auditTask, JsonNode elementNode) {
        if (null != auditTask) {
            boolean isAllowNextPerson;
            AllowNextPersonSettingModel allowNextPersonSettingModel;
            JsonNode isAllowNextPersonObj;
            JsonNode participant;
            boolean needCompatible = true;
            JsonNode allowNextPersonSettingModelObj = BpmnJsonConverterUtil.getProperty("allowNextPersonSettingModel", elementNode);
            if (null != allowNextPersonSettingModelObj && null != allowNextPersonSettingModelObj.get("allowNextPersonWhenMatch")) {
                needCompatible = false;
            }
            if (needCompatible && null != (participant = BpmnJsonConverterUtil.getProperty("participant", elementNode)) && (isAllowNextPersonObj = participant.get("allowNextPerson")) instanceof BooleanNode && null != (allowNextPersonSettingModel = BpmnJsonConverterUtil.convertJsonToAllowNextPersonSettingModel(isAllowNextPerson = ((BooleanNode)isAllowNextPersonObj).asBoolean()))) {
                auditTask.setAllowNextPersonSettingModel(allowNextPersonSettingModel.clone());
            }
        }
    }

    private void convertSSCCreditCustomParam2ExtAttrGroup(AuditTask auditTask) {
        ExtendAttributeGroup fiRCMCreditApproveGroup;
        Object creditControlSSC = auditTask.getCustomPropValue("creditcontrol_ssc");
        if (!(creditControlSSC instanceof String) || !BooleanUtils.toBoolean((String)creditControlSSC.toString())) {
            return;
        }
        String type = auditTask.getType();
        NodeTemplateExtAttrEntity nodeTemplateExtAttrEntity = NodeTemplateUtil.getExtAttrDatas(type);
        Map<String, String> extNameMap = nodeTemplateExtAttrEntity.getExtNameMap();
        if (WfUtils.isEmptyForMap(extNameMap)) {
            return;
        }
        String nodeExtNum = NodeTemplateUtil.getNodeExtNumByStencilType(type);
        if (!extNameMap.containsKey(nodeExtNum)) {
            return;
        }
        HashMap extAttrGroups = auditTask.getExtAttrGroup();
        if (WfUtils.isNullObject(extAttrGroups)) {
            extAttrGroups = Maps.newHashMapWithExpectedSize((int)extNameMap.size());
        }
        if ((fiRCMCreditApproveGroup = extAttrGroups.getOrDefault(nodeExtNum, new ExtendAttributeGroup())).isGroupEnable()) {
            return;
        }
        List<CustomParam> customParams = auditTask.getCustomParams().stream().filter(t -> !Objects.equals(t.getNumber(), "creditcontrol_ssc")).collect(Collectors.toList());
        auditTask.setCustomParams(customParams);
        fiRCMCreditApproveGroup.setGroupEnable(Boolean.TRUE);
        extAttrGroups.put(nodeExtNum, fiRCMCreditApproveGroup);
        auditTask.setExtAttrGroup(extAttrGroups);
    }
}

