/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.AutoMicroServiceTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.HasExtensionAttributes;
import kd.bos.workflow.bpmn.model.InParameter;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Parameter;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class AutoMicroServiceTaskJsonConverter
extends BaseBpmnJsonConverter {
    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        AutoMicroServiceTask task = (AutoMicroServiceTask)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        this.convertInParams(elementNode, task);
        if (rootElement instanceof Process) {
            Process process = (Process)rootElement;
            List<Macro> macros = BpmnModelUtil.loadDefaultNodeMacro(task, process.getProcessType(), task.getType());
            process.getMacros().addAll(macros);
        }
        task.removeAttribute("macros");
        return task;
    }

    private void convertInParams(JsonNode elementNode, AutoMicroServiceTask task) {
        JsonNode properties = elementNode.get("properties");
        JsonNode inParamsJson = properties.get("inParams");
        if (inParamsJson == null || inParamsJson.isEmpty()) {
            return;
        }
        int index = 0;
        List<InParameter> inParams = task.getInParams();
        for (JsonNode inParamJson : inParamsJson) {
            InParameter inParameter = inParams.get(index);
            this.convertInParameterParamsValue(inParameter, inParamJson);
            ++index;
        }
    }

    private void convertInParameterParamsValue(InParameter inParameter, JsonNode inParamJson) {
        int index = 0;
        JsonNode paramsJson = inParamJson.get("params");
        List<Parameter> inParams = inParameter.getParams();
        for (JsonNode paramJson : paramsJson) {
            JsonNode valueJson = paramJson.get("value");
            if (valueJson instanceof ArrayNode) {
                this.convertInParamArrayNodeValue(inParams.get(index), (ArrayNode)valueJson);
            }
            ++index;
        }
    }

    private void convertInParamArrayNodeValue(Parameter inParam, ArrayNode arrayValue) {
        if (arrayValue.isEmpty()) {
            inParam.setValue(new ArrayList());
            return;
        }
        String json = SerializationUtils.toJsonString((Object)arrayValue);
        List value = (List)SerializationUtils.fromJsonString((String)json, List.class);
        inParam.setValue(value);
    }

    @Override
    protected void parseElement(ObjectNode propNode, HasExtensionAttributes baseElement, List<BaseBpmnJsonConverter.PropInfo> modelProps) {
        Parameter param;
        Object value;
        if (baseElement instanceof Parameter && (value = (param = (Parameter)baseElement).getValue()) instanceof List) {
            this.parseParameterListValue(propNode, param);
            return;
        }
        super.parseElement(propNode, baseElement, modelProps);
    }

    private void parseParameterListValue(ObjectNode propNode, Parameter param) {
        List list;
        if (param.getId() != null) {
            propNode.put("id", param.getId());
        }
        if (param.getName() != null) {
            propNode.put("name", param.getName());
        }
        if (param.getNumber() != null) {
            propNode.put("number", param.getNumber());
        }
        if (param.getType() != null) {
            propNode.put("type", param.getType());
        }
        if ((list = (List)param.getValue()).isEmpty()) {
            return;
        }
        try {
            ArrayNode datas = (ArrayNode)this.objectMapper.readValue(JSON.toJSONString((Object)list), ArrayNode.class);
            propNode.set("value", (JsonNode)datas);
        }
        catch (Exception e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        AutoMicroServiceTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        AutoMicroServiceTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("AutoMicroServiceTask", AutoMicroServiceTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(AutoMicroServiceTask.class, AutoMicroServiceTaskJsonConverter.class);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new AutoMicroServiceTask();
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "AutoMicroServiceTask";
    }
}

