/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class AutoTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        AutoTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        AutoTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("AutoTask", AutoTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(AutoTask.class, AutoTaskJsonConverter.class);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new AutoTask();
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "AutoTask";
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        AutoTask task = (AutoTask)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        String extIf = task.getAttributeValue("service.extItf");
        if (WfUtils.isNotEmpty(extIf)) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(extIf);
            task.setExtItf(ret);
            task.removeAttribute("service.extItf");
        }
        this.messageCompatible(elementNode, task, rootElement);
        List<Macro> macros = null;
        if (rootElement instanceof Process) {
            Process process = (Process)rootElement;
            macros = BpmnModelUtil.loadDefaultNodeMacro(task, process.getProcessType(), this.getStencilId(task));
            process.getMacros().addAll(macros);
        }
        task.removeAttribute("macros");
        return task;
    }
}

