/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.Property;
import kd.bos.workflow.bpmn.converter.ActivityProcessor;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.converter.constants.StencilConstants;
import kd.bos.workflow.bpmn.converter.field.ConvertField;
import kd.bos.workflow.bpmn.converter.field.EntityConvertField;
import kd.bos.workflow.bpmn.converter.field.TransIgnore;
import kd.bos.workflow.bpmn.converter.util.JsonConverterUtil;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.Artifact;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.ExtendAttributeGroup;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.ExtensionElement;
import kd.bos.workflow.bpmn.model.FieldExtension;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.HasExtensionAttributes;
import kd.bos.workflow.bpmn.model.IMessageSupport;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.MessageFlow;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.MultiInstanceLoopCharacteristics;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.TerminateEventDefinition;
import kd.bos.workflow.bpmn.model.TimerEventDefinition;
import kd.bos.workflow.bpmn.model.basedata.BaseDataRecord;
import kd.bos.workflow.bpmn.model.basedata.IBaseData;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.bpmn.model.dynamicpartial.IDynamicPartial;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.ISupportJsonTransfer;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public abstract class BaseBpmnJsonConverter
extends StencilConstants {
    protected static Log log = LogFactory.getLog(BaseBpmnJsonConverter.class);
    public static final String NAMESPACE = "http://activiti.com/modeler";
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected ActivityProcessor processor;
    protected BpmnModel model;
    protected ObjectNode flowElementNode;
    protected double subProcessX;
    protected double subProcessY;
    protected ArrayNode shapesArrayNode;

    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        this.model = model;
        this.processor = processor;
        this.subProcessX = subProcessX;
        this.subProcessY = subProcessY;
        this.shapesArrayNode = shapesArrayNode;
        GraphicInfo graphicInfo = model.getGraphicInfo(baseElement.getId());
        String stencilId = baseElement.getType();
        this.flowElementNode = graphicInfo != null ? BpmnJsonConverterUtil.createChildShape(baseElement.getId(), stencilId, graphicInfo.getX() - subProcessX + graphicInfo.getWidth(), graphicInfo.getY() - subProcessY + graphicInfo.getHeight(), graphicInfo.getX() - subProcessX, graphicInfo.getY() - subProcessY) : BpmnJsonConverterUtil.createChildShape(baseElement.getId(), stencilId, 0.0, 0.0, 0.0, 0.0);
        shapesArrayNode.add((JsonNode)this.flowElementNode);
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("itemId", baseElement.getId());
        if (baseElement instanceof FlowElement) {
            FlowElement flowElement = (FlowElement)baseElement;
            if (StringUtils.isNotEmpty((String)flowElement.getStyle())) {
                this.flowElementNode.put("style", flowElement.getStyle());
            }
            this.flowElementNode.put("dynamic", flowElement.isDynamic());
            this.flowElementNode.put("addSign", flowElement.isAddSign());
            if (flowElement instanceof AuditTask) {
                this.flowElementNode.put("addSignMsg", SerializationUtils.toJsonString(((AuditTask)flowElement).getAddSignMsg()));
            } else if (flowElement instanceof CallActivity) {
                this.flowElementNode.put("addSignMsg", SerializationUtils.toJsonString(((CallActivity)flowElement).getAddSignMsg()));
            }
        }
        this.convertElementToJson(propertiesNode, baseElement);
        this.flowElementNode.put("properties", (JsonNode)propertiesNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        if (baseElement instanceof FlowNode) {
            FlowNode flowNode = (FlowNode)baseElement;
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getId()));
            }
            for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                if (!messageFlow.getSourceRef().equals(flowNode.getId())) continue;
                outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getId()));
            }
        }
        this.flowElementNode.put("outgoing", (JsonNode)outgoingArrayNode);
    }

    public void convertToBpmnModel(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, BpmnModel bpmnModel) {
        Lane lane;
        FlowElement flowElement;
        this.processor = processor;
        this.model = bpmnModel;
        BaseElement baseElement = this.convertJsonToElement(elementNode, modelNode, shapeMap, parentElement);
        baseElement.setId(BpmnJsonConverterUtil.getElementId(elementNode));
        if (baseElement instanceof FlowElement) {
            JsonNode orderArray;
            JsonNode flowOrderNode;
            flowElement = (FlowElement)baseElement;
            flowElement.setName(this.getPropertyValueAsString("name", elementNode));
            flowElement.setDocumentation(this.getPropertyValueAsString("documentation", elementNode));
            flowElement.setType(BpmnJsonConverterUtil.getStencilId(elementNode));
            JsonNode styleNode = elementNode.get("style");
            if (styleNode != null) {
                flowElement.setStyle(styleNode.asText());
            }
            if (elementNode.get("dynamic") != null) {
                flowElement.setDynamic(elementNode.get("dynamic").booleanValue());
            }
            if (elementNode.get("addSign") != null) {
                flowElement.setAddSign(elementNode.get("addSign").booleanValue());
            }
            if (baseElement instanceof Activity) {
                Activity activity = (Activity)baseElement;
                activity.setAsynchronous(this.getPropertyValueAsBoolean("asynchronousdefinition", elementNode));
                activity.setNotExclusive(!this.getPropertyValueAsBoolean("exclusivedefinition", elementNode));
                String multiInstanceType = this.getPropertyValueAsString("multiinstance_type", elementNode);
                String multiInstanceCardinality = this.getPropertyValueAsString("multiinstance_cardinality", elementNode);
                String multiInstanceCollection = this.getPropertyValueAsString("multiinstance_collection", elementNode);
                String multiInstanceCondition = this.getPropertyValueAsString("multiinstance_condition", elementNode);
                if (StringUtils.isNotEmpty((String)multiInstanceType) && !"none".equalsIgnoreCase(multiInstanceType)) {
                    String multiInstanceVariable = this.getPropertyValueAsString("multiinstance_variable", elementNode);
                    MultiInstanceLoopCharacteristics multiInstanceObject = new MultiInstanceLoopCharacteristics();
                    if ("sequential".equalsIgnoreCase(multiInstanceType)) {
                        multiInstanceObject.setSequential(true);
                    } else {
                        multiInstanceObject.setSequential(false);
                    }
                    multiInstanceObject.setLoopCardinality(multiInstanceCardinality);
                    multiInstanceObject.setInputDataItem(multiInstanceCollection);
                    multiInstanceObject.setElementVariable(multiInstanceVariable);
                    multiInstanceObject.setCompletionCondition(multiInstanceCondition);
                    activity.setLoopCharacteristics(multiInstanceObject);
                }
            } else if (baseElement instanceof Gateway && (flowOrderNode = this.getProperty("sequencefloworder", elementNode)) != null && (orderArray = (flowOrderNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(flowOrderNode)).get("sequenceFlowOrder")) != null && orderArray.size() > 0) {
                for (JsonNode orderNode : orderArray) {
                    ExtensionElement orderElement = new ExtensionElement();
                    orderElement.setName("EDITOR_FLOW_ORDER");
                    orderElement.setElementText(orderNode.asText());
                    flowElement.addExtensionElement(orderElement);
                }
            }
        }
        if (baseElement instanceof FlowElement) {
            flowElement = (FlowElement)baseElement;
            if (flowElement instanceof SequenceFlow) {
                ExtensionElement idExtensionElement = new ExtensionElement();
                idExtensionElement.setName("EDITOR_RESOURCEID");
                idExtensionElement.setElementText(elementNode.get("resourceId").asText());
                flowElement.addExtensionElement(idExtensionElement);
            }
            if (parentElement instanceof Process) {
                ((Process)parentElement).addFlowElement(flowElement);
            } else if (parentElement instanceof SubProcess) {
                ((SubProcess)parentElement).addFlowElement(flowElement);
            } else if (parentElement instanceof Lane) {
                lane = (Lane)parentElement;
                lane.getFlowReferences().add(flowElement.getId());
                lane.getParentProcess().addFlowElement(flowElement);
            }
            if (baseElement instanceof AuditTask) {
                if (elementNode.get("addSignMsg") == null) {
                    ((AuditTask)baseElement).setAddSignMsg(null);
                } else {
                    ((AuditTask)baseElement).setAddSignMsg((Map)SerializationUtils.fromJsonString((String)elementNode.get("addSignMsg").asText(), Map.class));
                }
            } else if (baseElement instanceof CallActivity) {
                if (elementNode.get("addSignMsg") == null) {
                    ((CallActivity)baseElement).setAddSignMsg(null);
                } else {
                    ((CallActivity)baseElement).setAddSignMsg((Map)SerializationUtils.fromJsonString((String)elementNode.get("addSignMsg").asText(), Map.class));
                }
            }
        } else if (baseElement instanceof Artifact) {
            Artifact artifact = (Artifact)baseElement;
            if (parentElement instanceof Process) {
                ((Process)parentElement).addArtifact(artifact);
            } else if (parentElement instanceof SubProcess) {
                ((SubProcess)parentElement).addArtifact(artifact);
            } else if (parentElement instanceof Lane) {
                lane = (Lane)parentElement;
                lane.getFlowReferences().add(artifact.getId());
                lane.getParentProcess().addArtifact(artifact);
            }
        }
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        String modelType = "WorkflowModel";
        FlowElementsContainer container = null;
        if (baseElement instanceof FlowElement && (container = ((FlowElement)baseElement).getParentContainer()) instanceof Process) {
            modelType = GraphCodecUtils.getModelTypeByProcessType(((Process)container).getProcessType());
        } else if (baseElement instanceof Process) {
            modelType = GraphCodecUtils.getModelTypeByProcessType(((Process)baseElement).getProcessType());
        }
        this.parseElement(propertiesNode, baseElement, this.getModelProps(modelType, this.getStencilId(baseElement), baseElement.getClass()));
        this.disposeExtensionAttributes(propertiesNode, baseElement);
    }

    protected void disposeExtensionAttributes(ObjectNode propertiesNode, BaseElement baseElement) {
        if (!baseElement.getAttributes().isEmpty()) {
            for (List<ExtensionAttribute> attributes : baseElement.getAttributes().values()) {
                for (ExtensionAttribute attribute : attributes) {
                    this.disposeExtensionAttribute(attribute, propertiesNode);
                }
            }
        }
    }

    protected void disposeExtensionAttribute(ExtensionAttribute attribute, ObjectNode propertiesNode) {
        String value = attribute.getValue();
        String type = attribute.getType();
        if (JsonNodeType.ARRAY.name().equals(type)) {
            this.setPropertyArrayValue(attribute.getName(), value, propertiesNode);
        } else if (JsonNodeType.BOOLEAN.name().equals(type)) {
            this.setPropertyValue(propertiesNode, attribute.getName(), Boolean.parseBoolean(value));
        } else {
            this.setPropertyValue(attribute.getName(), value, propertiesNode);
        }
    }

    private void setPropertyArrayValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        try {
            ArrayNode array = (ArrayNode)this.objectMapper.readValue(value, ArrayNode.class);
            this.setPropertyValue(propertiesNode, name, array);
        }
        catch (JsonProcessingException e) {
            log.error(WfUtils.getExceptionStacktrace(e));
        }
    }

    private void setPropertyValue(ObjectNode propertiesNode, String name, Object value) {
        String[] paths = name.split("\\.");
        ObjectNode parent = propertiesNode;
        int length = paths.length - 1;
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            JsonNode node = parent.get(path);
            if (!(node instanceof ObjectNode)) {
                node = this.objectMapper.createObjectNode();
                parent.put(path, node);
            }
            parent = (ObjectNode)node;
        }
        if (value instanceof JsonNode) {
            parent.put(paths[length], (JsonNode)value);
        } else if (value instanceof Boolean) {
            parent.put(paths[length], (Boolean)value);
        } else {
            parent.put(paths[length], String.valueOf(value));
        }
    }

    protected List<PropInfo> getModelProps(String modelType, String type, Class clazz) {
        ArrayList<PropInfo> modelProp = new ArrayList<PropInfo>();
        List<Property> properties = this.getModelPropertiesByType(modelType, type);
        Method md = null;
        String groupName = null;
        String name = null;
        for (Property prop : properties) {
            groupName = prop.getGroupId();
            PropertyDescriptor field = this.findField(prop.getPropertyName(), groupName, clazz);
            if (field == null || (md = field.getReadMethod()) == null || md.getAnnotation(TransIgnore.class) != null) continue;
            name = WfUtils.isNotEmpty(groupName) ? groupName + "." + prop.getPropertyName() : prop.getPropertyName();
            modelProp.add(new PropInfo(name, field.getPropertyType()));
        }
        return modelProp;
    }

    protected List<PropInfo> getModelProps(Class type) {
        PropertyDescriptor[] descs;
        ArrayList<PropInfo> modelProp = new ArrayList<PropInfo>();
        for (PropertyDescriptor desc : descs = PropertyUtils.getPropertyDescriptors((Class)type)) {
            Method md;
            if (GraphCodecUtils.isIgnore(desc.getName()) || (md = desc.getReadMethod()) != null && md.getAnnotation(TransIgnore.class) != null) continue;
            modelProp.add(new PropInfo(desc.getName(), desc.getPropertyType()));
        }
        return modelProp;
    }

    protected PropertyDescriptor findField(String fieldName, String groupName, Class clazz) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        Class<?> group = null;
        PropertyDescriptor[] fields = PropertyUtils.getPropertyDescriptors((Class)clazz);
        PropertyDescriptor propField = null;
        for (PropertyDescriptor field : fields) {
            if (groupName != null && groupName.equals(field.getName())) {
                group = field.getPropertyType();
            }
            if (!fieldName.equals(field.getName())) continue;
            propField = field;
            break;
        }
        if (group != null) {
            PropertyDescriptor groupField = this.findField(fieldName, null, group);
            return groupField != null ? groupField : propField;
        }
        return propField;
    }

    protected void parseElement(ObjectNode propNode, HasExtensionAttributes baseElement, List<PropInfo> modelProps) {
        String fieldName = null;
        String groupName = null;
        ObjectNode propertiesNode = null;
        for (PropInfo field : modelProps) {
            Object source;
            Object obj = null;
            propertiesNode = propNode;
            fieldName = field.getName();
            if (this.isIgnore(fieldName, propNode, baseElement)) continue;
            if (fieldName.indexOf(46) > 0) {
                String[] names = fieldName.split("\\.");
                groupName = names[0];
                fieldName = names[1];
                if (propNode.get(groupName) == null) {
                    propertiesNode = this.objectMapper.createObjectNode();
                    propNode.put(groupName, (JsonNode)propertiesNode);
                } else {
                    propertiesNode = (ObjectNode)propNode.get(groupName);
                }
            }
            try {
                obj = SpecialPropertyUtil.getProperty(baseElement, field.getName());
            }
            catch (Exception e) {
                log.error(WfUtils.getExceptionStacktrace(e));
            }
            if (obj == null) continue;
            if (field.getType().isAssignableFrom(String.class)) {
                this.setPropertyValue(fieldName, String.valueOf(obj), propertiesNode);
                continue;
            }
            if (obj instanceof ILocaleString && field.getType().isAssignableFrom(ILocaleString.class)) {
                this.setLocaleStringValue(fieldName, (ILocaleString)obj, propertiesNode);
                continue;
            }
            if (field.getType().isAssignableFrom(Integer.class) || field.getType().isAssignableFrom(Integer.TYPE)) {
                propertiesNode.put(fieldName, ((Integer)obj).intValue());
                continue;
            }
            if (field.getType().isAssignableFrom(Boolean.class) || field.getType().isAssignableFrom(Boolean.TYPE)) {
                propertiesNode.put(fieldName, ((Boolean)obj).booleanValue());
                continue;
            }
            if (field.getType().isAssignableFrom(Long.class) || field.getType().isAssignableFrom(Long.TYPE)) {
                propertiesNode.put(fieldName, ((Long)obj).longValue());
                continue;
            }
            if (field.getType().isAssignableFrom(Double.class) || field.getType().isAssignableFrom(Double.TYPE)) {
                propertiesNode.put(fieldName, ((Double)obj).doubleValue());
                continue;
            }
            if (field.getType().isAssignableFrom(List.class)) {
                source = (List)obj;
                if (source.size() <= 0) continue;
                ArrayNode itemsNode = this.objectMapper.createArrayNode();
                for (int i = 0; i < source.size(); ++i) {
                    Object single = source.get(i);
                    if (single instanceof HasExtensionAttributes) {
                        ObjectNode tmp = this.objectMapper.createObjectNode();
                        this.parseElement(tmp, (HasExtensionAttributes)single, this.getModelProps(single.getClass()));
                        if (single instanceof BaseElement) {
                            this.disposeExtensionAttributes(tmp, (BaseElement)single);
                        }
                        itemsNode.add((JsonNode)tmp);
                        continue;
                    }
                    if (single instanceof String) {
                        itemsNode.add((String)single);
                        continue;
                    }
                    if (single instanceof Integer) {
                        itemsNode.add((Integer)single);
                        continue;
                    }
                    if (single instanceof Double) {
                        itemsNode.add((Double)single);
                        continue;
                    }
                    if (single instanceof BigDecimal) {
                        itemsNode.add((BigDecimal)single);
                        continue;
                    }
                    if (single instanceof Boolean) {
                        itemsNode.add((Boolean)single);
                        continue;
                    }
                    if (!(single instanceof Long)) continue;
                    itemsNode.add((Long)single);
                }
                propertiesNode.put(fieldName, (JsonNode)itemsNode);
                propertiesNode = propNode;
                continue;
            }
            if (field.getType().isAssignableFrom(Map.class) && "extAttrGroup".equals(fieldName)) {
                source = (Map)obj;
                ObjectNode objectsNode = this.objectMapper.createObjectNode();
                Set entrySet = source.entrySet();
                for (Map.Entry single : entrySet) {
                    JsonNode extAttrValueJsonNode;
                    String key = (String)single.getKey();
                    ObjectNode extendAttributeGroupMap = this.objectMapper.createObjectNode();
                    ExtendAttributeGroup value = (ExtendAttributeGroup)single.getValue();
                    extendAttributeGroupMap.put("groupEnable", value.isGroupEnable());
                    ObjectMapper objectMapper = new ObjectMapper();
                    if (value.getExtAttrValue() != null && (extAttrValueJsonNode = objectMapper.valueToTree(value.getExtAttrValue())) != null && !(extAttrValueJsonNode instanceof NullNode)) {
                        extendAttributeGroupMap.put("extAttrValue", (JsonNode)((ObjectNode)objectMapper.valueToTree(value.getExtAttrValue())));
                    }
                    objectsNode.put(key, (JsonNode)extendAttributeGroupMap);
                }
                propertiesNode.put(fieldName, (JsonNode)objectsNode);
                continue;
            }
            if (!(obj instanceof HasExtensionAttributes)) continue;
            ObjectNode tmp = this.objectMapper.createObjectNode();
            this.parseElement(tmp, (HasExtensionAttributes)obj, this.getModelProps(obj.getClass()));
            propertiesNode.put(fieldName, (JsonNode)tmp);
            propertiesNode = propNode;
        }
    }

    protected boolean isIgnore(String fieldName, ObjectNode propNode, HasExtensionAttributes baseElement) {
        return false;
    }

    protected abstract BaseElement newInstanceElement(JsonNode var1);

    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        BaseElement elem = this.newInstanceElement(elementNode);
        elem.setId(BpmnJsonConverterUtil.getElementId(elementNode));
        if (elem instanceof FlowElement) {
            ((FlowElement)elem).setType(BpmnJsonConverterUtil.getStencilId(elementNode));
        }
        if (elementNode.get("properties") != null) {
            JsonNode propertiesNode = elementNode.get("properties");
            elem = (BaseElement)this.parseJsonNode(null, propertiesNode, elem, elem, rootElement, null);
        }
        return elem;
    }

    protected Object parseJsonNode(String key, JsonNode elementNode, String clazz, BaseElement elem, BaseElement rootElement, String arrKey) {
        Class cls = TypesContainer.getOrRegister((String)clazz);
        if (ISupportJsonTransfer.class.isAssignableFrom(cls) && !cls.getName().endsWith("Impl")) {
            clazz = clazz + "Impl";
        }
        Object obj = TypesContainer.createInstance((String)clazz);
        return this.parseJsonNode(key, elementNode, obj, elem, rootElement, arrKey);
    }

    protected Object parseJsonNode(String key, JsonNode elementNode, Object obj, BaseElement elem, BaseElement rootElement, String arrKey) {
        if (elementNode instanceof ObjectNode) {
            Iterator iter = elementNode.fields();
            while (iter.hasNext()) {
                String newKey;
                Map.Entry node = (Map.Entry)iter.next();
                ConvertField field = ConvertField.getConvertField(obj, (String)node.getKey());
                if (field.isIgnore()) continue;
                if (obj != elem && !field.exist()) {
                    field = ConvertField.getConvertField(elem, (String)node.getKey());
                }
                String string = newKey = WfUtils.isNotEmpty(key) ? key + "." + (String)node.getKey() : (String)node.getKey();
                if ("expireModel.expireTime".equals(newKey)) {
                    log.debug("kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter.parseJsonNode()" + node.getValue());
                }
                if (field.exist()) {
                    Object ret;
                    String actType;
                    Type[] arguments;
                    ParameterizedType type;
                    if (field.getType().isAssignableFrom(String.class)) {
                        if (node.getValue() instanceof TextNode) {
                            field.setValue(((JsonNode)node.getValue()).textValue());
                            continue;
                        }
                        if (node.getValue() instanceof LongNode) {
                            field.setValue(String.valueOf(((JsonNode)node.getValue()).longValue()));
                            continue;
                        }
                        if (node.getValue() instanceof IntNode) {
                            field.setValue(String.valueOf(((JsonNode)node.getValue()).intValue()));
                            continue;
                        }
                        if (!(node.getValue() instanceof DoubleNode)) continue;
                        field.setValue(String.valueOf(((JsonNode)node.getValue()).doubleValue()));
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Integer.TYPE) || field.getType().isAssignableFrom(Integer.class)) {
                        if (node.getValue() instanceof TextNode) {
                            field.setValue(Integer.valueOf(((JsonNode)node.getValue()).textValue()));
                            continue;
                        }
                        field.setValue(((JsonNode)node.getValue()).intValue());
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Boolean.TYPE) || field.getType().isAssignableFrom(Boolean.class)) {
                        if (node.getValue() instanceof BooleanNode) {
                            field.setValue(((JsonNode)node.getValue()).booleanValue());
                            continue;
                        }
                        if (node.getValue() instanceof IntNode) {
                            field.setValue(((JsonNode)node.getValue()).intValue() == 1);
                            continue;
                        }
                        if (node.getValue() instanceof TextNode) {
                            field.setValue(Boolean.valueOf(((JsonNode)node.getValue()).textValue()));
                            continue;
                        }
                        this.handleCustomConvert(newKey, obj, elem, rootElement, node);
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Long.TYPE) || field.getType().isAssignableFrom(Long.class)) {
                        if (node.getValue() instanceof TextNode && !WfUtils.isEmpty(((JsonNode)node.getValue()).textValue())) {
                            field.setValue(Long.valueOf(((JsonNode)node.getValue()).textValue()));
                            continue;
                        }
                        field.setValue(((JsonNode)node.getValue()).longValue());
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Double.TYPE) || field.getType().isAssignableFrom(Double.class)) {
                        if (node.getValue() instanceof TextNode) {
                            field.setValue(Double.valueOf(((JsonNode)node.getValue()).textValue()));
                            continue;
                        }
                        field.setValue(((JsonNode)node.getValue()).doubleValue());
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Date.class)) {
                        Timestamp t;
                        if (!(node.getValue() instanceof TextNode) || (t = Timestamp.valueOf(((JsonNode)node.getValue()).textValue())) == null) continue;
                        field.setValue(new Date(t.getTime()));
                        continue;
                    }
                    if (node.getValue() instanceof ArrayNode) {
                        if (field.getType().isAssignableFrom(List.class)) {
                            type = (ParameterizedType)field.getGenericType();
                            arguments = type.getActualTypeArguments();
                            actType = arguments.length > 0 ? arguments[0].getTypeName() : "";
                            ret = this.parseArrayObject(elem, rootElement, (ArrayNode)node.getValue(), actType, newKey);
                            field.setValue(ret);
                            continue;
                        }
                        this.handleCustomConvert(newKey, obj, elem, rootElement, node);
                        continue;
                    }
                    if (field.getType().isAssignableFrom(Map.class) && field.getGenericType() instanceof ParameterizedType) {
                        type = (ParameterizedType)field.getGenericType();
                        arguments = type.getActualTypeArguments();
                        actType = arguments[1].getTypeName();
                        ret = new HashMap();
                        JsonNode nodeValue = (JsonNode)node.getValue();
                        Iterator nodeValueFieldsIter = nodeValue.fields();
                        while (nodeValueFieldsIter.hasNext()) {
                            Map.Entry nodeValueFieldsEntry = (Map.Entry)nodeValueFieldsIter.next();
                            String mapKey = (String)nodeValueFieldsEntry.getKey();
                            JsonNode entryValue = (JsonNode)nodeValueFieldsEntry.getValue();
                            Object actTypeInstance = TypesContainer.createInstance((String)actType);
                            Object resultValue = this.parseJsonNode((String)node.getKey(), entryValue, actTypeInstance, elem, rootElement, newKey);
                            ret.put(mapKey, resultValue);
                        }
                        field.setValue(ret);
                        continue;
                    }
                    if (node.getValue() instanceof ObjectNode) {
                        if (field.getType().isPrimitive()) {
                            this.handleCustomConvert(newKey, obj, elem, rootElement, node);
                            continue;
                        }
                        if (ILocaleString.class == field.getType()) {
                            field.setValue(this.parseLocaleString((JsonNode)node.getValue()));
                            continue;
                        }
                        if (field instanceof EntityConvertField && field.getType().getName().equals("kd.bos.dataentity.entity.DynamicObject")) continue;
                        Object ret2 = this.parseJsonNode(newKey, (JsonNode)node.getValue(), field.getType().getName(), elem, rootElement, arrKey);
                        field.setValue(ret2);
                        continue;
                    }
                    this.handleCustomConvert(newKey, obj, elem, rootElement, node);
                    continue;
                }
                if (node.getValue() instanceof ObjectNode) {
                    this.parseJsonNode(newKey, (JsonNode)node.getValue(), obj, elem, rootElement, arrKey);
                    continue;
                }
                this.handleCustomConvert(newKey, obj, elem, rootElement, node);
            }
            if (obj instanceof IDynamicPartial && rootElement instanceof Process) {
                DynamicModelPartial partial = new DynamicModelPartial();
                partial.setPartial((IDynamicPartial)obj);
                partial.setFlowElement(elem);
                partial.setPartialPropertyName(((IDynamicPartial)obj).getPartialType());
                ((Process)rootElement).addDynamicModelPartial(partial);
            }
            if (obj instanceof IBaseData && rootElement instanceof Process) {
                BaseDataRecord baseDataRecord = new BaseDataRecord();
                baseDataRecord.setBaseData((IBaseData)obj);
                baseDataRecord.setFlowElement(elem);
                if (WfUtils.isEmpty(key)) {
                    baseDataRecord.setKey(arrKey);
                } else {
                    baseDataRecord.setKey(WfUtils.isEmpty(arrKey) ? key : arrKey + "." + key);
                }
                ((Process)rootElement).addBaseDataRecord(baseDataRecord);
            }
            return obj;
        }
        if (elementNode instanceof TextNode) {
            return ((TextNode)elementNode).textValue();
        }
        if (elementNode instanceof LongNode) {
            return ((LongNode)elementNode).longValue();
        }
        if (elementNode instanceof IntNode) {
            return ((IntNode)elementNode).intValue();
        }
        if (elementNode instanceof DoubleNode) {
            return ((DoubleNode)elementNode).doubleValue();
        }
        if (elementNode instanceof BooleanNode) {
            return ((BooleanNode)elementNode).booleanValue();
        }
        return elementNode.asText();
    }

    protected List parseArrayObject(BaseElement elem, BaseElement rootElement, ArrayNode arrNode, String actType, String arrKey) {
        ArrayList<Object> ret = new ArrayList<Object>();
        Iterator it = arrNode.elements();
        while (it.hasNext()) {
            ret.add(this.parseJsonNode(null, (JsonNode)it.next(), actType, elem, rootElement, arrKey));
        }
        return ret;
    }

    protected ILocaleString parseLocaleString(JsonNode elementNode) {
        LocaleString localeStr = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String key = lang.name();
            JsonNode value = elementNode.get(key);
            if (value == null) continue;
            localeStr.setItem(key, (Object)value.toString().replaceAll("\"", ""));
        }
        return localeStr;
    }

    protected void handleCustomConvert(String key, Object obj, BaseElement elem, BaseElement rootElement, Map.Entry<String, JsonNode> node) {
        if (obj instanceof HasExtensionAttributes) {
            BaseBpmnJsonConverter.addCustomAttributes(key, node.getValue(), (HasExtensionAttributes)obj);
        }
    }

    protected void convertJsonToChildProp(String key, JsonNode value, HasExtensionAttributes obj, BaseElement elem, BaseElement rootElement) {
    }

    public static void addCustomAttributes(String key, JsonNode node, HasExtensionAttributes element) {
        ExtensionAttribute extensionAttribute = new ExtensionAttribute();
        extensionAttribute.setName(key);
        if (node instanceof TextNode) {
            extensionAttribute.setValue(node.textValue());
        } else if (node instanceof IntNode) {
            extensionAttribute.setValue(String.valueOf(node.intValue()));
        } else if (node instanceof BooleanNode) {
            extensionAttribute.setValue(String.valueOf(node.booleanValue()));
        } else if (node instanceof LongNode) {
            extensionAttribute.setValue(String.valueOf(node.longValue()));
        } else if (node instanceof DoubleNode) {
            extensionAttribute.setValue(String.valueOf(node.doubleValue()));
        } else if (node instanceof ObjectNode) {
            extensionAttribute.setValue(SerializationUtils.toJsonString((Object)node));
        } else if (node instanceof ArrayNode) {
            extensionAttribute.setValue(SerializationUtils.toJsonString((Object)node));
        }
        extensionAttribute.setType(String.valueOf(node.getNodeType()));
        element.addAttribute(extensionAttribute);
    }

    protected abstract String getStencilId(BaseElement var1);

    protected void setPropertyValue(String name, String value, ObjectNode propertiesNode) {
        if (StringUtils.isNotEmpty((String)value)) {
            this.setPropertyValue(propertiesNode, name, value);
        }
    }

    protected void setLocaleStringValue(String name, ILocaleString localeValue, ObjectNode propertiesNode) {
        ObjectNode value = this.objectMapper.createObjectNode();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String key = lang.name();
            String temp = (String)localeValue.getItem(key);
            if (!WfUtils.isNotEmpty(temp)) continue;
            value.put(key, temp);
        }
        if (value.size() == 0) {
            return;
        }
        String[] paths = name.split("\\.");
        if (paths.length < 2) {
            propertiesNode.put(name, (JsonNode)value);
        } else {
            JsonNode group = propertiesNode.get(paths[0]);
            group = group != null ? group : this.objectMapper.createObjectNode();
            ((ObjectNode)group).put(paths[1], (JsonNode)value);
            propertiesNode.put(paths[0], group);
        }
    }

    protected void addFieldExtensions(List<FieldExtension> extensions, ObjectNode propertiesNode) {
        ObjectNode fieldExtensionsNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (FieldExtension extension : extensions) {
            ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
            propertyItemNode.put("name", extension.getFieldName());
            if (StringUtils.isNotEmpty((String)extension.getStringValue())) {
                propertyItemNode.put("stringValue", extension.getStringValue());
            }
            if (StringUtils.isNotEmpty((String)extension.getExpression())) {
                propertyItemNode.put("expression", extension.getExpression());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        fieldExtensionsNode.put("fields", (JsonNode)itemsNode);
        propertiesNode.put("servicetaskfields", (JsonNode)fieldExtensionsNode);
    }

    protected void addEventProperties(Event event, ObjectNode propertiesNode) {
        List<EventDefinition> eventDefinitions = event.getEventDefinitions();
        if (eventDefinitions.size() == 1) {
            EventDefinition eventDefinition = eventDefinitions.get(0);
            if (eventDefinition instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDefinition = (ErrorEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((String)errorDefinition.getErrorCode())) {
                    propertiesNode.put("errorref", errorDefinition.getErrorCode());
                }
            } else if (eventDefinition instanceof SignalEventDefinition) {
                SignalEventDefinition signalDefinition = (SignalEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((String)signalDefinition.getSignalRef())) {
                    propertiesNode.put("signalref", signalDefinition.getSignalRef());
                }
            } else if (eventDefinition instanceof MessageEventDefinition) {
                MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((String)messageDefinition.getMessageRef())) {
                    propertiesNode.put("messageref", messageDefinition.getMessageRef());
                }
            } else if (eventDefinition instanceof TimerEventDefinition) {
                TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
                if (StringUtils.isNotEmpty((String)timerDefinition.getTimeDuration())) {
                    propertiesNode.put("timerdurationdefinition", timerDefinition.getTimeDuration());
                }
                if (StringUtils.isNotEmpty((String)timerDefinition.getTimeCycle())) {
                    propertiesNode.put("timercycledefinition", timerDefinition.getTimeCycle());
                }
                if (StringUtils.isNotEmpty((String)timerDefinition.getTimeDate())) {
                    propertiesNode.put("timerdatedefinition", timerDefinition.getTimeDate());
                }
                if (StringUtils.isNotEmpty((String)timerDefinition.getEndDate())) {
                    propertiesNode.put("timerenddatedefinition", timerDefinition.getEndDate());
                }
            } else if (eventDefinition instanceof TerminateEventDefinition) {
                TerminateEventDefinition terminateEventDefinition = (TerminateEventDefinition)eventDefinition;
                propertiesNode.put("terminateall", terminateEventDefinition.isTerminateAll());
                propertiesNode.put("terminateMultiInstance", terminateEventDefinition.isTerminateMultiInstance());
            }
        }
    }

    protected void convertJsonToTimerDefinition(JsonNode objectNode, Event event) {
        String timeDate = this.getPropertyValueAsString("timerdatedefinition", objectNode);
        String timeCycle = this.getPropertyValueAsString("timercycledefinition", objectNode);
        String timeDuration = this.getPropertyValueAsString("timerdurationdefinition", objectNode);
        String endDate = this.getPropertyValueAsString("timerenddatedefinition", objectNode);
        TimerEventDefinition eventDefinition = new TimerEventDefinition();
        if (StringUtils.isNotEmpty((String)timeDate)) {
            eventDefinition.setTimeDate(timeDate);
        } else if (StringUtils.isNotEmpty((String)timeCycle)) {
            eventDefinition.setTimeCycle(timeCycle);
        } else if (StringUtils.isNotEmpty((String)timeDuration)) {
            eventDefinition.setTimeDuration(timeDuration);
        }
        if (StringUtils.isNotEmpty((String)endDate)) {
            eventDefinition.setEndDate(endDate);
        }
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToSignalDefinition(JsonNode objectNode, Event event) {
        String signalRef = this.getPropertyValueAsString("signalref", objectNode);
        SignalEventDefinition eventDefinition = new SignalEventDefinition();
        eventDefinition.setSignalRef(signalRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToMessageDefinition(JsonNode objectNode, Event event) {
        String messageRef = this.getPropertyValueAsString("messageref", objectNode);
        MessageEventDefinition eventDefinition = new MessageEventDefinition();
        eventDefinition.setMessageRef(messageRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToMessageDefinition(Event event, String messageRef) {
        MessageEventDefinition eventDefinition = new MessageEventDefinition();
        eventDefinition.setMessageRef(messageRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected void convertJsonToErrorDefinition(JsonNode objectNode, Event event) {
        String errorRef = this.getPropertyValueAsString("errorref", objectNode);
        ErrorEventDefinition eventDefinition = new ErrorEventDefinition();
        eventDefinition.setErrorCode(errorRef);
        event.getEventDefinitions().add(eventDefinition);
    }

    protected String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    protected boolean getValueAsBoolean(String name, JsonNode objectNode) {
        boolean propertyValue = false;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asBoolean();
        }
        return propertyValue;
    }

    protected List<String> getValueAsList(String name, JsonNode objectNode) {
        String fieldName = "value";
        ArrayList<String> resultList = new ArrayList<String>();
        JsonNode valuesNode = objectNode.get(name);
        if (valuesNode != null) {
            for (JsonNode valueNode : valuesNode) {
                if (valueNode.get(fieldName) == null || valueNode.get(fieldName).isNull()) continue;
                resultList.add(valueNode.get(fieldName).asText());
            }
        }
        return resultList;
    }

    protected String getPropertyValueAsString(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsString(name, objectNode);
    }

    protected boolean getPropertyValueAsBoolean(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsBoolean(name, objectNode);
    }

    protected List<String> getPropertyValueAsList(String name, JsonNode objectNode) {
        return JsonConverterUtil.getPropertyValueAsList(name, objectNode);
    }

    protected JsonNode getProperty(String name, JsonNode objectNode) {
        return JsonConverterUtil.getProperty(name, objectNode);
    }

    protected String convertListToCommaSeparatedString(List<String> stringList) {
        String resultString = null;
        if (stringList != null && !stringList.isEmpty()) {
            StringBuilder expressionBuilder = new StringBuilder();
            for (String singleItem : stringList) {
                if (expressionBuilder.length() > 0) {
                    expressionBuilder.append(',');
                }
                expressionBuilder.append(singleItem);
            }
            resultString = expressionBuilder.toString();
        }
        return resultString;
    }

    protected void setAllPropertiesToFlow(JsonNode elementNode, FlowElement elem) {
        if (elementNode.get("properties") != null) {
            JsonNode propertiesNode = elementNode.get("properties");
            Iterator iter = propertiesNode.fields();
            while (iter.hasNext()) {
                Map.Entry node = (Map.Entry)iter.next();
                Field field = ReflectUtil.getField((String)node.getKey(), elem);
                if (field == null) continue;
                if (field.getType().isAssignableFrom(String.class)) {
                    ReflectUtil.setField(field, elem, ((JsonNode)node.getValue()).textValue());
                    continue;
                }
                if (field.getType().isAssignableFrom(Integer.TYPE)) {
                    ReflectUtil.setField(field, elem, ((JsonNode)node.getValue()).intValue());
                    continue;
                }
                if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                    ReflectUtil.setField(field, elem, ((JsonNode)node.getValue()).booleanValue());
                    continue;
                }
                if (field.getType().isAssignableFrom(Long.TYPE)) {
                    ReflectUtil.setField(field, elem, ((JsonNode)node.getValue()).longValue());
                    continue;
                }
                if (!field.getType().isAssignableFrom(Double.TYPE)) continue;
                ReflectUtil.setField(field, elem, ((JsonNode)node.getValue()).doubleValue());
            }
        }
    }

    private List<Property> getModelPropertiesByType(String modelType, String type) {
        return GraphCodecUtils.getNodeProperties(modelType, type);
    }

    public void messageCompatible(JsonNode elementNode, FlowElement userTask, BaseElement rootElement) {
        String notify;
        if (userTask instanceof IMessageSupport && WfUtils.isNotEmpty(notify = userTask.getAttributeValue("message.notify"))) {
            if ("TRUE".equalsIgnoreCase(notify)) {
                ArrayList<MessageSendModel> models = new ArrayList<MessageSendModel>();
                MessageSendModel model = new MessageSendModel();
                model.setNotify(Boolean.parseBoolean(notify));
                model.setContent(userTask.getAttributeValue("message.content"));
                model.setMessagetype("notify");
                model.setNotifytype(userTask.getAttributeValue("message.notifyType"));
                String receiver = userTask.getAttributeValue("message.notifyReceivers");
                try {
                    JsonNode jsonNode = new ObjectMapper().readTree(receiver);
                    List ret = this.parseArrayObject(userTask, rootElement, (ArrayNode)jsonNode, ParticipantModelEntityImpl.class.getName(), null);
                    if (ret != null && ret.size() > 0) {
                        model.setReceiver(ret);
                    }
                }
                catch (Exception e) {
                    log.warn("\u517c\u5bb9\u65e7\u7248\u4eba\u5de5\u7c7b\u578b\u8282\u70b9\uff0c\u5728\u8f6c\u6362notifyReceivers\u65f6\u51fa\u9519:" + WfUtils.getExceptionStacktrace(e));
                }
                models.add(model);
                ((IMessageSupport)((Object)userTask)).setOutMsg(models);
            }
            userTask.removeAttribute("message.notify", "message.content", "message.notifyType", "message.notifyReceivers");
        }
    }

    protected static class PropInfo {
        private String name;
        private Class type;

        PropInfo(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class getType() {
            return this.type;
        }
    }
}

