/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.CompensateBackSet;
import kd.bos.workflow.bpmn.model.CompensateEventDefinition;
import kd.bos.workflow.bpmn.model.ErrorEventDefinition;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.engine.WfUtils;

public class BoundaryEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        BoundaryEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        BoundaryEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("BoundaryTimerEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryErrorEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundarySignalEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryMessageEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryCancelEvent", BoundaryEventJsonConverter.class);
        convertersToBpmnMap.put("BoundaryCompensateEvent", BoundaryEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(BoundaryEvent.class, BoundaryEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)baseElement;
        List<EventDefinition> eventDefinitions = boundaryEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "BoundaryTimerEvent";
        }
        EventDefinition eventDefinition = eventDefinitions.get(0);
        if (eventDefinition instanceof ErrorEventDefinition) {
            return "BoundaryErrorEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "BoundarySignalEvent";
        }
        if (eventDefinition instanceof MessageEventDefinition) {
            return "BoundaryMessageEvent";
        }
        if (eventDefinition instanceof CancelEventDefinition) {
            return "BoundaryCancelEvent";
        }
        if (eventDefinition instanceof CompensateEventDefinition) {
            return "BoundaryCompensateEvent";
        }
        return "BoundaryTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        super.convertElementToJson(propertiesNode, baseElement);
        BoundaryEvent boundaryEvent = (BoundaryEvent)baseElement;
        propertiesNode.put("attachedToRefId", boundaryEvent.getAttachedToRefId());
        ObjectNode offset = this.objectMapper.createObjectNode();
        offset.put("x", "-12");
        offset.put("y", "-12");
        ObjectNode bounds = (ObjectNode)this.flowElementNode.get("bounds");
        bounds.put("offset", (JsonNode)offset);
        bounds.put("relative", true);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new BoundaryEvent();
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        BoundaryEvent boundaryEvent = (BoundaryEvent)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("BoundaryTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, boundaryEvent);
        } else if ("BoundarySignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, boundaryEvent);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryCancelEvent".equals(stencilId)) {
            CancelEventDefinition cancelEventDefinition = new CancelEventDefinition();
            boundaryEvent.getEventDefinitions().add(cancelEventDefinition);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
        } else if ("BoundaryCompensateEvent".equals(stencilId)) {
            String textJs;
            CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
            boundaryEvent.getEventDefinitions().add(compensateEventDefinition);
            boundaryEvent.setCancelActivity(this.getPropertyValueAsBoolean("cancelactivity", elementNode));
            boundaryEvent.setCompensateSavePoint(this.getPropertyValueAsBoolean("compensateSavePoint", elementNode));
            JsonNode backSetJson = this.getProperty("backSet", elementNode);
            if (backSetJson instanceof ArrayNode) {
                ArrayList<CompensateBackSet> backSets = new ArrayList<CompensateBackSet>(16);
                Iterator iter = backSetJson.iterator();
                while (iter.hasNext()) {
                    CompensateBackSet backset = new CompensateBackSet();
                    JsonNode node = (JsonNode)iter.next();
                    backset.setErrorCode(node.get("errorcode").asText());
                    backset.setBackNode(node.get("backnode").asText());
                    backSets.add(backset);
                }
                compensateEventDefinition.setBackSet(backSets);
            } else if (backSetJson instanceof TextNode && WfUtils.isNotEmpty(textJs = backSetJson.asText())) {
                List items = SerializationUtils.fromJsonStringToList((String)textJs, Map.class);
                ArrayList<CompensateBackSet> backSets = new ArrayList<CompensateBackSet>(16);
                for (Map item : items) {
                    CompensateBackSet backset = new CompensateBackSet();
                    backset.setErrorCode((String)item.get("errorcode"));
                    backset.setBackNode((String)item.get("backnode"));
                    backSets.add(backset);
                }
                compensateEventDefinition.setBackSet(backSets);
            }
        }
        return boundaryEvent;
    }

    private String lookForAttachedRef(String boundaryEventId, JsonNode childShapesNode) {
        String attachedRefId = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !boundaryEventId.equals(resourceNode.asText())) continue;
                        attachedRefId = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (attachedRefId != null) break;
                }
                if ((attachedRefId = this.lookForAttachedRef(boundaryEventId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return attachedRefId;
    }
}

