/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.ActivityProcessor;
import kd.bos.workflow.bpmn.converter.AuditTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.AutoMicroServiceTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.AutoTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BillTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.BoundaryEventJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.converter.BroadcastTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.CallActivityJsonConverter;
import kd.bos.workflow.bpmn.converter.CatchEventJsonConverter;
import kd.bos.workflow.bpmn.converter.CompensateTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.EndEventJsonConverter;
import kd.bos.workflow.bpmn.converter.EventGatewayJsonConverter;
import kd.bos.workflow.bpmn.converter.EventSubProcessJsonConverter;
import kd.bos.workflow.bpmn.converter.ExclusiveGatewayJsonConverter;
import kd.bos.workflow.bpmn.converter.InclusiveGatewayJsonConverter;
import kd.bos.workflow.bpmn.converter.JudgeTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.MessageFlowJsonConverter;
import kd.bos.workflow.bpmn.converter.NotifyTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.ParallelGatewayJsonConverter;
import kd.bos.workflow.bpmn.converter.ProcessJsonConverter;
import kd.bos.workflow.bpmn.converter.RPATaskJsonConverter;
import kd.bos.workflow.bpmn.converter.SequenceFlowJsonConverter;
import kd.bos.workflow.bpmn.converter.StartEventJsonConverter;
import kd.bos.workflow.bpmn.converter.SubProcessJsonConverter;
import kd.bos.workflow.bpmn.converter.TextAnnotationJsonConverter;
import kd.bos.workflow.bpmn.converter.ThrowEventJsonConverter;
import kd.bos.workflow.bpmn.converter.UserTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.WaitTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.YunzhijiaTaskJsonConverter;
import kd.bos.workflow.bpmn.converter.constants.StencilConstants;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.converter.util.JsonConverterUtil;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AfterAuditModel;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.Artifact;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Event;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.ExtensionElement;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.GraphicOffset;
import kd.bos.workflow.bpmn.model.Lane;
import kd.bos.workflow.bpmn.model.Message;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.MessageFlow;
import kd.bos.workflow.bpmn.model.Pool;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;
import kd.bos.workflow.bpmn.model.SubProcess;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.bpmn.model.basedata.BaseDataRecord;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.persistence.IDynamicResourceItem;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionalRuleHelper;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import org.apache.commons.lang.StringUtils;

public class BpmnJsonConverter
extends StencilConstants
implements ActivityProcessor {
    protected static Log log = LogFactory.getLog(BpmnJsonConverter.class);
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected static Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap = new HashMap<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>>();
    protected static Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap = new HashMap<String, Class<? extends BaseBpmnJsonConverter>>();
    protected static final String OUTGOING = "outgoing";
    protected static final String EDITOR_FLOW_ORDER = "EDITOR_FLOW_ORDER";
    protected static final String EXTPROPS = "extProps";
    protected static final String PROPERTIES = "properties";
    private static final String AFTERAUDIT = "afterAudit";

    public ObjectNode convertDefaultFlowElementToJson(BaseElement baseElement) {
        Class<? extends BaseBpmnJsonConverter> converter = convertersToJsonMap.get(baseElement.getClass());
        if (converter != null) {
            try {
                BaseBpmnJsonConverter converterInstance = converter.newInstance();
                ObjectNode shapeNode = this.objectMapper.createObjectNode();
                ObjectNode stencilNode = this.objectMapper.createObjectNode();
                stencilNode.put("id", baseElement.getType());
                shapeNode.put("stencil", (JsonNode)stencilNode);
                ObjectNode propertiesNode = this.objectMapper.createObjectNode();
                shapeNode.put(PROPERTIES, (JsonNode)propertiesNode);
                if (baseElement instanceof FlowElement) {
                    FlowElement flowElement = (FlowElement)baseElement;
                    if (StringUtils.isNotEmpty((String)flowElement.getStyle())) {
                        shapeNode.put("style", flowElement.getStyle());
                    }
                    shapeNode.put("dynamic", flowElement.isDynamic());
                }
                converterInstance.convertElementToJson(propertiesNode, baseElement);
                return shapeNode;
            }
            catch (Exception e) {
                log.error(String.format("convertDefaultFlowElementToJson error converting {%s}", baseElement), (Throwable)e);
                throw new WFException(WFErrorCode.modelConvertError(), "BpmnModel converter to json error!", e.getMessage());
            }
        }
        return null;
    }

    public ObjectNode convertToJson(BpmnModel model) {
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        double maxX = 0.0;
        double maxY = 0.0;
        GraphicInfo modelGraphic = model.getLocation();
        if (modelGraphic != null) {
            maxX = modelGraphic.getWidth();
            maxY = modelGraphic.getHeight();
        } else {
            for (GraphicInfo flowInfo : model.getLocationMap().values()) {
                if (flowInfo.getX() + flowInfo.getWidth() > maxX) {
                    maxX = flowInfo.getX() + flowInfo.getWidth();
                }
                if (!(flowInfo.getY() + flowInfo.getHeight() > maxY)) continue;
                maxY = flowInfo.getY() + flowInfo.getHeight();
            }
            maxX += 50.0;
            maxY += 50.0;
            if (maxX < 1485.0) {
                maxX = 1485.0;
            }
            if (maxY < 700.0) {
                maxY = 700.0;
            }
        }
        modelNode.put("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode(maxX, maxY, 0.0, 0.0));
        String resourceId = model.getMainProcess().getResourceId();
        modelNode.put("resourceId", WfUtils.isNotEmpty(resourceId) ? resourceId : "node_1");
        ObjectNode stencilNode = this.objectMapper.createObjectNode();
        stencilNode.put("id", "BPMNDiagram");
        modelNode.put("stencil", (JsonNode)stencilNode);
        ObjectNode stencilsetNode = this.objectMapper.createObjectNode();
        stencilsetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        stencilsetNode.put("url", "../editor/stencilsets/bpmn2.0/bpmn2.0.json");
        modelNode.put("stencilset", (JsonNode)stencilsetNode);
        ArrayNode shapesArrayNode = this.objectMapper.createArrayNode();
        Process mainProcess = null;
        mainProcess = model.getPools().size() > 0 ? model.getProcess(model.getPools().get(0).getId()) : model.getMainProcess();
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        ProcessJsonConverter converter = new ProcessJsonConverter();
        ((BaseBpmnJsonConverter)converter).convertElementToJson(propertiesNode, mainProcess);
        BpmnJsonConverterUtil.convertSignalDefinitionsToJson(model, propertiesNode);
        BpmnJsonConverterUtil.convertMessagesToJson(model, propertiesNode);
        if (CollectionUtils.isNotEmpty(mainProcess.getDataObjects())) {
            BpmnJsonConverterUtil.convertDataPropertiesToJson(mainProcess.getDataObjects(), propertiesNode);
        }
        modelNode.put(PROPERTIES, (JsonNode)propertiesNode);
        boolean poolHasDI = false;
        if (!model.getPools().isEmpty()) {
            for (Pool pool : model.getPools()) {
                GraphicInfo graphicInfo = model.getGraphicInfo(pool.getId());
                if (graphicInfo == null) continue;
                poolHasDI = true;
                break;
            }
        }
        if (!model.getPools().isEmpty() && poolHasDI) {
            HashMap<String, ArrayNode> laneMap = new HashMap<String, ArrayNode>();
            for (Pool pool : model.getPools()) {
                GraphicInfo poolGraphicInfo = model.getGraphicInfo(pool.getId());
                if (poolGraphicInfo == null) continue;
                ObjectNode poolNode = BpmnJsonConverterUtil.createChildShape(pool.getId(), "Pool", poolGraphicInfo.getX() + poolGraphicInfo.getWidth(), poolGraphicInfo.getY() + poolGraphicInfo.getHeight(), poolGraphicInfo.getX(), poolGraphicInfo.getY());
                shapesArrayNode.add((JsonNode)poolNode);
                ObjectNode poolPropertiesNode = this.objectMapper.createObjectNode();
                poolPropertiesNode.put("overrideid", pool.getId());
                poolPropertiesNode.put("process_id", pool.getProcessRef());
                if (!pool.isExecutable()) {
                    poolPropertiesNode.put("process_executable", "No");
                }
                if (StringUtils.isNotEmpty((String)pool.getName())) {
                    poolPropertiesNode.put("name", pool.getName());
                }
                poolNode.put(PROPERTIES, (JsonNode)poolPropertiesNode);
                ArrayNode laneShapesArrayNode = this.objectMapper.createArrayNode();
                poolNode.put("childShapes", (JsonNode)laneShapesArrayNode);
                ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
                poolNode.put(OUTGOING, (JsonNode)outgoingArrayNode);
                poolNode.put("style", pool.getStyle());
                Process process = model.getProcess(pool.getId());
                if (process != null) {
                    laneMap.clear();
                    for (Lane lane : process.getLanes()) {
                        GraphicInfo laneGraphicInfo = model.getGraphicInfo(lane.getId());
                        if (laneGraphicInfo == null) continue;
                        ObjectNode laneNode = BpmnJsonConverterUtil.createChildShape(lane.getId(), "Lane", laneGraphicInfo.getX() + laneGraphicInfo.getWidth() - poolGraphicInfo.getX(), laneGraphicInfo.getY() + laneGraphicInfo.getHeight() - poolGraphicInfo.getY(), laneGraphicInfo.getX() - poolGraphicInfo.getX(), laneGraphicInfo.getY() - poolGraphicInfo.getY());
                        laneShapesArrayNode.add((JsonNode)laneNode);
                        ObjectNode lanePropertiesNode = this.objectMapper.createObjectNode();
                        lanePropertiesNode.put("overrideid", lane.getId());
                        if (StringUtils.isNotEmpty((String)lane.getName())) {
                            lanePropertiesNode.put("name", lane.getName());
                        }
                        laneNode.put(PROPERTIES, (JsonNode)lanePropertiesNode);
                        ArrayNode elementShapesArrayNode = this.objectMapper.createArrayNode();
                        laneNode.put("childShapes", (JsonNode)elementShapesArrayNode);
                        laneNode.put(OUTGOING, (JsonNode)this.objectMapper.createArrayNode());
                        laneNode.put("style", lane.getStyle());
                        laneMap.put(lane.getId(), elementShapesArrayNode);
                    }
                    for (FlowElement flowElement : process.getFlowElements()) {
                        BaseElement laneForElement = null;
                        GraphicInfo laneGraphicInfo = null;
                        FlowElement lookForElement = null;
                        if (flowElement instanceof SequenceFlow) {
                            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                            lookForElement = model.getFlowElement(sequenceFlow.getSourceRef());
                        } else {
                            lookForElement = flowElement;
                        }
                        for (Lane lane : process.getLanes()) {
                            if (!lane.getFlowReferences().contains(lookForElement.getId())) continue;
                            laneGraphicInfo = model.getGraphicInfo(lane.getId());
                            if (laneGraphicInfo == null) break;
                            laneForElement = lane;
                            break;
                        }
                        if (!(flowElement instanceof SequenceFlow) || laneForElement == null) continue;
                        double graphX = 0.0;
                        double graphY = 0.0;
                        if (laneGraphicInfo != null) {
                            graphX = laneGraphicInfo.getX();
                            graphY = laneGraphicInfo.getY();
                        }
                        this.processFlowElement(flowElement, process, model, (ArrayNode)laneMap.get(laneForElement.getId()), graphX, graphY);
                    }
                    this.processArtifacts(process, model, shapesArrayNode, 0.0, 0.0);
                }
                for (MessageFlow messageFlow : model.getMessageFlows().values()) {
                    if (!messageFlow.getSourceRef().equals(pool.getId())) continue;
                    outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(messageFlow.getId()));
                }
            }
            this.processMessageFlows(model, shapesArrayNode);
        } else {
            this.processFlowElements(model.getMainProcess(), model, shapesArrayNode, 0.0, 0.0);
            this.processMessageFlows(model, shapesArrayNode);
        }
        modelNode.put("childShapes", (JsonNode)shapesArrayNode);
        return modelNode;
    }

    @Override
    public void processFlowElements(FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        for (FlowElement flowElement : container.getFlowElements()) {
            this.processFlowElement(flowElement, container, model, shapesArrayNode, subProcessX, subProcessY);
        }
        this.processArtifacts(container, model, shapesArrayNode, subProcessX, subProcessY);
    }

    protected void processFlowElement(FlowElement flowElement, FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double containerX, double containerY) {
        Class<? extends BaseBpmnJsonConverter> converter = convertersToJsonMap.get(flowElement.getClass());
        if (converter != null) {
            try {
                BaseBpmnJsonConverter converterInstance = converter.newInstance();
                converterInstance.convertToJson(flowElement, this, model, container, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                log.error(String.format("processFlowElement error converting {%s}", flowElement), (Throwable)e);
                throw new WFException(WFErrorCode.modelConvertError(), "BpmnModel converter to json error!" + WfUtils.getExceptionStacktrace(e), e.getMessage());
            }
        }
    }

    protected void processArtifacts(FlowElementsContainer container, BpmnModel model, ArrayNode shapesArrayNode, double containerX, double containerY) {
        for (Artifact artifact : container.getArtifacts()) {
            Class<? extends BaseBpmnJsonConverter> converter = convertersToJsonMap.get(artifact.getClass());
            if (converter == null) continue;
            try {
                converter.newInstance().convertToJson(artifact, this, model, container, shapesArrayNode, containerX, containerY);
            }
            catch (Exception e) {
                log.error(String.format("processArtifacts error converting {%s}", artifact), (Throwable)e);
            }
        }
    }

    protected void processMessageFlows(BpmnModel model, ArrayNode shapesArrayNode) {
        MessageFlowJsonConverter jsonConverter = new MessageFlowJsonConverter();
        for (MessageFlow messageFlow : model.getMessageFlows().values()) {
            jsonConverter.convertToJson(messageFlow, this, model, null, shapesArrayNode, 0.0, 0.0);
        }
    }

    public BpmnModel convertToBpmnModel(JsonNode modelNode) {
        return this.convertToBpmnModel(modelNode, null);
    }

    /*
     * WARNING - void declaration
     */
    public BpmnModel convertToBpmnModel(JsonNode modelNode, List<IDynamicResourceItem> dynamicResourceItems) {
        this.mergeDynNodeProperty(modelNode, dynamicResourceItems);
        BpmnModel bpmnModel = new BpmnModel();
        bpmnModel.setTargetNamespace(" ");
        HashMap<String, JsonNode> shapeMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> sourceRefMap = new HashMap<String, JsonNode>();
        HashMap<String, JsonNode> edgeMap = new HashMap<String, JsonNode>();
        HashMap<String, List<JsonNode>> sourceAndTargetMap = new HashMap<String, List<JsonNode>>();
        this.readShapeDI(modelNode, 0.0, 0.0, shapeMap, sourceRefMap, bpmnModel);
        this.readModelDI(modelNode, bpmnModel);
        this.filterAllEdges(modelNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
        this.readEdgeDI(edgeMap, sourceAndTargetMap, bpmnModel);
        ArrayNode shapesArrayNode = (ArrayNode)modelNode.get("childShapes");
        if (shapesArrayNode == null || shapesArrayNode.size() == 0) {
            this.initProcess(bpmnModel, modelNode);
            return bpmnModel;
        }
        HashMap<String, Process> processMap = new HashMap<String, Process>();
        boolean nonEmptyPoolFound = false;
        HashMap<String, Object> elementInLaneMap = new HashMap<String, Object>();
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = BpmnJsonConverterUtil.getStencilId(shapeNode);
            if (!"Pool".equals(stencilId)) continue;
            Pool pool = new Pool();
            pool.setId(BpmnJsonConverterUtil.getElementId(shapeNode));
            pool.setName(JsonConverterUtil.getPropertyValueAsString("name", shapeNode));
            pool.setType(stencilId);
            pool.setStyle(shapeNode.get("style").textValue());
            pool.setProcessRef(JsonConverterUtil.getPropertyValueAsString("process_id", shapeNode));
            pool.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean("process_executable", shapeNode, true));
            bpmnModel.getPools().add(pool);
            String processId = pool.getProcessRef();
            Process process = (Process)processMap.get(processId);
            if (process == null) {
                Process process2 = new Process();
                processMap.put(processId, process2);
                this.initProcessInfo(bpmnModel, modelNode, process2);
                process2.setExecutable(pool.isExecutable());
                bpmnModel.addProcess(process2);
            }
            ArrayNode arrayNode = (ArrayNode)shapeNode.get("childShapes");
            for (JsonNode laneNode : arrayNode) {
                void var17_17;
                String laneStencilId = BpmnJsonConverterUtil.getStencilId(laneNode);
                if (!"Lane".equals(laneStencilId)) continue;
                nonEmptyPoolFound = true;
                Lane lane = new Lane();
                lane.setId(BpmnJsonConverterUtil.getElementId(laneNode));
                lane.setName(JsonConverterUtil.getPropertyValueAsString("name", laneNode));
                lane.setType(laneStencilId);
                lane.setStyle(laneNode.get("style").textValue());
                lane.setParentProcess((Process)var17_17);
                lane.setPoolRef(JsonConverterUtil.getPropertyValueAsString("pool_id", laneNode));
                var17_17.getLanes().add(lane);
                this.processJsonElements(laneNode.get("childShapes"), modelNode, lane, shapeMap, bpmnModel);
                if (!CollectionUtils.isNotEmpty(lane.getFlowReferences())) continue;
                for (String elementRef : lane.getFlowReferences()) {
                    elementInLaneMap.put(elementRef, lane);
                }
            }
        }
        JsonNode signalDefinitionNode = BpmnJsonConverterUtil.getProperty("signaldefinitions", modelNode);
        signalDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(signalDefinitionNode);
        if ((signalDefinitionNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(signalDefinitionNode)) instanceof ArrayNode) {
            ArrayNode signalDefinitionArrayNode = (ArrayNode)signalDefinitionNode;
            for (JsonNode signalDefinitionJsonNode : signalDefinitionArrayNode) {
                String signalId = signalDefinitionJsonNode.get("id").asText();
                String string = signalDefinitionJsonNode.get("name").asText();
                if (!StringUtils.isNotEmpty((String)signalId) || !StringUtils.isNotEmpty((String)string)) continue;
                Signal signal = new Signal();
                signal.setId(signalId);
                signal.setName(string);
                JsonNode signalScope = signalDefinitionJsonNode.get("scope");
                signal.setScope(signalScope != null && signalScope.asText().toLowerCase().equals("processinstance") ? "processInstance" : "global");
                bpmnModel.addSignal(signal);
            }
        }
        if (!nonEmptyPoolFound) {
            Process process = this.initProcess(bpmnModel, modelNode);
            this.processJsonElements((JsonNode)shapesArrayNode, modelNode, process, shapeMap, bpmnModel);
        } else {
            for (Object shapeNode : shapesArrayNode) {
                String sourceRef;
                if (!"SequenceFlow".equalsIgnoreCase(BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode)) && !"Association".equalsIgnoreCase(BpmnJsonConverterUtil.getStencilId((JsonNode)shapeNode)) || (sourceRef = BpmnJsonConverterUtil.lookForSourceRef(shapeNode.get("resourceId").asText(), modelNode.get("childShapes"))) == null) continue;
                Lane lane = (Lane)elementInLaneMap.get(sourceRef);
                SequenceFlowJsonConverter sequenceFlowJsonConverter = new SequenceFlowJsonConverter();
                if (lane != null) {
                    String string = BpmnJsonConverterUtil.getElementId((JsonNode)shapeNode);
                    sequenceFlowJsonConverter.convertToBpmnModel((JsonNode)shapeNode, modelNode, this, lane, shapeMap, bpmnModel);
                    lane.getFlowReferences().remove(string);
                    lane.getBeloneToPoolFlows().add(string);
                    continue;
                }
                sequenceFlowJsonConverter.convertToBpmnModel((JsonNode)shapeNode, modelNode, this, bpmnModel.getProcesses().get(0), shapeMap, bpmnModel);
            }
        }
        HashMap<String, SubProcess> subShapesMap = new HashMap<String, SubProcess>();
        for (Process process : bpmnModel.getProcesses()) {
            for (FlowElement flowElement : process.findFlowElementsOfType(SubProcess.class)) {
                SubProcess subProcess = (SubProcess)flowElement;
                this.fillSubShapes(subShapesMap, subProcess);
            }
            if (subShapesMap.size() <= 0) continue;
            ArrayList<String> removeSubFlowsList = new ArrayList<String>();
            for (FlowElement flowElement : process.findFlowElementsOfType(SequenceFlow.class)) {
                SubProcess subProcess;
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                if (!subShapesMap.containsKey(sequenceFlow.getSourceRef()) || (subProcess = (SubProcess)subShapesMap.get(sequenceFlow.getSourceRef())).getFlowElement(sequenceFlow.getId()) != null) continue;
                subProcess.addFlowElement(sequenceFlow);
                removeSubFlowsList.add(sequenceFlow.getId());
            }
            for (String string : removeSubFlowsList) {
                process.removeFlowElement(string);
            }
        }
        HashMap<String, FlowWithContainer> allFlowMap = new HashMap<String, FlowWithContainer>();
        ArrayList<Gateway> gatewayWithOrderList = new ArrayList<Gateway>();
        for (Process process : bpmnModel.getProcesses()) {
            this.postProcessElements(process, process.getFlowElements(), edgeMap, bpmnModel, allFlowMap, gatewayWithOrderList);
        }
        if (dynamicResourceItems != null && !dynamicResourceItems.isEmpty()) {
            for (IDynamicResourceItem iDynamicResourceItem : dynamicResourceItems) {
                String string = iDynamicResourceItem.getType();
                ILocaleString content = iDynamicResourceItem.getContent();
                if (content == null) continue;
                String contentStr = content.getLocaleValue();
                if (WfUtils.isEmpty(contentStr)) {
                    Set set = content.keySet();
                    for (String key : set) {
                        contentStr = (String)content.get((Object)key);
                        if (!WfUtils.isNotEmpty(content)) continue;
                        break;
                    }
                }
                DynProcessProcessorHelper.mergeDynBpmnModel(bpmnModel, contentStr, string);
            }
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.rebuildFlowNodeSequenceRelation(process, process.getFlowElements());
        }
        for (Gateway gateway : gatewayWithOrderList) {
            List<ExtensionElement> list = gateway.getExtensionElements().get(EDITOR_FLOW_ORDER);
            if (CollectionUtils.isNotEmpty(list)) {
                for (ExtensionElement orderElement : list) {
                    FlowWithContainer flowWithContainer;
                    String flowValue = orderElement.getElementText();
                    if (!StringUtils.isNotEmpty((String)flowValue) || (flowWithContainer = (FlowWithContainer)allFlowMap.get(flowValue)) == null) continue;
                    flowWithContainer.getFlowContainer().removeFlowElement(flowWithContainer.getSequenceFlow().getId());
                    flowWithContainer.getFlowContainer().addFlowElement(flowWithContainer.getSequenceFlow());
                }
            }
            gateway.getExtensionElements().remove(EDITOR_FLOW_ORDER);
        }
        for (Process process : bpmnModel.getProcesses()) {
            this.setAllowNextPersonSettingModel(process);
        }
        return bpmnModel;
    }

    private void mergeDynNodeProperty(JsonNode modelNode, List<IDynamicResourceItem> dynamicResourceItems) {
        if (modelNode == null || WfUtils.isEmptyForCollection(dynamicResourceItems)) {
            return;
        }
        ArrayList<IDynamicResourceItem> dynNodePropertyItems = new ArrayList<IDynamicResourceItem>(dynamicResourceItems.size());
        for (IDynamicResourceItem item : dynamicResourceItems) {
            String dynContent = item.getContent().getLocaleValue();
            if (!"dynNodeProperty".equals(item.getType())) continue;
            dynNodePropertyItems.add(item);
        }
        if (dynNodePropertyItems.isEmpty()) {
            return;
        }
        JsonNode modelChildShapes = modelNode.get("childShapes");
        if (modelChildShapes != null && modelChildShapes.isArray()) {
            ArrayNode childShapesArrayNode = (ArrayNode)modelChildShapes;
            for (JsonNode jsonNode : childShapesArrayNode) {
                ObjectNode node = (ObjectNode)jsonNode;
                ObjectNode propertiesNode = (ObjectNode)node.get(PROPERTIES);
                String resourceId = node.get("resourceId").textValue();
                ObjectMapper mapper = new ObjectMapper();
                Map properties = (Map)mapper.convertValue((Object)propertiesNode, Map.class);
                boolean needUpdate = false;
                for (IDynamicResourceItem item : dynNodePropertyItems) {
                    String dynContent = item.getContent().getLocaleValue();
                    if (WfUtils.isEmpty(dynContent)) continue;
                    JSONObject dynContentJSON = JSON.parseObject((String)dynContent);
                    JSONArray dynChildShapes = dynContentJSON.getJSONArray("childShapes");
                    JSONObject dynNodeJSON = dynChildShapes.getJSONObject(0);
                    JSONObject dynPropertyJSON = dynNodeJSON.getJSONObject(PROPERTIES);
                    String dynResourceId = dynNodeJSON.getString("resourceId");
                    if (!resourceId.equals(dynResourceId)) continue;
                    for (Map.Entry param : dynPropertyJSON.entrySet()) {
                        String propName = (String)param.getKey();
                        Object newValue = param.getValue();
                        BpmnModelUtil.setProperty(properties, propName, newValue);
                        needUpdate = true;
                    }
                }
                if (!needUpdate) continue;
                try {
                    JsonNode propertiesJsonNode = mapper.readTree(new JSONObject(properties).toJSONString());
                    node.remove(PROPERTIES);
                    node.putIfAbsent(PROPERTIES, propertiesJsonNode);
                }
                catch (Exception e) {
                    throw new KDException(WFErrorCode.invalidateResourceContentError(), new Object[]{this.getClass().getName() + "mergeDynNodeProperty->" + e.getMessage()});
                }
            }
        }
        dynamicResourceItems.removeAll(dynNodePropertyItems);
    }

    public void rebuildFlowNodeSequenceRelation(Process parentContainer, Collection<FlowElement> flowElementList) {
        for (FlowElement flowElement : flowElementList) {
            if (!(flowElement instanceof FlowNode)) continue;
            ((FlowNode)flowElement).getOutgoingFlows().clear();
            ((FlowNode)flowElement).getIncomingFlows().clear();
        }
        for (FlowElement flowElement : flowElementList) {
            FlowElement targetFlowElement;
            if (!(flowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            FlowElement sourceFlowElement = parentContainer.getFlowElement(sequenceFlow.getSourceRef());
            if (sourceFlowElement instanceof FlowNode) {
                sequenceFlow.setSourceFlowElement(sourceFlowElement);
                ((FlowNode)sourceFlowElement).getOutgoingFlows().add(sequenceFlow);
            }
            if (!((targetFlowElement = parentContainer.getFlowElement(sequenceFlow.getTargetRef())) instanceof FlowNode)) continue;
            sequenceFlow.setTargetFlowElement(targetFlowElement);
            ((FlowNode)targetFlowElement).getIncomingFlows().add(sequenceFlow);
        }
    }

    private Process initProcess(BpmnModel bpmnModel, JsonNode modelNode) {
        Process process = new Process();
        bpmnModel.getProcesses().add(process);
        this.initProcessInfo(bpmnModel, modelNode, process);
        return process;
    }

    public void initProcessInfo(BpmnModel bpmnModel, JsonNode modelNode, Process process) {
        JsonNode processVariables;
        JsonNode processVariableGroup;
        JsonNode processControl;
        JsonNode processDataPropertiesNode;
        JsonNode bosVersion;
        JsonNode allowNextPersonSettingModel;
        JsonNode autoAuditWhenSamePerson;
        String namespace;
        String type;
        String id = BpmnJsonConverterUtil.getPropertyValueAsString("process_id", modelNode);
        process.setId(id);
        String businessId = BpmnJsonConverterUtil.getPropertyValueAsString("businessId", modelNode);
        businessId = StringUtils.isBlank((String)businessId) ? id : businessId;
        process.setBusinessId(businessId);
        String subProcess = BpmnJsonConverterUtil.getPropertyValueAsString("subProcess", modelNode);
        process.setSubProcess(WfUtils.isEmpty(subProcess) ? false : Boolean.parseBoolean(subProcess));
        process.setNumber(process.getId());
        process.setBusinessId(BpmnJsonConverterUtil.getPropertyValueAsString("businessId", modelNode));
        process.setName((ILocaleString)new LocaleString(BpmnJsonConverterUtil.getPropertyValueAsString("name", modelNode)));
        if (modelNode.get("resourceId") != null) {
            process.setResourceId(modelNode.get("resourceId").asText());
        }
        if (WfUtils.isNotEmpty(type = BpmnJsonConverterUtil.getPropertyValueAsString("processType", modelNode))) {
            process.setProcessType(type);
        }
        process.setEntraBill(BpmnJsonConverterUtil.getPropertyValueAsString("entraBill", modelNode));
        process.setEntraBillId(BpmnJsonConverterUtil.getPropertyValueAsString("entraBillId", modelNode));
        process.setEntraBillName(BpmnJsonConverterUtil.getPropertyValueAsString("entraBillName", modelNode));
        process.setFlowRecordFormatter(BpmnJsonConverterUtil.getPropertyValueAsString("flowRecordFormatter", modelNode));
        String orgUnitId = BpmnJsonConverterUtil.getPropertyValueAsString("orgUnitId", modelNode);
        if (WfUtils.isNotEmpty(orgUnitId)) {
            process.setOrgUnitId(Long.parseLong(orgUnitId));
        }
        if (StringUtils.isNotEmpty((String)(namespace = BpmnJsonConverterUtil.getPropertyValueAsString("process_namespace", modelNode)))) {
            bpmnModel.setTargetNamespace(namespace);
        }
        if ((autoAuditWhenSamePerson = BpmnJsonConverterUtil.getProperty("autoAuditWhenSamePerson", modelNode)) != null) {
            process.setAutoAuditWhenSamePerson(autoAuditWhenSamePerson.booleanValue());
        }
        if (null != (allowNextPersonSettingModel = BpmnJsonConverterUtil.getProperty("allowNextPersonSettingModel", modelNode))) {
            process.setAllowNextPersonSettingModel(BpmnJsonConverterUtil.convertJsonToAllowNextPersonSettingModel(allowNextPersonSettingModel));
        } else {
            boolean allowNextPerson = false;
            JsonNode allowNextPersonWhenStart = BpmnJsonConverterUtil.getProperty("allowNextPersonWhenStart", modelNode);
            if (null != allowNextPersonWhenStart) {
                allowNextPerson = allowNextPersonWhenStart.booleanValue();
            }
            process.setAllowNextPersonSettingModel(BpmnJsonConverterUtil.convertJsonToAllowNextPersonSettingModel(allowNextPerson));
        }
        JsonNode withdrawProcInAuditing = BpmnJsonConverterUtil.getProperty("withdrawProcInAuditing", modelNode);
        if (withdrawProcInAuditing != null) {
            process.setWithdrawProcInAuditing(withdrawProcInAuditing.booleanValue());
        }
        process.setDocumentation((ILocaleString)new LocaleString(BpmnJsonConverterUtil.getPropertyValueAsString("documentation", modelNode)));
        JsonNode suspendRemindSubmitter = BpmnJsonConverterUtil.getProperty("suspendRemindSubmitter", modelNode);
        if (suspendRemindSubmitter != null) {
            process.setSuspendRemindSubmitter(suspendRemindSubmitter.booleanValue());
        }
        process.setTriggerMode(BpmnJsonConverterUtil.getPropertyValueAsString("triggerMode", modelNode));
        process.setStartType(BpmnJsonConverterUtil.getPropertyValueAsString("startType", modelNode));
        if (modelNode.get(PROPERTIES) != null) {
            process.setStartupcondrule(BpmnJsonConverterUtil.convertJsonToCondition(modelNode.get(PROPERTIES).get("startupcondrule")));
        }
        if (modelNode.get(PROPERTIES) != null) {
            process.setCloseCondition(BpmnJsonConverterUtil.convertJsonToCondition(modelNode.get(PROPERTIES).get("closecondition")));
        }
        process.setStartItems(BpmnJsonConverterUtil.convertJsonToStartItems(modelNode.get(PROPERTIES).get("startItems")));
        process.setEvtStartItems(BpmnJsonConverterUtil.convertJsonToEventStartItems(modelNode.get(PROPERTIES).get("evtStartItems")));
        JsonNode processExecutableNode = JsonConverterUtil.getProperty("process_executable", modelNode);
        if (processExecutableNode != null && StringUtils.isNotEmpty((String)processExecutableNode.asText())) {
            process.setExecutable(JsonConverterUtil.getPropertyValueAsBoolean("process_executable", modelNode));
        }
        if ((bosVersion = JsonConverterUtil.getProperty("bosVersion", modelNode)) != null) {
            process.setBosVersion(bosVersion.asText());
        }
        BpmnJsonConverterUtil.convertJsonToMessages(modelNode, bpmnModel);
        BpmnJsonConverterUtil.convertJsonToBillExceptionOperation(modelNode, process, bpmnModel);
        BpmnJsonConverterUtil.convertJsonToListeners(modelNode, process, false);
        JsonNode eventListenersNode = BpmnJsonConverterUtil.getProperty("eventlisteners", modelNode);
        if (eventListenersNode != null) {
            eventListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(eventListenersNode);
            BpmnJsonConverterUtil.parseEventListeners(eventListenersNode.get("eventListeners"), process);
        }
        if (modelNode.get(PROPERTIES) != null && (processDataPropertiesNode = modelNode.get(PROPERTIES).get("dataproperties")) != null) {
            List<ValuedDataObject> dataObjects = BpmnJsonConverterUtil.convertJsonToDataProperties(processDataPropertiesNode, process);
            process.setDataObjects(dataObjects);
            process.getFlowElements().addAll(dataObjects);
        }
        if ((processControl = BpmnJsonConverterUtil.getProperty("control", modelNode)) != null) {
            if (processControl.get("isSetNextAssignee") != null) {
                process.setNextAssignee(processControl.get("isSetNextAssignee").asBoolean());
            }
            if (processControl.get("processMode") != null) {
                process.setProcessMode(processControl.get("processMode").asText());
            }
        } else {
            if (BpmnJsonConverterUtil.getProperty("isSetNextAssignee", modelNode) != null) {
                process.setNextAssignee(BpmnJsonConverterUtil.getProperty("isSetNextAssignee", modelNode).asBoolean());
            }
            if (BpmnJsonConverterUtil.getProperty("processMode", modelNode) != null) {
                process.setProcessMode(BpmnJsonConverterUtil.getProperty("processMode", modelNode).asText());
            }
        }
        if ((processVariableGroup = BpmnJsonConverterUtil.getProperty("variableGroup", modelNode)) != null && (processVariables = processVariableGroup.get("variables")) != null) {
            List<Variable> variables = BpmnJsonConverterUtil.convertJsonToVariables(processVariables, process);
            process.setVariables(variables);
        }
        process.setMacros(BpmnModelUtil.loadDefaultNodeMacro(process, process.getProcessType(), "Diagram"));
        if (modelNode.get(PROPERTIES) != null) {
            AfterAuditModel model = BpmnJsonConverterUtil.converJsonToAfterAuditModel(modelNode.get(PROPERTIES).get(AFTERAUDIT));
            process.setAfterAudit(model);
            if (model != null) {
                BaseDataRecord baseDataRecord = new BaseDataRecord();
                baseDataRecord.setBaseData(model);
                baseDataRecord.setFlowElement(process);
                baseDataRecord.setKey(AFTERAUDIT);
                process.addBaseDataRecord(baseDataRecord);
            }
        }
    }

    @Override
    public void processJsonElements(JsonNode shapesArrayNode, JsonNode modelNode, BaseElement parentElement, Map<String, JsonNode> shapeMap, BpmnModel bpmnModel) {
        for (JsonNode shapeNode : shapesArrayNode) {
            String stencilId = BpmnJsonConverterUtil.getStencilId(shapeNode);
            Class<? extends BaseBpmnJsonConverter> converter = convertersToBpmnMap.get(stencilId);
            try {
                if (converter == null) {
                    log.info(stencilId + " \u662f\u6269\u5c55\u7684\u6a21\u578b\u4e2d\u7684\u8282\u70b9\uff0c\u627e\u5b83\u7ee7\u627f\u8282\u70b9\u7684\u8f6c\u6362\u5668...");
                    converter = convertersToBpmnMap.get(ModelConfigUtil.getExtendNodeInheritStencilType(stencilId));
                }
                if (converter == null) {
                    throw new WFException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c%s\u201d\u8282\u70b9\u7684\u8f6c\u6362\u5668\u3002", (String)"BpmnJsonConverter_1", (String)"bos-wf-engine", (Object[])new Object[0]), stencilId));
                }
                BaseBpmnJsonConverter converterInstance = converter.newInstance();
                converterInstance.convertToBpmnModel(shapeNode, modelNode, this, parentElement, shapeMap, bpmnModel);
            }
            catch (Exception e) {
                log.error(String.format("Error converting {%s},exception is {%s}", BpmnJsonConverterUtil.getStencilId(shapeNode), WfUtils.getExceptionStacktrace(e)), (Throwable)e);
                throw new WFException(e, WFErrorCode.modelConvertError(), e.getMessage());
            }
        }
    }

    public void parseAddSignFlowJsonNode(String elemType, Map<String, Object> extProps, FlowElement flowElement, Process dynProcess) {
        try {
            Class<? extends BaseBpmnJsonConverter> converter = convertersToBpmnMap.get(elemType);
            if (converter == null) {
                log.info(elemType + " \u662f\u6269\u5c55\u7684\u6a21\u578b\u4e2d\u7684\u8282\u70b9\uff0c\u627e\u5b83\u7ee7\u627f\u8282\u70b9\u7684\u8f6c\u6362\u5668...");
                converter = convertersToBpmnMap.get(ModelConfigUtil.getExtendNodeInheritStencilType(elemType));
            }
            BaseBpmnJsonConverter converterInstance = converter.newInstance();
            if (extProps != null && !extProps.isEmpty()) {
                HashMap<String, Map<String, Object>> extPropsMap = new HashMap<String, Map<String, Object>>();
                extPropsMap.put(EXTPROPS, extProps);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonNode = (JsonNode)mapper.convertValue(extPropsMap, JsonNode.class);
                converterInstance.parseJsonNode(null, jsonNode, flowElement, (BaseElement)flowElement, (BaseElement)dynProcess, null);
            }
        }
        catch (Exception e) {
            log.error(String.format("convert addsignFlowJsonError,exception is {%s}", WfUtils.getExceptionStacktrace(e)), (Throwable)e);
            throw new WFException(e, WFErrorCode.parseFreeFlowProcessError(), e.getMessage());
        }
    }

    public void parseFreeFlowJsonNode(String elemType, JsonNode elementNode, FlowElement flowElement, Process dynProcess) {
        try {
            Class<? extends BaseBpmnJsonConverter> converter = convertersToBpmnMap.get(elemType);
            if (converter == null) {
                log.info(elemType + " \u662f\u6269\u5c55\u7684\u6a21\u578b\u4e2d\u7684\u8282\u70b9\uff0c\u627e\u5b83\u7ee7\u627f\u8282\u70b9\u7684\u8f6c\u6362\u5668...");
                converter = convertersToBpmnMap.get(ModelConfigUtil.getExtendNodeInheritStencilType(elemType));
            }
            BaseBpmnJsonConverter converterInstance = converter.newInstance();
            ObjectNode tmp = (ObjectNode)elementNode;
            JsonNode nextNodes = tmp.get("nextNodes");
            tmp.remove("nextNodes");
            this.parseConditionRuleExpression(elemType, elementNode, flowElement);
            converterInstance.parseJsonNode(null, elementNode, flowElement, (BaseElement)flowElement, (BaseElement)dynProcess, null);
            JsonNode extProps = elementNode.get(EXTPROPS);
            if (extProps != null && extProps.size() > 0) {
                converterInstance.parseJsonNode(null, extProps, flowElement, (BaseElement)flowElement, (BaseElement)dynProcess, null);
            }
            if (nextNodes != null) {
                tmp.put("nextNodes", nextNodes);
            }
        }
        catch (Exception e) {
            log.error(String.format("convert freeFlowJsonError,exception is {%s}", WfUtils.getExceptionStacktrace(e)), (Throwable)e);
            throw new WFException(e, WFErrorCode.parseFreeFlowProcessError(), e.getMessage());
        }
    }

    private void parseConditionRuleExpression(String elemType, JsonNode elementNode, FlowElement flowElement) {
        JsonNode conditions;
        JsonNode conditionalRule;
        if (flowElement instanceof UserTask) {
            JsonNode conditions2;
            JsonNode autoAuditCondition;
            JsonNode autoAudit;
            JsonNode conditions3;
            JsonNode skipCondition = elementNode.get("skipCondition");
            if (skipCondition != null && skipCondition.size() > 0 && (conditions3 = skipCondition.get("entryentity")) != null && conditions3.size() > 0) {
                String expression = ConditionalRuleHelper.getConditionExpression((ArrayNode)conditions3);
                ((ObjectNode)skipCondition).put("expression", expression);
            }
            if ((autoAudit = elementNode.get("autoAudit")) != null && autoAudit.size() > 0 && (autoAuditCondition = autoAudit.get("autoAuditCondition")) != null && autoAuditCondition.size() > 0 && (conditions2 = autoAuditCondition.get("entryentity")) != null && conditions2.size() > 0) {
                String expression = ConditionalRuleHelper.getConditionExpression((ArrayNode)conditions2);
                ((ObjectNode)autoAuditCondition).put("expression", expression);
            }
        } else if (flowElement instanceof SequenceFlow && (conditionalRule = elementNode.get("conditionalRule")) != null && conditionalRule.size() > 0 && (conditions = conditionalRule.get("entryentity")) != null && conditions.size() > 0) {
            String expression = ConditionalRuleHelper.getConditionExpression((ArrayNode)conditions);
            ((ObjectNode)conditionalRule).put("expression", expression);
        }
    }

    private void fillSubShapes(Map<String, SubProcess> subShapesMap, SubProcess subProcess) {
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (flowElement instanceof SubProcess) {
                SubProcess childSubProcess = (SubProcess)flowElement;
                subShapesMap.put(childSubProcess.getId(), subProcess);
                this.fillSubShapes(subShapesMap, childSubProcess);
                continue;
            }
            subShapesMap.put(flowElement.getId(), subProcess);
        }
    }

    private void postProcessElements(FlowElementsContainer parentContainer, Collection<FlowElement> flowElementList, Map<String, JsonNode> edgeMap, BpmnModel bpmnModel, Map<String, FlowWithContainer> allFlowMap, List<Gateway> gatewayWithOrderList) {
        for (FlowElement flowElement : flowElementList) {
            FlowElement targetFlowElement;
            Event event;
            if (flowElement instanceof Event && CollectionUtils.isNotEmpty((event = (Event)flowElement).getEventDefinitions())) {
                MessageEventDefinition messageEventDef;
                EventDefinition eventDef = event.getEventDefinitions().get(0);
                if (eventDef instanceof SignalEventDefinition) {
                    SignalEventDefinition signalEventDef = (SignalEventDefinition)eventDef;
                    if (StringUtils.isNotEmpty((String)signalEventDef.getSignalRef()) && bpmnModel.getSignal(signalEventDef.getSignalRef()) == null) {
                        bpmnModel.addSignal(new Signal(signalEventDef.getSignalRef(), signalEventDef.getSignalRef()));
                    }
                } else if (eventDef instanceof MessageEventDefinition && StringUtils.isNotEmpty((String)(messageEventDef = (MessageEventDefinition)eventDef).getMessageRef()) && bpmnModel.getMessage(messageEventDef.getMessageRef()) == null) {
                    bpmnModel.addMessage(new Message(messageEventDef.getMessageRef(), messageEventDef.getMessageRef(), null));
                }
            }
            if (flowElement instanceof BoundaryEvent) {
                BoundaryEvent boundaryEvent = (BoundaryEvent)flowElement;
                Activity activity = this.retrieveAttachedRefObject(boundaryEvent.getAttachedToRefId(), parentContainer.getFlowElements());
                if (activity == null) {
                    log.warn("Boundary event " + boundaryEvent.getId() + " is not attached to any activity");
                    continue;
                }
                boundaryEvent.setAttachedToRef(activity);
                activity.getBoundaryEvents().add(boundaryEvent);
                continue;
            }
            if (flowElement instanceof Gateway) {
                if (!flowElement.getExtensionElements().containsKey(EDITOR_FLOW_ORDER)) continue;
                gatewayWithOrderList.add((Gateway)flowElement);
                continue;
            }
            if (flowElement instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)flowElement;
                this.postProcessElements(subProcess, subProcess.getFlowElements(), edgeMap, bpmnModel, allFlowMap, gatewayWithOrderList);
                continue;
            }
            if (!(flowElement instanceof SequenceFlow)) continue;
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            FlowElement sourceFlowElement = parentContainer.getFlowElement(sequenceFlow.getSourceRef());
            if (sourceFlowElement instanceof FlowNode) {
                boolean isDefault;
                sequenceFlow.setSourceFlowElement(sourceFlowElement);
                FlowWithContainer flowWithContainer = new FlowWithContainer(sequenceFlow, parentContainer);
                List<ExtensionElement> editorResourceId = sequenceFlow.getExtensionElements().remove("EDITOR_RESOURCEID");
                if (editorResourceId != null && !editorResourceId.isEmpty()) {
                    allFlowMap.put(editorResourceId.get(0).getElementText(), flowWithContainer);
                }
                ((FlowNode)sourceFlowElement).getOutgoingFlows().add(sequenceFlow);
                JsonNode edgeNode = edgeMap.get(sequenceFlow.getId());
                if (edgeNode != null && (isDefault = JsonConverterUtil.getPropertyValueAsBoolean("defaultflow", edgeNode)) && sourceFlowElement instanceof FlowNode) {
                    ((FlowNode)sourceFlowElement).setDefaultFlow(sequenceFlow.getId());
                }
            }
            if (!((targetFlowElement = parentContainer.getFlowElement(sequenceFlow.getTargetRef())) instanceof FlowNode)) continue;
            sequenceFlow.setTargetFlowElement(targetFlowElement);
            ((FlowNode)targetFlowElement).getIncomingFlows().add(sequenceFlow);
        }
    }

    private Activity retrieveAttachedRefObject(String attachedToRefId, Collection<FlowElement> flowElementList) {
        Activity activity = null;
        if (StringUtils.isNotEmpty((String)attachedToRefId)) {
            for (FlowElement flowElement : flowElementList) {
                SubProcess subProcess;
                Activity retrievedActivity;
                if (attachedToRefId.equals(flowElement.getId())) {
                    activity = (Activity)flowElement;
                    break;
                }
                if (!(flowElement instanceof SubProcess) || (retrievedActivity = this.retrieveAttachedRefObject(attachedToRefId, (subProcess = (SubProcess)flowElement).getFlowElements())) == null) continue;
                activity = retrievedActivity;
                break;
            }
        }
        return activity;
    }

    private void readShapeDI(JsonNode objectNode, double parentX, double parentY, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap, BpmnModel bpmnModel) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                ArrayNode outgoingNode;
                JsonNode resourceId;
                String stencilId = BpmnJsonConverterUtil.getStencilId(jsonChildNode);
                if ("SequenceFlow".equals(stencilId)) continue;
                GraphicInfo graphicInfo = new GraphicInfo();
                JsonNode boundsNode = jsonChildNode.get("bounds");
                if (boundsNode != null && !boundsNode.isEmpty()) {
                    JsonNode osNode;
                    ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                    graphicInfo.setX(upperLeftNode.get("x").asDouble());
                    graphicInfo.setY(upperLeftNode.get("y").asDouble());
                    ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
                    graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX());
                    graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY());
                    JsonNode relativeNode = boundsNode.get("relative");
                    if (relativeNode != null) {
                        graphicInfo.setRelative(relativeNode.asBoolean());
                    }
                    if ((osNode = boundsNode.get("offset")) != null && !(osNode instanceof NullNode)) {
                        ObjectNode offsetNode = (ObjectNode)osNode;
                        GraphicOffset offset = new GraphicOffset(offsetNode.get("x").asDouble(), offsetNode.get("y").asDouble());
                        graphicInfo.setOffset(offset);
                    }
                }
                if ((resourceId = jsonChildNode.get("resourceId")) != null) {
                    String childShapeId = resourceId.asText();
                    bpmnModel.addGraphicInfo(BpmnJsonConverterUtil.getElementId(jsonChildNode), graphicInfo);
                    shapeMap.put(childShapeId, jsonChildNode);
                }
                if ((outgoingNode = (ArrayNode)jsonChildNode.get(OUTGOING)) != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null) continue;
                        sourceRefMap.put(resourceNode.asText(), jsonChildNode);
                    }
                }
                this.readShapeDI(jsonChildNode, graphicInfo.getX(), graphicInfo.getY(), shapeMap, sourceRefMap, bpmnModel);
            }
        }
    }

    private void readModelDI(JsonNode objectNode, BpmnModel bpmnModel) {
        GraphicInfo graphicInfo = new GraphicInfo();
        JsonNode boundsNode = objectNode.get("bounds");
        if (boundsNode != null) {
            ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
            graphicInfo.setX(upperLeftNode.get("x").asDouble());
            graphicInfo.setY(upperLeftNode.get("y").asDouble());
            ObjectNode lowerRightNode = (ObjectNode)boundsNode.get("lowerRight");
            graphicInfo.setWidth(lowerRightNode.get("x").asDouble() - graphicInfo.getX());
            graphicInfo.setHeight(lowerRightNode.get("y").asDouble() - graphicInfo.getY());
        }
        bpmnModel.setLocation(graphicInfo);
    }

    private void filterAllEdges(JsonNode objectNode, Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, Map<String, JsonNode> shapeMap, Map<String, JsonNode> sourceRefMap) {
        if (objectNode.get("childShapes") != null) {
            for (JsonNode jsonChildNode : objectNode.get("childShapes")) {
                ObjectNode childNode = (ObjectNode)jsonChildNode;
                String stencilId = BpmnJsonConverterUtil.getStencilId((JsonNode)childNode);
                if ("SubProcess".equals(stencilId) || "Pool".equals(stencilId) || "Lane".equals(stencilId)) {
                    this.filterAllEdges((JsonNode)childNode, edgeMap, sourceAndTargetMap, shapeMap, sourceRefMap);
                    continue;
                }
                if (!"SequenceFlow".equals(stencilId) && !"Association".equals(stencilId)) continue;
                String childEdgeId = BpmnJsonConverterUtil.getElementId((JsonNode)childNode);
                JsonNode targetNode = childNode.get("target");
                if (targetNode != null && !targetNode.isNull() && targetNode.has("resourceId")) {
                    String targetRefId = targetNode.get("resourceId").asText();
                    ArrayList<JsonNode> sourceAndTargetList = new ArrayList<JsonNode>();
                    sourceAndTargetList.add(sourceRefMap.get(childNode.get("resourceId").asText()));
                    sourceAndTargetList.add(shapeMap.get(targetRefId));
                    sourceAndTargetMap.put(childEdgeId, sourceAndTargetList);
                }
                edgeMap.put(childEdgeId, (JsonNode)childNode);
            }
        }
    }

    private void readEdgeDI(Map<String, JsonNode> edgeMap, Map<String, List<JsonNode>> sourceAndTargetMap, BpmnModel bpmnModel) {
        for (Map.Entry<String, JsonNode> entry : edgeMap.entrySet()) {
            String edgeId = entry.getKey();
            JsonNode edgeNode = entry.getValue();
            JsonNode dockersNode = edgeNode.get("dockers");
            if (dockersNode == null) continue;
            ArrayList<GraphicInfo> graphicInfoList = new ArrayList<GraphicInfo>();
            Iterator iterator = dockersNode.iterator();
            JsonNode jsonNode = null;
            while (iterator.hasNext()) {
                jsonNode = (JsonNode)iterator.next();
                graphicInfoList.add(this.createGraphicInfo(jsonNode.get("x").asDouble(), jsonNode.get("y").asDouble()));
            }
            JsonNode boundsNode = edgeNode.get("bounds");
            if (boundsNode != null && boundsNode.size() > 0) {
                ObjectNode lowerRightNode;
                ObjectNode upperLeftNode = (ObjectNode)boundsNode.get("upperLeft");
                if (upperLeftNode != null) {
                    GraphicInfo sourcePoint = new GraphicInfo();
                    sourcePoint.setX(upperLeftNode.get("x").asDouble());
                    sourcePoint.setY(upperLeftNode.get("y").asDouble());
                    sourcePoint.setTerminalPointType("sourcePoint");
                    graphicInfoList.add(sourcePoint);
                }
                if ((lowerRightNode = (ObjectNode)boundsNode.get("lowerRight")) != null) {
                    GraphicInfo targetPoint = new GraphicInfo();
                    targetPoint.setX(lowerRightNode.get("x").asDouble());
                    targetPoint.setY(lowerRightNode.get("y").asDouble());
                    targetPoint.setTerminalPointType("targetPoint");
                    graphicInfoList.add(targetPoint);
                }
            }
            bpmnModel.addFlowGraphicInfoList(edgeId, graphicInfoList);
        }
    }

    private GraphicInfo createGraphicInfo(double x, double y) {
        GraphicInfo graphicInfo = new GraphicInfo();
        graphicInfo.setX(x);
        graphicInfo.setY(y);
        return graphicInfo;
    }

    private void setAllowNextPersonSettingModel(Process process) {
        AllowNextPersonSettingModel allowNextPersonSettingModel;
        UserTask userTask = BpmnModelUtil.getFirstUserTask(process);
        if (null != userTask && null == (allowNextPersonSettingModel = userTask.getAllowNextPersonSettingModel()) && null != process && null != (allowNextPersonSettingModel = process.getAllowNextPersonSettingModel())) {
            userTask.setAllowNextPersonSettingModel(allowNextPersonSettingModel.clone());
        }
    }

    static {
        ProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        StartEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EndEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SequenceFlowJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        MessageFlowJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        UserTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CallActivityJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        NotifyTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        AuditTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        YunzhijiaTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        WaitTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BroadcastTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        AutoTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        AutoMicroServiceTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        RPATaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        JudgeTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BillTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ExclusiveGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        InclusiveGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ParallelGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EventGatewayJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        SubProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        EventSubProcessJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CatchEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        ThrowEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        BoundaryEventJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        TextAnnotationJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
        CompensateTaskJsonConverter.fillTypes(convertersToBpmnMap, convertersToJsonMap);
    }

    static class FlowWithContainer {
        protected SequenceFlow sequenceFlow;
        protected FlowElementsContainer flowContainer;

        public FlowWithContainer(SequenceFlow sequenceFlow, FlowElementsContainer flowContainer) {
            this.sequenceFlow = sequenceFlow;
            this.flowContainer = flowContainer;
        }

        public SequenceFlow getSequenceFlow() {
            return this.sequenceFlow;
        }

        public void setSequenceFlow(SequenceFlow sequenceFlow) {
            this.sequenceFlow = sequenceFlow;
        }

        public FlowElementsContainer getFlowContainer() {
            return this.flowContainer;
        }

        public void setFlowContainer(FlowElementsContainer flowContainer) {
            this.flowContainer = flowContainer;
        }
    }
}

