/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.constants.StencilConstants;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.ActivitiListener;
import kd.bos.workflow.bpmn.model.AfterAuditModel;
import kd.bos.workflow.bpmn.model.AllowNextPersonSetting;
import kd.bos.workflow.bpmn.model.AllowNextPersonSettingModel;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.BooleanDataObject;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DateDataObject;
import kd.bos.workflow.bpmn.model.DoubleDataObject;
import kd.bos.workflow.bpmn.model.EventListener;
import kd.bos.workflow.bpmn.model.EventStartItem;
import kd.bos.workflow.bpmn.model.FieldExtension;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.IntegerDataObject;
import kd.bos.workflow.bpmn.model.ItemDefinition;
import kd.bos.workflow.bpmn.model.LongDataObject;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.Message;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.Signal;
import kd.bos.workflow.bpmn.model.StartItem;
import kd.bos.workflow.bpmn.model.StringDataObject;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.ValuedDataObject;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class BpmnJsonConverterUtil
extends StencilConstants {
    protected static Log log = LogFactory.getLog(BpmnJsonConverterUtil.class);
    private static DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static final String DATETIME = "datetime";
    private static final String DATAPROPERTIES = "dataproperties";
    private static final String EXECUTIONLISTENER = "_EXECUTIONLISTENER";
    private static final String TASKLISTENER = "_TASKLISTENER";

    public static ObjectNode createChildShape(String id, String type, double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode shapeNode = objectMapper.createObjectNode();
        shapeNode.put("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode(lowerRightX, lowerRightY, upperLeftX, upperLeftY));
        shapeNode.put("resourceId", id);
        ArrayNode shapesArrayNode = objectMapper.createArrayNode();
        shapeNode.put("childShapes", (JsonNode)shapesArrayNode);
        ObjectNode stencilNode = objectMapper.createObjectNode();
        stencilNode.put("id", type);
        shapeNode.put("stencil", (JsonNode)stencilNode);
        return shapeNode;
    }

    public static ObjectNode createChildShape(String id, String type) {
        ObjectNode shapeNode = objectMapper.createObjectNode();
        ArrayNode shapesArrayNode = objectMapper.createArrayNode();
        shapeNode.put("childShapes", (JsonNode)shapesArrayNode);
        ObjectNode stencilNode = objectMapper.createObjectNode();
        stencilNode.put("id", type);
        shapeNode.put("stencil", (JsonNode)stencilNode);
        return shapeNode;
    }

    public static ObjectNode createBoundsNode(double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode boundsNode = objectMapper.createObjectNode();
        boundsNode.put("lowerRight", (JsonNode)BpmnJsonConverterUtil.createPositionNode(lowerRightX, lowerRightY));
        boundsNode.put("upperLeft", (JsonNode)BpmnJsonConverterUtil.createPositionNode(upperLeftX, upperLeftY));
        return boundsNode;
    }

    public static ObjectNode createPositionNode(double x, double y) {
        ObjectNode positionNode = objectMapper.createObjectNode();
        positionNode.put("x", x);
        positionNode.put("y", y);
        return positionNode;
    }

    public static ObjectNode createResourceNode(String id) {
        ObjectNode resourceNode = objectMapper.createObjectNode();
        resourceNode.put("resourceId", id);
        return resourceNode;
    }

    public static String getStencilId(JsonNode objectNode) {
        String stencilId = null;
        JsonNode stencilNode = objectNode.get("stencil");
        if (stencilNode != null && stencilNode.get("id") != null) {
            stencilId = stencilNode.get("id").asText();
        }
        return stencilId;
    }

    public static String getElementId(JsonNode objectNode) {
        String elementId = null;
        String propertyValue = BpmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode);
        if (propertyValue != null && propertyValue.trim().length() > 0) {
            elementId = propertyValue.trim();
        } else {
            JsonNode resourceId = objectNode.get("resourceId");
            if (resourceId != null) {
                elementId = resourceId.asText();
            }
        }
        return elementId;
    }

    public static void convertMessagesToJson(Collection<Message> messages, ObjectNode propertiesNode) {
        String propertyName = "messages";
        ArrayNode messagesNode = objectMapper.createArrayNode();
        for (Message message : messages) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("message_id", message.getId());
            propertyItemNode.put("message_name", message.getName());
            propertyItemNode.put("message_item_ref", message.getItemRef());
            messagesNode.add((JsonNode)propertyItemNode);
        }
        propertiesNode.put(propertyName, (JsonNode)messagesNode);
    }

    public static void convertListenersToJson(List<ActivitiListener> listeners, boolean isExecutionListener, ObjectNode propertiesNode) {
        String propertyName = null;
        String valueName = null;
        if (isExecutionListener) {
            propertyName = "executionlisteners";
            valueName = "executionListeners";
        } else {
            propertyName = "tasklisteners";
            valueName = "taskListeners";
        }
        if (listeners.isEmpty()) {
            return;
        }
        ObjectNode listenersNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (ActivitiListener listener : listeners) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("event", listener.getEvent());
            if ("class".equals(listener.getImplementationType())) {
                propertyItemNode.put("className", listener.getImplementation());
            } else if ("expression".equals(listener.getImplementationType())) {
                propertyItemNode.put("expression", listener.getImplementation());
            } else if ("delegateExpression".equals(listener.getImplementationType())) {
                propertyItemNode.put("delegateExpression", listener.getImplementation());
            }
            if (CollectionUtils.isNotEmpty(listener.getFieldExtensions())) {
                ArrayNode fieldsArray = objectMapper.createArrayNode();
                for (FieldExtension fieldExtension : listener.getFieldExtensions()) {
                    ObjectNode fieldNode = objectMapper.createObjectNode();
                    fieldNode.put("name", fieldExtension.getFieldName());
                    if (StringUtils.isNotEmpty((String)fieldExtension.getStringValue())) {
                        fieldNode.put("stringValue", fieldExtension.getStringValue());
                    }
                    if (StringUtils.isNotEmpty((String)fieldExtension.getExpression())) {
                        fieldNode.put("expression", fieldExtension.getExpression());
                    }
                    fieldsArray.add((JsonNode)fieldNode);
                }
                propertyItemNode.put("fields", (JsonNode)fieldsArray);
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        listenersNode.put(valueName, (JsonNode)itemsNode);
        propertiesNode.put(propertyName, (JsonNode)listenersNode);
    }

    public static void convertEventListenersToJson(List<EventListener> listeners, ObjectNode propertiesNode) {
        ObjectNode listenersNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (EventListener listener : listeners) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((String)listener.getEvents())) {
                String[] eventArray;
                ArrayNode eventArrayNode = objectMapper.createArrayNode();
                for (String eventValue : eventArray = listener.getEvents().split(",")) {
                    if (!StringUtils.isNotEmpty((String)eventValue.trim())) continue;
                    ObjectNode eventNode = objectMapper.createObjectNode();
                    eventNode.put("event", eventValue.trim());
                    eventArrayNode.add((JsonNode)eventNode);
                }
                propertyItemNode.put("event", listener.getEvents());
                propertyItemNode.put("events", (JsonNode)eventArrayNode);
            }
            String implementationText = null;
            if ("class".equals(listener.getImplementationType())) {
                propertyItemNode.put("className", listener.getImplementation());
                implementationText = listener.getImplementation();
            } else if ("delegateExpression".equals(listener.getImplementationType())) {
                propertyItemNode.put("delegateExpression", listener.getImplementation());
                implementationText = listener.getImplementation();
            } else if ("throwErrorEvent".equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "error");
                propertyItemNode.put("errorcode", listener.getImplementation());
                implementationText = "Rethrow as error " + listener.getImplementation();
            } else if ("throwMessageEvent".equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "message");
                propertyItemNode.put("messagename", listener.getImplementation());
                implementationText = "Rethrow as message " + listener.getImplementation();
            } else if ("throwSignalEvent".equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "signal");
                propertyItemNode.put("signalname", listener.getImplementation());
                implementationText = "Rethrow as signal " + listener.getImplementation();
            } else if ("throwGlobalSignalEvent".equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "globalSignal");
                propertyItemNode.put("signalname", listener.getImplementation());
                implementationText = "Rethrow as signal " + listener.getImplementation();
            }
            if (StringUtils.isNotEmpty((String)implementationText)) {
                propertyItemNode.put("implementation", implementationText);
            }
            if (StringUtils.isNotEmpty((String)listener.getEntityType())) {
                propertyItemNode.put("entityType", listener.getEntityType());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        listenersNode.put("eventListeners", (JsonNode)itemsNode);
        propertiesNode.put("eventlisteners", (JsonNode)listenersNode);
    }

    public static void convertSignalDefinitionsToJson(BpmnModel bpmnModel, ObjectNode propertiesNode) {
        if (bpmnModel.getSignals() != null) {
            ArrayNode signalDefinitions = objectMapper.createArrayNode();
            for (Signal signal : bpmnModel.getSignals()) {
                ObjectNode signalNode = signalDefinitions.addObject();
                signalNode.put("id", signal.getId());
                signalNode.put("name", signal.getName());
                signalNode.put("scope", signal.getScope());
            }
            propertiesNode.put("signaldefinitions", (JsonNode)signalDefinitions);
        }
    }

    public static void convertMessagesToJson(BpmnModel bpmnModel, ObjectNode propertiesNode) {
        if (bpmnModel.getMessages() != null) {
            ArrayNode messageDefinitions = objectMapper.createArrayNode();
            for (Message message : bpmnModel.getMessages()) {
                ObjectNode messageNode = messageDefinitions.addObject();
                messageNode.put("id", message.getId());
                messageNode.put("name", message.getName());
            }
            propertiesNode.put("messagedefinitions", (JsonNode)messageDefinitions);
        }
    }

    public static void convertJsonToListeners(JsonNode objectNode, BaseElement element, boolean isDefaultListener) {
        JsonNode taskListenersNode;
        JsonNode executionListenersNode = BpmnJsonConverterUtil.getProperty("executionlisteners", objectNode);
        JsonNode jsonNode = executionListenersNode = executionListenersNode != null ? executionListenersNode : BpmnJsonConverterUtil.getProperty("executionListeners", objectNode);
        if (executionListenersNode != null) {
            executionListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(executionListenersNode);
            BpmnJsonConverterUtil.parseListeners(executionListenersNode, element, false, isDefaultListener);
        }
        if (element instanceof UserTask && (taskListenersNode = BpmnJsonConverterUtil.getProperty("tasklisteners", objectNode)) != null) {
            taskListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(taskListenersNode);
            BpmnJsonConverterUtil.parseListeners(taskListenersNode, element, true, isDefaultListener);
        }
    }

    public static void convertJsonToMessages(JsonNode objectNode, BpmnModel element) {
        JsonNode messagesNode = BpmnJsonConverterUtil.getProperty("messagedefinitions", objectNode);
        if (messagesNode != null) {
            messagesNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(messagesNode);
            BpmnJsonConverterUtil.parseMessages(messagesNode, element);
        }
    }

    protected static void parseListeners(JsonNode listenersNode, BaseElement element, boolean isTaskListener, boolean isDefaultListener) {
        if (listenersNode == null) {
            return;
        }
        listenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(listenersNode);
        int i = 0;
        for (JsonNode listenerNode : listenersNode) {
            JsonNode eventNode;
            if ((listenerNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(listenerNode)) != null && (eventNode = listenerNode.get("event")) != null && !eventNode.isNull() && StringUtils.isNotEmpty((String)eventNode.asText())) {
                String extItf;
                ActivitiListener listener = new ActivitiListener();
                listener.setEvent(eventNode.asText());
                listener.setId(BpmnJsonConverterUtil.getValueAsString("id", listenerNode));
                String ud = BpmnJsonConverterUtil.getValueAsString("userDefinied", listenerNode);
                if (WfUtils.isNotEmpty(ud) && "true".equalsIgnoreCase(ud)) {
                    listener.setUserDefinied(Boolean.TRUE);
                }
                if (ExternalInterfaceUtil.isValidValue(extItf = BpmnJsonConverterUtil.getValueAsString("implementation", listenerNode))) {
                    listener.setImplementationType(ExternalInterfaceUtil.getExtItfType(extItf));
                    listener.setBillNumber(BpmnJsonConverterUtil.getValueAsString("billnumber", listenerNode));
                    listener.setBillName(BpmnJsonConverterUtil.getValueAsString("billname", listenerNode));
                    listener.setImplementation(extItf);
                } else if (StringUtils.isNotEmpty((String)BpmnJsonConverterUtil.getValueAsString("className", listenerNode))) {
                    listener.setImplementationType("class");
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("className", listenerNode));
                    listener.setOperation("normal");
                } else if (StringUtils.isNotEmpty((String)BpmnJsonConverterUtil.getValueAsString("expression", listenerNode))) {
                    listener.setImplementationType("expression");
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("expression", listenerNode));
                } else if (StringUtils.isNotEmpty((String)BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode))) {
                    listener.setImplementationType("delegateExpression");
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode));
                }
                JsonNode fieldsNode = listenerNode.get("fields");
                if (fieldsNode != null) {
                    for (JsonNode fieldNode : fieldsNode) {
                        JsonNode nameNode = fieldNode.get("name");
                        if (nameNode == null || nameNode.isNull() || !StringUtils.isNotEmpty((String)nameNode.asText())) continue;
                        FieldExtension fieldExtension = new FieldExtension();
                        fieldExtension.setFieldName(nameNode.asText());
                        fieldExtension.setStringValue(BpmnJsonConverterUtil.getValueAsString("stringValue", fieldNode));
                        if (StringUtils.isEmpty((String)fieldExtension.getStringValue())) {
                            fieldExtension.setStringValue(BpmnJsonConverterUtil.getValueAsString("string", fieldNode));
                        }
                        if (StringUtils.isEmpty((String)fieldExtension.getStringValue())) {
                            fieldExtension.setExpression(BpmnJsonConverterUtil.getValueAsString("expression", fieldNode));
                        }
                        listener.getFieldExtensions().add(fieldExtension);
                    }
                }
                int index = i;
                if (element instanceof Process) {
                    index = isDefaultListener ? index : ((Process)element).getExecutionListeners().size();
                    ((Process)element).getExecutionListeners().add(index, listener);
                } else if (element instanceof SequenceFlow) {
                    index = isDefaultListener ? index : ((SequenceFlow)element).getExecutionListeners().size();
                    BpmnJsonConverterUtil.addListener(((SequenceFlow)element).getExecutionListeners(), listener, index);
                } else if (element instanceof UserTask) {
                    if (isTaskListener) {
                        index = isDefaultListener ? index : ((UserTask)element).getTaskListeners().size();
                        ((UserTask)element).getTaskListeners().add(index, listener);
                    } else {
                        index = isDefaultListener ? index : ((UserTask)element).getExecutionListeners().size();
                        BpmnJsonConverterUtil.addListener(((UserTask)element).getExecutionListeners(), listener, index);
                    }
                } else if (element instanceof FlowElement) {
                    index = isDefaultListener ? index : ((FlowElement)element).getExecutionListeners().size();
                    BpmnJsonConverterUtil.addListener(((FlowElement)element).getExecutionListeners(), listener, index);
                }
            }
            ++i;
        }
    }

    private static void addListener(List<ActivitiListener> listeners, ActivitiListener activitiListener, int index) {
        for (ActivitiListener listener : listeners) {
            if (listener == null || !listener.getEvent().equals(activitiListener.getEvent()) || !listener.getImplementationType().equals(activitiListener.getImplementationType()) || !listener.getImplementation().equals(activitiListener.getImplementation())) continue;
            return;
        }
        listeners.add(index, activitiListener);
    }

    protected static void parseMessages(JsonNode messagesNode, BpmnModel element) {
        if (messagesNode == null) {
            return;
        }
        for (JsonNode messageNode : messagesNode) {
            String messageItemRef;
            String messageName;
            Message message = new Message();
            String messageId = BpmnJsonConverterUtil.getValueAsString("id", messageNode);
            if (StringUtils.isNotEmpty((String)messageId)) {
                message.setId(messageId);
            }
            if (StringUtils.isNotEmpty((String)(messageName = BpmnJsonConverterUtil.getValueAsString("name", messageNode)))) {
                message.setName(messageName);
            }
            if (StringUtils.isNotEmpty((String)(messageItemRef = BpmnJsonConverterUtil.getValueAsString("message_item_ref", messageNode)))) {
                message.setItemRef(messageItemRef);
            }
            if (!StringUtils.isNotEmpty((String)messageId)) continue;
            element.addMessage(message);
        }
    }

    public static void parseEventListeners(JsonNode listenersNode, Process process) {
        if (listenersNode == null) {
            return;
        }
        listenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(listenersNode);
        for (JsonNode listenerNode : listenersNode) {
            JsonNode eventsNode = listenerNode.get("events");
            if (eventsNode == null || !eventsNode.isArray() || eventsNode.size() <= 0) continue;
            EventListener listener = new EventListener();
            StringBuilder eventsBuilder = new StringBuilder();
            for (JsonNode eventNode : eventsNode) {
                JsonNode eventValueNode = eventNode.get("event");
                if (eventValueNode == null || eventValueNode.isNull() || !StringUtils.isNotEmpty((String)eventValueNode.asText())) continue;
                if (eventsBuilder.length() > 0) {
                    eventsBuilder.append(',');
                }
                eventsBuilder.append(eventValueNode.asText());
            }
            if (eventsBuilder.length() == 0) continue;
            listener.setEvents(eventsBuilder.toString());
            JsonNode rethrowEventNode = listenerNode.get("rethrowEvent");
            if (rethrowEventNode != null && rethrowEventNode.asBoolean()) {
                JsonNode rethrowTypeNode = listenerNode.get("rethrowType");
                if (rethrowTypeNode != null) {
                    String signalName;
                    if ("error".equalsIgnoreCase(rethrowTypeNode.asText())) {
                        String errorCode = BpmnJsonConverterUtil.getValueAsString("errorcode", listenerNode);
                        if (StringUtils.isNotEmpty((String)errorCode)) {
                            listener.setImplementationType("throwErrorEvent");
                            listener.setImplementation(errorCode);
                        }
                    } else if ("message".equalsIgnoreCase(rethrowTypeNode.asText())) {
                        String messageName = BpmnJsonConverterUtil.getValueAsString("messagename", listenerNode);
                        if (StringUtils.isNotEmpty((String)messageName)) {
                            listener.setImplementationType("throwMessageEvent");
                            listener.setImplementation(messageName);
                        }
                    } else if ("signal".equalsIgnoreCase(rethrowTypeNode.asText())) {
                        signalName = BpmnJsonConverterUtil.getValueAsString("signalname", listenerNode);
                        if (StringUtils.isNotEmpty((String)signalName)) {
                            listener.setImplementationType("throwSignalEvent");
                            listener.setImplementation(signalName);
                        }
                    } else if ("globalSignal".equalsIgnoreCase(rethrowTypeNode.asText()) && StringUtils.isNotEmpty((String)(signalName = BpmnJsonConverterUtil.getValueAsString("signalname", listenerNode)))) {
                        listener.setImplementationType("throwGlobalSignalEvent");
                        listener.setImplementation(signalName);
                    }
                }
                if (StringUtils.isEmpty((String)listener.getImplementation())) {
                    continue;
                }
            } else {
                if (StringUtils.isNotEmpty((String)BpmnJsonConverterUtil.getValueAsString("className", listenerNode))) {
                    listener.setImplementationType("class");
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("className", listenerNode));
                } else if (StringUtils.isNotEmpty((String)BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode))) {
                    listener.setImplementationType("delegateExpression");
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode));
                }
                if (StringUtils.isNotEmpty((String)BpmnJsonConverterUtil.getValueAsString("entityType", listenerNode))) {
                    listener.setEntityType(BpmnJsonConverterUtil.getValueAsString("entityType", listenerNode));
                }
                if (StringUtils.isEmpty((String)listener.getImplementation())) continue;
            }
            process.getEventListeners().add(listener);
        }
    }

    public static String lookForSourceRef(String flowId, JsonNode childShapesNode) {
        String sourceRef = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                JsonNode outgoingNode = childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !flowId.equals(resourceNode.asText())) continue;
                        sourceRef = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (sourceRef != null) break;
                }
                if ((sourceRef = BpmnJsonConverterUtil.lookForSourceRef(flowId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return sourceRef;
    }

    public static List<ValuedDataObject> convertJsonToDataProperties(JsonNode objectNode, BaseElement element) {
        ArrayList<ValuedDataObject> dataObjects = new ArrayList<ValuedDataObject>();
        if (objectNode != null) {
            JsonNode itemsArrayNode;
            if (objectNode.isValueNode() && StringUtils.isNotEmpty((String)objectNode.asText())) {
                try {
                    objectNode = objectMapper.readTree(objectNode.asText());
                }
                catch (Exception e) {
                    log.debug("convertJsonToDataProperties data properties node cannot be read");
                }
            }
            if ((itemsArrayNode = objectNode.get("items")) != null) {
                for (JsonNode dataNode : itemsArrayNode) {
                    JsonNode dataIdNode = dataNode.get("dataproperty_id");
                    if (dataIdNode == null || !StringUtils.isNotEmpty((String)dataIdNode.asText())) continue;
                    ValuedDataObject dataObject = null;
                    ItemDefinition itemSubjectRef = new ItemDefinition();
                    String dataType = dataNode.get("dataproperty_type").asText();
                    if (dataType.equals("string")) {
                        dataObject = new StringDataObject();
                    } else if (dataType.equals("int")) {
                        dataObject = new IntegerDataObject();
                    } else if (dataType.equals("long")) {
                        dataObject = new LongDataObject();
                    } else if (dataType.equals("double")) {
                        dataObject = new DoubleDataObject();
                    } else if (dataType.equals("boolean")) {
                        dataObject = new BooleanDataObject();
                    } else if (dataType.equals(DATETIME)) {
                        dataObject = new DateDataObject();
                    } else {
                        log.error(String.format("Error converting {%s}", dataIdNode.asText()));
                    }
                    if (null == dataObject) continue;
                    dataObject.setId(dataIdNode.asText());
                    dataObject.setName(dataNode.get("dataproperty_name").asText());
                    itemSubjectRef.setStructureRef("xsd:" + dataType);
                    dataObject.setItemSubjectRef(itemSubjectRef);
                    if (dataObject instanceof DateDataObject) {
                        try {
                            dataObject.setValue(dateTimeFormatter.parseDateTime(dataNode.get("dataproperty_value").asText()).toDate());
                        }
                        catch (Exception e) {
                            log.error(String.format("Error converting {%s}", dataObject.getName()), (Throwable)e);
                        }
                    } else {
                        dataObject.setValue(dataNode.get("dataproperty_value").asText());
                    }
                    dataObjects.add(dataObject);
                }
            }
        }
        return dataObjects;
    }

    public static void convertDataPropertiesToJson(List<ValuedDataObject> dataObjects, ObjectNode propertiesNode) {
        ObjectNode dataPropertiesNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (ValuedDataObject dObj : dataObjects) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("dataproperty_id", dObj.getId());
            propertyItemNode.put("dataproperty_name", dObj.getName());
            String itemSubjectRefQName = dObj.getItemSubjectRef().getStructureRef();
            String dataType = itemSubjectRefQName.substring(itemSubjectRefQName.indexOf(58) + 1);
            propertyItemNode.put("dataproperty_type", dataType);
            Object dObjValue = dObj.getValue();
            String value = null;
            if (null == dObjValue) {
                propertyItemNode.put("dataproperty_value", "");
            } else {
                value = DATETIME.equals(dataType) ? new DateTime(dObjValue).toString("yyyy-MM-dd'T'hh:mm:ss") : dObjValue.toString();
                propertyItemNode.put("dataproperty_value", value);
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        dataPropertiesNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put(DATAPROPERTIES, (JsonNode)dataPropertiesNode);
    }

    public static JsonNode validateIfNodeIsTextual(JsonNode node) {
        if (node != null && !node.isNull() && node.isTextual() && StringUtils.isNotEmpty((String)node.asText())) {
            try {
                node = BpmnJsonConverterUtil.validateIfNodeIsTextual(objectMapper.readTree(node.asText()));
            }
            catch (Exception e) {
                log.error("Error converting textual node", (Throwable)e);
            }
        }
        return node;
    }

    public static String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = BpmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }

    public static List<StartItem> convertJsonToStartItems(JsonNode jsonNode) {
        ArrayList<StartItem> items = new ArrayList<StartItem>();
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode dataNode : arrayNode) {
                StartItem item = new StartItem();
                if (dataNode.get("id") != null) {
                    item.setId(dataNode.get("id").asText());
                }
                if (dataNode.get("nodeid") != null) {
                    item.setNodeid(dataNode.get("nodeid").asText());
                }
                if (dataNode.get("entitynumber") != null) {
                    item.setEntitynumber(dataNode.get("entitynumber").asText());
                }
                if (dataNode.get("entityname") != null) {
                    item.setEntityname(dataNode.get("entityname").asText());
                }
                if (dataNode.get("condition") != null) {
                    item.setCondition(BpmnJsonConverterUtil.convertJsonToCondition(dataNode.get("condition")));
                }
                if (dataNode.get("allowstart") != null) {
                    item.setAllowstart(dataNode.get("allowstart").booleanValue());
                }
                if (dataNode.get("operation") != null) {
                    item.setOperation(dataNode.get("operation").asText());
                }
                if (dataNode.get("batchnumber") != null) {
                    item.setBatchnumber(dataNode.get("batchnumber").asText());
                }
                if (dataNode.get("batchnumname") != null) {
                    item.setBatchnumname(dataNode.get("batchnumname").asText());
                }
                items.add(item);
            }
        }
        return items;
    }

    public static List<EventStartItem> convertJsonToEventStartItems(JsonNode jsonNode) {
        ArrayList<EventStartItem> items = new ArrayList<EventStartItem>();
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode dataNode : arrayNode) {
                EventStartItem item = new EventStartItem();
                if (dataNode.get("id") != null) {
                    item.setId(dataNode.get("id").asText());
                }
                if (dataNode.get("eventName") != null) {
                    item.setEventName(dataNode.get("eventName").asText());
                }
                if (dataNode.get("eventNumber") != null) {
                    item.setEventNumber(dataNode.get("eventNumber").asText());
                }
                item.setCondition(BpmnJsonConverterUtil.convertJsonToCondition(dataNode.get("condition")));
                items.add(item);
            }
        }
        return items;
    }

    public static List<Variable> convertJsonToVariables(JsonNode objectNode, BaseElement element) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (objectNode != null) {
            if (objectNode.isValueNode() && StringUtils.isNotEmpty((String)objectNode.asText())) {
                try {
                    objectNode = objectMapper.readTree(objectNode.asText());
                }
                catch (Exception e) {
                    log.error("convertJsonToVariables data properties node cannot be read", (Throwable)e);
                }
            }
            for (JsonNode dataNode : objectNode) {
                Variable variable = new Variable();
                if (dataNode.get("id") != null) {
                    variable.setId(dataNode.get("id").asText());
                }
                if (dataNode.get("name") != null) {
                    variable.setName(dataNode.get("name").asText());
                }
                if (dataNode.get("number") != null) {
                    variable.setNumber(dataNode.get("number").asText());
                }
                if (dataNode.get("description") != null) {
                    variable.setDescription(dataNode.get("description").asText());
                }
                if (dataNode.get("type") != null) {
                    variable.setType(dataNode.get("type").asText());
                }
                if (dataNode.get("defaultValue") != null) {
                    variable.setDefaultValue(dataNode.get("defaultValue").asText());
                } else if (dataNode.get("defaultvalue") != null) {
                    variable.setDefaultValue(dataNode.get("defaultvalue").asText());
                }
                if (dataNode.get("builtIn") != null) {
                    variable.setBuiltIn(dataNode.get("builtIn").booleanValue());
                }
                if (dataNode.get("grouprealvalue") != null) {
                    variable.setRealValue(dataNode.get("grouprealvalue").asText());
                }
                variables.add(variable);
            }
        }
        return variables;
    }

    public static void convertVariablesToJson(List<Variable> variables, ObjectNode propertiesNode) {
        ObjectNode dataPropertiesNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (Variable variable : variables) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("id", variable.getId());
            propertyItemNode.put("name", variable.getName());
            propertyItemNode.put("description", variable.getDescription());
            propertyItemNode.put("builtIn", variable.isBuiltIn());
            propertyItemNode.put("grouprealvalue", variable.getRealValue());
            String dataType = variable.getType();
            propertyItemNode.put("type", dataType);
            Object dObjValue = variable.getDefaultValue();
            String value = null;
            if (null == dObjValue) {
                propertyItemNode.put("defaultValue", "");
            } else {
                value = DATETIME.equals(dataType) ? new DateTime(dObjValue).toString("yyyy-MM-dd'T'hh:mm:ss") : dObjValue.toString();
                propertyItemNode.put("defaultValue", value);
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        dataPropertiesNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put(DATAPROPERTIES, (JsonNode)dataPropertiesNode);
    }

    public static List<Macro> convertJsonToMacros(JsonNode objectNode, BaseElement element) {
        ArrayList<Macro> macros = new ArrayList<Macro>();
        if (objectNode != null) {
            if (objectNode.isValueNode() && StringUtils.isNotEmpty((String)objectNode.asText())) {
                try {
                    objectNode = objectMapper.readTree(objectNode.asText());
                }
                catch (Exception e) {
                    log.error("convertJsonToMacros data properties node cannot be read", (Throwable)e);
                }
            }
            for (JsonNode dataNode : objectNode) {
                Macro macro = new Macro();
                macro.setName(dataNode.get("name").asText());
                macro.setDescription(dataNode.get("description").asText());
                macro.setType(dataNode.get("type").asText());
                macro.setParseClass(dataNode.get("parseClass").asText());
                macro.setDataType(dataNode.get("dataType").asText());
                macros.add(macro);
            }
        }
        return macros;
    }

    public static void convertMacrosToJson(List<Macro> macros, ObjectNode propertiesNode) {
        ObjectNode dataPropertiesNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (Macro macro : macros) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("id", macro.getId());
            propertyItemNode.put("name", macro.getName());
            propertyItemNode.put("description", macro.getDescription());
            propertyItemNode.put("parseClass", macro.getParseClass());
            itemsNode.add((JsonNode)propertyItemNode);
        }
        dataPropertiesNode.put("items", (JsonNode)itemsNode);
        propertiesNode.put(DATAPROPERTIES, (JsonNode)dataPropertiesNode);
    }

    public static AfterAuditModel converJsonToAfterAuditModel(JsonNode objectNode) {
        JsonNode keyAuditor;
        if (objectNode == null || objectNode instanceof NullNode) {
            return null;
        }
        if (objectNode instanceof TextNode && WfUtils.isEmpty(objectNode.asText())) {
            return null;
        }
        AfterAuditModel model = new AfterAuditModel();
        JsonNode afterAuditbtn = objectNode.get("afterAuditbtn");
        boolean isAfterAuditbtn = false;
        if (afterAuditbtn != null && !(afterAuditbtn instanceof NullNode)) {
            isAfterAuditbtn = afterAuditbtn.asBoolean();
        }
        model.setAfterAuditbtn(isAfterAuditbtn);
        JsonNode personRange = objectNode.get("personRange");
        if (personRange != null && !(personRange instanceof NullNode)) {
            model.setPersonRange(personRange.asText());
        }
        if ((keyAuditor = objectNode.get("keyAuditor")) != null && !(keyAuditor instanceof NullNode)) {
            ArrayList<Long> list = new ArrayList<Long>(keyAuditor.size());
            for (JsonNode node : (ArrayNode)keyAuditor) {
                list.add(node.asLong());
            }
            model.setKeyAuditor(list);
        } else {
            model.setKeyAuditor(new ArrayList<Long>(0));
        }
        return model;
    }

    public static ConditionalRuleEntity convertJsonToCondition(JsonNode objectNode) {
        JsonNode entryentity;
        if (objectNode == null || objectNode instanceof NullNode) {
            return null;
        }
        if (objectNode instanceof TextNode && WfUtils.isEmpty(objectNode.asText())) {
            return null;
        }
        ConditionalRuleEntityImpl entity = new ConditionalRuleEntityImpl();
        if (objectNode.get("elementid") != null) {
            entity.setElementid(objectNode.get("elementid").asText());
        }
        if (objectNode.get("expression") != null) {
            entity.setExpression(objectNode.get("expression").asText());
        }
        if (objectNode.get("type") != null) {
            entity.setType(objectNode.get("type").asText());
        }
        entity.setShowtext(BpmnJsonConverterUtil.convertJsonToILocaleString(objectNode.get("showtext")));
        entity.setDescription(BpmnJsonConverterUtil.convertJsonToILocaleString(objectNode.get("description")));
        if (objectNode.get("plugin") != null) {
            entity.setPlugin(objectNode.get("plugin").asText());
        }
        if ((entryentity = objectNode.get("entryentity")) instanceof ArrayNode) {
            ArrayNode array = (ArrayNode)entryentity;
            int size = array.size();
            ArrayList<ConditionalEntity> conditionals = new ArrayList<ConditionalEntity>(size);
            for (int i = 0; i < size; ++i) {
                JsonNode node = array.get(i);
                ConditionalEntityImpl condition = new ConditionalEntityImpl();
                if (node.get("id") != null) {
                    condition.setId(node.get("id").asText());
                }
                if (node.get("leftbracket") != null) {
                    condition.setLeftbracket(node.get("leftbracket").asText());
                }
                if (node.get("paramnumber") != null) {
                    condition.setParamnumber(node.get("paramnumber").asText());
                }
                if (node.get("operation") != null) {
                    condition.setOperation(node.get("operation").asText());
                }
                if (node.get("value") != null) {
                    condition.setValue(node.get("value").asText());
                }
                if (node.get("rightbracket") != null) {
                    condition.setRightbracket(node.get("rightbracket").asText());
                }
                if (node.get("logic") != null) {
                    condition.setLogic(node.get("logic").asText());
                }
                if (node.get("valuetype") != null) {
                    condition.setValuetype(node.get("valuetype").asText());
                }
                if (node.get("seq") != null) {
                    condition.setSeq(node.get("seq").asInt());
                }
                conditionals.add(condition);
            }
            entity.setEntryentity(conditionals);
        }
        return entity;
    }

    public static ILocaleString convertJsonToILocaleString(JsonNode json) {
        if (json instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)json;
            Iterator fields = node.fields();
            LocaleString locStr = new LocaleString();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                JsonNode value = (JsonNode)entry.getValue();
                if (value == null) continue;
                locStr.put(entry.getKey(), (Object)value.textValue());
            }
            return locStr;
        }
        return null;
    }

    public static void convertJsonToBillExceptionOperation(JsonNode objectNode, BaseElement element, BpmnModel bpmnModel) {
        JsonNode expOp = BpmnJsonConverterUtil.getProperty("billExceptionOp", objectNode);
        if (expOp != null) {
            Process mainProcess = bpmnModel.getMainProcess();
            String processType = mainProcess.getProcessType();
            ArrayList<BillExceptionOp> ops = new ArrayList<BillExceptionOp>();
            for (JsonNode expNode : expOp) {
                BillExceptionOp op = new BillExceptionOp();
                op.setOper(BpmnJsonConverterUtil.getValueAsString("oper", expNode));
                op.setOpername(BpmnJsonConverterUtil.getValueAsString("opername", expNode));
                op.setProcaction(BpmnJsonConverterUtil.getValueAsString("procaction", expNode));
                op.setId(BpmnJsonConverterUtil.getValueAsString("id", expNode));
                op.setBillname(BpmnJsonConverterUtil.getValueAsString("billname", expNode));
                op.setBillnumber(BpmnJsonConverterUtil.getValueAsString("billnumber", expNode));
                if (ProcessType.AuditFlow.name().equals(processType) || ProcessType.NoCodeFlow.name().equals(processType)) {
                    op.setBillnumber(mainProcess.getEntraBill());
                    op.setBillname(mainProcess.getEntraBillName());
                }
                ops.add(op);
            }
            if (CollectionUtil.isNotEmpty(ops) && element instanceof Process) {
                ((Process)element).setBillExceptionOp(ops);
            }
        }
    }

    public static List<ActivitiListener> getExecutionListenerFromProcess(FlowNode flowElement) {
        return BpmnJsonConverterUtil.getNodeListenerFromProcess(flowElement, EXECUTIONLISTENER);
    }

    public static List<ActivitiListener> getTaskListenerFromProcess(FlowNode flowElement) {
        return BpmnJsonConverterUtil.getNodeListenerFromProcess(flowElement, TASKLISTENER);
    }

    protected static List<ActivitiListener> getNodeListenerFromProcess(FlowNode flowElement, String listenerType) {
        List<ActivitiListener> listeners;
        String type;
        if (flowElement == null || flowElement.getParentContainer() == null) {
            return Collections.emptyList();
        }
        if (!(flowElement instanceof UserTask)) {
            return Collections.emptyList();
        }
        Process process = (Process)flowElement.getParentContainer();
        String string = type = BpmnModelUtil.instanceofAuditTask(flowElement.getType()) ? "AuditTask" : "UserTask";
        if (process.getNodeListener() != null && process.getNodeListener().size() > 0 && (listeners = process.getNodeListener().get(type + listenerType)) != null) {
            return listeners;
        }
        ArrayList<ActivitiListener> auditExecListeners = new ArrayList<ActivitiListener>();
        ArrayList<ActivitiListener> auditTaskListeners = new ArrayList<ActivitiListener>();
        ArrayList<ActivitiListener> userExecListeners = new ArrayList<ActivitiListener>();
        ArrayList<ActivitiListener> userTaskListeners = new ArrayList<ActivitiListener>();
        for (ActivitiListener listener : process.getExecutionListeners()) {
            String evtName = listener.getEvent();
            boolean isTaskListener = false;
            boolean isExecutionListener = false;
            if (evtName.startsWith("task")) {
                isTaskListener = true;
            }
            if (evtName.startsWith("node")) {
                isExecutionListener = true;
            }
            if (!isExecutionListener && !isTaskListener) continue;
            String realEventName = evtName.substring(evtName.lastIndexOf(95) + 1);
            ActivitiListener activitiListener = listener.clone();
            activitiListener.setEvent(realEventName);
            boolean isAuditListener = evtName.matches("\\w+audit\\w+");
            boolean isUserListener = evtName.matches("\\w+user\\w+");
            if (isAuditListener) {
                if (isExecutionListener) {
                    auditExecListeners.add(activitiListener);
                    continue;
                }
                if (!isTaskListener) continue;
                auditTaskListeners.add(activitiListener);
                continue;
            }
            if (!isUserListener) continue;
            if (isExecutionListener) {
                userExecListeners.add(activitiListener);
                continue;
            }
            if (!isTaskListener) continue;
            userTaskListeners.add(activitiListener);
        }
        process.getNodeListener().put("AuditTask_EXECUTIONLISTENER", auditExecListeners);
        process.getNodeListener().put("AuditTask_TASKLISTENER", auditTaskListeners);
        process.getNodeListener().put("UserTask_EXECUTIONLISTENER", userExecListeners);
        process.getNodeListener().put("UserTask_TASKLISTENER", userTaskListeners);
        return process.getNodeListener().get(type + listenerType);
    }

    public static AllowNextPersonSettingModel convertJsonToAllowNextPersonSettingModel(JsonNode jsonNode) {
        AllowNextPersonSettingModel model = new AllowNextPersonSettingModel();
        if (null != jsonNode) {
            JsonNode allowNextPersonSetting;
            JsonNode allowNextPersonWhenMatch = jsonNode.get("allowNextPersonWhenMatch");
            boolean allowNextPerson = false;
            if (null != allowNextPersonWhenMatch) {
                allowNextPerson = allowNextPersonWhenMatch.asBoolean();
            }
            model.setAllowNextPersonWhenMatch(allowNextPerson);
            if (allowNextPerson && null != (allowNextPersonSetting = jsonNode.get("allowNextPersonSetting"))) {
                JsonNode allowNextPersonWayAssign;
                JsonNode sceneNextNodeAssignValue;
                AllowNextPersonSetting setting = new AllowNextPersonSetting();
                JsonNode allowNextPersonScene = allowNextPersonSetting.get("allowNextPersonScene");
                if (null != allowNextPersonScene) {
                    setting.setAllowNextPersonScene(allowNextPersonScene.asText());
                }
                if (null != (sceneNextNodeAssignValue = allowNextPersonSetting.get("sceneNextNodeAssignValue"))) {
                    setting.setSceneNextNodeAssignValue(sceneNextNodeAssignValue.asText());
                }
                if (null != (allowNextPersonWayAssign = allowNextPersonSetting.get("allowNextPersonWayAssign"))) {
                    setting.setAllowNextPersonWayAssign(allowNextPersonWayAssign.asText());
                }
                model.setAllowNextPersonSetting(setting);
            }
        }
        return model;
    }

    public static AllowNextPersonSettingModel convertJsonToAllowNextPersonSettingModel(boolean allowNextPerson) {
        AllowNextPersonSettingModel model = new AllowNextPersonSettingModel();
        model.setAllowNextPersonWhenMatch(allowNextPerson);
        if (allowNextPerson) {
            AllowNextPersonSetting allowNextPersonSetting = new AllowNextPersonSetting();
            allowNextPersonSetting.setAllowNextPersonScene("only");
            allowNextPersonSetting.setAllowNextPersonWayAssign("allow");
            model.setAllowNextPersonSetting(allowNextPersonSetting);
        }
        return model;
    }

    public static boolean incomingFlowDisableBillRelationAdv(String stencilId) {
        if (StringUtils.isBlank((String)stencilId)) {
            return false;
        }
        return "WaitTask".equals(stencilId) || "BroadcastTask".equals(stencilId) || "RPATask".equals(stencilId) || "EndNoneEvent".equals(stencilId) || "NotifyTask".equals(stencilId) || "InclusiveGateway".equals(stencilId);
    }
}

