/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IOParameter;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.MultiInstanceLoopCharacteristics;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import org.apache.commons.lang.StringUtils;

public class CallActivityJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CallActivityJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CallActivityJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CallActivity", CallActivityJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CallActivity.class, CallActivityJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "CallActivity";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        super.convertElementToJson(propertiesNode, baseElement);
        CallActivity callActivity = (CallActivity)baseElement;
        if (StringUtils.isNotEmpty((String)callActivity.getCalledElement())) {
            propertiesNode.put("callactivitycalledelement", callActivity.getCalledElement());
        }
    }

    private void addJsonParameters(String propertyName, String valueName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((String)parameter.getSource())) {
                parameterItemNode.put("source", parameter.getSource());
            } else {
                parameterItemNode.putNull("source");
            }
            if (StringUtils.isNotEmpty((String)parameter.getTarget())) {
                parameterItemNode.put("target", parameter.getTarget());
            } else {
                parameterItemNode.putNull("target");
            }
            if (StringUtils.isNotEmpty((String)parameter.getSourceExpression())) {
                parameterItemNode.put("sourceExpression", parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull("sourceExpression");
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.put(valueName, (JsonNode)itemsNode);
        propertiesNode.put(propertyName, (JsonNode)parametersNode);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new CallActivity();
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        CallActivity callActivity = (CallActivity)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        if (StringUtils.isNotEmpty((String)this.getPropertyValueAsString("callactivitycalledelement", elementNode))) {
            callActivity.setCalledElement(this.getPropertyValueAsString("callactivitycalledelement", elementNode));
        }
        if (callActivity.getInParameters() != null) {
            callActivity.getInParameters().addAll(this.convertToIOParameters("callactivityinparameters", "inParameters", elementNode));
        }
        if (callActivity.getOutParameters() != null) {
            callActivity.getOutParameters().addAll(this.convertToIOParameters("callactivityoutparameters", "outParameters", elementNode));
        }
        MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics = new MultiInstanceLoopCharacteristics();
        multiInstanceLoopCharacteristics.setInputDataItem("#{callActivityCalc.getBusinessKeys}");
        multiInstanceLoopCharacteristics.setElementVariable("businessKey");
        multiInstanceLoopCharacteristics.setLoopCardinality("#{callActivityCalc.getbusinessKeysCount}");
        multiInstanceLoopCharacteristics.setSequential(false);
        multiInstanceLoopCharacteristics.setCompletionCondition("#{participantCalc.hasCompleted}");
        callActivity.setLoopCharacteristics(multiInstanceLoopCharacteristics);
        Process process = (Process)rootElement;
        List<Macro> macros = BpmnModelUtil.loadDefaultNodeMacro(callActivity, process.getProcessType(), this.getStencilId(callActivity));
        process.getMacros().addAll(macros);
        return callActivity;
    }

    private List<IOParameter> convertToIOParameters(String propertyName, String valueName, JsonNode elementNode) {
        JsonNode itemsArrayNode;
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        JsonNode parametersNode = this.getProperty(propertyName, elementNode);
        if (parametersNode != null && (itemsArrayNode = (parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(parametersNode)).get(valueName)) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                JsonNode sourceNode = itemNode.get("source");
                JsonNode sourceExpressionNode = itemNode.get("sourceExpression");
                if ((sourceNode == null || !StringUtils.isNotEmpty((String)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((String)sourceExpressionNode.asText()))) continue;
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((String)this.getValueAsString("source", itemNode))) {
                    parameter.setSource(this.getValueAsString("source", itemNode));
                } else if (StringUtils.isNotEmpty((String)this.getValueAsString("sourceExpression", itemNode))) {
                    parameter.setSourceExpression(this.getValueAsString("sourceExpression", itemNode));
                }
                if (StringUtils.isNotEmpty((String)this.getValueAsString("target", itemNode))) {
                    parameter.setTarget(this.getValueAsString("target", itemNode));
                }
                ioParameters.add(parameter);
            }
        }
        return ioParameters;
    }
}

