/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.EventDefinition;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.IntermediateCatchEvent;
import kd.bos.workflow.bpmn.model.MessageEventDefinition;
import kd.bos.workflow.bpmn.model.SignalEventDefinition;

public class CatchEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CatchEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CatchEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CatchTimerEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchMessageEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchSignalEvent", CatchEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(IntermediateCatchEvent.class, CatchEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)baseElement;
        List<EventDefinition> eventDefinitions = catchEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "CatchTimerEvent";
        }
        EventDefinition eventDefinition = eventDefinitions.get(0);
        if (eventDefinition instanceof MessageEventDefinition) {
            return "CatchMessageEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "CatchSignalEvent";
        }
        return "CatchTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)baseElement;
        this.addEventProperties(catchEvent, propertiesNode);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new IntermediateCatchEvent();
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        IntermediateCatchEvent catchEvent = new IntermediateCatchEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("CatchTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, catchEvent);
        } else if ("CatchMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, catchEvent);
        } else if ("CatchSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, catchEvent);
        }
        return catchEvent;
    }
}

