/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.CancelEventDefinition;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.TerminateEventDefinition;
import kd.bos.workflow.bpmn.model.property.SpecialPropertyUtil;
import org.apache.commons.lang.StringUtils;

public class EndEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        EndEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        EndEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EndNoneEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndErrorEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndCancelEvent", EndEventJsonConverter.class);
        convertersToBpmnMap.put("EndTerminateEvent", EndEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(EndEvent.class, EndEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        EndEvent endEvent = (EndEvent)baseElement;
        return SpecialPropertyUtil.getEndEventType(endEvent);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        EndEvent endEvent = (EndEvent)baseElement;
        this.addEventProperties(endEvent, propertiesNode);
        propertiesNode.put("name", endEvent.getName());
        propertiesNode.put("number", endEvent.getNumber());
        propertiesNode.put("documentation", endEvent.getDocumentation());
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new EndEvent();
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement parentElement) {
        EndEvent endEvent = (EndEvent)super.convertJsonToElement(elementNode, modelNode, shapeMap, parentElement);
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("EndErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, endEvent);
        } else if ("EndCancelEvent".equals(stencilId)) {
            CancelEventDefinition eventDefinition = new CancelEventDefinition();
            endEvent.getEventDefinitions().add(eventDefinition);
        } else if ("EndTerminateEvent".equals(stencilId)) {
            String terminateMiStringValue;
            TerminateEventDefinition eventDefinition = new TerminateEventDefinition();
            String terminateAllStringValue = this.getPropertyValueAsString("terminateall", elementNode);
            if (StringUtils.isNotEmpty((String)terminateAllStringValue)) {
                eventDefinition.setTerminateAll("true".equals(terminateAllStringValue));
            }
            if (StringUtils.isNotEmpty((String)(terminateMiStringValue = this.getPropertyValueAsString("terminateMultiInstance", elementNode)))) {
                eventDefinition.setTerminateMultiInstance("true".equals(terminateMiStringValue));
            }
            endEvent.getEventDefinitions().add(eventDefinition);
        }
        return endEvent;
    }
}

