/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.EventSubProcess;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class EventSubProcessJsonConverter
extends BaseBpmnJsonConverter {
    protected static Log logger = LogFactory.getLog(EventSubProcessJsonConverter.class);

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        EventSubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        EventSubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("EventSubProcess", EventSubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(EventSubProcess.class, EventSubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "EventSubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        super.convertElementToJson(propertiesNode, baseElement);
        propertiesNode.put("activitytype", "Event-Sub-Process");
        propertiesNode.put("subprocesstype", "Embedded");
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        this.flowElementNode.put("childShapes", (JsonNode)subProcessShapesArrayNode);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new EventSubProcess();
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        EventSubProcess subProcess = (EventSubProcess)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        subProcess.setParentContainer((Process)rootElement);
        String processId = subProcess.getSubProcessId();
        if (WfUtils.isNotEmpty(processId)) {
            WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            ResourceEntity resource = service.getRepositoryService().getResourceByModelIdAndType(Long.valueOf(processId), "graph_json");
            if (resource == null) {
                resource = service.getRepositoryService().getResourceByProcDefId(Long.valueOf(processId));
            }
            if (resource == null) {
                return subProcess;
            }
            String json = resource.getData();
            if (WfUtils.isEmpty(json)) {
                return subProcess;
            }
            try {
                JsonNode jsonNode = new ObjectMapper().readTree(json);
                JsonNode childShapesArray = jsonNode.get("childShapes");
                this.processor.processJsonElements(childShapesArray, jsonNode, subProcess, shapeMap, this.model);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDException(WFErrorCode.jsonConvertError(), new Object[]{e.getMessage()});
            }
        }
        return subProcess;
    }
}

