/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.ExtensionAttribute;
import kd.bos.workflow.bpmn.model.JudgeTask;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntityImpl;

public class JudgeTaskJsonConverter
extends BaseBpmnJsonConverter {
    private static final String PROPERTY_JUDGECONDITION = "judgeCondition";

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        JudgeTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        JudgeTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    private static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("JudgeTask", JudgeTaskJsonConverter.class);
    }

    private static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(JudgeTask.class, JudgeTaskJsonConverter.class);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new JudgeTask();
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "JudgeTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        super.convertElementToJson(propertiesNode, baseElement);
        if (baseElement instanceof JudgeTask) {
            JudgeTask judgeTask = (JudgeTask)baseElement;
            JsonNode conditionJsonNode = propertiesNode.get(PROPERTY_JUDGECONDITION);
            this.convertConditionExtAttributes(conditionJsonNode, judgeTask.getJudgeCondition());
        }
    }

    private void convertConditionExtAttributes(JsonNode conditionJsonNode, ConditionalRuleEntityImpl judgeCondition) {
        if (judgeCondition == null) {
            return;
        }
        Map<String, List<ExtensionAttribute>> attributesMap = judgeCondition.getAttributes();
        if (attributesMap.isEmpty()) {
            return;
        }
        if (conditionJsonNode instanceof ObjectNode) {
            ObjectNode conditionNode = (ObjectNode)conditionJsonNode;
            Iterator<List<ExtensionAttribute>> iter = attributesMap.values().iterator();
            String prefix = String.format("%s.", PROPERTY_JUDGECONDITION);
            while (iter.hasNext()) {
                List<ExtensionAttribute> attributes = iter.next();
                for (ExtensionAttribute attribute : attributes) {
                    attribute.setName(attribute.getName().replace(prefix, ""));
                    this.disposeExtensionAttribute(attribute, conditionNode);
                }
            }
        }
    }
}

