/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.Macro;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;

public class NotifyTaskJsonConverter
extends BaseBpmnJsonConverter {
    private static final String NOTIFYRECEIVERS = "notifyReceivers";

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        NotifyTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        NotifyTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("NotifyTask", NotifyTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(NotifyTask.class, NotifyTaskJsonConverter.class);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new NotifyTask();
    }

    @Override
    protected void handleCustomConvert(String newKey, Object obj, BaseElement elem, BaseElement rootElement, Map.Entry<String, JsonNode> node) {
        if (!NOTIFYRECEIVERS.equalsIgnoreCase(node.getKey()) || !(node.getValue() instanceof ArrayNode)) {
            super.handleCustomConvert(newKey, obj, elem, rootElement, node);
        }
        super.handleCustomConvert(newKey, obj, elem, rootElement, node);
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement rootElement) {
        NotifyTask notifyTask = (NotifyTask)super.convertJsonToElement(elementNode, modelNode, shapeMap, rootElement);
        if (notifyTask == null) {
            return notifyTask;
        }
        List<Macro> macros = null;
        if (rootElement instanceof Process) {
            Process process = (Process)rootElement;
            macros = BpmnModelUtil.loadDefaultNodeMacro(notifyTask, process.getProcessType(), this.getStencilId(notifyTask));
            process.getMacros().addAll(macros);
        }
        notifyTask.removeAttribute("macros");
        String content = notifyTask.getAttributeValue("content");
        if (WfUtils.isNotEmpty(content)) {
            MessageSendModel model = new MessageSendModel();
            model.setContent(content);
            model.setNotify(true);
            model.setMessagetype("notify");
            model.setNotifytype(notifyTask.getAttributeValue("notifyType"));
            String receiver = notifyTask.getAttributeValue(NOTIFYRECEIVERS);
            try {
                JsonNode jsonNode;
                List ret;
                if (receiver != null && (ret = this.parseArrayObject(notifyTask, rootElement, (ArrayNode)(jsonNode = new ObjectMapper().readTree(receiver)), ParticipantModelEntityImpl.class.getName(), null)) != null && ret.size() > 0) {
                    model.setReceiver(ret);
                }
            }
            catch (Exception e) {
                log.warn("\u517c\u5bb9\u65e7\u7248\u6d88\u606f\u8282\u70b9\uff0c\u5728\u8f6c\u6362notifyReceivers\u65f6\u51fa\u9519:" + WfUtils.getExceptionStacktrace(e));
            }
            ArrayList<MessageSendModel> ret = new ArrayList<MessageSendModel>();
            ret.add(model);
            notifyTask.setInMsg(ret);
            notifyTask.removeAttribute("notifyType", "content", NOTIFYRECEIVERS);
        }
        return notifyTask;
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "NotifyTask";
    }
}

