/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.Process;

public class ProcessJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Process.class, ProcessJsonConverter.class);
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new Process();
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "Diagram";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        super.convertElementToJson(propertiesNode, baseElement);
        Process mainProcess = (Process)baseElement;
        propertiesNode.put("process_id", mainProcess.getId());
        this.variablesCompatible(propertiesNode);
        BpmnJsonConverterUtil.convertEventListenersToJson(mainProcess.getEventListeners(), propertiesNode);
    }

    private void variablesCompatible(ObjectNode propertiesNode) {
        JsonNode variables;
        JsonNode variableGroup = propertiesNode.get("variableGroup");
        if (variableGroup != null && (variables = variableGroup.get("variables")) instanceof ArrayNode) {
            ArrayNode vars = (ArrayNode)variables;
            for (ObjectNode var : vars) {
                var.set("defaultvalue", var.remove("defaultValue"));
            }
        }
    }
}

