/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpmn.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.converter.ActivityProcessor;
import kd.bos.workflow.bpmn.converter.BaseBpmnJsonConverter;
import kd.bos.workflow.bpmn.converter.BpmnJsonConverterUtil;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillRelationshipModel;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.ExclusiveGateway;
import kd.bos.workflow.bpmn.model.ExtensionElement;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowElementsContainer;
import kd.bos.workflow.bpmn.model.GraphicInfo;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import org.apache.commons.lang.StringUtils;

public class SequenceFlowJsonConverter
extends BaseBpmnJsonConverter {
    private static final String FIELDID = "fieldId";
    private static final String OPERATOR = "operator";
    private static final String VALUE = "value";
    private static final String OUTCOMEFORMID = "outcomeFormId";
    private static final String OUTCOMENAME = "outcomeName";

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SequenceFlowJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SequenceFlowJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SequenceFlow", SequenceFlowJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SequenceFlow.class, SequenceFlowJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "SequenceFlow";
    }

    @Override
    public void convertToJson(BaseElement baseElement, ActivityProcessor processor, BpmnModel model, FlowElementsContainer container, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        FlowElement sourceFlowElement;
        SequenceFlow sequenceFlow = (SequenceFlow)baseElement;
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(sequenceFlow.getId(), "SequenceFlow");
        ObjectNode boundsNode = this.objectMapper.createObjectNode();
        flowNode.put("bounds", (JsonNode)boundsNode);
        flowNode.put("resourceId", baseElement.getId());
        ArrayNode dockersNode = this.objectMapper.createArrayNode();
        flowNode.put("dockers", (JsonNode)dockersNode);
        List<GraphicInfo> graphics = model.getFlowLocationGraphicInfo(sequenceFlow.getId());
        ObjectNode dockNode = null;
        ObjectNode boundNode = null;
        if (graphics != null) {
            for (GraphicInfo graphic : graphics) {
                if (graphic.getTerminalPointType() == null) {
                    dockNode = this.objectMapper.createObjectNode();
                    dockNode.put("x", graphic.getX());
                    dockNode.put("y", graphic.getY());
                    dockersNode.add((JsonNode)dockNode);
                    continue;
                }
                boundNode = this.objectMapper.createObjectNode();
                boundNode.put("x", graphic.getX());
                boundNode.put("y", graphic.getY());
                boundsNode.put("sourcePoint".equals(graphic.getTerminalPointType()) ? "upperLeft" : "lowerRight", (JsonNode)boundNode);
            }
        }
        flowNode.put("style", sequenceFlow.getStyle());
        flowNode.put("dynamic", sequenceFlow.isDynamic());
        flowNode.put("addSign", sequenceFlow.isAddSign());
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getTargetRef()));
        flowNode.put("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.put("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getTargetRef()));
        flowNode.put("source", (JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getSourceRef()));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        if (StringUtils.isNotEmpty((String)sequenceFlow.getSourceRef()) && (sourceFlowElement = container.getFlowElement(sequenceFlow.getSourceRef())) != null) {
            String defaultFlowId = null;
            if (sourceFlowElement instanceof ExclusiveGateway) {
                ExclusiveGateway parentExclusiveGateway = (ExclusiveGateway)sourceFlowElement;
                defaultFlowId = parentExclusiveGateway.getDefaultFlow();
            } else if (sourceFlowElement instanceof Activity) {
                Activity parentActivity = (Activity)sourceFlowElement;
                defaultFlowId = parentActivity.getDefaultFlow();
            }
            if (defaultFlowId != null && defaultFlowId.equals(sequenceFlow.getId())) {
                propertiesNode.put("defaultflow", true);
            }
        }
        if (sequenceFlow.getExecutionListeners().size() > 0) {
            BpmnJsonConverterUtil.convertListenersToJson(sequenceFlow.getExecutionListeners(), true, propertiesNode);
        }
        flowNode.put("properties", (JsonNode)propertiesNode);
        propertiesNode.put("itemId", baseElement.getId());
        super.convertElementToJson(propertiesNode, sequenceFlow);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BaseElement parentElement) {
        JsonNode targetNode;
        BaseElement elem = super.convertJsonToElement(elementNode, modelNode, shapeMap, parentElement);
        SequenceFlow flow = (SequenceFlow)elem;
        String sourceRef = null;
        JsonNode sourceNode = elementNode.get("source");
        sourceRef = sourceNode != null && !sourceNode.isNull() ? sourceNode.get("resourceId").asText() : BpmnJsonConverterUtil.lookForSourceRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes"));
        if (sourceRef != null) {
            flow.setSourceRef(sourceRef);
        }
        if ((targetNode = elementNode.get("target")) != null && !targetNode.isNull() && targetNode.has("resourceId")) {
            String targetId = targetNode.get("resourceId").asText();
            flow.setTargetRef(targetId);
            this.correctSequenceFlowProperties(flow, targetId, shapeMap);
        }
        return flow;
    }

    private void correctSequenceFlowProperties(SequenceFlow flow, String targetId, Map<String, JsonNode> shapeMap) {
        String stencilId;
        if (shapeMap != null && shapeMap.get(targetId) != null && BpmnJsonConverterUtil.incomingFlowDisableBillRelationAdv(stencilId = BpmnJsonConverterUtil.getStencilId(shapeMap.get(targetId)))) {
            BillRelationshipModel billRelationshipModel = flow.getBillRelationshipModel();
            if (billRelationshipModel != null) {
                billRelationshipModel.setRelationType("sameWithPreNode");
            }
            flow.setTargetBillsFilterCondition(null);
            flow.setEnableAggregation(false);
            flow.setEnableTargetBillsFilter(false);
        }
    }

    @Override
    protected BaseElement newInstanceElement(JsonNode elementNode) {
        return new SequenceFlow();
    }

    protected void setFieldConditionExpression(SequenceFlow flow, JsonNode expressionNode) {
        String fieldId = null;
        if (expressionNode.get(FIELDID) != null && !expressionNode.get(FIELDID).isNull()) {
            fieldId = expressionNode.get(FIELDID).asText();
        }
        String operator = null;
        if (expressionNode.get(OPERATOR) != null && !expressionNode.get(OPERATOR).isNull()) {
            operator = expressionNode.get(OPERATOR).asText();
        }
        String value = null;
        if (expressionNode.get(VALUE) != null && !expressionNode.get(VALUE).isNull()) {
            value = expressionNode.get(VALUE).asText();
        }
        if (fieldId != null && operator != null && value != null) {
            flow.setConditionExpression("${" + fieldId + " " + operator + " " + value + "}");
            this.addExtensionElement("conditionFieldId", fieldId, flow);
            this.addExtensionElement("conditionOperator", operator, flow);
            this.addExtensionElement("conditionValue", value, flow);
        }
    }

    protected void setOutcomeConditionExpression(SequenceFlow flow, JsonNode expressionNode) {
        Long formId = null;
        if (expressionNode.get(OUTCOMEFORMID) != null && !expressionNode.get(OUTCOMEFORMID).isNull()) {
            formId = expressionNode.get(OUTCOMEFORMID).asLong();
        }
        String operator = null;
        if (expressionNode.get(OPERATOR) != null && !expressionNode.get(OPERATOR).isNull()) {
            operator = expressionNode.get(OPERATOR).asText();
        }
        String outcomeName = null;
        if (expressionNode.get(OUTCOMENAME) != null && !expressionNode.get(OUTCOMENAME).isNull()) {
            outcomeName = expressionNode.get(OUTCOMENAME).asText();
        }
        if (formId != null && operator != null && outcomeName != null) {
            flow.setConditionExpression("${form" + formId + "outcome " + operator + " " + outcomeName + "}");
            this.addExtensionElement("conditionFormId", String.valueOf(formId), flow);
            this.addExtensionElement("conditionOperator", operator, flow);
            this.addExtensionElement("conditionOutcomeName", outcomeName, flow);
        }
    }

    protected void addExtensionElement(String name, String value, SequenceFlow flow) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://activiti.com/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(value);
        flow.addExtensionElement(extensionElement);
    }
}

